PAGE	59,132
TITLE	 HASP-Emulator:VxD , (c)1996-99 by MeteO, Fixit
.XLIST
;
;	  								  
;   			  HASP Emulation kernel				  
;	  			Platform Q				  
;   Created: 19.04.98 03:16 (30.06.98 03:15)			  
;   Version: 2.50.000 (work release)		   		      	  
;   Copyright (C) 1996-99 MeteO (meteo@null.net)			  
;	  	(C) 1998 by Fixit (admin@fixit.spb.ru)   		  
;   This is the HASP emulation microkernel for all HASPdumb(tm) progs	  
;	  								  
;   We assume no responsibility for any side-effects of using this code 
;	  								  
;   This code is privateware, do not redistribute!			  
;	  								  
;
.586p
.LIST
;
;
$Progname		Equ	'VxD/32'
Copyright		Equ     '(x)1998-99 by MeteO, Fixit //UCLabs'
$ver$			Equ	'3.00.507'
;
;
.MODEL FLAT, StdCall
LOCALS
	.XLIST
	INCLUDE w32.Inc
        INCLUDE haspfunc.inc
	INCLUDE	misc.inc
        INCLUDE	haspdef.inc
	.LIST
;
;                   E Q U A T E S
; Internal driver version
VER_MAJ			EQU	3
VER_MIN			EQU	01
; Which API of Hasp is Emulated
HASP_VER_MAJ		EQU	3
HASP_VER_MIN		EQU	81h
; the following equate makes the VXD dynamically loadable.
HASP95_DYNAMIC		EQU	1
HASP95DL_DEVICE_ID	EQU	3CDCH
;
;
;        V I R T U A L   D E V I C E   D E C L A R A T I O N
;
;
_DATA		SEGMENT PUBLIC 'DATA' USE32
		ASSUME  CS:_TEXT, DS:_DATA
;
; The VxD services provided for other VxDs to call
;
PUBLIC HASP95DL_DDB
HASP95DL_DDB		dd	0
__SDK_Version		dw	400h
__Req_Device_Number	dw	HASP95DL_DEVICE_ID
__Dev_Major_Version	db	VER_MAJ
__Dev_Minor_Version	db	VER_MIN
__Flags			dw	0
__Name			db	'HASP95DL'
__Init_Order		dd	UNDEFINED_INIT_ORDER
__Control_Proc		dd	offset _HASP95DL_Control
__V86_API_Proc		dd	offset HASP95Emu_VM86
__PM_API_Proc		dd	offset HASP95Emu_PM0
__V86_API_CSIP		dd	0
__PM_API_CSIP		dd	0
__Reference_Data	dd	?
__Service_Table_Ptr	dd	offset HASP95DL_Service_Table
__Service_Table_Size	dd	2
__Win32_Service_Table	dd	0
__Prev			dd	'Prev'
__Size			dd	size VxD_Desc_Block+1
__Reserved1		dd	'Rsv1'
__Reserved2		dd	'Rsv2'
__Reserved3		dd	'Rsv3'
;
;
HASP95DL_Service_Table	dd	offset HASP95DL_Get_Version
			dd	offset HASP95DL_Old_API_Support
_DATA ENDS
;
_TEXT		SEGMENT PUBLIC 'CODE' USE32
		ASSUME  CS:_TEXT, DS:_DATA
;
INCLUDE hasp95dl.inc
;
;
;   P R O T E C T E D   M O D E   I N I T I A L I Z A T I O N   C O D E
;
;
;
;
;   PROCEDURE: HASP95_Control
;
;   DESCRIPTION:
;    Device control procedure for the HASP VxD
;
;   ENTRY:
;    EAX = Control call ID
;
;   EXIT:
;    If carry clear then
;        Successful
;    else
;        Control call failed
;
;   USES:
;    EAX, EBX, ECX, EDX, ESI, EDI, Flags
;
;
BeginProc _HASP95DL_Control
    Control_Dispatch CREATE_VM,			HASP95EMU_Create_VM
    Control_Dispatch VM_INIT,			HASP95EMU_VM_Init
    Control_Dispatch THREAD_INIT,		HASP95EMU_Thread_Init
    Control_Dispatch INIT_COMPLETE,		HASP95EMU_Init_Complete
    Control_Dispatch W32_DEVICEIOCONTROL,	HASP95EMU_DeviceIOControl
    Control_Dispatch SYS_DYNAMIC_DEVICE_INIT,	HASP95EMU_Dynamic_Init
    Control_Dispatch SYS_DYNAMIC_DEVICE_EXIT,	HASP95EMU_Dynamic_Exit
    clc
    ret
EndProc _HASP95DL_Control
;
;
;          M O V E A B L E   C O D E   S E G M E N T
;
;
BeginProc HASP95DL_Get_Version
		mov	eax, VER_MAJ shl 4h + VER_MIN	; Get internal version
		clc
		ret
EndProc HASP95DL_Get_Version
;---------------------------------------------------------------------------;
;
;   DESCRIPTION: This function is called to perform Device IO
;	for a 32 bit process which has opened this device with <f CreateFile>,
;	and is performing IO using <f DeviceIOControl>. Preserves the C32
;	calling registers ESI, EDI, but not EBX, since the DevIOCtl calls
;	preserve that already.
;
;   ENTRY: EBX	DDB
;	   ECX	dwIoControlCode
;	   ESI	ptr to DIOCParams
;
;   EXIT:  As determined by function, or 1 if invalid IOCTL
;---------------------------------------------------------------------------;
BeginProc HASP95EMU_DeviceIOControl
		pushad

		cmp     [esi.dwIoControlCode], DIOC_OPEN
		je	_DIOC_OPEN
		cmp	[esi.dwIoControlCode], DIOC_CLOSEHANDLE
		je	_DIOC_CLOSEHANDLE
		cmp	[esi.dwIoControlCode], 3; HASP-bug(tm) feature
		je	_PAGE_LOCK
		cmp	[esi.dwIoControlCode], 4; HASP-bug(tm) feature
		je	_PAGE_UNLOCK

		mov	ebp, [esi.lpvOutBuffer]
                call	Buffer0x48
		jmp     _DIOC_DONE
;***
	_PAGE_LOCK:
               	mov     ebx, [esi.lpvOutBuffer]
               	mov     edi, [esi.cbOutBuffer]
               	shr     ebx, 12
               	shr     edi, 12
               	inc     edi

               	VMMCall LinPageLock <ebx>	; HASP bug(tm) feature:
						; invalid params at VMMCall
               	jmp     _DIOC_DONE
;***
	_PAGE_UNLOCK:

                mov     ebx, [esi.lpvOutBuffer]
		mov     edi, [esi.cbOutBuffer]
                shr     ebx, 12
                shr     edi, 12
                inc     edi

                VMMCall LinPageUnLock <ebx>	; Also HASP-bug (tm) feature

	_DIOC_OPEN:
	_DIOC_CLOSEHANDLE:
        _DIOC_DONE:
		popad

		xor	eax, eax	; Insert Baby Dry into HASP
		ret			; Be always dry & healthfull...
EndProc HASP95EMU_DeviceIOControl
;
;
BeginProc HASP95Emu_PM0
		mov	ax, (Client_ES SHL 8) + Client_EBX
		VMMCall	Map_Flat
		cmp	eax, -1
		je	@error
		mov	edi, eax
		xchg	ebp, edi

		call	EncryptROR

		xchg	ebp, edi

		mov	ax, [edi+44h]		; Prepare internal
		mov	[ebp.Client_ES], ax	; HASPCall structure
		movzx	eax, word ptr [edi+40h]
		mov	[ebp.Client_EBX], eax

		mov	ax, (Client_ES SHL 8) + Client_EBX
		VMMCall	Map_Flat

		mov	ebp, edi		; Store linear address of
		mov	[ebp+40h], eax		; return params at #ReadBlock


		call	Call_HASP

		mov     [ebp.o_EAX],eax		; Return values
		mov     [ebp.o_EBX],ebx
		mov     [ebp.o_ECX],ecx
		mov     [ebp.o_EDX],edx

		call	EncryptROR
		clc
		ret
	@error:
		stc
		ret
EndProc HASP95Emu_PM0
;
;
BeginProc HASP95DL_Old_API_Support
		mov	edi, dword ptr ss:[esp+4]	; # of crypted bytes
		mov	ebp, dword ptr ss:[esp+8]	; offset to buffer
		cmp	edi, 28h
		jne	Buffer_54

                call	Buffer0x28

		clc
		ret
Buffer_54:
		call	Buffer0x54
		clc
		ret
EndProc HASP95DL_Old_API_Support
;
;
;
; Control procedures dispatch block
;
;
;
BeginProc HASP95EMU_Thread_Init
BeginProc HASP95EMU_VM_Init
		call	InstallInt06
BeginProc HASP95EMU_Init_Complete
BeginProc HASP95EMU_Create_VM
		clc
		ret
EndProc HASP95EMU_Create_VM
EndProc HASP95EMU_Init_Complete
EndProc HASP95EMU_VM_Init
EndProc HASP95EMU_Thread_Init
;
;
; Startup initialisation of HASP emulator. Called once
;
;
BeginProc HASP95EMU_Dynamic_Init
IFDEF DEBUGGING
		push	offset m_Ver
		call	DebugString
		push	offset msg_FROMAUTHORS
		call	DebugString
ENDIF
crc_00s label byte
                call	FirstInit	; Initialize all structures
                jb	@dyn_fail
IFNDEF REGISTERED
		call	ChkSice		; SICE presence checking
                jc	@sec_chk	; W/o expiration
		call	ChkTime		; Expiration checks
		jc	@dyn_fail
	@sec_chk:
		call	CheckSecurity	; Control checksum checking
		jc	@dyn_fail
ENDIF
		call	SetupInt06
	@dyn_fail:
		push	eax		; Hook Int2f for system call
		push	esi
		mov	eax, 2Fh
crc_00e label byte
		mov     esi, offset Int2F
		VMMCall Hook_V86_Int_Chain
		pop     esi
		pop     eax
		ret
EndProc HASP95EMU_Dynamic_Init
;
BeginProc HASP95EMU_Dynamic_Exit
		push	eax
		push	esi
		mov	eax, 2Fh
		mov     esi, offset Int2F
		VMMCall Unhook_V86_Int_Chain
		pop     esi
		pop     eax
;
BeginProc HASP95Emu_VM86			; While not supported
		mov	eax, VXD_SUCCESS
		clc
		ret
EndProc HASP95Emu_VM86
;
EndProc HASP95EMU_Dynamic_Exit
;
;
; Version check at 2F, return release version and magic number
;***
BeginProc Int2F
               	cmp     [ebp.Client_EAX], 5000h ; magic func
               	jz      @service5000
		cmp	[ebp.Client_EAX], 5001h ; our VXD magic func #1
		jz	@service5001
		cmp	[ebp.Client_EAX], 5002h ; our VXD magic func #2
		jz	@service5002
               	stc
                ret

@service5000:
                mov     [ebp.Client_EAX], HASP_VER_MAJ*100 + HASP_VER_MIN
       	        mov     [ebp.Client_EBX], 'ES'	; Return 'SECAPI'
                mov     [ebp.Client_ECX], 'AC'
       	        mov     [ebp.Client_EDX], 'IP'
               	clc
               	ret
@service5001:
                mov     [ebp.Client_EAX], VER_MAJ * 100 + VER_MIN
       	        mov     [ebp.Client_EBX], 'KCUF'; Return what we think
                mov     [ebp.Client_ECX], ' EHT'; about HASP
       	        mov     [ebp.Client_EDX], 'PSAH'
                mov	eax, [_t_Supported]   	; Total # of programs
                dec	eax			; substract 0:0 Pwd's
                mov	[ebp.Client_ESI], eax
IFNDEF REGISTERED
                mov     [ebp.Client_EDI], 'DEMO'
ELSE
		mov     [ebp.Client_EDI], 'REG.'
ENDIF
               	clc
               	ret

@service5002:
		movzx	ebx, word ptr [ebp.Client_ECX]
		movzx	edx, word ptr [ebp.Client_EDX]

		cld					; which HASP we'll f..ck
                mov	esi, [_heapSupported]

		mov     ecx, dword ptr [_t_Supported]	; Total # of progs
		or	ecx, ecx			; Protection
		jz	@fault_rmv
	@scanloop:
		lodsd				; ds:esi -> ax
		cmp	eax, ebx
		jne	@next
		lodsd
		cmp	eax, edx
		jne	@next2

		xor	eax, eax
		mov	dword ptr [esi-4], eax		; Pwd2
		mov	dword ptr [esi-8], eax		; Pwd1
		jmp	short @done_rmv

	@next:	add	esi, 4
	@next2:	add	esi, 4*2		; next value
		loop	@scanloop

	@fault_rmv:
		mov	eax, -1
	@done_rmv:
		mov	[ebp.Client_EAX], eax
		clc
	ret

EndProc Int2F
;
BeginProc _EMUBreak
		int 3
		ret
EndProc _EMUBreak
;
_TEXT ENDS
;
; Data
;
;
_DATA		SEGMENT PUBLIC USE32
		ASSUME  CS:_TEXT, DS:_DATA
;
;
;
;
;
IFNDEF REGISTERED
;
;
crc_02s label byte
include		crc.inc
crc_02e label byte
;
;[Security table]
;
bSecurityTable	dd	offset32 crc_00s, offset32 crc_00e-1	; Calling SICE/CheckSecurity
		dd	offset32 crc_10s, offset32 crc_10e-1	; SiceCheck/Query Trial check (SIWVID)
		dd	offset32 crc_11s, offset32 crc_11e-1	; XorTable
		dd	offset32 crc_12s, offset32 crc_12e-1	; SecurityTable check
                dd	offset32 crc_01s, offset32 crc_01e-1	; Herald
                dd	offset32 crc_15s, offset32 crc_15e-1	;
                dd	offset32 crc_02s, offset32 crc_02e-1	; CRC of table CRC
lSecurityTable	equ	($-bSecurityTable)/(4*2)
;
ENDIF
;
IFDEF DEBUGGING
include debugng.inc
ENDIF
;
crc_01s label byte
;
;
m_Herald		db	13,10, ''
m_Ver			db	$Progname
			db	' v', $ver$
IFNDEF REGISTERED
			db	'trial'
ENDIF
                        db	' ', Copyright, 0
			db	'(',??date,' ',??time,')'
IFNDEF NOSTRINGS
			db	'(DEBUG)'
ENDIF
;
crc_01e label byte
;
msg_FROMAUTHORS	db	0dh,0ah,0dh,0ah, 'HASP is a *DUMB* key. '
		db	'Contact us: <METEO@NULL.NET>, <ADMIN@FIXIT.SPB.RU>',0dh,0ah,0dh,0ah
		db	'(c)1998-1999, PRIVATE PROPERTY OF //UCL, USE WITH PERMISSION!',0dh,0ah,0dh,0ah,0
t_Herald	equ	$-m_Herald
;
;
;_al_buf	equ	msg_FROMAUTHORS	;db	8 dup (?)
;_ch		equ	_al_buf+8	;db	10 dup (?)
;_tab		equ	_al_buf+8	;dd	64 dup (?)
;
;
;
_DATA ENDS
                end _HASP95DL_Control

