;
; support address meteo@null.net
;
; Created 12-12-98 02:48pm
;
.386p
include w32.inc
include	haspdef.inc
include haspfunc.inc
include misc.inc
include registry.inc
;
; Initial value for reserved mask retrieved from registry
;
;
_DATA		SEGMENT PUBLIC 'DATA' USE32
		ASSUME  CS:_TEXT, DS:_DATA
;
cbszDwordValue	dd	4	; TypeOf regValue
cbszTempValue	dd	?	;
szTypeValue	dd	?	; "Type" value (stored value)
szSNValue	dd	?	; "SN" value (stored value)
szMemoryValue	dd	?	; "Memory" value (stored value)
szSICEValue	dd	?	
lpKey		dd	?	; lp to Key
;
hKeyEnum	dd	?	; Key for registry access
hKeyRoot	dd	?	; Root of "Dump"
hKeyID		dd	?	; Dump Enumerator
;
;
;
AllocX	szServices, System\CurrentControlSet\Services\Emulator\HASP
t_szServices	=	$-szServices; length
;
;
; Subkeys
;
AllocX	szDump, \Dump		; Subkey \Dump\
t_szDump	=	$-szDump; length
;
; Enums of subkey \Dump
;					What means
AllocZ	szType, Type		; Type of dongle (MemoHASP, NetHASP etc)
AllocZ	szMemory, Memory	; Size of memory
AllocZ	szSN, SN		; Serial number
AllocZ	szExpired, Expired	; Expiration date
AllocZ	szData, Data		; Dongle data
AllocZ	szCRC, CRC		; Checksum
AllocZ	szSice, SICECheck	; Internal SICE checking flag
AllocZ	szHardwaretrap, Hardware; Reserved
AllocZ	szSystem, System	; Extraflag
AllocZ	szDebug, Debug		; Debug flag
AllocZ	szRegistered, Registered; Registered CRC
AllocZ	szName, Name		; Name [registered to]
IFNDEF REGISTERED
AllocZ	szTrial, Geigerzahler	; Trial counter
ENDIF
t_szTotal	equ	$-szType; length of Subkeys
;
iEnum		dw	?	; Enumerates nodes
;
_DATA ENDS
;
;
;;
_TEXT		SEGMENT PUBLIC 'CODE' USE32
		ASSUME  CS:_TEXT, DS:_DATA
;
;
;
BeginProc rgOpenKey
		push_x	<offset32 hKeyEnum>
		push_x	<offset32 szServices>
		push	HKEY_LOCAL_MACHINE
		VMMCall _RegOpenKey
		add	esp, 3*4
		ret
EndProc	rgOpenKey
;
BeginProc rgCloseKey
		pushf
		push_x	<offset32 hKeyEnum>
		VMMCall _RegCloseKey
		add	esp, 1*4
		popf
		ret
EndProc rgCloseKey
;
IFNDEF REGISTERED
;
BeginProc rgCreateKey
		push_x	<offset32 hKeyEnum>
		push_x	<offset32 szServices>
		push	HKEY_LOCAL_MACHINE
		VMMCall _RegCreateKey
		add	esp, 3*4
		ret
EndProc	rgCreateKey
;
BeginProc rgWriteInitialTrial
		push	1
		push_x	<offset32 szTrialValue>
		push	REG_BINARY
		push	0
		push_x	<offset32 szTrial>
		push_x	<offset32 hKeyEnum>
		VMMCall _RegSetValueEx
		add	esp, 6*4
		ret
EndProc	rgWriteInitialTrial
;
BeginProc rgQuerySICE
		push_x	<offset32 cbszDwordValue>
		push_x	<offset32 szSICEValue>
		push	0
		push	0
		push_x	<offset32 szSice>
		push_x	<offset32 hKeyEnum>
		VMMCall _RegQueryValueEx
		add	esp, 6*4
		ret
EndProc rgQuerySICE
;
BeginProc rgQueryDate
		mov	dword ptr cbszDwordValue, 4	; Restore

		push_x	<offset32 cbszDwordValue>
		push_x	<offset32 cbszTempValue>
		push	0
		push	0
		push_x	<offset32 szExpired>
		push_x	<offset32 hKeyEnum>
		VMMCall _RegQueryValueEx
		add	esp, 6*4
		ret
EndProc rgQueryDate
;
BeginProc rgQueryTrial
		push_x  <offset32 cbszDwordValue>
		push_x  <offset32 szTrialValue>
		push	0
		push	0
		push_x  <offset32 szTrial>
		push_x  <offset32 hKeyEnum>
		VMMCall _RegQueryValueEx
		add	esp, 6*4
		ret
EndProc rgQueryTrial
;
BeginProc rgFlushKey
		push_x	<offset32 hKeyEnum>
		VMMCall _RegFlushKey
		add	esp, 1*4
		ret
EndProc rgFlushKey
ENDIF
;
;
; Initializes all structures
;
BeginProc FirstInit
						; Allocate 1st element of Supported table
		VMMCall _HeapAllocate, <4*4, HEAPZEROINIT>

		or	eax, eax		; zero if error
		jz	not_allocated
		mov	[_heapSupported], eax	; address of memory block

						; Allocate memory for HASP memory
		VMMCall _HeapAllocate, <112+4, HEAPZEROINIT>
                stc
		or	eax, eax            	; zero if error
		jz	not_allocated
		mov	[_heapMemory], eax	; address of memory block
;
; Initialize beginning of pwd table
;
; Just add 1 dongle with HASP Pwd 0:0, Type:MemoHASP, SN=0136
;
                mov	dword ptr [eax], 136	; S/n
                mov	ebx, [_heapSupported]
                mov	[ebx.Cell._Pwd1], 0000	; Pwd is 0:0, MemoHASP
                mov	[ebx.Cell._Pwd2], 0000	;
                mov	[ebx.Cell._Type], MemoHASP
                mov	[_t_Supported], 1	; Total supported
                mov	[ebx.Cell._Memory], eax
                cld
		mov	edi, eax
                add	edi, 4			; For S/n
		mov	ecx, 112
                mov	eax, 0FFFFh		; Fill Memory by FFFF
	rep	stosb
;
; Decrypt params (main tree)
;
IFNDEF OEM
		lea	esi, szServices
                mov	ecx, t_szServices
                call	DecryptX
		lea	esi, szDump
                mov	ecx, t_szDump
                call	DecryptX
;
; Decrypt subkeys
;
		lea	edi, szType
                mov	ecx, t_szTotal
	@szDmp:
                mov	al, encryption_byte2	; Encryption byte
                add	[edi], al
                mov	al, encryption_byte3	; Encryption byte
                xor	[edi], al
                inc	edi
                loop	@szDmp
ENDIF
        	clc
	not_allocated:
                ret
EndProc FirstInit
;
;
IFNDEF OEM
BeginProc DecryptX
	@szSrv:
                mov	al, encryption_byte1	; Encryption byte
                xor	[esi], al
                mov	al, encryption_byte0	; Encryption byte
                xor	[esi], al
                inc	esi
                loop	@szSrv
                ret
EndProc DecryptX
ENDIF
;
IFNDEF NOSTRINGS
		db	'Cache Level I'
ENDIF
BeginProc _ReadRegistry@0
		pushad
		VMMCall _HeapAllocate, <MAX_FRIENDLY_NAME, HEAPZEROINIT>
		jz	@absent

		mov	lpKey, eax

		mov	edi, eax
		mov	esi, offset32 szServices
                mov	ecx, t_szServices
	rep	movsb				; Store <\Services\HASP\>

                mov	esi, offset32 szDump
                mov	ecx, t_szDump
	rep	movsb				; Store <\Dump>
		mov	byte ptr [edi], '\'	; Add path
                inc	edi

                xor	eax, eax
		mov	ax, word ptr [ebp.__ECX]
                call	Cvt2Hex
                mov	ax, word ptr [ebp.__EDX]
                call	Cvt2Hex
                mov	byte ptr [edi], 0	; AsciiZ

		VMMCall	_RegOpenKey <HKEY_LOCAL_MACHINE,<lpKey>,<offset32 hKeyEnum>>
                cmp	eax, ERROR_SUCCESS
                jnz	@absent

		VMMCall _RegQueryValueEx, <hKeyEnum,<offset32 szType>,0,0,<offset32 szTypeValue>,<offset32 cbszDwordValue>>
                cmp	eax, ERROR_SUCCESS
                jnz	@absent

		VMMCall _RegQueryValueEx, <hKeyEnum,<offset32 szMemory>,0,0,<offset32 szMemoryValue>,<offset32 cbszDwordValue>>
                cmp	eax, ERROR_SUCCESS
                jnz	@absent

                inc	[_t_Supported]
                			; Alloc memory for HASPCell
		mov	eax, [_t_Supported]
                shl	eax, 4		; *10
                VMMCall	_HeapReAllocate <[_heapSupported], eax, HEAPZEROINIT>
		or	eax, eax	; zero if error
		jz	@absent

		mov	[_heapSupported], eax

                mov	ebx, [_t_Supported]
                dec	ebx				; For current
                shl	ebx, 4
                lea	ebx, [ebx+eax]			; [heapSupported]
                movzx	eax, word ptr [ebp.__ECX]       ; Pwd1
                mov	[ebx.Cell._Pwd1], eax
		movzx	eax, word ptr [ebp.__EDX]	; Pwd2
		mov	[ebx.Cell._Pwd2], eax
                mov	eax, [szTypeValue]		; Type of key
                mov	[ebx.Cell._Type], eax

                mov	eax, [_t_Supported]
                inc	eax
                call	GetOffsetToMem	; Get at ebx offset to the end

					; Alloc memory for HASPmemory
                VMMCall	_HeapReAllocate <[_heapMemory], ebx, HEAPZEROINIT>
		or	eax, eax	; zero if error
		jz	@error_rr

                mov	[_heapMemory], eax

		VMMCall _RegQueryValueEx, <hKeyEnum,<offset32 szSN>,0,0,<offset32 szSNValue>,<offset32 cbszDwordValue>>
		cmp	eax, ERROR_SUCCESS
                jnz	@error_rr

                mov	eax, [_t_Supported]
                call	GetOffsetToMem  ; ebx = offset to current prog

                mov	eax, [_heapMemory]
                lea	ebx, [ebx+eax]

                mov	ecx, [szSNValue]
                mov	[ebx], ecx	; Store SN

		add	ebx, 4		; Pass thry SN
                mov	eax, [szTypeValue]
                call	GetMemSize
		mov	cbszTempValue, eax

		VMMCall _RegQueryValueEx, <hKeyEnum,<offset32 szData>,0,0,ebx,<offset32 cbszTempValue>>
		cmp	eax, ERROR_SUCCESS
                jnz	@error_rr
	@ok:
		call	rgCloseKey	; VMMCall _RegCloseKey, <hKeyEnum>
                push	[_t_Supported]
                pop	Prog_type
		VMMCall	_HeapFree <lpKey, 0>
        	popad
                clc
	ret

        @error_rr:
		call	rgCloseKey	; VMMCall _RegCloseKey, <hKeyEnum>
		dec	[_t_Supported]		; Unsuccessfull installation
		VMMCall	_HeapFree <lpKey, 0>
	@absent:
        	popad
	@t_s0:
		stc
	ret
EndProc _ReadRegistry@0
_TEXT ENDS
END
