; 14.10.98 01:18
; Hasp'Emu protection routines. All rights lefted, all lefts righted
; (x)1998-99 by MeteO (meteo@null.net)
;
.386p
;
include w32.inc
include	haspdef.inc
include haspfunc.inc
include misc.inc
;
_TEXT		SEGMENT PUBLIC 'CODE' USE32
		ASSUME  CS:_TEXT,DS:_TEXT
;
include si.inc
;
IFNDEF REGISTERED
;
;
;
BeginProc SiwVid_ExecInt
		mov	ax, 1684h
		mov	bx, 7a5fh	; Get S-Ice(SIWViD) IO entry point
		push	2Fh
		VMMCall Exec_VxD_Int	; es:di->SICE entry point
	        and	edi, 0ffffh	; Prevent destruction

		mov_x	eax, dwAddValue
	ret
EndProc SiwVid_ExecInt
;
BeginProc GetDate
		mov	ah, 2ah
		push	21h
		VMMCall	Exec_VxD_Int	; cx:dx current date
	ret
EndProc GetDate
;
;
;
;   PROCEDURE: ChkSice
;
;   DESCRIPTION: Check presence of SoftIce via call SIWVID GetEntrypoint
;
;
BeginProc ChkSice
crc_10s label byte
		int	3
		pushad

		call	rgOpenKey
        	cmp     eax, ERROR_SUCCESS	; Not found, need to create
        	je	@chkval			; Registry entry

		call	rgCreateKey
		cmp	eax, ERROR_SUCCESS
		jnz	@xort			; fault

	@create:
		call	rgWriteInitialTrial
		cmp	eax, ERROR_SUCCESS
		jnz	@xort			; fault

	@chkval:
		call	rgQuerySICE		; Check flag "SICEcheck"
	       	cmp     eax, ERROR_SUCCESS
	        jnz	@sichk

                stc
		mov_x	eax, szSICEValue
		cmp	dword ptr [eax], 1917d	; Doesnt check SICE presence
		je	@no_si_chk

	@sichk:
		call	SiwVid_ExecInt		; Sice present - lets encrypt
                add	[eax], edi              ; Return [eax] -> add encrypt
	@no_si_chk:
      		call	rgQueryTrial		; Query key value 'Trial'
		mov_x	esi, szTrialValue	;
	       	cmp     eax, ERROR_SUCCESS
	        je	@chk_query

                cmp	eax, ERROR_FILE_NOT_FOUND
                jne	@xort			; If not exist - create it!
		jmp	@create
	@chk_query:
	        cmp	dword ptr [esi], 0
	        jle	@xort				; Low, fuck off!
	        cmp	dword ptr [esi], MAX_RUN+1	; For any hacker's...
	        jg	@xort
		dec	dword ptr [esi]

		call	rgWriteInitialTrial	; Err:"Word" bugfix
	       	cmp     eax, ERROR_SUCCESS
	        jnz	@xort			; unable to write registry

		call	rgFlushKey		; Err:"Word" bugfix
	       	cmp     eax, ERROR_SUCCESS
	        je	@q_pp			; was successfully written
	@xort:
		call	XorTable
	@q_pp:	clc
		call	rgCloseKey
		popad
	ret
crc_10e label byte
EndProc ChkSice
; 
BeginProc XorTable
;
crc_11s label byte
 		mov_x	ecx, _t_Supported
                mov	dword ptr [ecx], 0		; Make zero
		ret
crc_11e label byte
EndProc XorTable
;
; Added 14.10.98
;
BeginProc CheckSecurity
crc_12s label byte
		mov_x	esi, bSecurityTable
		mov_x	edi, bCRCValues

		cld
		mov	ecx, lSecurityTable

	CRCcheck:
		push	ecx
                push	esi
                dec	ecx
		mov	eax, dword ptr [esi+ecx*8]	; add offset
		mov	ecx, dword ptr [esi+ecx*8+4]	; the same
		sub	ecx, eax
                xchg	esi, eax

		xor	eax, eax
                xor	ebx, ebx
                cdq
	@@zoop:
		lodsb
		add	bh, bl
		add	bl, 5
		and	al, bl
                shl	eax, 2
		xor	edx, eax

		loop	@@zoop
                pop	esi

		pop	ecx
		sub	[edi+ecx*4-4], edx	; Compare CRC
		loop	CRCcheck
		ret
crc_12e label byte
EndProc CheckSecurity
;
; 19.01.99 16:45
;
BeginProc ChkTime
crc_15s label byte
		call	rgOpenKey	; After all at ESI
		stc
        	cmp     eax, ERROR_SUCCESS
		jne	@time_f

		call	rgQueryDate
		mov_x	esi, cbszDateValue
                stc
	       	cmp     eax, ERROR_SUCCESS
                jne	@time_f

		call	GetDate		; Execute 21h GetTime CX=Year, DHDL=Day/Month
                and	edx, 0000FFFFh	; Month/Day
                and	ecx, 0000FFFFh	; Year
                shl	ecx, 10h
                or	ecx, edx

;	nibble1:=date-1998
;       word1:=(nible1<4 & month<2 & day)
;	CRC :=word1 xor 'xM'
;
; Expired=(((date-1998) shl (8+4)) or (month shl 8) or day) shl 10h

                xor	edx, edx
                			; (year |[ month| day])| (CRC)
	        mov	eax, esi	; Copy

		rol	eax, 10h
		xor	eax, 'xMxM'
                xor	eax, esi
                stc
                or	eax, eax
		jnz	@time_f

                mov	eax, esi
			    ;[       |      ][       |      ]
		and	eax, 11110000000000000000000000000000b
	        shr	eax, 16+8+4
	        add	eax, 1998
		shl	eax, 10h
		or	edx, eax	; Got year
;------------------------
		mov	eax, esi
			    ;[       |      ][       |      ]
		and	eax, 00001111000000000000000000000000b
	        shr	eax, 16
		or	edx, eax	; Got month
;------------------------
		mov	eax, esi
			    ;[       |      ][       |      ]
		and	eax, 00000000111111110000000000000000b
		shr	eax, 10h
		or	edx, eax	; Got day
;------------------------
		mov	eax, ecx	; Current date
                call	CvtDate
                xchg	ecx, eax	; Store res
                mov	eax, edx
                call	CvtDate
		sub	eax, ecx	; Compare date

	@time_f:
		call	rgCloseKey
crc_15e label byte
		ret

EndProc ChkTime
;
; 27.01.99 02:50 KT
;
; Input:  EAX = date
; Output: EAX = Number of days converted
;
BeginProc CvtDate
		push	ecx
	        push	eax
		push	eax

	        shr	eax, 10h	; Get year
	        sub	eax, 1998
	        imul	eax, eax, 365	; Num days remaining (year)
	        xchg	eax, ecx	; Store result
	        pop	eax
	        and	eax, 1111111100000000b	; Get month
	        shr	eax, 8		;
		imul	eax,eax,30	; Num days remaining (month)
		add	ecx, eax
	        pop	eax
	        and	eax, 11111111b	; Get days
	        add	ecx, eax
	        xchg	eax, ecx
	        pop	ecx
	        ret
EndProc CvtDate
;
; Data re
;
dwAddValue	dd	0
szTrialValue	dd	MAX_RUN	; Total runnings
cbszDateValue	dd	?	; Curr date
ENDIF
_TEXT ENDS
END

