//---------------------------------------------------------------------------
#include <vcl\vcl.h>
#pragma hdrstop

#include "CallVxd.h"
//---------------------------------------------------------------------------
HANDLE vxd_handle = INVALID_HANDLE_VALUE;
char InBuffer[0x100000];
unsigned long InBytes;


char *OutBuffer;  //dynamic allocated

int InstallVxd() //return 0 if success
{
  HANDLE h = CreateFile( "\\\\.\\STUB.VXD", 0, 0, NULL,
  						0, FILE_FLAG_DELETE_ON_CLOSE, NULL );
  if(h != INVALID_HANDLE_VALUE)
    CloseHandle(h);

  vxd_handle = CreateFile( "\\\\.\\VKEYPROD.VXD", 0, 0, NULL,
  						0, FILE_FLAG_DELETE_ON_CLOSE, NULL );
  if ( vxd_handle == INVALID_HANDLE_VALUE )
  {
	Application->MessageBox("VKEYPROD.VXD w˥...","Info",MB_OK);
    return -1;
  }
  return 0;
}

//////////////////////////////////////////////////
void UnInstallVxd()
{
  if(vxd_handle != INVALID_HANDLE_VALUE)
    CloseHandle(vxd_handle);
}

//////////////////////////////////////////////////
void SetSaveState(int state)
{
  if(state == 0)
  {
    char c = 0;
    DeviceIoControl(vxd_handle,VKEYPROD_SetSaveState, &c, 1,
                    NULL, 0, 0, 0);
  }
  else
  {
  	char c = 1;
    DeviceIoControl(vxd_handle,VKEYPROD_SetSaveState, &c, 1,
                    NULL, 0, 0, 0);
  }
}

///////////////////////////////////////////////////
void GetSaveData()
{
  DeviceIoControl(vxd_handle,VKEYPROD_GetSaveDatas, NULL, 0,
                  InBuffer,sizeof(InBuffer),&InBytes, 0);
  InBytes = RestructData(InBuffer, InBytes);                
  InBytes = OptimizeData(InBuffer, InBytes);
}




///////////////////////////////////////////////////
void ConvertSaveData(TStream *SaveData, TStream *OutStream)
{
  TMemoryStream *header, *buffer, *bufIndex;
  char item1[8], item2[8];
  long n;
  unsigned short w;

  header = new TMemoryStream;
  buffer = new TMemoryStream;
  bufIndex = new TMemoryStream;

  while(SaveData->Position<SaveData->Size)
  {
    //process header
    SaveData->ReadBuffer(item1, 8);
    header->Seek(0, soFromBeginning);;
    while(header->Position<header->Size)
    {
      header->ReadBuffer(item2, 8);
      if(memcmp(item1,item2,8) == 0)
        goto HEADER_EXIST;
    }
    //add to header
    header->Seek(0,soFromEnd);
    header->WriteBuffer(item1, 8);
HEADER_EXIST:
	//process buffer index & buffer
    n = buffer->Position;
    bufIndex->WriteBuffer(&n, sizeof(n));
    buffer->WriteBuffer(item1,8); //put the header
    while(true)
    {
      if(SaveData->Position>=SaveData->Size)
        break;
      SaveData->ReadBuffer(&w,2);
      buffer->WriteBuffer(&w,2);
      if(w == 0xffff)
        break;
    }
  }
  //prepare outStream
  n = header->Size;
  header->Seek(0,soFromBeginning);
  OutStream->WriteBuffer(&n,4);
  OutStream->CopyFrom(header,n);

  n = bufIndex->Size;
  bufIndex->Seek(0,soFromBeginning);
  OutStream->WriteBuffer(&n,4);
  OutStream->CopyFrom(bufIndex,n);

  n = buffer->Size;
  buffer->Seek(0,soFromBeginning);
  OutStream->WriteBuffer(&n,4);
  OutStream->CopyFrom(buffer,n);

  delete header;
  delete buffer;
  delete bufIndex;
}

////////////////////////////////////////
void SendKeyProFile(char *filename)
{
  TFileStream *fs;
  TMemoryStream *ms;
  char *buf;

  fs = new TFileStream(filename, fmOpenRead);
  ms = new TMemoryStream;

  ConvertSaveData(fs, ms);

  buf = new char[ms->Size];
  ms->Seek(0,soFromBeginning);
  ms->ReadBuffer(buf, ms->Size);
  DeviceIoControl(vxd_handle,VKEYPROD_SetKeyproDatas, buf, ms->Size,
                  NULL,0,NULL, 0);
  free(buf);
  delete fs;
  delete ms;
}
/////////////////////////////////////////////////
void SendKeyProDatas(char *keyprodata, int size)
{
  TMemoryStream *ms,*in;
  char *buf;

  ms = new TMemoryStream;
  in = new TMemoryStream;
  in->WriteBuffer(keyprodata, size);
  in->Seek(0,soFromBeginning);

  ConvertSaveData(in, ms);

  buf = new char[ms->Size];
  ms->Seek(0,soFromBeginning);
  ms->ReadBuffer(buf, ms->Size);
  DeviceIoControl(vxd_handle,VKEYPROD_SetKeyproDatas, buf, ms->Size,
                  NULL,0,NULL, 0);
  free(buf);
  delete ms;
  delete in;
}


/////////////////////////////////////////
void SetEmuState(int state)
{
  if(state == 0)
  {
    DeviceIoControl(vxd_handle,VKEYPROD_DisableEmu, NULL, 0,
                  NULL,0,NULL, 0);
  }
  else
  {
    DeviceIoControl(vxd_handle,VKEYPROD_EnableEmu, NULL, 0,
                  NULL,0,NULL, 0);
  }
}
//----------------------------------------------------------------------------
int OptimizeData(char *Datas, int Size)
{
  int Count, i, j,k,check;
  int *Checksums;
  char **Indexes;
  bool MatchFlag;

  i = 0;
  Count = 0;
  while(i <Size)
  {
    if((unsigned char)Datas[i] == 0xff)
    {
      Count++;
      i++;
    }
    i++;
  }
  Checksums = (int *)malloc(Count*sizeof(int));
  Indexes = (char **)malloc(Count*sizeof(char *));
  i = 0;
  Count = 0;
  check = 0;
  Indexes[0] = &Datas[0];
  while(i <Size)
  {
    if((unsigned char)Datas[i] == 0xff)
    {
      Checksums[Count] = check;
      check = 0;
      Count++;
      i+=2;
      if(i >= Size)
        break;
      Indexes[Count] = &Datas[i];
    }
    check += Datas[i++];
    check += Datas[i++];
  }

  for(i=0; i<Count; i++)
  {
    for(j=0; j<Count;j++)
    {
      if(i!=j && Checksums[j] != 0)
      {
        if(Checksums[i] == Checksums[j]) //compare more details
        {
           k=0;
           MatchFlag = true;
           while(true)
           {
             if((unsigned char)Indexes[i][k] == 0xff)
               break;
             if(Indexes[i][k] != Indexes[j][k])
             {
               MatchFlag = false;
               break;
             }
             k++;
             if(Indexes[i][k] != Indexes[j][k])
             {
               MatchFlag = false;
               break;
             }
             k++;
           }
           if(MatchFlag == true)
             Checksums[j] = 0; //a mark
        }
      }
    }
  }
  //output
  TMemoryStream *ms = new TMemoryStream;
  for(i=0; i<Count; i++)
  {
    if(Checksums[i] != 0)
    {
      k = 0;
      while((unsigned char)Indexes[i][k] != 0xff)
        k+=2;
      k+=2;

      ms->WriteBuffer(Indexes[i],k);
    }
  }
  ms->Seek(0,soFromBeginning);
  ms->ReadBuffer(Datas, ms->Size);
  int s = ms->Size;
  delete ms;
  free(Checksums);
  free(Indexes);
  return s;
}
//----------------------------------------------------------------------
int RestructData(char  *Datas, int Size)
{
  int i,OutCount,TempCount;
  bool InputFlag;
  TMemoryStream *os;
  char temp[14];
  os = new TMemoryStream;

  i = 0;
  OutCount = 0;
  InputFlag = false;
  TempCount = 0;
  while(i < Size)
  {
    switch(Datas[i])
    {
      case 0:
      case 2:
        OutCount++;
        temp[TempCount] = Datas[i];
        temp[TempCount+1] = Datas[i+1];
        i += 2;
        TempCount += 2;
        break;
      case 1:
        InputFlag = true;
        OutCount = 0;
        temp[TempCount] = Datas[i];
        temp[TempCount+1] = Datas[i+1];
        i += 2;
        TempCount += 2;
        break;
      case 0xff:
        i+=2;
        break;
    }
    if(OutCount >= 7 && InputFlag == true)
    {
      OutCount = 0;
      short eob = 0xffff;
      os->WriteBuffer(&eob,2);
      InputFlag = false;
    }
    if(TempCount >= 14)
    {
      os->WriteBuffer(&temp[0], 2);
      memmove(&temp[0], &temp[2], 12);
      TempCount  -= 2;
    }
  }
  if(TempCount != 0)
    os->WriteBuffer(&temp[0], TempCount);
  if((unsigned char)temp[TempCount-2] != 0xff)
  {
    temp[0] = 0xff;
    temp[1] = 0xff;
    os->WriteBuffer(&temp[0],2);
  }
  os->Seek(0,soFromBeginning);
  os->ReadBuffer(Datas, os->Size);
  int r = os->Size;
  delete os;
  return r;
}
