//---------------------------------------------------------------------------
#include <vcl\vcl.h>
#pragma hdrstop

#include "KeyProForm.h"
#include "MergeFileForm.h"
#include "CallVxd.h"
#include "About.h"
//---------------------------------------------------------------------------
#pragma resource "*.dfm"
TForm1 *Form1;
//---------------------------------------------------------------------------

__fastcall TForm1::TForm1(TComponent* Owner)
	: TForm(Owner)
{
  Changed = false;
  EmuDatas = NULL;
  EmuDataSize = 0;
}

//---------------------------------------------------------------------------
void __fastcall TForm1::EnableEmuItemClick(TObject *Sender)
{
  if(EmuDataSize == 0)
  {
    Application->MessageBox("ثeS...","T",MB_OK);
    return;
  }
  SendKeyProDatas(EmuDatas,EmuDataSize); //send data to Vxd first
  SetEmuState(1);           //enable emu
  FunctionItem->Items[0]->Enabled = false;
  FunctionItem->Items[1]->Enabled = true;
  FunctionItem->Items[3]->Enabled = false;
}
//---------------------------------------------------------------------------
void __fastcall TForm1::DisableEmuItemClick(TObject *Sender)
{
  SetEmuState(0);  //disable emu
  FunctionItem->Items[0]->Enabled = true;
  FunctionItem->Items[1]->Enabled = false;
  FunctionItem->Items[3]->Enabled = true;
}
//---------------------------------------------------------------------------
void __fastcall TForm1::EnableCaptureItemClick(TObject *Sender)
{
  SetSaveState(1);
  FunctionItem->Items[3]->Enabled = false;
  FunctionItem->Items[4]->Enabled = true;
  FunctionItem->Items[0]->Enabled = false;
}
//---------------------------------------------------------------------------
void __fastcall TForm1::DisableCaptureItemClick(TObject *Sender)
{
  GetSaveData();
  SetSaveState(0);
  if(InBytes != 0)
    SaveFileItemClick(Sender);
  FunctionItem->Items[3]->Enabled = true;
  FunctionItem->Items[4]->Enabled = false;
  FunctionItem->Items[0]->Enabled = true;
  if(EmuDatas != NULL)
    free(EmuDatas);
  EmuDatas = (char *)malloc(InBytes);
  if(EmuDatas == NULL)
  {
    Application->MessageBox("O餣...","T",MB_OK);
    EmuDataSize = 0;
    UpdateMemo();
    return;
  }
  EmuDataSize = InBytes;
  memcpy(EmuDatas, InBuffer, InBytes);
  Filename = "NONAME.KPE";
  Caption = "KEYPRO { - "+ Filename;
  UpdateMemo();
}
//---------------------------------------------------------------------------
void __fastcall TForm1::NewFileItemClick(TObject *Sender)
{
  if(CheckSave() != 1)
    return;
  Filename = "NONAME.KPE";
  Caption = "KEYPRO { - "+ Filename;
  if(EmuDatas != NULL)
  {
    free(EmuDatas);
    EmuDatas = NULL;
    EmuDataSize = 0;
  }
  UpdateMemo();
  Changed = false;
}
//---------------------------------------------------------------------------
//return 1 if pass
int __fastcall TForm1::CheckSave()
{
  if(Changed)
  {
    int r = Application->MessageBox("O_nNثeƦs?","q",MB_YESNOCANCEL);
    if(r == IDYES)
      SaveFileItemClick(this);
    if(r == IDCANCEL)
      return 0;
    return 1;
  }
  return  1;
}

/////////////////////////////////////////////////////////////////////////
void __fastcall TForm1::OpenFileItemClick(TObject *Sender)
{
  if(CheckSave() == 0)
    return;
  TFileStream *fs;
  if(OpenDialog1->Execute() == true)
  {
    Changed = false;
    Filename = OpenDialog1->FileName;
    fs = new TFileStream(Filename, fmOpenRead);
    if(EmuDatas != NULL)
      free(EmuDatas);
    EmuDatas = (char *)malloc(fs->Size);
    if(EmuDatas == NULL)
    {
      Application->MessageBox("O餣...","T",MB_OK);
      EmuDataSize = 0;
    }
    else
    {
      fs->ReadBuffer(EmuDatas, fs->Size);
      EmuDataSize = fs->Size;
    }
    delete fs;
    Caption = "KEYPRO { - "+ Filename;
    UpdateMemo();
    Changed = false;
  }
}
//---------------------------------------------------------------------------
void __fastcall TForm1::SaveFileItemClick(TObject *Sender)
{
  if(EmuDataSize == 0)
  {
//    Application->MessageBox("ثeS...","T",MB_OK);
    return;
  }
  if(Filename == "NONAME.KPE")
  {
    if(SaveDialog1->Execute() == true)
      Filename = SaveDialog1->FileName;
    else
      return;
  }
  TFileStream *fs = new TFileStream(Filename, fmCreate);
  fs->WriteBuffer(EmuDatas, EmuDataSize);
  delete fs;
  Caption = "KEYPRO { - "+ Filename;
}
//---------------------------------------------------------------------------
void __fastcall TForm1::SaveAsItemClick(TObject *Sender)
{
  if(EmuDataSize == 0)
  {
    Application->MessageBox("ثeS...","T",MB_OK);
    return;
  }
  if(SaveDialog1->Execute() == true)
    Filename = SaveDialog1->FileName;
  else
    return;
  TFileStream *fs = new TFileStream(Filename, fmCreate);
  fs->WriteBuffer(EmuDatas, EmuDataSize);
  delete fs;
  Caption = "KEYPRO { - "+ Filename;
}
//---------------------------------------------------------------------------
void __fastcall TForm1::FormClose(TObject *Sender, TCloseAction &Action)
{
  if(EmuDatas != NULL)
    free(EmuDatas);
  UnInstallVxd();
}
//---------------------------------------------------------------------------
void __fastcall TForm1::FormCloseQuery(TObject *Sender, bool &CanClose)
{
  if(Changed)
  {
    if(EmuDataSize != 0)
    {
      int r = Application->MessageBox("O_nNƦs?","q",MB_YESNOCANCEL);
      if(r == ID_CANCEL)
        CanClose = false;
      if(r == ID_YES)
        SaveFileItemClick(Sender);
    }
  }
}
//---------------------------------------------------------------------------
void __fastcall TForm1::MergeFiles()
{
  Form2->ShowModal();
}

//---------------------------------------------------------------------------
void __fastcall TForm1::MergeFileItemClick(TObject *Sender)
{
  MergeFiles();
}
//---------------------------------------------------------------------------
void __fastcall TForm1::UpdateMemo()
{
  AnsiString S;
  char  temp[255];
  int LineCount;
  int Index;
  Memo1->Clear();
  if(EmuDatas == NULL)
    return;
  LineCount = 0;
  Index = 0;
//  Memo1->Enabled = false;
  while(Index < EmuDataSize)
  {
    sprintf(temp,"                   %04d  ",LineCount+1);
    Memo1->Items->Add(temp);
    S = "";
    int ColCount = 0;
    while((unsigned char)EmuDatas[Index] != 0xff && Index < EmuDataSize)
    {
      Application->ProcessMessages();
      sprintf(temp,"%02X %02X ",(unsigned char)EmuDatas[Index],(unsigned char)EmuDatas[Index+1]);
      Index+=2;
      ColCount += 2;
      S += temp;
      if(ColCount >= 16)
      {
        Memo1->Items->Add(S);
        S = "";
        ColCount = 0;
      }
    }
    if(Index >= EmuDataSize)
      break;
    sprintf(temp,"%02d %02d ",EmuDatas[Index],EmuDatas[Index+1]);
    Index += 2;
    S += temp;
    Memo1->Items->Add(S);
    LineCount++;
    if(LineCount == 31)
      S = "";
  }
  //Memo1->Enabled = true;
}

void __fastcall TForm1::FormCreate(TObject *Sender)
{
  if(InstallVxd() == -1)
    VxdInstalled = false;
  else
    VxdInstalled = true;
  Filename = "NONAME.KPE";
  if(VxdInstalled == true)
    CheckDefaultFile();
  Caption = "KEYPRO { - "+ Filename;
  Memo1->Font->Name = "Fixedsys";
  Memo1->Font->Size = 9;
}
//---------------------------------------------------------------------------
void __fastcall TForm1::FormActivate(TObject *Sender)
{
  if(!VxdInstalled)
    Close();
}
//---------------------------------------------------------------------------
void __fastcall TForm1::Memo1KeyPress(TObject *Sender, char &Key)
{
  Key = 0;
}
//---------------------------------------------------------------------------
void __fastcall TForm1::N3Click(TObject *Sender)
{
  AboutBox->ShowModal();	
}
//---------------------------------------------------------------------------
void __fastcall TForm1::ExitItemClick(TObject *Sender)
{
  Close();	
}
//---------------------------------------------------------------------------
void __fastcall TForm1::CheckDefaultFile()
{
  try
  {
    TFileStream *fm  = new TFileStream("DEFAULT.KPE",fmOpenRead);
    if(fm != NULL)
    {
      if(EmuDatas != NULL)
        free(EmuDatas);
      EmuDataSize = 0;
      EmuDatas = (char *)malloc(fm->Size);
      if(EmuDatas == NULL)
        return;
      EmuDataSize = fm->Size;
      fm->ReadBuffer(EmuDatas,fm->Size);
      delete fm;
      Filename = "Default.kpe";
      UpdateMemo();
      EnableEmuItemClick(this);
    }
  }
  catch(...)
  {
    return;
  }
}
//---------------------------------------------------------------------------
