name VKeyProD
.386p

;;;;;;;;;;;;;;include  items
include <vmm.inc>
include <vwin32.inc>


;;;;;;;;;;;;;;;;Constants
VKEYPROD_MajoRev        equ     1
VKEYPROD_MinoRev        equ     0
VKEYPROD_DeviceID       equ     Undefined_Device_ID


;;-------------Virtual Device declaration
Declare_Virtual_Device  VKEYPROD,            \
                        VKEYPROD_MajoRev,    \
                        VKEYPROD_MinoRev,    \
                        VKEYPROD_Control,    \
                        VKEYPROD_DeviceID,   \
                        Undefined_Init_Order

VxD_LOCKED_CODE_SEG

BeginProc VKEYPROD_Control
        Control_Dispatch Sys_Dynamic_Device_Init, VKEYPROD_Device_Init
        Control_Dispatch Sys_Dynamic_Device_Exit, VKEYPROD_Device_UNInit
        Control_Dispatch W32_DeviceIoControl, VKEYPROD_Device_IOctrl
        clc
        ret
EndProc VKEYPROD_Control


;;================ VxD interface

BeginProc VKEYPROD_Device_Init
        VMMCall _MapPhysToLinear, <046CH,4,0>
        jc error
        mov [Time],eax  ;BIOS ɶ}
        mov edi,offset32 iotable
        VMMCall Install_Mult_IO_Handlers  ;wdIO{
        jc error
        VMMCall _PageAllocate, <10,PG_SYS,0,0,0,0,0,PAGELOCKED>
        test eax,eax
        jz ioctl_failure
        mov [WordBuffer],eax
        clc
        ret
error:   
        stc
        ret
EndProc VKEYPROD_Device_Init


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
BeginProc VKEYPROD_Device_UNInit
        mov edi,offset32 iotable
        VMMCall Remove_Mult_IO_Handlers    ;ѰdIIO{
        cmp [SaveBuffer],0
        je UN1
        VMMCall _PageFree, <SaveBuffer, 0>
  UN1:
        cmp [EmuData],0
        je UN2
        VMMCall _PageFree, <EmuData, 0>
  UN2:
        cmp [EmuHeader],0
        je UN3
        VMMCall _PageFree, <EmuHeader, 0>
  UN3:
        cmp [BufIndexes],0
        je UN4
        VMMCall _PageFree, <BufIndexes, 0>
  UN4:
        cmp [WordBuffer],0
        je UN5
        VMMCall _PageFree, <WordBuffer, 0>
UN5:
        ret
EndProc VKEYPROD_Device_UNInit


                  
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
BeginProc Trap378Callback, locked
        Dispatch_Byte_IO Fall_Through, byteout378 ;Y OUT h byteout378
        in al,dx
        ret
byteout378:        
        out dx,al
        push eax       
        push ebx
        push ecx
        mov ah,[EmuFlag]
        cmp ah,1        ;O_A
        jne T378_2
        call EmuCheckTimeOut
        call CheckEmuData ;ƬO_bƤ
  T378_2:
        cmp ah,2        ;O_ŪKEYPROƪA
        jne T378_1       ;;not in save mode
        ;procee save mode
        call CheckTimeOut ;ˬdO_@ƪ
        mov ebx,[SaveBuffer]  ;Nƥ[JƮw
        add ebx,[SaveCount]
        add [SaveCount],2
        mov ecx,[SaveCount]
        cmp ecx,[SaveBufferSize]
        ja  T378_1
        mov byte ptr [ebx],0  ; PORT 378h
        mov byte ptr [ebx+1],al
  T378_1:
        pop ecx
        pop ebx
        pop eax 
        ret
EndProc Trap378Callback

;;always input data, 16 times for a word
BeginProc Trap379Callback, locked
        Dispatch_Byte_IO Fall_Through, byteout379
        in al,dx 
        mov ah,[EmuFlag]
        cmp ah,1
        jne T379_2
        call EmuCheckTimeOut
        call GetEmuData   ;NƩJ AL
  T379_2:
        push ebx
        push ecx
        cmp ah,2
        jne T379_1      ;;not in save mode
        ;;;;process save mode
        call CheckTimeOut
        mov ebx,[SaveBuffer]
        add ebx,[SaveCount]
        add SaveCount,2
        mov ecx,[SaveCount]
        cmp ecx,[SaveBufferSize]
        ja  T379_1
        mov byte ptr [ebx],1
        mov byte ptr [ebx+1],al
  T379_1:
        pop ecx
        pop ebx
        ret
byteout379:        
        out dx,al
        ret
EndProc Trap379Callback


BeginProc Trap37ACallback, locked
        Dispatch_Byte_IO Fall_Through, byteout37a
        in al,dx
        ret
byteout37a:        
        out dx,al
        push eax       
        push ebx
        push ecx
        mov ah,[EmuFlag]
        cmp ah,1
        jne T37a_2
        call EmuCheckTimeOut
        call CheckEmuData
  T37a_2:
        cmp ah,2
        jne T37a_1       ;;not in save mode
        call CheckTimeOut
        mov ebx,[SaveBuffer]
        add ebx,[SaveCount]
        add SaveCount,2
        mov ecx,[SaveCount]
        cmp ecx,[SaveBufferSize]
        ja  T37a_1
        mov byte ptr [ebx],2
        mov byte ptr [ebx+1],al
  T37a_1:
        pop ecx
        pop ebx
        pop eax 
        ret
EndProc Trap37ACallback
               
;;;;;;;; Emulator engine ;;;;;;;;;;;;;;;;;;;;;;
;; In: AL : the out data      ˬdO@{ŪƬO_
;      DX : port number       PƮwƬ۲
;; Out:  N/A
BeginProc CheckEmuData, Locked
        push ebx
        push ecx
        push edx        
        push esi
        push edi
        mov ebx,[WordBuffer];KEYPRO {ƼȦs
        add ebx,WordBufferIndex
        sub DX,378h                ;
        mov byte ptr [ebx],dl      ;
        inc ebx                    ;Nn諸ƥ[JȦs
        mov byte ptr [ebx],al      ;
        inc ebx                    ;
        sub ebx,[WordBuffer]       ;
        mov [WordBufferIndex],ebx  ;

        cmp [WordBufferIndex],10   ;׭YWX10 bytesNqL?
        jae CE1                   ;passed
        ;~Y
        mov ecx,[EmuHeaderCount]  ;Y
        cld
  CE2:
        push ecx
        mov esi,[EmuHeader];Y
        dec ecx 
        shl ecx,3       ;ecx=ecx*8   ,CYƬ 8 bytes
        add esi,ecx     ;esi = &EmuHeader[ecx-1]
        mov edi,[WordBuffer]
        mov ecx,[WordBufferIndex]  ;compare with every header
        repe cmpsb                 ;ȦsϸƬO_۲
        pop ecx
        je CE1          ;F
        loop CE2        ;ŦX,~U@
        ;;when got here,  no data is match
        mov [WordBufferIndex],0 ;,Oڭn,MȦs
  CE1:          
        pop edi
        pop esi
        pop edx
        pop ecx
        pop ebx
        ret     
EndProc CheckEmuData

;;In:Nothing
;;Out : AL contains the Emu data for INPUT
BeginProc GetEmuData, Locked         ;qƮw
        cmp [WordBufferIndex],8 ;O_qLY
        jae GED1        ;passed ,can get a data
        ;;not pass,maybe some error ocure, reset buffer
        mov [WordBufferIndex],0 ;SqLiӨo,MȦs
        ret
  GED1:
        push ecx
        push esi
        push edi
        mov ecx,[BufIndexCount] ;Ʈw
  GED2:
        push ecx
        mov edi,[BufIndexes]   ;Ư
        dec ecx
        shl ecx,2              ;Cӯަ4bytes
        add edi,ecx            ;edi = BufIndexes[ecx-1]
        mov edi,[edi]
        add edi,[EmuData]  ;point to Emu Datas
        mov ecx,[WordBufferIndex] ;Ȧsϸƪ
        mov esi,[WordBuffer]
        repe cmpsb             ;ȦsϸƮwƬO_۲
        pop  ecx
        je GED3       ;F,NƩJ AL
        loop GED2     ;U@
        ;not found any match datas, AL needn't change
        ;S,MȦs,sA
        mov [WordBufferIndex],0
        pop edi
        pop esi
        pop ecx
        ret
  GED3:      
        mov al,byte ptr [edi+1] ; [edi+1] contains port data
        mov esi,[ WordBuffer]   ;
        add esi,[WordBufferIndex]    ;
        mov byte ptr [esi],1         ;
        inc esi                      ;Nƥ[JȦsϤ
        mov byte ptr [esi],al        ;
        add [WordBufferIndex],2      ;
        cmp word ptr [edi+2],0ffffh          ;O_F@ƪ
        jne GED4
        ;reach the end of a data, prepare next data
        mov [WordBufferIndex],0
GED4:
        pop edi
        pop esi
        pop ecx
        ret
EndProc GetEmuData


;IN : nothing
;OUT:nothing      ήɶӧP_Cƪ
;
BeginProc CheckTimeOut
        push eax
        push ebx
        push ecx
        mov ebx,[Time]    ;ثeɶ
        cmp [PrevTime],0  ;O_Ĥ@Ū
        je CT1
        mov eax,[ebx]
        sub eax,[PrevTime]
        cmp eax,9              ;O_j 1/2 
        jb CT1
        ;@ƪ
        mov eax,[SaveBuffer]
        add eax,[SaveCount]
        add [SaveCount],2
        mov ecx,[SaveCount]
        cmp ecx,[SaveBufferSize]
        ja CT1
        mov word ptr [eax],0ffffh
CT1:
        mov eax,[ebx]
        mov [PrevTime],eax
        pop ecx
        pop ebx
        pop eax
        ret
EndProc CheckTimeOut
;
; Aˬd,HKMȦs
;
BeginProc EmuCheckTimeOut
        push eax
        push ebx
        push ecx
        mov ebx,[Time]    ;ثeɶ
        cmp [PrevTime],0  ;O_Ĥ@Ū
        je ECT1
        mov eax,[ebx]
        sub eax,[PrevTime]
        cmp eax,18*3           ;O_j 3 
        jb ECT1
        ;MȦs
        mov [WordBufferIndex],0
ECT1:
        mov eax,[ebx]
        mov [PrevTime],eax
        pop ecx
        pop ebx
        pop eax
        ret
EndProc EmuCheckTimeOut

;;======================== IOControl ========================
;;Win95{ VXD qɭ
BeginProc VKEYPROD_Device_IOctrl
        mov ecx,[esi].dwIoControlCode   ;get ioctl code
        cmp ecx,Service_Table_Size      ;out of baunds
        jae ioctl_failure
        jmp Service_Table[4*ecx]
;;======== Vxd Initial progress use,VxDlƮɷ|ӳo,S@
ioctl_closehandle:
        xor eax,eax
        jmp ioctl_success ;nothing to do ,just a progresss

;;======== ioctl_Set_Save_State, ]wŪKEYPRO Ҧ
ioctl_Set_Save_State:
        mov ebx,[esi].lpvInBuffer
        mov al, byte ptr [ebx]
        cmp al,0        ;ˬdOҩlΰ
        jz SSS1         ;reset save state
        mov EmuFlag,2
        mov SaveCount,0
        cmp [SaveBuffer],0
        jne ioctl_success       ;already allocated
        VMMCall _PageAllocate, <1000,PG_SYS,0,0,0,0,0,PAGELOCKED>    ;tm4MBxs
        test eax,eax
        jz ioctl_failure
        mov [SaveBuffer],eax
        mov [SaveBufferSize],1000*4096
        mov dx,378H     ;reset keypro
        mov al,0        ;
        out dx,al       ;
        jmp ioctl_success
  SSS1:
        mov EmuFlag,0
        VMMCall _PageFree, <SaveBuffer, 0>  ;NW@tmO
        mov [SaveBuffer],0
        jmp ioctl_success


;;===============ioctl_Get_Save_Datas,oҺI쪺 KEYPRO
ioctl_Get_Save_Datas:
        cmp [SaveCount],0
        je GSD2
        cmp [SaveBuffer],0
        je GSD2
        ;add end flag, YSO,[W@
        mov ebx,[SaveBuffer]
        add ebx,[SaveCount]
        cmp byte ptr [ebx-2],0ffh
        je GSD1
        mov word ptr [ebx],0ffffh
        add [SaveCount],2
GSD1:
        mov ebx,esi             ;;use ebx for accessing DIOC
        mov ecx,[SaveCount]
        mov edi,[ebx].lpcbBytesReturned  ;Ǧ^ƪ
        mov [edi],ecx
        mov edi,[ebx].lpvOutBuffer
        mov esi,[SaveBuffer]
        cld
        rep movsb    ;NƷh DIOC 
        jmp ioctl_success
GSD2:
        mov ebx,[esi].lpcbBytesReturned
        mov DWORD PTR [ebx],0
        jmp ioctl_success

;;============== ioctl_Set_Keypro_Datas; ]w KEYPRO 
ioctl_Set_Keypro_Datas:              
        mov [WordBufferIndex],0 ;reset  MȦs
        ;;;;;;;;;;process data header
        cmp [EmuHeader],0       ;YwtmO,hM
        je SKD3
        VMMCall _PageFree, <EmuHeader, 0>
        mov [EmuHeader],0
SKD3:
        mov ebx,[esi].lpvInBuffer       ;;the datas
        mov ecx,[ebx]           ;;Head count(in bytes)
        add ebx,4
        push ecx
        shr ecx,12
        inc ecx
        VMMCall _PageAllocate, <ecx,PG_SYS,0,0,0,0,0,PAGELOCKED>
        pop ecx
        test eax,eax
        jz ioctl_failure
        mov [EmuHeader],eax
        mov eax,ecx
        shr eax,3       ;;divide count by 8
        mov [EmuHeaderCount],eax
        mov esi,ebx
        mov edi,[EmuHeader]
        cld
        rep movsb               ;;copy emu header
        ;;;;;;;;process buffer index
        cmp [BufIndexes],0        ;;if allocated before?
        je SKD1                 ;;not allocated
        ;free  the original IndexBuffer
        VMMCall _PageFree, <BufIndexes, 0>
        mov [BufIndexes],0
  SKD1:                         
        mov ecx,[esi]           ;IndexBuffer count
        add esi,4
        mov eax,ecx
        shr eax,2
        mov BufIndexCount,eax
        push ecx
        shr ecx,12
        inc ecx
        VMMCall _PageAllocate, <ecx,PG_SYS,0,0,0,0,0,PAGELOCKED>
        pop ecx
        test eax,eax
        jz ioctl_failure
        mov [BufIndexes],eax
        mov edi,eax
        cld
        rep movsb
        ;;;;;;;;;;;; process keypro datas
        cmp [EmuData],0        ;;if allocated before?
        je SDK2                 ;;not allocated
        ;free the original EmuData
        VMMCall _PageFree, <EmuData, 0>
        mov [EmuData],0
  SDK2:
        mov ecx,[esi]
        add esi,4
        push ecx
        shr ecx,12
        inc ecx
        VMMCall _PageAllocate, <ecx,PG_SYS,0,0,0,0,0,PAGELOCKED>
        pop ecx
        test eax,eax
        jz ioctl_failure
        mov [EmuData],eax

        mov edi,[EmuData]
        cld
        rep movsb
        jmp ioctl_success

;;=============== ioctl_Disable_Emu
ioctl_Disable_Emu:
        mov [EmuFlag],0
        jmp ioctl_success

;;=============== ioctl_Enable_Emu
ioctl_Enable_Emu:
        mov [EmuFlag],1
        mov [WordBufferIndex],0
        mov dx,378H     ;reset keypro
        mov al,0        ;
        out dx,al       ;
        jmp ioctl_success
ioctl_success:
        xor eax,eax
        clc
        ret
ioctl_failure:
        stc
        ret
EndProc VKEYPROD_Device_IOctrl

VxD_LOCKED_CODE_ENDS

;;============= Datas ========================
VxD_LOCKED_DATA_SEG
  Begin_VxD_IO_Table iotable
    Vxd_IO    378h, Trap378Callback
    Vxd_IO    379h, Trap379Callback
    Vxd_IO    37ah, Trap37ACallback
  End_VxD_IO_Table iotable              
;;;;;;;;;;;;;;;;;;;;;
  Service_Table label DWORD
        dd offset32 ioctl_Closehandle
        dd offset32 ioctl_Set_Save_State
        dd offset32 ioctl_Get_Save_Datas
        dd offset32 ioctl_Set_Keypro_Datas 
        dd offset32 ioctl_Disable_Emu
        dd offset32 ioctl_Enable_Emu
  Service_Table_Size    equ ($-Service_Table)/4

  IoctlError    DD      0
  EmuFlag       DB      0       ;;2 means not in save mode
                                ;;1 means active
                                ;;0 means inactive
  SaveBuffer    DD      0       ;;ffffh means the end of a data streeam
                                ;;0001h means out 378h,1
                                ;;0101h means in  379h,1
                                ;;0201h means out 37ah,1
  EmuData       DD      0       ;store keypro data for emu use
  SaveCount     DD      0
  SaveBufferSize DD     0
  
  EmuHeader     DD      0
  EmuHeaderCount  DD    0
  WordBufferIndex DD    0
  WordBuffer    DD      0
  
  BufIndexes    DD      0
  BufIndexCount DD      0

  Time          DD      0
  PrevTime      DD      0
VxD_LOCKED_DATA_ENDS           

        END
