;-------------------------------------------------------------------------------
; FlexLMCodeGen (C)_muffin_ 2k
;-------------------------------------------------------------------------------

%include "util.mac"
%include "icedump.inc"
%include "wiat.inc"
%include "vxdn.inc"


global Parse_FlexLMCode


extern sdata
extern Parser.return
extern Parser.error
extern Parser.errorMsg
extern ParseExpression
extern ParseAddress
extern pStrlen__


bits 32


;-------------------------------------------------------------------------------
%define var_10	(-010h)
%define var_C	(-0Ch)
%define var_8	(-08h)
%define var_4	(-04h)

%define arg_0  (08h)
;-------------------------------------------------------------------------------


segment _LTEXT

;-------------------------------------------------------------------------------
; FLEXLMCODE <version(5, 6 or 7)> <offset fakecode> <vendorname>
; e.g. /flexlmcode 6 00406700 dumbo
; fake codes have to start w/ 00000004 !
;-------------------------------------------------------------------------------
Parse_FlexLMCode:
	Trace_Out "ICEDUMP: FlexLMCodeGen (C)_muffin_ 2k"
	Trace_Out ""

	mov	edi,Error_BadVersion
	call	ParseExpression		; parse <version>
	jb	near Parser.errorMsg

	mov	[dwFlexLMVers], eax

	call	[pSkipWhiteSpace]	; skip to <offset fakecode>
	jnz	@F

	mov	edi,Error_NoPtr
	jmp	Parser.errorMsg

@@
	mov	edi,Error_BadPtr
	call	ParseAddress		; parse <offset fakecode>
	jb	near Parser.errorMsg

	mov	[pFakeCodes],eax
	cmp	dword [eax], byte 4
	jz 	@F

	mov	edi,Error_BadPtr
	jmp	Parser.errorMsg
	
@@
	call	[pSkipWhiteSpace]	; skip to <vendorname>
	jnz	@F

	mov	edi,Error_NoVendor
	jmp	Parser.errorMsg

@@
	mov	dword[pVendorNamePtr], esi
	push	esi
	call	pStrlen__
	test	eax, eax
	jnz	@F
	
	mov	edi,Error_NoVendor
	jmp	Parser.errorMsg

@@
	mov	byte [esi+eax], 0h
	dec	eax
	cmp	eax, 10			;MAX_VENDOR_NAME
	jle	@F	

	mov	edi,Error_BadVendor
	jmp	Parser.errorMsg

@@	
	mov 	[dwVendorLen], eax

	call 	CalcFlexLMCodes
	test	eax, eax
	jnz	@F

	mov	edi,Error_FailGen
	jmp	Parser.errorMsg

@@
	mov	eax, [dwSeed_1]
	Trace_Out "ICEDUMP: FlexLMCode Seed1: #eax"
	mov	eax, [dwSeed_2]
	Trace_Out "ICEDUMP: FlexLMCode Seed2: #eax"

	mov	ecx, dword[pFakeCodes]
	mov	eax, dword[ecx+0ch]
	Trace_Out "ICEDUMP: FlexLMCode Key1 : #eax"
	mov	eax, dword[ecx+10h]
	Trace_Out "ICEDUMP: FlexLMCode Key2 : #eax"
	mov	eax, dword[ecx+14h]
	Trace_Out "ICEDUMP: FlexLMCode Key3 : #eax"
	mov	eax, dword[ecx+18h]
	Trace_Out "ICEDUMP: FlexLMCode Key4 : #eax"
	mov	eax, [dwKey_5]
	Trace_Out "ICEDUMP: FlexLMCode key5 : #eax"

	call	[pUpdateSomeWindows]	; we wanna see it, don't we ;-)
	popad
	retn


;-------------------------------------------------------------------------------
;l_zinit()
;-------------------------------------------------------------------------------
l_zinit:
	push	ebp
	mov	ebp, esp
	sub	esp, 0Ch
	mov	eax, dword [dwXorVal_1]
	mov	[ebp+var_4], eax
	mov	dword [ebp+var_8], 0
	mov	dword [ebp+var_C], 0
	jmp	short loc_0_27

loc_0_1E:
	mov	ecx, [ebp+var_C]
	add	ecx, 1
	mov	[ebp+var_C], ecx

loc_0_27:
	mov	edx, [ebp+var_C]
	cmp	edx, dword [dwVendorLen]
	jnb	short loc_0_65
	mov	eax, dword [pVendorNamePtr]
	add	eax, [ebp+var_C]
	movsx	edx, byte [eax]
	mov	ecx, [ebp+var_8]
	shl	ecx, 3
	shl	edx, cl
	mov	eax, [ebp+var_4]
	xor	eax, edx
	mov	[ebp+var_4], eax
	mov	ecx, [ebp+var_8]
	add	ecx, 1
	mov	[ebp+var_8], ecx
	cmp	dword [ebp+var_8], 4
	jl	short loc_0_63
	mov	dword [ebp+var_8], 0

loc_0_63:
	jmp	short loc_0_1E

loc_0_65:
	mov	eax, [ebp+var_4]
	mov	esp, ebp
	pop	ebp
	retn

;-------------------------------------------------------------------------------
;l_key(LPDWORD pKeys)
;-------------------------------------------------------------------------------
l_key:
	push	ebp
	mov	ebp, esp
	push	esi
	mov	eax, [ebp+arg_0]
	mov	ecx, [eax]
	push	ecx
	call	l_icf
	add	esp, 4
	mov	esi, eax
	call	l_zinit
	xor	esi, eax
	mov	dword [dwFlexLMBuf], esi
	mov	edx, [ebp+arg_0]
	mov	eax, [edx+4]
	push	eax
	call	l_icf
	add	esp, 4
	mov	ecx, [ebp+arg_0]
	xor	eax, [ecx]
	xor	eax, dword [dwFlexLMBuf]
	mov	dword [dwFlexLMBuf+4], eax
	mov	edx, [ebp+arg_0]
	mov	eax, [edx+8]
	push	eax
	call	l_icf
	add	esp, 4
	mov	ecx, [ebp+arg_0]
	xor	eax, [ecx+4]
	xor	eax, dword [dwFlexLMBuf+4]
	mov	dword [dwFlexLMBuf+8], eax
	mov	edx, [ebp+arg_0]
	mov	eax, [edx+0Ch]
	push	eax
	call	l_icf
	add	esp, 4
	mov	ecx, [ebp+arg_0]
	xor	eax, [ecx+8]
	xor	eax, dword [dwFlexLMBuf+8]
	mov	dword [dwFlexLMBuf+0Ch], eax
	pop	esi
	pop	ebp
	retn

;-------------------------------------------------------------------------------
;l_br(DWORD dw)
;-------------------------------------------------------------------------------
l_br:
	push	ebp
	mov	ebp, esp
	mov	eax, [ebp+arg_0]
	and	eax, 2
	shl	eax, 5
	mov	ecx, [ebp+arg_0]
	and	ecx, 20h
	sar	ecx, 3
	or	eax, ecx
	mov	edx, [ebp+arg_0]
	and	edx, 4
	shl	edx, 3
	or	eax, edx
	mov	ecx, [ebp+arg_0]
	and	ecx, 10h
	sar	ecx, 1
	or	eax, ecx
	mov	edx, [ebp+arg_0]
	and	edx, 1
	shl	edx, 7
	or	eax, edx
	mov	ecx, [ebp+arg_0]
	and	ecx, 8
	shl	ecx, 1
	or	eax, ecx
	mov	edx, [ebp+arg_0]
	and	edx, 80h
	sar	edx, 7
	or	eax, edx
	mov	ecx, [ebp+arg_0]
	and	ecx, 40h
	sar	ecx, 5
	or	eax, ecx
	pop	ebp
	retn


;-------------------------------------------------------------------------------
;l_hbs(DWORD dw)
;-------------------------------------------------------------------------------
l_hbs:
	push	ebp
	mov	ebp, esp
	mov	eax, [ebp+arg_0]
	and	eax, 0F0h
	sar	eax, 4
	mov	ecx, [ebp+arg_0]
	and	ecx, 0Fh
	shl	ecx, 4
	or	eax, ecx
	pop	ebp
	retn

;-------------------------------------------------------------------------------
;l_icf(DWORD dwKeys_x)
;-------------------------------------------------------------------------------
l_icf:
	push	ebp
	mov	ebp, esp
	sub	esp, 10h
	mov	eax, [ebp+arg_0]
	and	eax, 0FF0000h
	sar	eax, 10h
	push	eax
	call	l_br
	add	esp, 4
	push	eax
	call	l_hbs
	add	esp, 4
	mov	[ebp+var_10], eax
	mov	ecx, [ebp+arg_0]
	sar	ecx, 18h
	push	ecx
	call	l_hbs
	add	esp, 4
	xor	eax, [ebp+var_10]
	shl	eax, 10h
	mov	[ebp+var_4], eax
	movsx	edx, byte[ebp+arg_0+1]
	push	edx
	call	l_br
	add	esp, 4
	xor	eax, [ebp+var_10]
	mov	[ebp+var_8], eax
	mov	eax, [ebp+arg_0]
	and	eax, 0FFh
	push	eax
	call	l_hbs
	add	esp, 4
	push	eax
	call	l_br
	add	esp, 4
	xor	eax, [ebp+var_8]
	mov	[ebp+var_C], eax
	mov	eax, [ebp+var_10]
	shl	eax, 10h
	or	eax, [ebp+var_8]
	shl	eax, 8
	or	eax, [ebp+var_4]
	or	eax, [ebp+var_C]
	mov	esp, ebp
	pop	ebp
	retn

;-------------------------------------------------------------------------------
;l_svk(LPDWORD pKeys)
;-------------------------------------------------------------------------------
l_svk:
%define var_11	(-11h)
%define var_3	(-3)
%define var_2	(-2)
%define var_1	(-1)

	push	ebp
	mov	ebp, esp
	sub	esp, 14h
	mov	byte [ebp+var_4], 0
	mov	byte [ebp+var_3], 0
	mov	byte [ebp+var_2], 0
	mov	byte [ebp+var_1], 0
	mov	eax, [ebp+arg_0]
	push	eax
	call	l_key
	add	esp, 4
	mov	dword [ebp+var_C], 3
	mov	dword [ebp+var_10], 0
	jmp	short loc_0_228

loc_0_21F:
	mov	ecx, [ebp+var_10]
	add	ecx, 1
	mov	[ebp+var_10], ecx

loc_0_228:
	mov	edx, [ebp+var_10]
	cmp	edx, dword [dwVendorLen]
	jnb	short loc_0_26D
	mov	eax, dword [pVendorNamePtr]
	add	eax, [ebp+var_10]
	mov	cl, [eax]
	mov	[ebp+var_11], cl
	movsx	edx, byte [ebp+var_11]
	mov	eax, [ebp+var_C]
	movsx	ecx, byte [ebp+eax+var_4]
	xor	ecx, edx
	mov	edx, [ebp+var_C]
	mov	[ebp+edx+var_4], cl
	mov	eax, [ebp+var_C]
	sub	eax, 1
	mov	[ebp+var_C], eax
	cmp	dword [ebp+var_C], 0
	jge	short loc_0_26B
	mov	dword [ebp+var_C], 3

loc_0_26B:
	jmp	short loc_0_21F

loc_0_26D:
	movsx	ecx, byte [ebp+var_4]
	movsx	edx, byte [ebp+var_3]
	shl	edx, 8
	or	ecx, edx
	movsx	eax, byte [ebp+var_2]
	shl	eax, 10h
	or	ecx, eax
	movsx	edx, byte [ebp+var_1]
	shl	edx, 18h
	or	ecx, edx
	mov	[ebp+var_8], ecx
	mov	eax, [ebp+var_8]
	xor	eax, dword [dwXorVal_2]
	mov	[ebp+var_8], eax
	mov	ecx, [ebp+var_8]
	xor	ecx, [dwFlexLMBuf+4]
	mov	[ebp+var_8], ecx
	mov	edx, [ebp+var_8]
	xor	edx, dword [dwFlexLMBuf+8]
	mov	[ebp+var_8], edx
	mov	eax, [ebp+var_8]
	mov	[ebp+var_8], eax
	cmp	dword [ebp+var_8], 0
	jnz	short loc_0_2C8
	mov	ecx, dword [dwXorVal_2]
	mov	[ebp+var_8], ecx

loc_0_2C8:
	mov	eax, [ebp+var_8]
	mov	esp, ebp
	pop	ebp
	retn
%undef var_11	
%undef var_3	
%undef var_2	
%undef var_1	

;  S U B	R O U T	I N E 
CalcFlexLMCodes:
	push	ebp
	mov	ebp, esp
	push	ecx
	mov	dword [dwXorVal_2], 0A8F38730h
	mov	eax, dword [dwFlexLMVers]
	mov	[ebp+var_4], eax
	cmp	dword [ebp+var_4], 5
	jz	short loc_0_2F9
	cmp	dword [ebp+var_4], 6
	jz	short loc_0_305
	cmp	dword [ebp+var_4], 7
	jz	short loc_0_311
	jmp	short loc_0_327
; 

loc_0_2F9:
	mov	dword [dwXorVal_1], 58A340F2h
	jmp	short loc_0_32B
; 

loc_0_305:
	mov	dword [dwXorVal_1], 1504C935h
	jmp	short loc_0_32B
; 

loc_0_311:
	mov	dword [dwXorVal_1], 788F71D2h
	mov	dword [dwXorVal_2], 7648B98Eh
	jmp	short loc_0_32B
; 

loc_0_327:
	xor	eax, eax
	jmp	short loc_0_370
; 

loc_0_32B:
	mov	ecx, dword [pFakeCodes]
	add	ecx, 0Ch
	push	ecx
	call	l_svk
	add	esp, 4
	mov	dword [dwKey_5],	eax
	mov	edx, dword [pFakeCodes]
	mov	eax, [edx+4]
	xor	eax, dword [dwKey_5]
	mov	dword [dwSeed_1], eax
	mov	ecx, dword [pFakeCodes]
	mov	edx, [ecx+8]
	xor	edx, dword [dwKey_5]
	mov	dword [dwSeed_2], edx
	mov	eax, 1

loc_0_370:
	mov	esp, ebp
	pop	ebp
	retn


segment _LDATA
Error_BadVersion:	db 'cannot evaluate <version>',0
Error_NoVendor:		db 'missing <vendorname>',0
Error_BadVendor:	db 'cannot evaluate <vendorname>',0
Error_NoPtr:		db 'missing <offset vendorcode>',0
Error_BadPtr:		db 'cannot evaluate <offset vendorcode>',0
Error_FailGen:		db 'yikes, code generation failed', 0

	align 4
dwFlexLMVers		dd 0	
pVendorNamePtr		dd 0
dwVendorLen		dd 0	
pFakeCodes		dd 0

dwFlexLMBuf:		dd 0, 0, 0, 0
dwXorVal_1:		dd 0
dwXorVal_2:		dd 0
dwSeed_1:		dd 0
dwSeed_2:		dd 0
dwKey_5:		dd 0


;-------------------------------------------------------------------------------
%undef var_10
%undef var_C
%undef var_8
%undef var_4

%undef arg_0
;-------------------------------------------------------------------------------
