; code for unpacking petite 2.1/2.2 using levels 1..9 compression
; also code for fixing offsets for call's / jump's ...

unpack_petite:

    cmp     byte ptr [packer_pep], 42h
    jnz     petite_l0
;

    mov     eax, [entrypoint]
    sub     eax, 42h
    cmp     [eax+68h], 080c78166h   ; check for add di, 0780h
    jz      pet22_l19               ; if its here, its petite2.2

    cmp     [eax+6bh], 0ba0f0a8bh   ; check for petite 2.1 
    jnz     fatal

    mov     dword ptr [petite_ver], 21
    lea     edx, [eax+178h]     ; array of unpack datas for 2.1
    mov     [packer_data], edx  ;
    push    eax
    push    [vmemory]
    jmp     pet2_prepared

pet22_l19:
    mov     dword ptr [petite_ver], 22
    push    eax
    push    [vmemory]
    mov     edi, [esp]      ; edi = pointer to virtual 'pe header'
    mov     esi, [eax]      ; esi = offset to import data in .petite section
    add     edi, 780h
    lea     esi, [esi+eax+8]
    mov     [eax], edi
    movzx   ecx, byte ptr [eax+83h]
    repz    movsd
    
    add     edi, 68h
    add     esi, [eax+9ch]          ; offset to library names
    sub     esi, 8
    movzx   ecx, byte ptr [eax+81h] ; size in dwords of library names
    mov     [size_of_library_names], ecx
    mov     [ptr_lib_names], edi    ; save address of library names for rebuilding .idata
    repz    movsd                   ; copy into virtual pe header .. at 800h ..

    lea edx, [eax+1B8h]     ; array of unpack datas
    mov [packer_data], edx  ;
pet2_prepared:
    mov ecx, [eax+48h]      ; grab address of seh from first block of unpacker code
    sub ecx, [imagebase]    ;  seh points to packers 2nd layer
    mov [packer_seh], ecx   ; store its relative address :p
    
process_packer_data:
    mov     ecx, [edx]      ; get unpack data
    test    ecx, ecx        ; NULL == all blocks unpacked, now we can process unpacked data
    jz      data_unpacked
    btr     ecx, 1Fh        ; do some weird test
    jnb     decompress_block
    mov     eax, [esp]
    std
    mov     esi, eax
    mov     edi, eax
    add     esi, [edx+4]
    add     edi, [edx+8]
    repz    movsd           ; copy some data backwards :)
    add     edx, 0Ch
    cld
    jmp     process_packer_data


data_unpacked:
    cmp     byte ptr [packer_pep], 42h
    jnz     du_petite_l0
    add     esp, 8              ; fix stack from l1..9 decompressor code..
    
du_petite_l0:
    ret




;-----------------------------------------------------------
; this part unpacks the chunks of compressed data into
; the correct places :d
;-----------------------------------------------------------
;

decompress_block:
    add     edx, 10h
    mov     ebx, [edx-0Ch]  ; ebx = size of decompressed data
    test    ebx, ebx
    jz      process_packer_data
    mov     eax, [esp]      ; eax = imagebase :)
    mov     edi, [edx-8]    ; edi = rva to unpack data chunk
    add     edi, eax
    push    edx
    lea     esi, [ecx+eax]  ; esi = pointer to compressed data
    jmp     db_setup_variables

block_decompressed:
    pop eax
    pop eax
    pop eax
    pop edx
    jmp process_packer_data

db_setup_variables:
    cmp     ebx, 10000h     ; 64kb
    jnb     db_more_than_64kb
    push    0FFFFC060h
    push    0FFFFFC60h
    mov     dh, 5
    jmp     unpack_start

db_more_than_64kb:
    cmp     ebx, 40000h     ; 256kb
    jnb     db_more_than_256kb
    push    0FFFF8180h
    push    0FFFFF980h
    mov     dh, 7
    jmp     unpack_start

db_more_than_256kb:
    push    0FFFF8300h
    push    0FFFFFB00h
    mov     dh, 8

unpack_start:
    push    0
    xor     dl, dl
    dec     ebx
    movsb
    xor     ecx, ecx

unpack_main_loop:
    cmp     ebx, 0
    jle     block_decompressed
    call    db_read_proc_pbyte
    jb      db_unpack_bytes
    movsb
    xor     [edi-1], bl         ;) decrypt byte just unpacked
    dec     ebx
    jmp     unpack_main_loop

db_read_proc_pbyte:             ; read and process a packed byte
    add dl, dl
    jnz db_processed_byte
    mov dl, [esi]
    sub esi, 0FFFFFFFFh
    adc dl, dl
db_processed_byte:
    ret

sub_66014B:
    inc     ecx
loc_66014C:
    call    db_read_proc_pbyte
    adc     ecx, ecx
    call    db_read_proc_pbyte
    jb      loc_66014C
    ret

db_unpack_bytes:                    ; someone should comment this
    xor     ebp, ebp
    call    sub_66014B
    sub     ecx, 3
    jnb     loc_66016D
    mov     eax, [esp]
    inc     ecx
    jmp     loc_660190

loc_66016D:
    mov     eax, ecx
    movzx   ecx, dh

loc_660172:                         ; ive got no idea whats going off
    call    db_read_proc_pbyte
    adc     eax, eax
    dec     ecx
    jnz     loc_660172
    xor     eax, 0FFFFFFFFh
    cmp     eax, [esp+4]
    adc     ebp, 1
    cmp     eax, [esp+8]
    adc     ebp, 0
    mov     [esp], eax

loc_660190:                         ; hehe . you want to?
    call    db_read_proc_pbyte
    adc     ecx, ecx
    call    db_read_proc_pbyte
    adc     ecx, ecx
    jnz     store_unpacked_bytes
    call    sub_66014B
    add     ecx, 2

store_unpacked_bytes:               ; Mr. Luck, help me out here ..
    add     ecx, ebp
    push    esi
    sub     ebx, ecx
    lea     esi, [eax+edi]
    repz    movsb
    pop     esi
    jmp     unpack_main_loop


;-----------------------------------------------------------
; this part fixes the offsets for jumps and call's
; in the unpacked code, and wipes some data (huh?)
;-----------------------------------------------------------
;

fix_offsets:
    cmp     dword ptr [esi], 0
    jz      fo_finished
    bt      dword ptr [esi], 1Fh
    jnb     fo_process_data
    add     esi, 0Ch
    jmp     fix_offsets

fo_finished:
    ret

fo_process_data:
    mov     ecx, [ptr_section_data]
    mov     edi, [esi+4]    ; SIZE
    mov     [ecx+4], edi
    mov     edi, [esi+8]    ; RVA
    mov     [ecx], edi
    add     ecx, 8
    mov     [ptr_section_data], ecx

    add     edi, ebp
    mov     ecx, [esi+0Ch]
    sar     ecx, 1
    push    ecx
    jb      fo_scan_start

fo_clear_memory:
    add     edi, [esi+4]    ; add address_of_section, raw size
    sar     ecx, 2
    xor     eax, eax
    repz    stosd           ; clear any crap at the end of the section.
    pop     ecx
    and     ecx, 3
    repz    stosb
    add     esi, 10h
    jmp     fix_offsets

fo_scan_start:
    mov     ebx, [esi+4]
    sub     ebx, 6
    xor     edx, edx

fo_scan4_call_or_jump:
    jb      fo_clear_memory
    mov     al, [edx+edi]
    cmp     al, 0E8h        ; scan for call
    jz      loc_403D22
    cmp     al, 0E9h        ; or jump
    jz      loc_403D22
    cmp     al, 0Fh         ; or conditional jump
    jz      loc_403D2E

loc_403D1C:
    inc     edx
    sub     ebx, 1
    jmp     fo_scan4_call_or_jump

loc_403D22:
    sub     [edx+edi+1], edx    ; sub [offset], counter
    add     edx, 5
    sub     ebx, 5
    jmp     fo_scan4_call_or_jump

loc_403D2E:
    mov     al, [edx+edi+1]
    cmp     al, 80h             ; below 0f 80 ?
    jb      short loc_403D1C    ; its not a large jump
    cmp     al, 8Fh             ; above 0f 8f ?
    ja      short loc_403D1C    ; its not a large jump
    sub     [edx+edi+2], edx
    add     edx, 6
    sub     ebx, 6
    jmp     fo_scan4_call_or_jump