; petite 2.2 unpacking & fixing code ..
; raped by r!sc and ida, july/august 2000
; no $hareware was harmed during the creation of this file

; !$

db  'r!sc',0

 include petite.l0.asm          ; level 0 decompression algo
 include petite.l1_to_9.asm     ; level 1 to 9 decompression algo & 'fix_offsets' algo
 
unpack_file:
    pushad
    call    unpack_petite       ; heh, unpack the data
    

    mov     ebp, [vmemory]      ; data was unpacked into 'vmemory' ..
    mov     esi, [packer_data]
    mov     eax, [packer_seh]   ; packer seh is the va of the second layer of the packer
    add     eax, ebp            ; add our imagebase to it


    call    get_data_offsets    ; calc some data offsets for *this* version of petite


    mov     ebx, [dd_offset_import]
    mov     ebx, [eax+ebx]      ; grab RVA of image import descriptors.. (mangled ones ??)
    mov     [import_rva], ebx
    mov     ebx, [dd_offset_mangle]
    mov     ebx, [eax+ebx]      ; grab a dword from the mangling code

    mov     [mangled], ebx      ; will be 90909090h if imports aint mangled (for use in entrypoint decryption)
    mov     ebx, [eax+0fh]      ; grab encrypted entrypoint
    mov     [encrypted_ep], ebx
    call    crc_2nd_layer       ; crc 2nd layer using fs:22h and fs:1ch and then xor result with
                                ;  the encrypted entrypoint (1st pass for oep decryption..)

    call    fix_offsets         ; fix offsets of relative jumps and calls in the unpacked code
    call    decrypt_entrypoint_using_import_table   ; should fully decrypt the oep... (2.2 only!)
    call    rebuild_pe          ; heh, make a working pe file
    popad
    ret                         ; woohoo! finished



;-----------------------------------------------------------
; this part does a crc on the 2nd layer of the unpacker
; and uses the result to decrypt the programs entrypoint
;-----------------------------------------------------------
;

crc_2nd_layer:  ; eax -> seh, the beginning of the second layer
    pushad

    mov     ebx, [dd_offset_crc_size]
    mov     edi, [eax+ebx]  ; bytes to crc ..
    mov     ebx, [dd_offset_crc_rol]
    mov     cl, [eax+ebx]   ; counter for the ROL

crc_begin:
    add     [size_2nd_layer], edi
    xor     ebx, ebx        ; ebx stores the crc
    lea     edx, [eax+13h]  ; dont crc the first 13h bytes :d
crc_main_loop:
    bt      ebx, 0
    jb      crc_skip_tib
    mov     esi, [fs:1Ch]   ; arrgh, 
    btr     esi, 0
    add     esi, [fs:22h]   ; oh no!
    inc     esi
    xor     bx, si          ; morph crc

crc_skip_tib:
    xor     bl, [edi+edx]   ; xor bl, [byte from this code]
    rol     ebx, cl         ; morph crc some more
    dec     edi
    jge     crc_main_loop
    xor     [encrypted_ep], ebx ;)
    popad
    ret


;-----------------------------------------------------------
; this part is horrible, the entrypoint is still encrypted
; and decrypted using the 'mangled' import table
; so this code fake's the mangling and does the decryption
;-----------------------------------------------------------
;

decrypt_entrypoint_using_import_table:
    mov     edx, [packer_pep]   ; the jump table for the mangled imports starts at the packers
    add     edx, 5              ;  entrypoint + 5 .. the addresses of the jumps are used
    mov     esi, [import_rva]   ;   for decrypting the entrypoint
    add     esi, [vmemory]
    xor     ebx, ebx
decrypt_ep_thunk_loop:
    cmp     dword ptr [esi], 0  ; esi points to our broken image_import_descriptors
    jz      de_exit             ; just an array of first thunk pointers
    mov     edi, [esi]          ; get thunk pointer :)
    add     edi, [vmemory]      ; add our imagebase to it
    add     esi, 4
    lea     ecx, thunkbuffer-4  ; our thunk buffer, for building a mangled thunk :D
de_thunk_loop:
    add     ecx, 4
    mov     eax, [edi]          ; get api pointer
    test    eax, eax            ; check 4 null terminator
    jz      de_morph_entrypoint
    test    eax, 80000000h
    jnz     de_ordinal
    sub     dword ptr [edi], 2  ; fix pointer (needs to point to hint, 2 bytes b4 ascii)
de_skip_fixing_ord:
    add     edi, 4              ; point edi 2 next pointer
    mov     dword ptr [ecx], eax    ; fake the import loading
    dec     ebx                 ; ebx decides whether to mangle call or not
    jge     de_thunk_loop
    cmp     [mangled], 90909090h    ;) was mangling turned on?
    je      de_thunk_loop
    mov     [ecx], edx          ; need to store pointers to fake mangled imports
    add     edx, 5              ; e9xxxxxxxx . so we add 5 to edx..
    mov     ebx, edx            ; edx will be used for our magic mangle counter
    and     ebx, 7              ; .will mangle imports quite randomly
    jmp     de_thunk_loop

de_ordinal:
    inc ebx                     ; if its a ordinal, we dont want to dec our call mangler dword
    jmp de_skip_fixing_ord      ; and we dont want to sub 2 off it, as ordinals dont have hints :)

de_exit:                            ; WOO! we have finished!
    mov     edx, [packer_pep]
    add     edx, 5
    mov     ecx, [encrypted_ep]     ; entrypoint is an offset from its address, e9 xx xx xx xx
    lea     eax, [edx+ecx]          ; offset+VA = real entrypoint
    sub     eax, [imagebase]        ; get the RVA for sticking into the pe header ..
    mov     [oep], eax
    rol     eax, 8      ; check the highest 8 bits of the entrypoint
    test    al, al      ; if they aint 0, maybe it decrypted wrong
    jz      de_good_oep
    call    MessageBoxA, 0, offset oep_error, offset error, 0
de_good_oep:
    ret

de_morph_entrypoint:
    cmp     dword ptr [petite_ver], 21
    jz      decrypt_ep_thunk_loop       ; if its petite 2.1, we dont decrypt the entrypoint using
                                        ;  the mangled thunk's

    mov     dword ptr [ecx], 0          ; null terminate the thunk
    lea     ecx, thunkbuffer            ; our mangled thunk :)
    mov     eax, [packer_pep]           ; packers entrypoint + imagebase
    sub     eax, 42h                    ; we need the sections VA .
de_morph_loop:
    cmp     dword ptr [ecx], 0          ; reached the null terminator?
    jz      decrypt_ep_thunk_loop
    cmp     eax, [ecx]                  ; cmp packer sections VA, [api pointer]
    sbb     dword ptr [encrypted_ep], 0 ; maybe sub 1 ..
    cmp     [ecx], edx                  ; cmp [api pointer], current va of mangled pointers
    sbb     dword ptr [encrypted_ep], 0 ; maybe sub 1 ..
    add     ecx, 4                      ; onto next pointer
    ror     dword ptr [encrypted_ep], 3 ; arrgh :)
    jmp     de_morph_loop


;-----------------------------------------------------------
; prepare for rebuilding the pe file
;-----------------------------------------------------------
;
rebuild_pe:
    mov     esi, [vmemory]
    mov     edi, [vmemory2]
    mov     ecx, 1000h
    repz movsd
;-----------------------------------------------------------
; scan for and remove packers 2nd layer
;-----------------------------------------------------------
    mov     edi, [packer_seh]   ; packer seh is the va of the second layer of the packer
    add     edi, [vmemory]      ; edi -> beginning of 2nd layer
    mov     ecx, [size_2nd_layer] ; size of it
    xor     eax,eax
    repz    stosb               ; wipe it clean


;-----------------------------------------------------------
; dodgily rebuilds the image import descriptors
;-----------------------------------------------------------
    mov     ebp, [vmemory]
    mov     esi, [import_rva]
    lea     esi, [esi+ebp]
    xor     ecx, ecx
count_thunks_loop:
    inc     ecx
    cmp     dword ptr [ecx*4+esi], 0
    je      counted_thunks
    jmp     count_thunks_loop

counted_thunks:
    inc     ecx                         ; ecx = amount+1 of image_import_descriptors we need to rebuild
    imul    ecx, 14h                    ; iid's are 14h bytes ..
    lea     esi, [ecx+esi]              ; start scanning for space after the iid's
    mov     ecx, [size_of_library_names]
    inc     ecx
scan4emptyspace:
    add     esi, 4
    mov     ebx, ecx
s4es_loop:
    cmp     dword ptr [ebx*4+esi], 0    ; scan for space after the image_import_descriptors
    jnz     scan4emptyspace             ; to copy the library names
    dec     ebx                         ; from the pe header..
    jge     s4es_loop
    dec     ecx                         ; cool, esi points to XX empty dwords
    add     esi, 4                      ; lets leave whatever was there, null terminated
    mov     edi, esi                    ; 
    mov     edx, esi
    mov     esi, [ptr_lib_names]        ; esi points to the library names
    repz    movsd                       ; copy them into the free space we found
    
    sub     edx, ebp                    ;) now edx is the RVA of the first library name
    mov     esi, [import_rva]           ; esi points to the first thunk pointers
    add     esi, ebp                    ;  that we have to rebuild
    lea     edi, new_iid+010h           ; edi points to a temp buffer to rebuild the iid's
    xor     ecx,ecx                     ; our iid counter :)
rit_fix_iid:
    mov     [edi-4], edx                ; stamp pointer to library name into iid
    movsd                               ; copy first thunk pointer into it ..
rit_scanz:
    inc     edx                         ; increase lib name RVA
    cmp     byte ptr [ebp+edx-1], 0     ; scan for the beginning of the next library name
    jnz     rit_scanz
    
    add     ecx, 5                      ; each iid is 5 dwords :/
    add     edi, 10h                    ; skip orig first thunk, time date, and that other thing ..
    cmp     dword ptr [esi], 0          ;  leave them as null ..
    jne     rit_fix_iid                 ; 'cmp     dword ptr [esi], 0' have we fixed all iid's?
    mov     edi, [import_rva]           ; rva of image_import_descriptors
    add     edi, ebp                    ; add imagebase :)
    lea     esi, new_iid                ; our freshly rebuilt iid's
    repz    movsd                       ;)
    
    mov     ebx, [vmemory2]
    add     ebx, [ebx+3ch]          ; point to our pe header
    mov     eax, [oep]
    mov     [ebx+28h], eax          ; fix entrypoint
    mov     eax, [import_rva]
    mov     [ebx+80h], eax          ; fix import table


    call    check4edata_tls     ; if exe has exports, we may have to add two sections into our
                                ; section_data array, and if it has TLS, we need to add this info aswell


;-----------------------------------------------------------
; scan for, and fix the resource section information
;-----------------------------------------------------------
    mov     eax, [ebx+88h]      ; get resource RVA
    test    eax, eax
    jz      no_resources
    xor     ecx,ecx
    lea     edx, section_data
res_loop:
    cmp     [edx+ecx], eax      ; scan for section info that is higher or equal to the resource rva
    jae     found_res_info
    cmp     dword ptr [edx+ecx], 0  ; or scan for null :/
    jz      found_res_info
    add     ecx, 8
    jmp     res_loop
found_res_info:
    mov     [edx+ecx], eax      ; fix section information..
    mov     eax, [ebx+8ch]      ; get resource size
    mov     [edx+ecx+4], eax    ; fix section size
no_resources:

    call    scan_pe_header      ; uhm, scan pe header & compare section rva's with section_data
                                ; to see if any sections need adding (non compressed sections)


    lea     edx, section_data
    mov     eax, [import_rva]
    xor     ecx,ecx
idata_loop:
    cmp     [edx+ecx], eax      ; scan for idata section
    jae     found_idata_info
idata_loop_return:
    add     ecx, 8
    jmp     idata_loop
found_idata_info:
    cmp     [edx+ecx+8], eax
    jl      idata_loop_return
    mov     eax, [size_of_library_names]
    shl     eax, 2
    add     [edx+ecx+4], eax    ; add size of lib names to it..

;-----------------------------------------------------------
; fix the raw size of the section which had the packers
; second layer unpacked into it..
;-----------------------------------------------------------
    lea     edx, section_data
    mov     eax, [packer_seh]
    add     eax, 400h
    xor     ecx,ecx
seh_loop:
    cmp     [edx+ecx], eax      ; scan for section info that higher than this rva
    ja      found_seh_info      ; then we know its in the previous section..
    cmp dword ptr [edx+ecx], 0
    jz fuck_fixing_it
    add     ecx, 8
    jmp     seh_loop
found_seh_info:
    mov     eax, [size_2nd_layer]
    sub     [edx+ecx-4], eax    ; fix section size in previous section
fuck_fixing_it:    

;-----------------------------------------------------------
; rebuild the pe file, section #1 & headers first
;-----------------------------------------------------------
    mov     word ptr [ebx+6], 1 ; stamp '1' into number of sections
    lea     edi, [ebx+0f8h]     ; point edi to first section
    mov     ecx, 2000h          ;
    xor     eax,eax             ;
    repz    stosd               ; wipe old section's info from header
    
    lea     edi, [ebx+0f8h]     ; point edi to first section (again!)
    mov     eax, [edx]          ; get section RVA from the sorted section data
    movzx   esi, word ptr [ebx+6]
    add     esi, 40h            ; names are A,B,C,D,E, etc :) 
    mov     [edi], esi          ; stamp new name into section header
    mov     [edi+0ch], eax      ; stamp rva into section

    
    mov     ecx, [ebx+54h]      ; ecx = total header size
    mov     dword ptr [edi+14h], ecx    ; which is also the raw offset for section #1
    mov     eax, [edx+8]        ; next sections RVA
    sub     eax, [edx]          ; sub this sections RVA
    mov     [edi+8], eax        ; == this sections vsize
    
    
    mov     eax, [edx+4]        ; get this sections raw size
    mov     ecx, 200h
    push    edx
    xor     edx,edx
    idiv    ecx                 ; div 200h
    mov     eax, edx            ; put remainder into eax
    pop     edx
    sub     ecx, eax            ; calculate 200h-remainder
    test    eax, eax
    jnz     dont_fuck_me
    sub     ecx, ecx
dont_fuck_me:
    add     ecx, [edx+4]        ; add result to raw size, now its aligned to 200h bytes
    mov     [edx+4], ecx        ; update section data raw size info
    mov     [edi+10h], ecx      ; and also put raw size into section header
    push edi
    mov     edi, [edi+14h]      ; edi = raw offset to section #1
    mov     esi, [edx]          ; esi = rva to the unpacked section
    add     esi, ebp            ; ebp is the base of our unpacked data
    cmp     [esi], 40373db8h    ; check they not unpacking unSafedisc v1.4 :d
    jz      eexit_cheeky
    cmp     [esi], 4037b3b8h    ; unSafedisc v1.5
    jz      eexit_cheeky
    mov     eax, [esi]
    xor     eax, 'ebiv'
    cmp     eax, 6114804h
    jz      eexit_cheeky
    add     edi, [vmemory2]     ;
    repz movsb                  ; copy section 1 from vmemory into our pe buffer


;-----------------------------------------------------------
; rebuild the rest of the sections
;-----------------------------------------------------------
rpe_section_loop:
    sub     edi, [vmemory2]     ; calc the raw offset for next section 
    mov     [edx], edi
    pop     edi
    
    mov     dword ptr [edi+24h], 0E0000060h ; update section characteristics
    add     edi, 28h            ; point edi to next section header
    add     edx, 8              ; point edx to next section information
    cmp     dword ptr [edx], 0
    jz      rpe_exit
    
    inc     word ptr [ebx+6]    ; increase the section count as we are adding another section
    movzx   esi, word ptr [ebx+6]
    add     esi, 40h
    mov     [edi], esi          ; new name
    mov     eax, [edx]          ; get rva
    mov     [edi+0ch], eax      ; stamp into section header
    mov     eax, [edx-8]        ; get raw offset :D
    mov     [edi+14h], eax      ; stamp into section header
    mov     eax, [edx+8]        ;
    test    eax, eax            ; check for last section, as we have to compute the real size for it
    jnz     not_last_section
        sub     dword ptr [image_size], 1000h   ; section vsize&rawsize will be image_size-RVA-1000h
        mov     eax, [image_size]
        sub     eax, [edx]
        mov     ecx, [edx+4]        ; is raw size present for last section?
        test    ecx, ecx            ;
        jnz     dont_update_raw_size
        mov     [edx+4], eax        ; update section raw size
    dont_update_raw_size:
        add     eax, [edx]
not_last_section:
    sub     eax, [edx]          ; next sections RVA - current sections RVA = vSize
    mov     [edi+8], eax        ; stamp vsize into section
    mov     eax, [edx+4]        ; get raw size
    mov     ecx, 200h
    push    edx
    xor     edx, edx
    idiv    ecx                 ; div 200h
    mov     eax, edx            ; put remainder into eax
    pop     edx
    test    eax, eax            ; check remainder for 0
    jnz section_isnt_aligned    ;
    sub     ecx, ecx            ; we dont want to sub 0, 200h
section_isnt_aligned:
    sub     ecx, eax            ; calculate 200h-remainder
    add     ecx, [edx+4]        ; add raw size to result, now its aligned to 200h bytes
    mov     [edx+4], ecx        ; update section info
    mov     [edi+10h], ecx      ; update section header
    push    edi
    mov     esi, [edx]
    add     esi, ebp            ; esi -> section to copy
    mov     edi, [vmemory2]
    add     edi, [edx-8]        ; edi -> pe file were rebuilding
    repz movsb                  ; hehe
    jmp rpe_section_loop
    
rpe_exit:
    sub     edi, [vmemory2]
    and     di, 0fff0h
    add     edi, [vmemory2]
    add     edi, 10h
    mov     ecx, 10h
    lea     esi, tag
    repz movsb
    mov     eax, [image_size]
    mov     [ebx+50h], eax
    mov     eax, [edx-8]
    mov     [image_size], eax
    ret


;-----------------------------------------------------------
; if exe has edata, the code & edata section info may not
; be in our section_data array
; also the tls info may be missing from section_data
; if edata isnt compressed, it could be in the unpacker.
;
; (i should really scan section_data for everything from
;   the pe's IMAGE_DATA_DIRECTORY..)
;
;-----------------------------------------------------------
check4edata_tls:
    pushad
    mov eax, [ebx+78h]  ; get exports rva from pe header..
    test eax, eax       ; this exe has exports?
    jz c4e_skip_edata
    mov ecx, eax
    and ecx, 0fffh      ; check if it points direct to a section, or inside a section
    test ecx, ecx
    jz exe_table_isnt_present
    mov esi, eax        ; if it falls within a section, its probably after the packers
    mov edi, [vmemory]  ;  import table, and has to be copied into its own section :)
    sub edi, 1000h
    
    add edi, [image_size]
    mov eax, [image_size]
    sub eax, 1000h
    mov ecx, [ebx+7ch]
    add esi, [vmemory]
    repz movsb
    mov [ebx+78h], eax
    add [image_size], 1000h
    
exe_table_isnt_present:
    lea esi, [ebx+0f8h] ; point esi to ..
    
    mov ecx, [esi+0ch]      ; see if code section info is already in section_data array
    lea edx, section_data
c4e_check_section_data:
    cmp [edx], ecx          ; check RVA's for a match
    jz c4e_skip_code        ; if we find it, we dont have to scan the pe header for this sections info
    cmp dword ptr [edx], 0  ; check for null terminator..
    jz c4e_scan4code
    add edx, 8
    jmp c4e_check_section_data
c4e_scan4code:
    cmp [esi+0ch], ecx      ; check sections RVA's in pe header
    jz  c4e_found_code      ; for the code section :/
    add esi,28h
    jmp c4e_scan4code
c4e_found_code:
    mov ecx, [ptr_section_data] ; points to the end of my section_data array
    mov edi, [esi+10h]    ; grab sections RAW SIZE from pe header
    mov [ecx+4], edi
    mov edi, [esi+0ch]    ; RVA (heh, 1000h..) (arrgh, see iexplore.exe ..)
    mov [ecx], edi
    add ecx, 8
    mov [ptr_section_data], ecx
c4e_skip_code:
    lea edx, section_data
c4e_check_edata_section_data:
    cmp [edx], eax          ; see if edata section info is already in our section_data array
    jz c4e_skip_edata
    cmp dword ptr [edx], 0
    jz c4e_scan4edata       ; if it isnt, get rva & size from pe header, and update section_data
    add edx, 8
    jmp c4e_check_edata_section_data 
c4e_scan4edata:
    mov ecx, [ptr_section_data]
    mov edx, [ebx+7ch]      ; edata raw size
    mov [ecx+4], edx        ;d
    mov [ecx], eax          ; edata rva
    add ecx, 8
    mov [ptr_section_data], ecx
c4e_skip_edata:

    lea edx, section_data
    mov eax, [ebx+0c0h]     ; get TLS RVA from pe header
c4e_check_tls_section_data:
    cmp [edx], eax          ; see if tls info is already in our section_data array
    jz c4e_skip_tls
    cmp dword ptr [edx], 0
    jz c4e_scan4tls         ; de-ja-vu
    add edx, 8
    jmp c4e_check_tls_section_data 
c4e_scan4tls:
    mov ecx, [ptr_section_data]
    mov edx, [ebx+0c4h]     ; tls raw size
    mov [ecx+4], edx        ;
    mov [ecx], eax          ; tls rva
c4e_skip_tls:
    xor     eax, eax
    mov     [ebx+0a0h], eax     ; uhm, be naughty and clear reloc entry
    mov     [ebx+0a4h], eax
    call    rva_sort
    popad
    ret


;-----------------------------------------------------------
; uhm, scan pe header & compare section rva's with section_data
; to see if any sections need adding (non compressed sections)
;-----------------------------------------------------------
scan_pe_header:
    pushad
    lea     edx, section_data
    mov     esi, [vmemory]
    add     esi, [esi+3ch]
    movzx   ebx, word ptr [esi+6]
    add     esi, 0f8h-28h
    xor     edi, edi
sph_loopA:
    add     esi, 28h
    dec     ebx
    jz      sph_finished
    xor     ecx, ecx
    mov     eax, [esi+0ch]
sph_loopB:
    cmp     eax, [ecx*8+edx]
    jz      sph_loopA
    cmp     edi, [ecx*8+edx]
    jz      sph_found_new_section
    inc     ecx
    jmp     sph_loopB
sph_found_new_section:
    cmp     edi, [esi+10h]      ; check raw size of section isnt null ..
    jz      sph_loopA
    mov     [ecx*8+edx], eax    ; put rva of this non compressed section into our section_data
    mov     eax, [esi+10h]
    mov     [ecx*8+edx+4], eax  ; same with raw size..
    jmp     sph_loopA
sph_finished:
    call    rva_sort
    popad
    ret


;-----------------------------------------------------------
; sort the section data into ascending order
;-----------------------------------------------------------
rva_sort:
    pushad
    lea     edx, section_data
sort_reset:
    xor     ecx, ecx
sort_loop:
    cmp     dword ptr [edx+ecx+8], 0
    jz      sorted
    mov     edi, [edx+ecx]
    cmp     dword ptr [edx+ecx+8], edi
    jb      sort_swap
    add     ecx, 8
    jmp     sort_loop
sort_swap:
    mov     eax, [edx+ecx]      ; movq mm0, [edx+ecx]
    mov     edi, [edx+ecx+8]    ; movq mm1, [edx+ecx+8]
    test    edi, edi            ; check rva2 isnt null (would trigger a sort)
    jz      sorted
    mov     [edx+ecx], edi      ; movq [edx+ecx], mm1
    mov     [edx+ecx+8], eax    ; movq [edx+ecx+8], mm0
    add     ecx, 4              ; jmp  sort_reset
    mov     eax, [edx+ecx]
    mov     edi, [edx+ecx+8]
    mov     [edx+ecx], edi
    mov     [edx+ecx+8], eax
    jmp     sort_reset    
sorted:
    popad
    ret


;-----------------------------------------------------------
; fix some offsets i need depending on the version of petite
; added support for petite2.2 commandline version.. ;)
;-----------------------------------------------------------
get_data_offsets:
    cmp     dword ptr [petite_ver], 21
    jnz     dont_worry_be_happy
    call    move_library_names
dont_worry_be_happy:

    cmp     byte ptr [packer_pep], 42h
    jnz     its_petite_l0
    
    ; do check for 2.1 / 2.2 ..
    cmp     dword ptr [petite_ver], 21
    jz      l19_21
this_is_where_ya_get_a_little_fucking_darker:
    mov     dword ptr [petite_ver], 22
    mov     [dd_offset_mangle], 1c0h
    mov     [dd_offset_import], 121h
    mov     [dd_offset_crc_size], 0a8h
    mov     [dd_offset_crc_rol], 0d0h
    ret
l19_21:
    mov     [dd_offset_mangle], 1c0h
    mov     [dd_offset_import], 17ch    ;121h
    mov     [dd_offset_crc_size], 0ffh  ;0a8h
    mov     [dd_offset_crc_rol], 12bh
    mov     ebx, [eax+0ffh]
    shr     ebx, 12
    test    ebx, ebx
    jnz     this_is_where_ya_get_a_little_fucking_darker
    ret

its_petite_l0:
    cmp     dword ptr [petite_ver], 21
    jz      l0_21
    mov     dword ptr [petite_ver], 22  ; should already be set, but if we get here from the
    mov     [dd_offset_mangle], 1d9h    ; jump below, we gotta do this.. seems two versions of
    mov     [dd_offset_import], 129h    ; petite 2.2 are floating around ;)
    mov     [dd_offset_crc_size], 0adh
    mov     [dd_offset_crc_rol], 0d5h
    ret
l0_21:
    mov     [dd_offset_mangle], 1d9h    ; unused in 2.1 ..
    mov     [dd_offset_import], 184h
    mov     [dd_offset_crc_size], 104h
    mov     [dd_offset_crc_rol], 130h
;
    mov     ebx, [eax+0104h]
    shr     ebx, 12
    test    ebx, ebx
    jnz     its_petite_l0
    ret


;-----------------------------------------------------------
; find library names, count there size, and move them into
; the pe header, so 2.2 rebuilding code will work with 2.1
;-----------------------------------------------------------
move_library_names:
    pushad
    mov     [size_of_library_names], 0
    mov     edi, [vmemory]
    mov     ebx, edi
    mov     edx, edi
    add     ebx, [ebx+3ch]          ; point to our pe header
    mov     eax, [ebx+80h]          ; grab import table pointer
    add     eax, edi
    add     edi, 800h
    mov     [ptr_lib_names], edi
mln_main_loop:
    mov     esi, [eax+0ch]
    add     eax, 14h
    xor     ecx, ecx
    test    esi, esi
    jz      mln_all_done
    add     esi, edx
mln_scan4null:
    cmp     byte ptr [esi+ecx], 0
    jz      mln_got_length
    inc     ecx
    jmp     mln_scan4null

mln_got_length:
    inc     ecx
    add     [size_of_library_names], ecx
    repz    movsb
    jmp     mln_main_loop

mln_all_done:
    shr     dword ptr [size_of_library_names], 2
    inc     dword ptr [size_of_library_names]
    popad
    ret




tag db 'unpacked by r!sc'

eexit_cheeky:
    lea edi, exit_cheeky+ 9090h ; hah
    push edi                    ;p
    add dword ptr [esp], -9090h ; hmm
    ret