FixDumpedFile	proc	;eax=*filename string
	call	OpenTheFile			;Open the file
	test	eax, eax
	je	fdferr1

	call	create_mapping			;Map the file
        jc      fdferr1
	push	eax

	call	NewReportSec			;make a new section in report txt
	call	AddReportTxt,offset strPART1	;introduce section to report txt

	pop	eax
	call	GetPEHead			;pointer to the peheader -> esi

	movzx	edx, word ptr [esi+numObj]	;number of sections -> edx
	mov	numsec, edx			;save number of sections

	add	esi, headlen			;pointer to object table -> esi
	xor	ebx, ebx
fdfloop1:					;first loop to check if reloc is possible
	mov	eax, 28h
	mul	bl
	mov	edi, esi
	add	edi, eax
	mov	eax, [edi+12]
	add	eax, [edi+8]

	cmp	eax, [ffsize]			;if RVA > filesize then raw fix not possible
	jg	fdferr1

	inc	ebx				;next section
	cmp	ebx, edx
	jne	fdfloop1

	mov	esi, ptrpeheader
;	movzx	edx, word ptr [esi+numObj]
	mov	edx, numsec
	add	esi, headlen
	xor	ebx, ebx

fdfloop2:					;second loop to fix raws
	mov	eax, 28h
	mul	bl
	mov	edi, esi
	add	edi, eax
	mov	eax, [edi+12]			;eax<-RVA offset
	mov	[edi+20], eax			;eax->RAW offset
	mov	eax, [edi+8]			;eax<-Virtual Size
	mov	[edi+16], eax			;eax->RAW Size
	call	AddReportLine1			;add line to report text
	inc	ebx				;next section
	cmp	ebx, edx
	jne	fdfloop2

	call	unmap				;unmap the file
	call	CloseTheFile			;close the file

	call	AddReportTxt,offset strLINE	;end of section in report text

	xor	eax, eax
	inc	eax
	ret
fdferr1:
	mov	RebError, 1
	mov	TagRaw, 0
	call	AddReportTxt,offset strERRSEC	;add error line in report text
	call	AddReportTxt,offset strLINE	;end of section in report text

	call	unmap				;unmap the file
	call	CloseTheFile			;close the file
	xor	eax, eax
	ret	
FixDumpedFile	endp


FixPEFile	proc	;eax=*filename string
	push	eax

	call	NewReportSec			;make a new section in report txt
	call	AddReportTxt,offset strPART2	;introduce section to report txt

	mov	error, 0			;init some counters for report
	mov	funcnumb, 0
	mov	funcerr, 0
	mov	doneimpfix, 1

	pop	eax

	call	OpenTheFile			;open the file
	test	eax, eax
	je	fpeferr

	call	create_mapping			;map the file into memory
        jc      fpeferr

	call	GetPEHead			;pointer to pe header -> esi

	mov	ebx, [esi+imagesize]
	mov	imgsize, ebx			;save image size

	mov	ebx, esi

	add	ebx, 80h
	mov	eax, [ebx]			;RVA to import table -> eax
	mov	MapImpLoc, eax			;save ptr to import table
	test	eax, eax
	je	fpeferr

	mov	edi, offset strIMPLOC2
	call	print_hex_32b			;print import table RVA to report

	call	ImageRvaToSection,ptrpeheader,map_ptr,MapImpLoc		;get section where imp table is
	mov	edi, eax

	mov	edx, [edi+12]
	sub	edx, [edi+20]
	mov	impdecal, edx			;save gap between RVA and VA relative to this section

	call	ImageRvaToVa,ptrpeheader,map_ptr,MapImpLoc,0	;convert RVA to VA

	mov	MapImpLoc, eax			;save VA to import table

	mov	edi, offset strIMPLOC3
	call	print_hex_32b			;print import table VA to report

	mov	edx, eax
	xor	ecx, ecx
	mov	FnctNames, 0			;init ptr to function name strings

fpefloop1:					;start loop to find location of function names strings
	mov	eax, 20
	mul	cl
	add	eax, edx
	mov	ebx, [eax.lpDLLName]
	test	ebx, ebx
	je	endsec
	mov	ebx, [eax.Imports]
	add	ebx, [map_ptr]
	sub	ebx, impdecal

	add	ebx, 8

	test	ecx, ecx
	je	fpefcont2
	cmp	ebx, FnctNames
	jle	fpefcont
	add	ebx, 8
	mov	FnctNames, ebx
	mov	FnctPoint, ebx
fpefcont:
	inc	ecx
	jmp	fpefloop1

fpefcont2:
	mov	FnctNames, ebx
	mov	FnctPoint, ebx
	inc	ecx
	jmp	fpefloop1

endsec:
	mov	DLLNumb, ecx		;save number of imported DLL

	call	CreateDLLArray		;Create an array containing DLL and functions pointers

	xor	ebx, ebx
	mov	eax, DLLNumb
	test	eax, eax
	je	fpeffin			;If there is no DLL to fix, then jmp to end

zobloop2:				;start main loop (1 pass for each DLL)
	mov	eax, 100
	mul	bl
	add	eax, DLLArray
	mov	DLLArrayLoc, eax
	mov	eax, 4
	mul	bl
	add	eax, IMPArray
	mov	IMPArrayLoc, eax

	push	ebx
	xor	ebx, ebx

zobloop1:				;'slave' loop : 1 pass for each imported function
	mov	edx, IMPArrayLoc
	mov	edx, [edx]
	lea	edx, [ebx*4+edx]
	mov	ecx, [edx]
	test	ecx, ecx
	je	zobloop1n		;skip this function
	cmp	ecx, imgsize		;if ecx<imgsize, then this IAT is correct
	jle	skipfunc

	mov	eax, DLLArrayLoc
	call	GetDLLFunctionName	;get correct IAT for this function
	test	eax, eax
	je	zobloop1b		;eax=0, then function address not found in memory
	mov	edi, eax
	sub	edi, [map_ptr]		;sub mapping loc
	add	edi, impdecal		;add section gap
	mov	[edx], edi		;save new fixed IAT
	inc	funcnumb		;inc counter of funcs for report
	inc	ebx			;next function
	jmp	zobloop1		;'slave' loop
zobloop1b:
	inc	funcerr			;inc counter of fails for report
	xor	edi, edi
	mov	[edx], edi		;put 00 at this IAT
skipfunc:
	inc	ebx			;next function
	jmp	zobloop1		;'slave' loop

zobloop1n:
	pop	ebx
	inc	ebx			;next DLL
	cmp	ebx, DLLNumb		;test if finished
	jne	zobloop2		;if not -> main loop

fpeffin:
	cmp	funcnumb, 0		;test number of fixed functions
	jg	fpeffin2
	call	AddReportTxt,offset strNOIMP	;no function fixed -> report text
fpeffin2:
	call	AddReportTxt,offset strLINE	;end import table section in report text

	call	unmap			;unmap the file
	call	CloseTheFile		;close the file
	push	DLLArray
	call	LocalFree		;free DLL array mem
	mov	error, 1
fpeferr:
	movzx	eax, error
	ret
FixPEFile	endp


NextFnctName	proc			;get next function name string ptr in the import table
	push	ebx
	push	ecx
	push	edx
	mov	esi, FnctPoint
	add	esi, 2
	call	strnlen
	add	eax, esi
	mov	edi, eax

	xor	eax, eax
	mov	ecx, 5
	repe	scasb
	dec	edi
	mov	esi, edi

	call	strnlen
	cmp	eax, 4			;test if fucntions field is not outpassed (astuce  2 balles)
	jle	nfnnone
	sub	esi, 2
	mov	FnctPoint, esi
	pop	edx
	pop	ecx
	pop	ebx
	ret
nfnnone:
	mov	eax, -1
	pop	edx
	pop	ecx
	pop	ebx
	ret
NextFnctName	endp

CreateDLLArray	proc			;create 2 arrays : 1 for imported DLLs. 1 for imported functions
	push	eax
	push	ebx
	push	ecx
	push	edx

	mov	DLLNumb2, 0		;DLLNumb2=number of dlls that don't need to be rebuilt

	mov	ecx, DLLNumb
	add	ecx, 1
	mov	eax, 100
	mul	ecx
	mov	esi, eax

	push	esi

	mov	ecx, DLLNumb
	add	ecx, 3
	mov	eax, 4
	mul	ecx
	add	eax, esi

	call	LocalAlloc,LMEM_ZEROINIT,eax	;allocate mem for DLL array
	mov	DLLArray, eax			;save ptr
	mov	DLLArrayLoc, eax

	pop	esi

	add	eax, esi
	add	eax, 4
	mov	IMPArray, eax
	mov	IMPArrayLoc, eax

	sub	IMPArrayLoc, 4		;align var
	
	xor	ebx, ebx
cdllaloop:
	mov	edx, MapImpLoc
	mov	eax, 20			;REAL length of IMAGE_IMPORT_DESCRIPTOR struct
	mul	bl
	mov	edi, [edx]
	test	edi, edi
	jne	bdllar			;If the orig thunk is present, then skip
	add	edx, eax


	add	edx, 12			;IMAGE_IMPORT_DESCRIPTOR.Name
	mov	esi, edx
	mov	eax, 100
	mul	bl
	add	eax, DLLArray
	mov	DLLArrayLoc, eax
	mov	eax, 4
	mul	bl
	add	eax, IMPArray
	mov	IMPArrayLoc, eax
	mov	eax, IMPArrayLoc
	mov	ecx, [esi+4]
	add	ecx, [map_ptr]
	sub	ecx, impdecal		;gap VA<->RVA
	mov	[eax], ecx
	lodsd
	mov	esi, eax
	add	esi, [map_ptr]
	sub	esi, impdecal		;GAP VA<->RVA
	call	strnlen
	inc	eax
	mov	ecx, eax
	mov	edi, DLLArrayLoc
	rep	movsb
bdllar2:
	inc	ebx
	cmp	ebx, DLLNumb
	jne	cdllaloop
	mov	eax, DLLArray
	mov	DLLArrayLoc, eax
	mov	eax, IMPArray
	mov	IMPArrayLoc, eax

	mov	eax, DLLNumb2
	sub	DLLNumb, eax
	pop	edx
	pop	ecx
	pop	ebx
	pop	eax
	ret
bdllar:
	inc	DLLNumb2
	jmp	bdllar2	
CreateDLLArray	endp

GetDLLFunctionName	proc			;params : eax=*dll name  ecx=fnct addr
	push	ebx
	push	ecx
	push	edx
	push	eax
	mov	ebx, ecx
	mov	FuncAddr, ebx

	mov	edx, FnctNames
	mov	FnctPoint, edx

	call	GetModuleHandleA, eax
	test	eax, eax
	je	gdllfnerr
	mov	DLLHandle, eax

gdllfnloop:
	mov	eax, FnctPoint
	add	eax, 2
	call	GetProcAddress,DLLHandle,eax
	cmp	eax, FuncAddr
	je	gdllfnok
	call	NextFnctName
	cmp	eax, -1
	je	gdllfnerr
	jmp	gdllfnloop

gdllfnok:
	pop	eax
	call	AddReportLine2			;add line to report text

	pop	edx
	pop	ecx
	pop	ebx
	mov	eax, FnctPoint
	ret
gdllfnerr:
	pop	eax
	pop	edx
	pop	ecx
	pop	ebx
	xor	eax, eax
	ret
GetDLLFunctionName	endp


AddReportLine1	proc				;report text line adding proc. Useless to comment it
	pushad
	mov	cursec, edi

	mov	esi, edi
	call	strnlen
	mov	ecx, eax
	mov	edi, offset strSecRVA2
	rep	movsb
	mov	ecx, 8
	sub	ecx, eax
	mov	al, 20h
	rep	stosb

	mov	esi, cursec

	call	strnlen
	mov	ecx, eax
	mov	edi, offset strSecSIZ2
	rep	movsb
	mov	ecx, 8
	sub	ecx, eax
	mov	al, 20h
	rep	stosb

	mov	edi, cursec

	mov	eax, [edi+20]
	mov	edi, offset strSecRVA3
	call	print_hex_32b

	mov	edi, cursec

	mov	eax, [edi+16]
	mov	edi, offset strSecSIZ3
	call	print_hex_32b

	mov	edi, cursec

	mov	eax, [edi+12]
	mov	edi, offset strSecRVA4
	call	print_hex_32b

	mov	edi, cursec

	mov	eax, [edi+8]
	mov	edi, offset strSecSIZ4
	call	print_hex_32b

	call	AddReportTxt,offset strSecRVA
	call	AddReportTxt,offset strSecSIZ

	popad
	ret
AddReportLine1	endp


AddReportLine2	proc				;report text line adding proc. Useless to comment it
	mov	esi, eax
	call	strnlen
	mov	ecx, eax
	mov	edi, offset strIMPFUNC
	rep	movsb

	mov	byte ptr [edi], '!'
	inc 	edi

	mov	esi, FnctPoint
	add	esi, 2
	call	strnlen
	mov	ecx, eax
	rep	movsb

	mov	[edi], '  - '
	add	edi, 3

	mov	esi, offset strFIXED
	call	strnlen
	mov	ecx, eax
	inc	ecx				;include the 0 at th end
	rep	movsb

	call	AddReportTxt,offset strIMPFUNC

	ret
AddReportLine2	endp


.Data

IMPORTENTRY	struct				;personnal struct
	res1		dd 0
	res2		dd 0
	res3		dd 0
	lpDLLName	dd 0
	Imports		dd 0
IMPORTENTRY	ends

IMAGE_NT_SIGNATURE  	EQU     000004550h

fnhand			dd 0

DLLHandle		dd 0
FuncAddr		dd 0

DLLNumb			dd 0
DLLNumb2		dd 0

DLLArray		dd 0
DLLArrayLoc		dd 0
IMPArray		dd 0
IMPArrayLoc		dd 0

FnctPoint		dd 0
FnctNames		dd 0
MapPEHeader		dd 0
MapImpLoc		dd 0
FileOpened		dd 0

funcnumb		dd 0
funcerr			dd 0

dfhand			dd 0

doneimpfix		dd 0
impdecal		dd 0

numsec			dd 0

imgsize			dd 0
cursec			dd 0
