.386
locals
jumps
.model flat,STDCALL

extrn	ImageRvaToVa		: PROC
extrn	ImageRvaToSection	: PROC

UNICODE=0

include w32.inc

PBM_SETRANGE    equ WM_USER+1
PBM_SETPOS      equ WM_USER+2
PBM_DELTAPOS    equ WM_USER+3
PBM_SETSTEP     equ WM_USER+4
PBM_STEPIT      equ WM_USER+5

IDC_FILENAME		equ	3000
IDC_BUTTON              equ     3001
IDC_EXIT                equ     3002
IDC_BROWSE		equ	3003
IDC_ABOUT		equ	3004
IDC_NEWALIGN		equ	3006
IDC_OLDALIGN		equ	3007
IDC_REPORT		equ	3008

IDC_DETAILS		equ	3000

IDC_CHKREALIGN		equ	20001
IDC_CHKSECSIZE		equ	20002
IDC_CHKIMPORT		equ	20000
IDC_CHKRAW		equ	20003
IDC_CHKBACKUP		equ	20004
IDC_CHKRRSRC		equ	20005
IDC_CHKSUPERAL		equ	20006
IDC_CHKRELOC		equ	20007

IDC_RADIOMODE1		equ	3005
IDC_RADIOMODE0		equ	3009

IDC_PROGRESS		equ	30000
IDC_STATUS		equ	30002

;---------Report Dialog Consts----------
IDC_ORGALIGN		equ	12013
IDC_NEWALIGN2		equ	12018
IDC_ORGSIZE		equ	12014
IDC_NEWSIZE		equ	12015
IDC_DLLFIXED		equ	12010
IDC_FUNCTIONS		equ	12011
IDC_FAILS		equ	12012
IDC_RAW			equ	12008
IDC_DIFF		equ	12009
;---------About Dialog Consts-----------
IDC_LICENSE		equ	3500
IDC_MAILTITI		equ	3600
IDC_MAILVIROGEN		equ	3601
IDC_GOPC		equ	3602
IDC_GOTITI		equ	3604
;---------------------------------------
ICON_BIG		equ	1
ICON_SMALL		equ	0

IDM_GETTEXT             equ     32000
IDM_CLEAR               equ     32001
IDM_EXIT                equ     32002

BN_CLICKED              equ     0

MB_ICONASTERISK         equ     040h
MB_ICONHAND             equ     010h


WM_DESTROY              equ     0002h
WM_CLOSE                equ     0010h
WM_INITDIALOG           equ     0110h
WM_COMMAND              equ     0111h

GMEM_ZEROINIT           equ     040h

;---------Structures Decalrartions----------------

RECT	struct
     rc_left		dd 0
     rc_top		dd 0
     rc_right		dd 0
     rc_bottom		dd 0
RECT	ends

OPENFILENAME struc
    Size        dd ?
    HOwner      dd ?
    AppHwnd     dd ?
    Filters     dd ?
    CustFilters dd ?
    CstFltSize  dd ?
    CurFilter   dd ?
    CurFileName dd ?
    CurFlNmSize dd ?
    CurFile     dd ?
    CurFlSize   dd ?
    InitialDir  dd ?
    DlgTitle    dd ?
    Flags       dd ?
    FileOffset  dw ?
    ExtOffset   dw ?
    Extension   dd ?
    CustData    dd ?
    HookProc    dd ?
    TmplateRsc  dd ?
OPENFILENAME ends


.data

defaultTXT	db 'By TiTi/BLZ & Virogen/PC',0

linktiti	db 'http://titiasm.cjb.net',0
linkpc		db 'http://www.phrozencrew.com',0

mailtiti	db 'mailto:titi@blizzard.st',0
mailvirogen	db 'mailto:vgen@hotmail.com',0

LicenseText	db '  This tool is totally free of use. Its source is distribued for educationnal purpose, and can be used, provided you ask the authors by email.',13,10,13,10
		db '  PE Rebuilding is a sensitive process, and may lead to crashes on some PE Files. So, ALWAYS do a save copy of the file you want to rebuild. Authors are not responsible of any damage made by this tool to your system. Use it at your own risk :p',0

AppHWndd         dd 0

readhexstr	db 9 dup (0)
rhresult	dd 0

curdir  	db 513 dup (0)
curdir2		db 513 dup (0)

bogus		db 20 dup (0)
bogus2		db 9 dup (0)

hMain		dd 0

TagRealign	db 0
TagSecsize	db 0
TagImport	db 0
TagRaw		db 0
TagRrsrc	db 0
TagSuperal	db 0
TagReloc	db 0
TagReport	db 1

SuperalMode	db 0

reportbuff	dd 0

RebError	db 0

InitialSize	dd 0

defaultalign	db '00000200',0

okaytitle	db 'Completed',0
okaytext	db 'PE File rebuilt successfully',0

somerrtext	db 'PE File rebuild completed.',13,10
		db 'Anyway there were errors... See ''Report'' for more details',0

errtitletxt	db 'Fatal Error',0
erraligntxt	db 'An error occured while trying to realign the file.',0
errimptxt	db 'An error occured while trying to rebuild the import table',0
erralignvtxt	db 'The new file alignment you specified is incorrect',13,10,13,10
		db 'It must be a Hex value greater than 200h, and it',13,10
		db 'also must NOT be greater than the original align.',0
errreloctxt	db 'Error while trying to fix RAW offsets.',13,10
		db 'This file has probably NOT been dumped, of has already been fixed',0
erropentxt	db 'Could not open the specified file...',0
errselecttxt	db 'Please select at least one of the rebuild options',0

filopen    OPENFILENAME <?>
filfilt	db "Executables (*.EXE)",0h,"*.EXE",0h
	db "All Files (*.*)",0h,"*.*",2 dup (0)
;----------------Status strings--------------------------
statALIGN	db 'Realigning the file...',0
statREBIMP	db 'Rebuilding import table...',0
statRERSRC	db 'Restructuring resource directory...',0
statFIXRAW	db 'Fixing RAW offsets...',0
statMZ		db 'Rebuilding DOS Stub (MZ Header)',0
statRELOC	db 'Wiping the .reloc section',0
statEOF		db 'Wiping ending zeros',0
statALLDONE	db 'Rebuild process completed !',0

;----------------Report frame strings--------------------
strBYTES	db ' bytes - ('
strBYTES2	db 6 dup (0)

strLINE		db 13,10,'----------------------------------------------------------',13,10,13,10,0
strCRLF		db 13,10,0

strPHASE	db 'PHASE x - ',0

strPART1	db 'Section RAW Fix Module :',13,10,13,10,0

strERRSEC	db 'RAW fixing could not be performed on this PE file.',13,10,0

strSecRVA	db 'Section '
strSecRVA2	db '         - changed RAW VA from '
strSecRVA3	db '00000000h to '
strSecRVA4	db '00000000h',13,10,0

strSecSIZ	db 'Section '
strSecSIZ2	db '         - changed RAW Size from '
strSecSIZ3	db '00000000h to '
strSecSIZ4	db '00000000h',13,10,0

strPART2	db 'Import Table Rebuild Module :',13,10,13,10,0

strNOIMP	db 'No imported function has been fixed',13,10,0

strIMPLOC	db 'Import table RVA :'
strIMPLOC2	db '00000000h - RAW VA : '
strIMPLOC3	db '00000000h',13,10,13,10,0

strIMPFUNC	db 150 dup (0)

strFIXED	db 'Import Fixed',13,10,0


strPART3	db 'PE Realigner Module :',13,10,13,10,0

strRESIZ	db 'Section '
strRESIZ2	db 'xxxxxxxx - Size decreased of '
strRESIZ3	db 10 dup (0)

strTOTSEC	db 13,10,'Space saved by resizing sections : '
strTOTSEC2	db 10 dup (0)

strTOTPAD	db 'Space saved by removing useless padding : '
strTOTPAD2	db 10 dup (0)

strTOTTOT	db 'Total space saved : '
strTOTTOT2	db 10 dup (0)

strPART4	db 'Resource Directory Restructure Module :',13,10,13,10,0

strRSRC		db 'Number of Resource entries restructured : '
strRSRC2	db 10 dup (0)

strERRSRC	db 'Resource Restructure could not be performed on this PE file.',13,10,0

strPART5	db 'MZ Header Rebuilding Module :',13,10,13,10,0

strWipeMZ	db 'Space saved by MZ Header Rebuilding : '
strWipeMZ2	db 10 dup (0)

strNewPEOff	db 13,10,'New offset of PE Header : '
strNewPEOff2	db '00000000h',0

strSuperMode0	db '  -  (Friendly Mode)',13,10,0
strSuperMode1	db '  -  (Strong Mode)',13,10,0

strPART6	db 'EOF Wiping Module :',13,10,13,10,0

strWipeEOF	db 'Space saved by Wiping Ending ZEROs : '
strWipeEOF2	db 10 dup (0)

strPART7	db '.reloc Section Wiping Module :',13,10,13,10,0

strRELOC	db 'RAW Size of the wiped .reloc section : '
strRELOC2	db 10 dup (0)

strRELAL	db 13,10,'Space saved by associated realign : '
strRELAL2	db 10 dup (0)

strNORELOC	db 'No .reloc section can be wiped in this file',13,10,0

strERROR	db 'Error occured while performing this operation',13,10,0

repsec	dd 0

wc	WNDCLASSEX <>
;--------------------------------------------------------
DlgRect		RECT <>
DlgWidth	dd ?
DlgHeight	dd ?
DesktopRect	RECT <>
SizeHwnd	dd 0

statheight	dd 0
statwidth	dd 0
stathwnd	dd 0
statx		dd 0
staty		dd 0
winx		dd 0
winy		dd 0

PointsArray	dd 0,0, 030h,0, 030h,0FFh, 0h,0FFh

DlgName         db "MyDialog",0
ReportDlgName	db "ReportDialog",0
AboutDlgName	db "AboutDialog",0


.code

include	pefix.asm
include	vgal.asm
include restruct.asm

Start:
	call    GetModuleHandleA, 0
	mov     [AppHWndd],eax
	call	GetProcessHeap
	mov	HeapHandle,eax
	call	VirtualAlloc,0,20000,MEM_COMMIT,PAGE_READWRITE
	mov	reportbuff, eax			;alloc 20Kb for report buffer
	call	InitCommonControls		;init common controls
	call    DialogBoxParamA,[AppHWndd],offset DlgName,0,offset WndProc,0
	call    ExitProcess, 0

WndProc proc uses ebx edi esi, hwnd:DWORD, wmsg:DWORD, wparam:DWORD, lparam:DWORD

	cmp     [wmsg], WM_INITDIALOG
	je      dlginit
	cmp     [wmsg], WM_COMMAND
	je      wmcommand
	cmp     [wmsg], WM_SYSCOMMAND
	je      dlgsysc
	mov     eax, 0
	ret
dlginit:
	call    LoadIconA,AppHWndd,101		;Set window icon
	push	eax
	call    SendMessageA,hwnd,80h,ICON_SMALL,eax
	pop 	eax
	call    SendMessageA,hwnd,80h,ICON_BIG,eax

	call	CenterWindow,hwnd		;Center window in desktop
	call	SetDlgItemTextA,hwnd,IDC_NEWALIGN,offset defaultalign
	call	InitStatusProgress		;init status and progress bar
	call	SetStatus,offset defaultTXT	;set default statusbar text

	call	CheckDlgButton,hwnd,IDC_RADIOMODE1,1

	mov	eax, hwnd
	mov	hMain, eax

	mov     eax, 1
	ret

dlgsysc:
	mov     eax, [wparam]
	cmp     eax, SC_CLOSE
	je      btn2                    	;If CLOSE Pressed, then exit

	xor	eax, eax			;process command
	ret


wmcommand:
	mov     eax, [wparam]
	cmp     ax, IDC_BUTTON
	je      btnreb
	cmp     ax, IDC_EXIT
	je      btn2
	cmp	ax, IDC_BROWSE
	je	btnbrowse
	cmp	ax, IDC_REPORT
	je	dispreport
	cmp	ax, IDC_CHKREALIGN
	je	chk1click
	cmp	ax, IDC_CHKSUPERAL
	je	chk2click
	cmp	ax, IDC_ABOUT
	je	dispabout
	mov     eax, 0
	ret

dispabout:
	call    DialogBoxParamA,[AppHWndd],offset AboutDlgName,hwnd,offset AboutProc,0
	jmp	btnend

chk1click:			;checkbox 'Realign' clicked
	shr	eax, 16
	cmp	eax, BN_CLICKED
	jne	btnend

	call	IsDlgButtonChecked,hwnd,IDC_CHKREALIGN
	mov	esi, eax

	call    GetDlgItem, hwnd, IDC_NEWALIGN
	call    EnableWindow, eax, esi
	call    GetDlgItem, hwnd, IDC_CHKSECSIZE
	call    EnableWindow, eax, esi
	call    GetDlgItem, hwnd, IDC_CHKSUPERAL
	xor	ebx, ebx
	test	esi, esi
	sete	bl
	call    EnableWindow, eax, ebx
	jmp	btnend


chk2click:			;checkbox 'Super Align' clicked
	shr	eax, 16
	cmp	eax, BN_CLICKED
	jne	btnend

	call	IsDlgButtonChecked,hwnd,IDC_CHKSUPERAL
	mov	esi, eax
	call    GetDlgItem, hwnd, IDC_RADIOMODE1
	call    EnableWindow, eax, esi
	call    GetDlgItem, hwnd, IDC_RADIOMODE0
	call    EnableWindow, eax, esi
	xor	ebx, ebx
	test	esi, esi
	sete	bl
	mov	esi, ebx
	call    GetDlgItem, hwnd, IDC_CHKREALIGN
	call    EnableWindow, eax, esi
	jmp	btnend

btn2:				;exit pressed
	shr     eax,16
	cmp     ax, BN_CLICKED
	jne     btnend

	call	VirtualFree,reportbuff,20000,MEM_DECOMMIT   ;free report text buffer

	call    ExitProcess,0
	jmp     btnend

dispreport:
	call    DialogBoxParamA,[AppHWndd],offset ReportDlgName,hwnd,offset ReportProc,0
	jmp	btnend


btnreb:
	shr     eax,16
	cmp     ax, BN_CLICKED
	jne	btnend

	call	GetDlgItemTextA,hwnd,IDC_FILENAME,offset curdir,512

	mov	eax, offset curdir	;test is filename is valid
	call	OpenTheFile
	test	eax, eax
	je	erropen
	mov	eax, ffsize
	mov	InitialSize, eax
	call	CloseTheFile

	call	GetDlgItemTextA,hwnd,IDC_NEWALIGN,offset bogus,9
	mov	esi, offset bogus
	call	read_hex_32b
	mov	newalign, eax		;store new align

	cmp	eax, orgalign		;
	jg	erralignval		;
	cmp	eax, 200h		;Check specified newalign value
	jl	erralignval		;

	call	IsDlgButtonChecked,hwnd,IDC_RADIOMODE1
	mov	SuperalMode, al

	call	IsDlgButtonChecked,hwnd,IDC_CHKREALIGN
	mov	TagRealign, al
	call	IsDlgButtonChecked,hwnd,IDC_CHKSECSIZE
	mov	TagSecsize, al
	call	IsDlgButtonChecked,hwnd,IDC_CHKIMPORT
	mov	TagImport, al
	call	IsDlgButtonChecked,hwnd,IDC_CHKRRSRC
	mov	TagRrsrc, al
	call	IsDlgButtonChecked,hwnd,IDC_CHKRAW
	mov	TagRaw, al
	call	IsDlgButtonChecked,hwnd,IDC_CHKSUPERAL
	mov	TagSuperal, al
	call	IsDlgButtonChecked,hwnd,IDC_CHKRELOC
	mov	TagReloc, al

	or	al, TagImport
	or	al, TagRealign
	or	al, TagRrsrc
	or	al, TagRaw
	or	al, TagSuperal
	test	eax, eax
	je	errsel

	call	IsDlgButtonChecked,hwnd,IDC_CHKBACKUP
	test	eax, eax
	je	rebbegin
	call	MakeBackup			;backup original exe to .exe.bak

rebbegin:
	call	DispReportInit			;init report text buffer
	mov	RebError, 0
	mov	repsec, 1			;init phase counter

	cmp	TagSuperal, 1
	jne	rebc1
	mov	TagRealign, 1
	mov	TagSecsize, 1
	add	TagSuperal, 1
  rebc1:
	movzx	eax, TagRaw
	add	al, TagImport
	add	al, TagRealign
	add	al, TagRrsrc			;eax=numb of phases to be performed
	add	al, TagReloc
	add	al, TagSuperal
	mov	ebx, 10
	mul	ebx
	call	SetProgressRng,eax		;Set progressbar range value

	cmp	TagRaw, 1
	jne	reb0

	call	SetStatus,offset statFIXRAW	;Set status bar text
	mov	eax, offset curdir
	call	FixDumpedFile			;Fiw RAW offsets of file
	call	StepProgress			;step progressbar


reb0:
	cmp	TagRrsrc, 1
	jne	reb05

	call	SetStatus,offset statRERSRC	;Set status bar text
	mov	eax, offset curdir
	call	RestructRsrc			;restructure rsrc directory
	call	StepProgress			;step progressbar
	
reb05:
	cmp	TagImport, 1
	jne	reb1

	call	SetStatus,offset statREBIMP	;Set status bar text
	mov	eax, offset curdir
	call	FixPEFile			;Rebuild import table
	test	eax, eax			;did error happened ?
	je	errimp
	call	StepProgress			;step progressbar

reb1:
	cmp	TagReloc, 1
	jne	reb12
	call	SetStatus,offset statRELOC	;Set status bar text
	mov	eax, offset curdir
	call	WipeReloc
	call	StepProgress			;step progressbar

reb12:
	cmp	TagSuperal, 0
	je	reb15


	call	SetStatus,offset statALIGN	;Set status bar text
	mov	newalign, 200h
	mov	eax, offset curdir
	call	AlignFile			;align and resize sections
	test	eax, eax			;did error happened ?
	je	erralign
	call	StepProgress			;step progressbar

	call	SetStatus,offset statMZ		;Set status bar text
	mov	eax, offset curdir
	call	WipeMZ
	call	StepProgress

	call	SetStatus,offset statALIGN	;Set status bar text
	mov	newalign, 200h
	mov	eax, offset curdir
	call	AlignFile			;align and resize sections
	test	eax, eax			;did error happened ?
	je	erralign
	call	StepProgress			;step progressbar

	call	SetStatus,offset statEOF		;Set status bar text
	mov	eax, offset curdir
	call	FixupEOF			;wipe ending Zeros

	jmp	reb2
	
reb15:
	cmp	TagRealign, 1
	jne	reb2

	call	SetStatus,offset statALIGN	;Set status bar text
	mov	eax, offset curdir
	call	AlignFile			;align and resize sections
	test	eax, eax			;did error happened ?
	je	erralign
	call	StepProgress			;step progressbar

reb2:
	mov	eax, offset curdir
	call	OpenTheFile
	call	GetFileSize,handle1,0
	mov	new_fsize, eax
	call	CloseTheFile

	call    GetDlgItem,hwnd,IDC_REPORT
	call    EnableWindow,eax,1		;enable 'report' button
	call	SetStatus,offset statALLDONE	;Set status bar text

	cmp	RebError, 1			;did error(s) happened ?
	je	some_errs

	call    MessageBoxA, hwnd, offset okaytext, offset okaytitle, MB_ICONASTERISK
	jmp	btnend

some_errs:
	call    MessageBoxA, hwnd, offset somerrtext, offset okaytitle, MB_ICONASTERISK
	jmp	btnend

;error messages 

errimp:
	call    MessageBoxA, hwnd, offset errimptxt, offset errtitletxt, MB_ICONHAND
	jmp	btnend

erralign:
	call    MessageBoxA, hwnd, offset erraligntxt, offset errtitletxt, MB_ICONHAND
	jmp	btnend

erralignval:
	call    MessageBoxA, hwnd, offset erralignvtxt, offset errtitletxt, MB_ICONHAND
	jmp	btnend
errsel:
	call    MessageBoxA, hwnd, offset errselecttxt, offset errtitletxt, MB_ICONHAND
	jmp	btnend

erropen:
	call    MessageBoxA, hwnd, offset erropentxt, offset errtitletxt, MB_ICONHAND
	jmp	btnend

btnbrowse:
	mov     [filopen.Size],76
        mov     eax,[hwnd]
        mov     ebx,[AppHWndd]
        mov     [filopen.HOwner],eax
        mov     [filopen.AppHwnd],ebx
        mov     [filopen.Filters],offset filfilt
        mov     [filopen.CustFilters],0
        mov     [filopen.CstFltSize],0
        mov     [filopen.CurFilter],1
        mov     [filopen.CurFileName],offset curdir
        mov     [filopen.CurFlNmSize],512
        mov     [filopen.CurFile],0
        mov     [filopen.CurFlSize],0
        mov     [filopen.InitialDir],0
        mov     [filopen.DlgTitle],0
        mov     [filopen.Flags],1800h
        mov     [filopen.FileOffset],0
        mov     [filopen.ExtOffset],0
        mov     [filopen.Extension],0
        mov     [filopen.CustData],0
        mov     [filopen.HookProc],0
        mov     [filopen.TmplateRsc],0
        call    GetOpenFileNameA,offset filopen	;display 'open file' dialog
	test	eax, eax			;error or cancel pressed ?
	je	btnend

	call    SetDlgItemTextA,hwnd,IDC_FILENAME,offset curdir

	call	InitTags			;init check tags

	mov	eax, offset curdir
	call	OpenTheFile
	test	eax, eax
	je	browerr
        call    create_mapping			; create file mapping
        jc      browerr

        cmp     word ptr [eax],'ZM'		; is EXE?
        jnz     browerr
        call    GetPEHead			; load esi->PE Header
        call    IsBadReadPtr,esi,2              ; was ptr any good?       
        or      eax,eax
        jnz     browerr
        cmp     word ptr [esi],'EP'		; PE?
        jnz     browerr

	mov	eax,[esi+filealign]
	mov	orgalign,eax

	call	unmap
	call	CloseTheFile

	call	DispBogusHex,orgalign,IDC_OLDALIGN	;display original align

	call    GetDlgItem, hwnd, IDC_REPORT
	call    EnableWindow, eax, 0		;disable 'report' button
	call    GetDlgItem, hwnd, IDC_BUTTON
	call    EnableWindow, eax, 1		;enable 'rebuild' button
	jmp	btnend

browerr:
	call	unmap
	call	CloseTheFile
	call    MessageBoxA, hwnd, offset erropentxt, offset errtitletxt, MB_ICONHAND
	jmp	btnend	

btnend:
	mov     eax, 1
	ret
Less:
;-----------Ouverture du fichier-----------------

mle:
nogo:
	xor     eax,eax
	ret
WndProc          endp


ReportProc proc uses ebx edi esi, hwnd:DWORD, wmsg:DWORD, wparam:DWORD, lparam:DWORD
	cmp     [wmsg], WM_INITDIALOG
	je      rddlginit
	cmp     [wmsg], WM_COMMAND
	je      rdwmcommand
	cmp	[wmsg], WM_SYSCOMMAND
	je	rddlgsysc
	mov     eax, 0
	ret

rddlginit:
	call	CenterWindow,hwnd		;center dialog window

	call	SetDlgItemTextA,hwnd,IDC_DETAILS,reportbuff
	call	DispBogusDec,InitialSize,IDC_ORGSIZE

;	cmp	TagRealign, 1
;	jne	rddlgc1
	call	DispBogusDec,new_fsize,IDC_NEWSIZE

	mov	eax, InitialSize
	sub	eax, new_fsize
	mov	ebx, IDC_DIFF

	push 	ebx
	mov     edi, offset bogus
	call    print_dec_32b
	mov	esi, offset bogus
	call	strnlen
	add	edi, eax
	push	edi

	mov	eax, InitialSize
	sub	eax, new_fsize
	mov	ebx, 100
	mul	ebx
	mov	ebx, InitialSize
	div	ebx
	mov	edi, offset strBYTES2
	call	printdec
	mov	word ptr [edi-1], ')%'
	mov	byte ptr [edi+1], 0

	mov	esi, offset strBYTES
	call	strnlen
	mov	ecx, eax
	pop	edi
	rep	movsb

	pop	ebx
	call    SetDlgItemTextA, hwnd, ebx, offset bogus

	call	DispBogusHex,newalign,IDC_NEWALIGN2
	call	DispBogusHex,orgalign,IDC_ORGALIGN

rddlgc1:
	cmp	TagImport, 1
	jne	rddlgc2
	call	DispBogusDec,DLLNumb,IDC_DLLFIXED
	call	DispBogusDec,funcnumb,IDC_FUNCTIONS
	call	DispBogusDec,funcerr,IDC_FAILS

rddlgc2:
	cmp	TagRaw, 1
	jne	rddlgc3
	call	DispBogusDec,numsec,IDC_RAW

rddlgc3:
	jmp     btnend

rddlgsysc:
	mov	eax, [wparam]
	cmp	eax, SC_CLOSE
	je	rdeexit			;If CLOSE Pressed, then exit

	xor	eax, eax
	ret

rdwmcommand:
	mov     eax, [wparam]
	cmp     ax, IDC_EXIT
	je      rdeexit
	mov     eax, 0
	ret

rdeexit:
	shr     eax,16
	cmp     ax, BN_CLICKED
	jne     rdbtnend

	call	EndDialog, hwnd, 0
	jmp     rdbtnend

rdbtnend:
	mov     eax, 1
	ret
ReportProc endp


AboutProc proc uses ebx edi esi, hwnd:DWORD, wmsg:DWORD, wparam:DWORD, lparam:DWORD
	cmp     [wmsg], WM_INITDIALOG
	je      abdlginit
	cmp     [wmsg], WM_COMMAND
	je      abwmcommand
	cmp	[wmsg], WM_SYSCOMMAND
	je	abdlgsysc
	mov     eax, 0
	ret

abdlginit:
	call	CenterWindow,hwnd		;center dialog window
	push	offset LicenseText
	push	IDC_LICENSE
	push	hwnd
	call	SetDlgItemTextA
	jmp	btnend

abdlgsysc:
	mov	eax, [wparam]
	cmp	eax, SC_CLOSE
	je	abexit			;If CLOSE Pressed, then exit
	xor	eax, eax
	ret

abwmcommand:
	mov     eax, [wparam]
	cmp     ax, IDC_GOPC
	je      gopc
	cmp     ax, IDC_GOTITI
	je      gotiti
	cmp	ax, IDC_MAILTITI
	je	mtiti
	cmp	ax, IDC_MAILVIROGEN
	je	mvirogen
	mov     eax, 0
	ret

mtiti:
	call	ShellExecuteA,hMain,NULL,offset mailtiti,NULL,NULL,NULL
	jmp	btnend

mvirogen:
	call	ShellExecuteA,hMain,NULL,offset mailvirogen,NULL,NULL,NULL
	jmp	btnend

gotiti:
	call	ShellExecuteA,hMain,NULL,offset linktiti,NULL,NULL,NULL
	jmp	btnend

gopc:
	call	ShellExecuteA,hMain,NULL,offset linkpc,NULL,NULL,NULL
	jmp	btnend

abexit:
	shr     eax,16
	cmp     ax, BN_CLICKED
	jne     btnend
	call	EndDialog, hwnd, 0
	jmp     btnend
AboutProc	endp

;
; --- DWORD InitTags()
; Init tags
;
InitTags	proc
	mov	TagRealign, 0
	mov	TagSecsize, 0
	mov	TagImport, 0
	mov	TagRaw, 0
	ret
InitTags	endp

;
; --- DWORD MakeBackup()
; Make backup copy of file. Call with curdir & curdir2 set
;
MakeBackup	proc
	mov	esi, offset curdir
	mov	edi, offset curdir2
	mov	ecx, 512
	rep	movsb
	mov	esi, offset curdir2
	call	strnlen
	add	esi, eax
	mov	[esi], 'KAB.'
	mov	byte ptr [esi+4], 0
	call	CopyFileA, offset curdir, offset curdir2, FALSE
	ret
MakeBackup	endp

;
; --- DWORD AddReportTxt(DWORD *string)
; Adds specified string to the end of the current report text
;
AddReportTxt	proc	;esi=*string
	pop	eax
	pop	esi
	push	eax
	mov	al, TagReport
	test	al, al
	je	end_art
	mov	edi, esi
	mov	esi, reportbuff
	call	strnlen
	add	esi, eax
	xchg	edi, esi
	call	strnlen
	mov	ecx, eax
	rep	movsb
end_art:
	ret
AddReportTxt	endp

;
; --- DWORD NewReportSec()
; Introduces a new section in the report text. (incremets phase number)
;
NewReportSec	proc
	mov	esi, offset strPHASE
	mov	eax, repsec
	add	eax, 30h
	mov	byte ptr [esi+6], al
	call	AddReportTxt,offset strPHASE
	inc	repsec
	ret
NewReportSec	endp

;
; --- DWORD DispReportInit()
; Clear report text buffer
;
DispReportInit	proc
	xor	eax, eax
	mov	ecx, 20000
	mov	edi, reportbuff
	rep	stosb
	ret
DispReportInit	endp

;
; --- DWORD DispBogusHex(DWORD Number, DWORD IdOfControl)
; Display given number in given control using hexadecimal base
;
DispBogusHex    proc
	pop	ecx
	pop	eax
	pop	ebx
	push	ecx
	mov     edi, offset bogus
	call    print_hex_32b
	mov	byte ptr [edi+8], 0
	call    SetDlgItemTextA, hwnd, ebx, offset bogus
	ret
DispBogusHex    endp

;
; --- DWORD DispBogusDec(DWORD Number, DWORD IdOfControl)
; Display given number in given control using decimal base
;
DispBogusDec    proc
	pop	ecx
	pop	eax
	pop	ebx
	push	ecx
	mov     edi, offset bogus
	call    print_dec_32b
	call    SetDlgItemTextA, hwnd, ebx, offset bogus
	ret
DispBogusDec    endp

;
; --- DWORD SetProgressRng(DWORD MaxValue)
; Set progress bar range value
;
SetProgressRng	proc	;eax=max value
	pop	ebx
	pop	eax
	push	ebx
	shl	eax, 16
	call	SendDlgItemMessage,hwnd,IDC_PROGRESS,PBM_SETRANGE,NULL,eax
	ret
SetProgressRng	endp

;
; --- DWORD StepProgress()
; Step progress bar (default step=10)
;
StepProgress	proc
	call	SendDlgItemMessage,hwnd,IDC_PROGRESS,PBM_STEPIT,NULL,NULL
	ret
StepProgress	endp

;
; --- DWORD SetStatus(DWORD *string)
; Sets Status bar text
;
SetStatus	proc
	pop	eax
	pop	esi
	push	eax
	call	SetDlgItemTextA,hwnd,IDC_STATUS,esi
	ret
SetStatus	endp

;
; --- DWORD InitStatusProgress()
; Display status and progress bar correctly
;
InitStatusProgress	proc
	call	GetWindowRect,hwnd,offset DlgRect
	mov	eax, [DlgRect.rc_left]
	add	eax, 3
	mov	winx, eax
	mov	eax, [DlgRect.rc_top]
	add	eax, 4
	mov	winy, eax

	call	GetDlgItem,hwnd,IDC_STATUS
	push	eax

	call	GetWindowRect,eax,offset DlgRect

	mov	esi, offset PointsArray
	mov	eax, [DlgRect.rc_bottom]
	sub	eax, [DlgRect.rc_top]
	mov	[esi+20], eax
	mov	[esi+28], eax
	sub	eax,2
	mov	statheight, eax

	mov	eax, [DlgRect.rc_top]
	sub	eax, winy
	mov	staty, eax

	mov	edi, [DlgRect.rc_left]
	call	GetDlgItem,hwnd,IDC_PROGRESS
	mov	stathwnd, eax

	call	GetWindowRect,eax,offset DlgRect

	mov	eax, [DlgRect.rc_left]
	sub	eax, edi
	mov	esi, offset PointsArray
	mov	[esi+8], eax
	mov	[esi+16], eax

	mov	eax, [DlgRect.rc_right]
	sub	eax, [DlgRect.rc_left]
	mov	statwidth, eax

	mov	eax, [DlgRect.rc_left]
	sub	eax, winx
	mov	statx, eax

	call	CreatePolygonRgn, offset PointsArray, 4, ALTERNATE
	pop	ebx
        call	SetWindowRgn, ebx, eax, FALSE

	sub	staty, 10h
	call	SetWindowPos,stathwnd,0,statx,staty,statwidth,statheight,SWP_NOZORDER
	ret
InitStatusProgress	endp


;
; --- DWORD CenterWindow(DWORD hWnd)
; Center the window in desktop
;
CenterWindow	proc
;Code by Iczelion (commented by rudeboy) - slightly modified
	pop	ebx
	pop	eax
	push	ebx
	mov	SizeHwnd, eax
	push	offset DlgRect			;Ptr to the Rect struct that will store the coordinates
	push	eax				;The window handle
	call	GetWindowRect			;
	call	GetDesktopWindow		;get the handle to the Desktop window
	push	offset DesktopRect		;offset to the Rect struct that holds the size ofthe desktop
	push	eax                       	;The hWnd ofthe desktop
	call	GetWindowRect			;Get the info
	push	0				;Part of the later call to MoveWindow (no repaint)
	mov	eax, DlgRect.rc_bottom		;Get the bottom of our dialogs window
	sub	eax, DlgRect.rc_top		;subtract the y value at the top of our window
	mov	DlgHeight, eax			;And store it as the dialog's height
	push	eax				;Push it for the call to MoveWindow
	mov	eax, DlgRect.rc_right		;The X coordinate of the right side of our dialog
	sub	eax, DlgRect.rc_left		;minus that of the left side
	mov	DlgWidth, eax			;gives us the width
	push	eax				;Push it for the call to MoveWindow
	mov	eax, DesktopRect.rc_bottom	;Get the bottom of the desktop window
	sub	eax, DlgHeight			;Subtract the height of our dialog
	shr	eax, 1				;and divide by 2...this gives the middle of the screen
	push	eax				;Push for the movewindow call
	mov	eax, DesktopRect.rc_right	;Get the right side of the desktop
	sub	eax, DlgWidth			;Minus the width of our dialog
	shr	eax, 1				;Divide by 2
	push	eax				;Push it
	mov	eax, SizeHwnd			;Get the window hwnd
	push	eax				;Push the window handle
	call	MoveWindow			;Move the window
	xor	eax, eax
	mov	SizeHwnd, eax
	ret
CenterWindow	endp

print_dec_32b	proc
	push	eax
	push    edi
	push    ebx
	push	edx
	mov	ebx,10
	xor	ecx,ecx
p2dl1:	xor	edx,edx
	div	ebx
	push	edx
	inc	ecx
	or	eax,eax
	jne	p2dl1
p2dl2:	pop	edx
	add	dl,'0'
	mov	al,dl
	stosb
	dec	ecx
	jnz	p2dl2
	xor	al,al
	stosb
	pop	edx
	pop     ebx
	pop     edi
	pop	eax
	ret
print_dec_32b	endp

read_hex_32b	proc
	push	esi
	push	esi
	call	CharUpperA
	pop	esi
	call	strnlen
	cmp	eax, 8
	jg	rherr
	je	rhexact
	mov	edi, offset readhexstr
	mov	ebx, eax
	mov	eax, 8
	sub	eax, ebx
	mov	ebx, eax
rhloop1:
	mov	ecx, eax
	mov	eax, 30h
	push	edi
	rep	stosb
	pop	edi
	xor	edx, edx

rhloop2:
	mov	cl, byte ptr [esi+edx]
	cmp	cl, 30h
	jl	rherr
	cmp	cl, 46h
	jg	rherr
	cmp	cl, 40h
	je	rherr
	mov	byte ptr [edi+ebx], cl
	inc	ebx
	inc	edx
	cmp	ebx, 8
	jne	rhloop2
	jmp	rhgo
rhexact:
	mov	edi, offset readhexstr
	xor	ebx, ebx
	xor	edx, edx
	jmp	rhloop2
rhgo:
	mov	rhresult, 0
	xor	ebx, ebx
	xor	ecx, ecx
	mov	esi, edi
	xor	edi, edi
	mov	edi, 10000000h
rhlooop:
	mov	cl, byte ptr [esi+ebx]
	cmp	cl, 40h
	jl	rhc1
	sub	cl, 7
rhc1:	sub	cl, 30h
	mov	eax, edi
	mul	ecx
	add	rhresult, eax
	inc	ebx
	shr	edi, 4
	cmp	ebx, 8
	jne	rhlooop
	mov	eax, rhresult
	ret
rherr:
	mov	ebx, -1
	ret
read_hex_32b	endp

strnlen proc                    ; esi = *string, ret: eax = len
	push    esi
	push	edi
	xor     ecx, ecx
	dec     ecx
sl0:    lodsb
	inc     ecx
	or      al,al
	jnz     sl0
	mov     eax, ecx
	pop	edi
	pop     esi
	ret
strnlen endp

printdec        proc            ; eax = nummer, edi = ziel-ascii
	mov     ebx,10
	xor     ecx,ecx
pdl1:   xor     edx,edx
	div     ebx
	push    edx
	inc     ecx
	or      eax,eax
	jne     pdl1

pdl2:   pop     edx
	add     dl,'0'
	mov     al,dl
	stosb
	dec     ecx
	jnz     pdl2
	xor     al,al
	stosb
	ret
printdec        endp

print_hex_32b   proc
	push    edi
	push    ebx
	mov     ecx,8                   ; 8 digits
p2hl0:  rol     eax,4                   ; rol left 4 bits
	mov     bl,al
	and     bl,1111b
	cmp     bl,0ah
	jl      p2hl0a
	add     bl,7
p2hl0a: add     bl,'0'
	mov     [edi],bl
	inc     edi
	dec     ecx
	jnz     p2hl0
	pop     ebx
	pop     edi
	ret
endp    print_hex_32b


End Start
