RestructRsrc	proc	;eax=*filename string
	mov	numbrsrc, 0

	call	OpenTheFile
	test	eax, eax
	je	err_rrsrc

	call	create_mapping
        jc      err_rrsrc
	push	eax

	call	NewReportSec
	call	AddReportTxt,offset strPART4

	pop	eax
	call	GetPEHead

        movzx	eax,word ptr [esi+numObj]
        mov	TotalSections,eax

        movzx   eax, word ptr [esi+NtHeaderSize]	; get header size
        add     eax,18h					; object table is here
        add     eax,esi
        mov     objptr,eax

	cmp	dword ptr [esi+ID_OFF],marker
	je	no_rsrc

	push	esi
	mov	ebx,[esi+136]
	mov	eax,[esi+140]
	or	ebx,ebx
	jz	no_rsrc
	mov	NewRsrcSize,eax
	mov	RsrcRva,ebx
	call	CalcPhysicalAddress
	add	ebx,map_ptr
	mov	RsrcStartRva,ebx

	call	InitRsrcTables

	call	ScanResourceDir, ebx
	jc	no_rsrc2

	call	FindResourceDataStart 
	xchg	eax, ebx	
	call	CalcPhysicalAddress
	add	ebx,map_ptr
	call	RestructureResourceSection, ebx
	sub	eax,RsrcStartRva
	mov	RsrcDisplacement, eax

	mov	eax, numbrsrc
	mov	edi, offset strRSRC2
	call	printdec

	call	AddReportTxt,offset strRSRC
	call	AddReportTxt,offset strCRLF
	call	AddReportTxt,offset strLINE

	call	unmap
	call	CloseTheFile
	pop	esi
	ret

no_rsrc2:
	pop	esi
no_rsrc:
	clc
	mov	RebError, 1
	call	AddReportTxt,offset strERRSRC
	call	AddReportTxt,offset strLINE

	call	unmap
	call	CloseTheFile
	ret

err_rrsrc:
	call	CloseTheFile
	pop	esi
	ret
RestructRsrc	endp

;
;
; --- DWORD RestructureResourceSection(DWORD *DataStart)
;
RestructureResourceSection proc
	pop	eax
	pop	edi
	push	eax		
	call	PlaceResourceTable,edi,pUncompressableRsrcTable	
	push	eax	
	call	PlaceResourceTable,eax,pCompressableRsrcTable		
	pop	eax
	ret
RestructureResourceSection endp

; --- DWORD *End PlaceResourceTable(DWORD *dest, DWORD *VgRsrcTable)
;
PlaceResourceTable proc
	pop	eax
	pop	edi
	pop	edx
	push	eax
place_rsrc_loop:
	mov	eax,[edx+VgRsrcTableEntryAddress]
	or	eax,eax
	jz	place_loop_done
	mov	ebx,[eax+DataRVA]
	mov	ebx,edi
	sub	ebx,map_ptr
	push	eax edx
	call	CalcVirtualAddress
	pop	edx eax
	mov	dword ptr [eax+DataRVA],ebx
	mov	esi,[edx+VgRsrcTableDataHandle]
	mov	ecx,[eax+RSize]	
	rep	movsb
	inc	numbrsrc
next_vgrsrc:
	add	edx,size VgRsrcTable
	jmp	place_rsrc_loop
place_loop_done:
	mov	eax,edi
	ret
PlaceResourceTable endp

FindResourceDataStart proc        
        push	ebx ecx edx esi edi                
        call 	FindLowestRVAInTable,pCompressableRsrcTable
        push	eax
        call	FindLowestRVAInTable,pUncompressableRsrcTable     
        pop	ebx        
        cmp	ebx,eax
        ja	eax_low
        xchg	ebx,eax
eax_low:        
	pop	edi esi edx ecx ebx
	ret
FindResourceDataStart endp

FindLowestRVAInTable proc
	pop	eax
	pop	esi
	push	eax
	mov	edx,-1
start_loop:	
	mov	eax,[esi+VgRsrcTableEntryAddress]
	or	eax,eax
	jz	start_loop_done
	mov	ebx,[eax+DataRVA]	
	or	ebx,ebx
	jz	not_new_start1
	cmp	ebx,edx
	jae	not_new_start1
	mov	edx,ebx
not_new_start1:	
	add	esi,size VgRsrcTable
	jmp	start_loop	
start_loop_done:	
	xchg	edx,eax
	ret	
FindLowestRVAInTable endp

InitRsrcTables proc	
	call	HeapAlloc,HeapHandle,HEAP_ZERO_MEMORY,size VgRsrcTable*1000	
	mov	pCompressableRsrcTable,eax
	mov	curCompressableRsrcTable,eax
	call	HeapAlloc,HeapHandle,HEAP_ZERO_MEMORY,size VgRsrcTable*1000		
	mov	pUncompressableRsrcTable,eax
	mov	curUncompressableRsrcTable,eax
	ret
InitRsrcTables endp

CalcPhysicalAddress proc
	push	esi edi edx ecx eax	
        mov     eax,objptr
	mov	ecx,TotalSections
continue_find2: 
        mov     edx,eax[objrva]         
        cmp     edx,ebx
        ja 	got_obj_no_dec2
        add	eax,40
        loop	continue_find2        
got_obj_no_dec2:
        sub     eax,40
        sub     ebx,eax[objrva]
        add     ebx,eax[objpoff]
	pop	eax ecx edx edi esi
	ret
CalcPhysicalAddress endp

CalcVirtualAddress proc
	push	esi edi edx ecx eax	
        mov     eax,objptr
	mov	ecx,TotalSections
continue_find: 
        mov     edx,eax[objpoff]         
        cmp     edx,ebx
        ja 	got_obj_no_dec
        add	eax,40
        loop	continue_find        
got_obj_no_dec:
        sub     eax,40
        sub     ebx,eax[objpoff]
        add     ebx,eax[objrva]
	pop	eax ecx edx edi esi
	ret
CalcVirtualAddress endp

; --- ScanResourceDir(DWORD *rsrcdir)
;
ScanResourceDir proc
	pop	eax
	pop	esi	
	push	eax
	
	or	esi,esi
	jz	nothing_in_dir		
	movzx	ecx,word ptr [esi+NumberOfNamedEntries]
	add	cx,word ptr [esi+NumberOfIdEntries]
	add	esi,size ResourceDir
	or	ecx,ecx
	jz	nothing_in_dir	
dir_entry_loop:	
	mov	ebx,[esi+OffsetToData]
	test	ebx,80000000h
	jz	isData			
	cmp	TreeLevel,0
	jnz	doscan_dir
	cmp	[esi+Name],RT_ICON
	jz	uncompressable
	cmp	[esi+Name],RT_GROUPICON
	jz	uncompressable
	cmp	[esi+Name],RT_VERSIONINFO
	jnz	compressable
uncompressable:	
	mov	CompressableRsrc,0
	jmp	doscan_dir
compressable:
	mov	CompressableRsrc,1
doscan_dir:	
	and	ebx,7fffffffh
	add	ebx,RsrcStartRva		
	pushad
	inc	TreeLevel
	call	ScanResourceDir,ebx   ;,[esi+Name]
	jc	srd_err
	dec	TreeLevel
	popad
go_dir_loop:	
	add	esi,size ResourceDirEntry
	loop	dir_entry_loop
	jmp	nothing_in_dir
isData:
	pushad
	call	GetRsrcRva
	jc	srd_err
	popad
	jmp	go_dir_loop
nothing_in_dir:
	mov	eax,RsrcDisplacement
	ret
srd_err:
	popad
	stc
	ret
ScanResourceDir endp

; ebx->OffsetToData
GetRsrcRva proc
	and	ebx,7fffffffh
	add	ebx,RsrcStartRva
	mov	esi,ebx
	cmp	CompressableRsrc,1
	jz	is_compressable_data
	mov	edx,curUncompressableRsrcTable
	add	curUncompressableRsrcTable,size VgRsrcTable
	jmp	setup_rsrc_table
is_compressable_data:
	mov	edx,curCompressableRsrcTable
	add	curCompressableRsrcTable,size VgRsrcTable
setup_rsrc_table:
	mov	[edx+VgRsrcTableEntryAddress],esi
	mov	ecx,[esi+Size]
	push	ebx ecx edx esi edi ebp
	call	HeapAlloc,HeapHandle,HEAP_ZERO_MEMORY,ecx
	pop	ebp edi esi edx ecx ebx
	mov	[edx+VgRsrcTableDataHandle],eax
	push	eax
	mov	ebx,dword ptr [esi+DataRVA]
	call	CalcPhysicalAddress
	add	ebx,map_ptr

	; save the resource data in allocated mem
	pop	edi
	mov	ecx,[esi+RSize]
	mov	esi,ebx
;-Added Error Check-------------------------->---
	pushad
        call    IsBadWritePtr,edi,ecx
        or      eax,eax
        jnz     GetRsrcRva_err
	popad
;-Added Error Check--------------------------<---

	rep	movsb

	sub	ebx,RsrcStartRva

GetRsrcRva_e:
	clc
	ret
GetRsrcRva_err:
	popad
	stc
	ret
GetRsrcRva endp

.data

;----------VG Restruct-----------------------------------
curUncompressableRsrcTable	dd 0
pUncompressableRsrcTable	dd 0
pCompressableRsrcTable		dd 0
curCompressableRsrcTable	dd 0
CompressableRsrc		dd 0
NewRsrcSize			dd 0
RsrcStartRva			dd 0
RsrcRva				dd 0
RsrcDisplacement		dd 0

HeapHandle			dd 0

TotalSections			dd 0
objptr				dd 0
TreeLevel			dd 0

numbrsrc			dd 0

; object record offsets
objname equ 0
objvsize equ 8
objrva equ 12
objpsize equ 16
objpoff equ 20
objflags equ 36

oflag_write equ 80000000h

VgRsrcTable STRUCT
   VgRsrcTableEntryAddress dd ?
   VgRsrcTableDataHandle   dd ?
VgRsrcTable ENDS

ResourceDataEntry STRUCT
  DataRVA	   dd ?
  RSize		   dd ?
  CodePage	   dd ?
  Reserved	   dd ?
ResourceDataEntry ENDS

ResourceDir STRUCT
   Characteristics dd ?
   TimeDateStamp   dd ?
   MajorVersion    dw ?
   MinorVersion    dw ?
   NumberOfNamedEntries dw ?
   NumberOfIdEntries dw ?
ResourceDir ENDS

ResourceDirEntry STRUCT
  Name		   dd ?
  OffsetToData	   dd ?
ResourceDirEntry ENDS

HEAP_GROWABLE			equ 00000002h
HEAP_GENERATE_EXCEPTIONS	equ 00000004h
HEAP_ZERO_MEMORY		equ 00000008h
HEAP_REALLOC_IN_PLACE_ONLY	equ 00000010h
HEAP_TAIL_CHECKING_ENABLED	equ 00000020h
HEAP_FREE_CHECKING_ENABLED	equ 00000040h
HEAP_DISABLE_COALESCE_ON_FREE	equ 00000080h
HEAP_CREATE_ALIGN_16		equ 00010000h
HEAP_CREATE_ENABLE_TRACING	equ 00020000h
HEAP_MAXIMUM_TAG		equ 0FFFh
HEAP_PSEUDO_TAG_FLAG		equ 8000h
HEAP_TAG_SHIFT 			equ 18

RT_CURSOR	equ 1
RT_BITMAP	equ 2
RT_ICON		equ 3
RT_MENU		equ 4
RT_DIALOG	equ 5
RT_STRING	equ 6
RT_FONTDIR	equ 7
RT_FONT		equ 8
RT_ACCELERATOR	equ 9
RT_RCDATA	equ 10
RT_MESSAGETABLE	equ 11
RT_GROUPCURSOR	equ 12
RT_GROUPICON	equ 14
RT_VERSIONINFO	equ 16

ID_OFF		equ 0Ch
marker		equ 90909090h

;--------------------------------------------------------
