WipeMZ	proc
	mov	fnameptr, eax

	call	NewReportSec
	call	AddReportTxt,offset strPART5

	mov	eax, fnameptr
	call	OpenTheFile

	test	eax, eax
	jne	wmzc1
	call	AddReportTxt,offset strERROR
	call	AddReportTxt,offset strLINE
	mov	RebError, 1
	mov	eax, -1
	ret

wmzc1:
        call    create_mapping			; create file mapping
        jc      abort_wmz
        mov     ecx,ffsize
        or	ecx,ecx				; no file size?
        jz	abort_wmz
        mov 	org_fsize,ecx
						; eax->mapped file
        cmp     word ptr [eax],'ZM'		; is EXE?
        jnz     abort_wmz

        call    GetPEHead			; load esi->PE Header
	push	esi

        call    IsBadReadPtr,esi,2              ; was ptr any good?       
        or      eax,eax
        jnz     abort_wmz

        cmp     word ptr [esi],'EP'		; PE?
        jnz     abort_wmz

	cmp	SuperalMode, 1
	je	MZMode1
MZMode0:
	mov	edi, map_ptr
	add	edi, 3
	mov	esi, offset MZHeader0
	mov	ecx, 51h
	rep	movsb
	mov	NewPtrToPE, 54h				;ptr to pe header
	jmp	MZCont
MZMode1:
	mov	edi, map_ptr
	add	edi, 3
	mov	al, 0
	mov	ecx, 9
	rep	stosb

	mov	esi, ptrpeheader
	mov	dword ptr [esi+30h], 0Ch		;0C = new ptr to pe header
	mov	NewPtrToPE, 0Ch

MZCont:
	pop	esi
	
	mov	ecx, ffsize
	mov	eax, esi
	sub	eax, map_ptr
	mov	MZDecal, eax
	mov	ebx, NewPtrToPE
	sub	MZDecal, ebx
	sub	ecx, eax
	rep	movsb

	sub	edi, map_ptr
        call    unmap
        call    SetFilePointer,handle1,edi,0,FILE_BEGIN
        call    SetEndOfFile,handle1
	call	CloseTheFile

	call	PostWipeMZ
	test	eax, eax
	je	retbad_wmz

	mov	eax, MZDecal
	mov	edi, offset strWipeMZ2
	call	printdec
	call	AddReportTxt,offset strWipeMZ

	mov	eax, NewPtrToPE
	mov	edi, offset strNewPEOff2
	call	print_hex_32b
	call	AddReportTxt,offset strNewPEOff

	mov	al, SuperalMode
	test	al, al
	je	repmode0
repmode1:
	call	AddReportTxt, offset strSuperMode1
	jmp	repcont
repmode0:
	call	AddReportTxt, offset strSuperMode0
repcont:
	call	AddReportTxt,offset strLINE

	mov	eax, 1
	ret

abort_wmz:
        call    unmap				;unmap if aborted infection
	call	CloseTheFile
retbad_wmz:
	call	AddReportTxt,offset strERROR
	call	AddReportTxt,offset strLINE
	mov	eax, -1
	ret
WipeMZ	endp


PostWipeMZ	proc
	mov	eax, fnameptr
	call	OpenTheFile			;Open the file
	call	create_mapping			;Map the file

	call	GetPEHead			;pointer to the peheader -> esi

	movzx	edx, word ptr [esi+numObj]	;number of sections -> edx
	mov	numsec, edx			;save number of sections

	mov	esi, ptrpeheader
	mov	edx, numsec
	add	esi, headlen
	xor	ebx, ebx

pwmloop2:					;second loop to fix raws
	mov	eax, 28h
	mul	bl
	mov	edi, esi
	add	edi, eax
	mov	eax, [edi+20]			;eax<-RAW offset
	sub	eax, MZDecal
	mov	[edi+20], eax			;eax->RAW offset
	inc	ebx				;next section
	cmp	ebx, edx
	jne	pwmloop2

	call	unmap				;unmap the file
	call	CloseTheFile			;close the file

	xor	eax, eax
	inc	eax
	ret
PostWipeMZ	endp

FixupEOF	proc
	mov	fnameptr, eax

	call	NewReportSec
	call	AddReportTxt,offset strPART6

	mov	eax, fnameptr
	call	OpenTheFile
	call	create_mapping

	mov	edi, map_ptr
	add	edi, ffsize
	dec	edi
	xor	eax, eax
	mov	ecx, -1
	std
	repe	scasb
	cld
	not	ecx
	cmp	ecx, 5
	jl	nofixup
	add	edi, 5
	sub	edi, map_ptr

	call	unmap				;unmap the file
        call    SetFilePointer,handle1,edi,0,FILE_BEGIN
        call    SetEndOfFile,handle1
	jmp	fixuprep

nofixup:
	mov	edi, ffsize
	call	unmap

fixuprep:
	call	CloseTheFile
	mov	eax, ffsize
	sub	eax, edi
	mov	edi, offset strWipeEOF2
	call	printdec
	call	AddReportTxt,offset strWipeEOF
	call	AddReportTxt,offset strCRLF
	call	AddReportTxt,offset strLINE
	mov	eax, 1
	ret
FixupEOF	endp


WipeReloc	proc
	mov	fnameptr, eax

	mov	RelocGain, 0

	call	NewReportSec
	call	AddReportTxt,offset strPART7

	mov	eax, fnameptr
	call	OpenTheFile

	test	eax, eax
	jne	wrelc1
	mov	eax, -1
	ret

wrelc1:
        call    create_mapping			; create file mapping
        jc      abort_wrel
        mov     ecx,ffsize
        or	ecx,ecx				; no file size?
        jz	abort_wrel
        mov 	org_fsize,ecx
						; eax->mapped file
        cmp     word ptr [eax],'ZM'		; is EXE?
        jnz     abort_wrel

        call    GetPEHead			; load esi->PE Header

        call    IsBadReadPtr,esi,2              ; was ptr any good?       
        or      eax,eax
        jnz     abort_wrel

        cmp     word ptr [esi],'EP'		; PE?
        jnz     abort_wrel


	mov	esi, ptrpeheader
	movzx	ecx,word ptr [esi+numObj]
	mov	numsec, edx			;save number of sections
	mov	edi, esi
	add	edi, headlen			;pointer to object table -> edi
scan_objs:
	cmp	[edi], 'ler.'
	jne	wrelnsec
	cmp	word ptr [edi+4], 'co'
	jne	wrelnsec
	mov	eax, [edi+16]			;eax=rawsize of .reloc section
	test	eax, eax
	je	noreloc
found_reloc:
	mov	RelocDecal, eax
	mov	RelocSec, ecx
	cmp	ecx,1
	jnz	reloc_not_last
	pushad
	dec	word ptr [esi+numObj]
	xor	al,al
	mov	ecx,40
	rep	stosb

	sub	edi, 40*2
	mov	eax, [edi+8]			;recompute the SizeOfImage value
	add	eax, [edi+12]
	mov	[esi+imagesize], eax
	popad
reloc_not_last:
        mov	ax,word ptr [esi+PEFlags]
        or	ax,1				; set "relocations stripped"
      	mov	[esi+PEFlags],ax

	mov	dword ptr [edi+objpsize],0
        mov	dword ptr [esi+160],0		;Base relocation table address
        mov	dword ptr [esi+164],0		;Base relocation table size

;----------------/end-------------------------------------------
skiprelbcl:
        call    unmap
	call	CloseTheFile

	call	DiscretAlign			;realign the file
	mov	eax, org_fsize
	sub	eax, new_fsize
	add	RelocGain, eax

	mov	eax, RelocSec
	cmp	eax, 1
	je	skip_tablwipe
	call	WipeRelocObj			;wipe .reloc entry in the object table
	call	DiscretAlign			;realign the file
	mov	eax, org_fsize
	sub	eax, new_fsize
	add	RelocGain, eax
skip_tablwipe:
	mov	eax, RelocDecal
	mov	edi, offset strRELOC2
	call	printdec
	call	AddReportTxt, offset strRELOC
	mov	eax, RelocGain
	mov	edi, offset strRELAL2
	call	printdec
	call	AddReportTxt, offset strRELAL
	call	AddReportTxt, offset strCRLF
	call	AddReportTxt, offset strLINE

	mov	eax, 1
	ret
	
    wrelnsec:
	add	edi,40
	loop	scan_objs
	
noreloc:
        call    unmap
	call	CloseTheFile
	call	AddReportTxt, offset strNORELOC
	call	AddReportTxt, offset strLINE
	mov	RebError, 1
	mov	eax, 0
	ret

abort_wrel:
        call    unmap
	call	CloseTheFile
	mov	eax, -1
	ret
WipeReloc	endp

DiscretAlign	proc
	mov	al, TagSecsize
	mov	ah, TagRealign
	push	eax
	mov	TagSecsize, 0
	mov	TagRealign, 1
	mov	eax, orgalign
	mov	newalign, eax
	mov	eax, fnameptr
	mov	TagReport, 0
	call	AlignFile			;align and resize sections
	mov	TagReport, 1
	pop	eax
	mov	TagSecsize, al
	mov	TagRealign, ah
	ret
DiscretAlign	endp


WipeRelocObj	proc
	mov	eax, fnameptr
	call	OpenTheFile
	call	create_mapping

	call	GetPEHead

	lea	edi, [esi+headlen]
	movzx	ecx, word ptr [esi+numObj]
	mov	eax, RelocSec
recalc:
	cmp	ecx, eax
	je	wrocont1
	add	edi, 40
	loop	recalc

wrocont1:
	dec	word ptr [esi+numObj]
	mov	ebx, [edi+8]			;.reloc virtual size
	lea	eax, [edi-40]			;previous section
	add	[eax+8], ebx			;fixup prev section virtual size

	mov	eax, 40
	mul	ecx
	mov	ecx, eax
	lea	esi, [edi+40]
	rep	movsb

	call	unmap
	call	CloseTheFile
	ret
WipeRelocObj	endp


AlignFile proc		;eax=*filename  newalign=newalign
	mov	fnameptr, eax

	call	NewReportSec
	call	AddReportTxt,offset strPART3

	mov	eax, fnameptr
	call	OpenTheFile
	test	eax, eax
	jne	goon
	mov	eax, -1
	ret

goon:
        call    create_mapping			; create file mapping
        jc      abort_encrypt
        mov     ecx,ffsize
        or	ecx,ecx				; no file size?
        jz	abort_encrypt
        mov 	org_fsize,ecx
						; eax->mapped file
        cmp     word ptr [eax],'ZM'		; is EXE?
        jnz     abort_encrypt

;###########BEGINING OF APPENDED CODE#########################
	push	eax
;###########END OF APPENDED CODE##############################

        call    GetPEHead			; load esi->PE Header

        call    IsBadReadPtr,esi,2              ; was ptr any good?       
        or      eax,eax
        jnz     abort_encrypt

        cmp     word ptr [esi],'EP'		; PE?
        jnz     abort_encrypt
not_encrypted:

	mov	eax,[esi+filealign]
	mov	orgalign,eax

	cmp	TagSecsize, 1		;Should the sections sizes fix be performed ?
	jne	realalign

;###########BEGINING OF APPENDED CODE#########################

	lea	edi, [esi+headlen]		;beginning of obj table
	mov	secpt, edi
	movzx	ecx, word ptr [esi+numObj]	;number of sections
	xor	ebx, ebx
	mov	totsecsiz, ebx
secloop:
	call	SqueezeSection
	inc	ebx
	cmp	ebx, ecx
	je	secdone
	jmp	secloop
secdone:


;###########END OF APPENDED CODE##############################

realalign:
	pop	eax
        call    GetPEHead

	cmp	TagRealign, 1
	je	was_same

	call	unmap
	jmp	unmapped

was_same:
        xor     eax,eax
        mov     ax, word ptr [esi+NtHeaderSize]	; get header size
        add     eax,18h				; object table is here
        add     eax,esi

	push    eax				; save ptr to obj table
	xor     edx,edx
	mov     ecx,40
	xor     eax,eax
	mov     ax,[esi+numObj]
	inc     eax
	mul     ecx
	xchg    eax,ebx
	pop 	eax
	push    eax

	add     eax,ebx
	mov     ecx,[esi+filealign]

	call    align_fix
	xchg    ebx,eax				; ebx->phy. start of first obj
	pop 	eax

        mov 	ecx,ebx
        sub	ecx,map_ptr
        mov 	[esi+sizehdr],ecx		; save new total size of hdr

        mov     ecx,newalign
        mov     [esi+filealign],ecx

        xor     ecx,ecx
        mov     cx,[esi+numObj]			; get number of objects
	mov     edi,ebx				; edi->phy. start of first obj
; edi contains pointer to current writing address of the executable
otbl_loop:
	push    eax ecx
	mov     ecx,edi				; ecx->current obj poff
	sub     ecx,map_ptr			; get real obj poff
	mov     esi,[eax+objpoff]		; esi->original obj p. off
	mov     [eax+objpoff],ecx		; save new physical offset at cur
	mov	ebx,[eax+objvsize]		; get virtual size
	cmp     ebx,[eax+objpsize]		; bigger than physical size?
	jge     skip_align			; if so skip re-aligning this one
	mov     ecx,newalign			; ecx=200h
	push    eax				; save obj rec ptr
	xchg    eax,ebx				; eax=object virtual size
	call    align_fix			; align that baby
	xchg    eax,ebx				; ebx=object virtual size
	pop 	eax				; restore obj ptr
	jmp     did_align
skip_align:
	mov     ebx,[eax+objpsize]		; use psize if vsize>psize
did_align:
	mov     [eax+objpsize],ebx		; save new aligned physical size
	add     esi,map_ptr			; set esi into mapping
	mov     ecx,ebx				; ecx=physical size
	rep     movsb				; store object at new|old location
next_obj:
	pop     ecx eax
	add     eax,40				; onto next object ..whohoo
	loop    otbl_loop

	sub     eax,40				; adjust to last object
	mov     ecx,[eax+objpsize]		; ecx=last object physical size
	add     ecx,[eax+objpoff]		; ecx=total physical size of file
	push    ecx

	call    unmap

	mov     error,0

        pop     ecx
        mov     new_fsize,ecx
        call    SetFilePointer,handle1,ecx,0,FILE_BEGIN	; move file pointer to
        call    SetEndOfFile,handle1			; set end of file

go_checksum:
        xor     ecx,ecx
        call    create_mapping
        jc      unmapped
        call    GetPEHead
        lea     eax,[esi+checksum]
        call    CheckSumMappedFile,map_ptr,ffsize,offset oldchksum,eax
        call    unmap

        mov     error,0				; if we made it here then no error
        jmp     unmapped
abort_encrypt:
        call    unmap				;unmap if aborted infection

unmapped:
	call	CloseTheFile

	call	ReportEndAlign

	mov	esi, offset strLINE
	call	AddReportTxt,offset strLINE

        movzx	eax,error
        inc	eax
        ret
AlignFile endp

GetPEHead proc
        mov     esi,[eax+3Ch]			; where PE hdr pointer is
        add     esi,eax
        mov     ptrpeheader,esi			; esi->PE Hdr
        ret
GetPEHead endp

OpenTheFile	proc
        mov     fnameptr, eax

	mov	error,-1
	call	GetFileAttributesA, eax              ; get file attributes
	mov	oldattrib,eax

	cmp	eax,-1                               ; if error then maybe shared  
	jz	otferr

        call    SetFileAttributesA,fnameptr,20h

        call    CreateFileA,fnameptr,0c0000000h,0,0,3,20h,0
	call    test_error
        jc	otferr

	mov	handle1, eax

	call    GetFileTime,eax,offset creation,offset lastaccess,offset lastwrite
	mov	eax, 1
	ret
otferr:
	xor	eax, eax
	ret
OpenTheFile	endp

CloseTheFile	proc
        call    SetFileTime,handle1,offset creation,offset lastaccess,offset lastwrite
        call	CloseHandle, handle1
        call	SetFileAttributesA,fnameptr,oldattrib
	ret
CloseTheFile	endp

create_mapping proc

        call	GetFileSize,handle1,0
        call	test_error
        jnc	good_nc
bad_cm_abort:
        jmp	create_abort
good_nc:
        mov     ffsize,eax
        or	eax,eax
        jz	bad_cm_abort

        call	CreateFileMappingA,handle1,0,PAGE_READWRITE,0,eax,0
        call	test_error
        jc	create_abort
        mov	maphandle,eax

        call	MapViewOfFile,eax,FILE_MAP_WRITE,0,0,0
        call    test_error
        jc      create_abort
        mov     map_ptr,eax

create_abort:
        ret
create_mapping endp

test_error proc
        cmp     eax,-1 
        jz      api_err
        or      eax,eax
        jz      api_err
        clc
        ret
api_err:
        stc
        ret
test_error endp

unmap proc
	call	UnmapViewOfFile, map_ptr
	call	CloseHandle, maphandle
	ret
unmap endp

align_fix proc
        xor     edx,edx
        div     ecx			; /alignment
        or      edx,edx			; if no remainder then no next
        jz      no_adjust
        inc     eax			; next alignment
no_adjust:
        mul     ecx			; *alignment
        ret
align_fix endp

;###########BEGINING OF APPENDED CODE#########################
SqueezeSection	proc
	push	ebx
	push	ecx
	mov	eax, 28h
	mul	bl
	add	eax, secpt
	mov	esi, eax	;pointer to (i) section entry in table

	mov	eax, [esi+10h]	;get raw size of (i) section
	mov	orgsecsiz, eax
	mov	ecx, eax

	add	eax, [esi+14h]	;add raw offset to size
	add	eax, map_ptr	;add file mapping offset

	mov	edi, eax
	dec	edi
	xor	eax, eax
	std			;set direction flag
	repe	scasb		;calculate REAL end of section (eliminate 00)
	cld			;restore direction flag
	add	edi, 2		;adjust real end of section

	sub	edi, [esi+14h]	;sub raw offset from new size
	sub	edi, map_ptr	;sub mapping offset to obtain real size

	dec	edi
	and	edi, 0FFFFFF00h	;only get main part     
	add	edi, 100h

	mov	ecx, newalign
ssloop:                         ;find a new section size multiple of 'newalign'
	mov	eax, edi
	xor	edx, edx
	div	ecx
	test	edx, edx
	je	ssend
	add	edi, 100h
	jmp	ssloop

ssend:
	cmp	edi, [esi+10h]
	jge	ssnofix		;test is new size is lower than original
	mov	[esi+10h], edi	;write new section size

	call	AddReportLine3

ssnofix:
	pop	ecx
	pop	ebx
	ret
SqueezeSection	endp

AddReportLine3	proc
	mov	eax, orgsecsiz
	sub	eax, edi
	add	totsecsiz, eax

	mov	edi, offset strRESIZ3
	call	printdec

	call	strnlen
	mov	ecx, eax
	mov	edi, offset strRESIZ2
	rep	movsb
	mov	ecx, 8
	sub	ecx, eax
	mov	al, 20h
	rep	stosb

	mov	esi, offset strRESIZ
	call	strnlen

	mov	dword ptr [esi+eax], 00000A0Dh

	call	AddReportTxt,offset strRESIZ

	ret
AddReportLine3	endp

ReportEndAlign	proc
	mov	eax, totsecsiz
	mov	edi, offset strTOTSEC2
	call	printdec

	mov	esi, offset strTOTSEC
	call	strnlen
	mov	dword ptr [esi+eax], 00000A0Dh
	call	AddReportTxt,offset strTOTSEC

	mov	eax, org_fsize
	sub	eax, new_fsize
	sub	eax, totsecsiz
	mov	edi, offset strTOTPAD2
	call	printdec

	mov	esi, offset strTOTPAD
	call	strnlen
	mov	dword ptr [esi+eax], 00000A0Dh
	call	AddReportTxt,offset strTOTPAD

	mov	eax, org_fsize
	sub	eax, new_fsize
	mov	edi, offset strTOTTOT2
	call	printdec

	mov	esi, offset strTOTTOT
	call	strnlen
	mov	dword ptr [esi+eax], 00000A0Dh
	call	AddReportTxt,offset strTOTTOT

	ret
ReportEndAlign	endp

;###########END OF APPENDED CODE##############################

extrn	CheckSumMappedFile	:PROC
extrn	IsBadReadPtr		:PROC

.data

signature		equ 0
cputype			equ 4
numObj			equ 6
NtHeaderSize		equ 20
PEFlags			equ 22
entrypointRVA		equ 40
imagebase		equ 52
objalign		equ 56
filealign		equ 60
imagesize		equ 80
headersize		equ 84
checksum		equ 88
edatadir		equ 120
datadir			equ 128
sizehdr			equ 54h

objname			equ 0
objvsize		equ 8
objrva			equ 12
objpsize		equ 16
objpoff			equ 20
objflags		equ 36

oflag_write		equ 80000000h

headlen			equ 0F8h

fnameptr	dd 0
ptrpeheader	dd 0
high_size	dd 0
ffsize		dd 0
handle1		dd 0
map_ptr		dd 0

oldattrib	dd 0
creation        dd 2 dup (0)
lastaccess      dd 2 dup (0)
lastwrite       dd 2 dup (0)
org_fsize	dd 0
new_fsize	dd 0
orgalign	dd 0
oldchksum	dd 0
error		db -1
maphandle	dd 0
newalign	dd 0

secpt		dd 0
orgsecsiz	dd 0
totsecsiz	dd 0

MZDecal		dd 0
RelocSec	dd 0
RelocDecal	dd 0
RelocGain	dd 0

NewPtrToPE	dd 0

MZHeader0	db 0,2,0,0,0,4,0,0fh,0,0FFh,0FFh,0,0,0B8h,7 dup (0),40h,0,01Ah,33 dup (0),054h,0,0,0
		db 0BAh,010h,0,0Eh,1Fh,0B4h,9,0CDh,21h,0B8h,1,4Ch,0CDh,21h,90h,90h
		db 0Dh,0Ah,24h,37h		;len=51h
		

