COMMENT *

AspackDie
---------

Target: Aspack 2.11

This unpacker doesn't unpack or decrypt anything by hand. It hooks
the 'GetProcAddress' calls of the loader. The 3rd one is the first call
of the Import Table handler, after which the exe is dumped (with untouched
Import Table and unpacked sections). I just have to past the original EntryPoint RVA
and the RVA of the original Import Table and I'm done :)...
Resource realigning is not really needed coz they are just splitted to 2 sections.

Internal stuff:
The way of realizing the Api hook stub is different for NT OS's because on NT I don't know of a simple
way to get shared memory....
This proggy has to use the debug APIs because on win2k isn't the IAT initialized after creating a process 
in suspended mode :(
An other thing on win2k is that I need to make the debuggee load User32.dll because Aspack's IT doesn't
contain any user API's. User32 is needed for the SendMessage calls of the GetProcAddress stub.

Pls report any ideas, comments and suggestions to yoda_f2f@gmx.net.

yoda/f2f

*

.386
.model flat, stdcall
option casemap:none

INCLUDE \masm32\include\kernel32.inc
INCLUDE \masm32\include\user32.inc
INCLUDE \masm32\include\comdlg32.inc
INCLUDE \masm32\include\imagehlp.inc
INCLUDELIB \masm32\lib\kernel32.lib
INCLUDELIB \masm32\lib\user32.lib
INCLUDELIB \masm32\lib\comdlg32.lib
INCLUDELIB \masm32\lib\imagehlp.lib
INCLUDELIB ForceLibrary.lib

INCLUDE \masm32\include\windows.inc
INCLUDE ForceLibrary.INC

memset                    PROTO :LPVOID, :DWORD, :DWORD
IsNT                      PROTO
PasteTradeMark            PROTO :LPVOID, :LPSTR

;DEBUG_APIHOOK EQU 1

;------ STRUCTs ------
APIHOOKSTUB STRUCT 1
	_PUSHAD                   DB 060h
  IFDEF DEBUG_APIHOOK
	_INT3                     DB 0CCh
  ENDIF
	_PUSH0                    DW 0006Ah
	_PUSH0_2                  DW 0006Ah
	_PUSHDW                   DB 068h
	_PUSHWM                   DD WM_DEBUGGEE_GETPROC_CALL
	_PUSHDW_2                 DB 068h
	_PUSHHWND                 DD ?			; debug window handle
	_MOVEAXDW                 DB 0B8h
	_MOVVAL                   DD ?			; address of SendMessage API
	_CALLEAX                  DW 0D0FFh
	_POPAD                    DB 061h
	_JMPDW                    DB 0E9h
	_JMPADDR                  DD ?			; jump related address of GetProcAddress API
APIHOOKSTUB ENDS

;------ CONST ------
.CONST
D                         EQU DWORD PTR
W                         EQU WORD PTR
B                         EQU BYTE PTR
VA_SHARED                 EQU 08000000h			; Undocumented flag for "VirtualAlloc" to get shared memory
							; on 9x. ME too ?
WM_DEBUGGEE_GETPROC_CALL  EQU WM_USER + "y"
DEPACK_WAIT_COUNT         EQU 3000
DEBUGGEE_KILL_VALUE       EQU 4321

szCurDir                  DB ".",0
szFilter                  DB "EXE files",0,"*.exe",0,0
szOfnAllFilter            DB "All files",0,"*.*",0,0
szOfnOpen                 DB "[AspackDie] by yoda - Select the target file...",0
szOfnSave                 DB "Select filename for saving...",0
szU32                     DB "USER32",0
szK32                     DB "KERNEL32",0
szGetProcAddress          DB "GetProcAddress",0
szSendMessage             DB "SendMessageA",0
szWndCls                  DB "EVENT LOG WINDOW",0
szWndTitle                DB "AspackDie",0
szUnpacked                DB "unpacked.ExE",0
szLoadU32Err              DB "Couldn't force debuggee to load User32.dll :(",0
szSign                    DB "[AspackDie!]",0

szShit                    DB "AspackDie - SHIT!",0
szSmile                   DB ":D",0
szMapErr                  DB "Couldn't map file :(",0
szPeErr                   DB "Invalid PE file !",0
szSigErr                  DB "This file doesn't seem to be protected with Aspack 2.11 !",0
szFindThunkErr            DB "Couldn't find 'GetProcAddress'-thunk :(",0
szProcCreateErr           DB "Error during process creation !",0
szApiStubMemErr           DB "Couldn't get memory for API hook stub :(",0
szIATFixErr               DB "Couldn't modify IAT :(",0
szMemErr                  DB "Not enough memory available !",0
szDumpErr                 DB "Couldn't read process memory :(",0
szFileCreateErr           DB "Couldn't create file :(",0
szUnknownErr              DB "Unknown error !",0
szUnpackDone              DB "File seems to be unpacked successfully.",0

;------ DATA ------
.DATA
cFname                    DB MAX_PATH DUP (0)
ofn                       OPENFILENAME <SIZEOF OPENFILENAME>
pMap                      DD 0
dwMapSize                 DD 0
dwBytesRead               DD 0
dwBytesWritten            DD 0
pStub                     DD 0
dwStubSize                DD 0
pAspSecRva                DD 0
pNTH                      DD 0
pGetProcAddrThunkRva      DD 0
hInst                     DD 0
hDbgWnd                   DD 0
PI_                       PROCESS_INFORMATION <>
SI_                       STARTUPINFO <SIZEOF STARTUPINFO>
ApiHookStub               APIHOOKSTUB <>
dwApiCallCnt              DD 0
pDump                     DD 0
dwDumpSize                DD 0
hOutFile                  DD 0
pAspSecObj                DD 0
bNT                       DD 0
DB_                       DEBUG_EVENT <>
dwContStat                DD 0
dwBPCnt                   DD 0
dwEntryVa                 DD 0

;------ CODE ------
.CODE
Main:
	INVOKE GetModuleHandle, NULL
	MOV    hInst, EAX
	INVOKE IsNT
	MOV    bNT, EAX

	;-> get a file path
	MOV    ofn.lpstrFilter, OFFSET szFilter
	MOV    ofn.lpstrInitialDir, OFFSET szCurDir
	MOV    ofn.Flags, OFN_FILEMUSTEXIST + OFN_PATHMUSTEXIST + OFN_LONGNAMES + OFN_EXPLORER + \
    					OFN_HIDEREADONLY
    	MOV    ofn.lpstrFile, OFFSET cFname
    	MOV    ofn.nMaxFile, SIZEOF cFname
    	MOV    ofn.lpstrTitle, OFFSET szOfnOpen
	INVOKE GetOpenFileName, OFFSET ofn
	OR     EAX, EAX
	JZ     @@Quit
	
	PUSH   OFFSET cFname
	CALL   UnpackDaFucker
	
  @@Quit:	
	INVOKE ExitProcess, 0
	
	
UnpackDaFucker PROC szFname : LPSTR
	;---- MAP THE FILE ----
	INVOKE CreateFile, szFname, GENERIC_READ,FILE_SHARE_READ,NULL,OPEN_EXISTING,FILE_ATTRIBUTE_NORMAL,0
	INC    EAX
	JZ     @@MapErr
	DEC    EAX
	MOV    ESI, EAX										; ESI -> hFile
	INVOKE GetFileSize, EAX, NULL
	MOV    dwMapSize, EAX
	INVOKE VirtualAlloc, NULL, EAX, MEM_COMMIT, PAGE_EXECUTE_READWRITE
	OR     EAX, EAX
	.IF ZERO?
		INVOKE CloseHandle, ESI
		JMP    @@MapErr
	.ENDIF	
	MOV    pMap, EAX
	INVOKE ReadFile, ESI, EAX, dwMapSize, OFFSET dwBytesRead, NULL
	INVOKE CloseHandle, ESI
	
	;---- check "PE" ----
	INVOKE ImageNtHeader, pMap
	OR     EAX, EAX
	JZ     @@PeErr
	MOV    pNTH, EAX
	
	;---- GET THE ASPACK SECTION AND DO A SIGNATURE CHECK ! ----
	MOV    ESI, EAX
	ASSUME ESI : PTR IMAGE_NT_HEADERS							; ESI -> NT header
	INVOKE ImageRvaToSection, ESI, pMap, [ESI].OptionalHeader.AddressOfEntryPoint
	MOV    EDI, EAX
	SUB    EAX, pMap
	MOV    pAspSecObj, EAX
	ASSUME EDI : PTR IMAGE_SECTION_HEADER							; EDI -> section header
	PUSH   [EDI].VirtualAddress
	POP    pAspSecRva
	
	MOV    EBX, pMap									; EBX -> asp section base
	ADD    EBX, [EDI].PointerToRawData
	CMP    D [EBX], 03DE96090h
	JNZ    @@SignatureErr
	CMP    W [EBX + 4], 0004h
	JNZ    @@SignatureErr
	
	;---- GET ADDRESS OF THE "GetProcAddress" THUNK ----
	PUSH   EBX
	PUSH   EDI
	PUSH   ESI
	MOV    pGetProcAddrThunkRva, 0
	INVOKE ImageRvaToVa, ESI, pMap, [ESI].OptionalHeader.DataDirectory[8].VirtualAddress, NULL
	MOV    EBX, EAX
	ASSUME EBX : PTR IMAGE_IMPORT_DESCRIPTOR
	.WHILE [EBX].FirstThunk
		;-> scan the thunk chain
		MOV    EDI, [EBX].FirstThunk						; EDI -> real IAT pointer
		MOV    ESI, [EBX].OriginalFirstThunk					; ESI -> IT data pointer
		.IF !ESI
			MOV    ESI, EDI
		.ENDIF
		
		;-> get image pointers
		INVOKE ImageRvaToVa, pNTH, pMap, ESI, NULL
		OR     EAX, EAX
		JZ     @@SkipIID
		MOV    ESI, EAX
		.WHILE D [ESI]
			INVOKE ImageRvaToVa, pNTH, pMap, D [ESI], NULL
			OR     EAX, EAX
			JZ     @@SkipThunk
			ADD    EAX, 2
			;-> Is it the right thunk ?
			INVOKE lstrcmp, EAX, OFFSET szGetProcAddress
			OR     EAX, EAX
			.IF ZERO?
				MOV    pGetProcAddrThunkRva, EDI
			.ENDIF
		  @@SkipThunk:
			ADD    ESI, 4
			ADD    EDI, 4
		.ENDW
		
	  @@SkipIID:
	  	ADD    EBX, SIZEOF IMAGE_IMPORT_DESCRIPTOR	  
	.ENDW	
	ASSUME EBX : NOTHING
	POP    ESI
	POP    EDI
	POP    EBX
	CMP    pGetProcAddrThunkRva, 0
	JZ     @@FindThunkErr

	;---- CREATE A NEW PROCESS ----
	INVOKE CreateProcess, szFname, NULL, NULL, NULL, FALSE, CREATE_SUSPENDED OR DEBUG_PROCESS OR DEBUG_ONLY_THIS_PROCESS, \
		NULL, NULL, OFFSET SI_, OFFSET PI_
	OR     EAX, EAX
	JZ     @@ProcCreateErr
	
	;---- GET MEMORY, CREATE DEBUG WINDOW, AND CREATE API STUB ----
	MOV    dwStubSize, SIZEOF APIHOOKSTUB
	.IF !bNT
		INVOKE VirtualAlloc, NULL, dwStubSize, MEM_COMMIT OR VA_SHARED, PAGE_EXECUTE_READWRITE
	.ELSE
		INVOKE VirtualAllocEx, PI_.hProcess, NULL, dwStubSize, MEM_COMMIT, PAGE_EXECUTE_READWRITE
	.ENDIF
	OR     EAX, EAX
	.IF ZERO?
		INVOKE CloseHandle, PI_.hProcess
		INVOKE CloseHandle, PI_.hThread
		INVOKE TerminateProcess, PI_.hProcess, DEBUGGEE_KILL_VALUE
		JMP    @@ApiStubMemErr
	.ENDIF
	MOV    pStub, EAX
	
	CALL   CreateDbgWindow
	
	PUSH   hDbgWnd
	POP    ApiHookStub._PUSHHWND
	INVOKE GetModuleHandle, OFFSET szU32
	INVOKE GetProcAddress, EAX, OFFSET szSendMessage
	MOV    ApiHookStub._MOVVAL, EAX
	INVOKE GetModuleHandle, OFFSET szK32
	INVOKE GetProcAddress, EAX, OFFSET szGetProcAddress
	SUB    EAX, pStub
	SUB    EAX, OFFSET ApiHookStub._JMPADDR - OFFSET ApiHookStub._PUSHAD + 4
	MOV    ApiHookStub._JMPADDR, EAX

	.IF !bNT
		;-> copy hook stub structure to allocated shared memory
		PUSH   ESI
		PUSH   EDI
		MOV    ESI, OFFSET ApiHookStub
		MOV    EDI, pStub
		MOV    ECX, SIZEOF ApiHookStub
	  	REP    MOVSB
	  	POP    EDI
	  	POP    ESI
	.ELSE
		;-> write hook stub to memory in the debuggee's process memory
		INVOKE WriteProcessMemory, PI_.hProcess, pStub, OFFSET ApiHookStub, SIZEOF APIHOOKSTUB,\
			OFFSET dwBytesWritten
	.ENDIF

  	;---- EXECUTE MAIN THREAD ----
  	INVOKE ResumeThread, PI_.hThread
  	
  	;---- ENTER DEBUG LOOP ----
  	MOV    dwBPCnt, 0
  	MOV    EAX, [ESI].OptionalHeader.ImageBase
  	ADD    EAX, [ESI].OptionalHeader.AddressOfEntryPoint
  	MOV    dwEntryVa, EAX
 	
  	.WHILE TRUE
  		INVOKE WaitForDebugEvent, OFFSET DB_, INFINITE
  		OR     EAX, EAX
  		.IF ZERO?
  			.BREAK
  		.ENDIF
  		MOV   dwContStat, DBG_EXCEPTION_NOT_HANDLED
  		
  		.IF DB_.dwDebugEventCode == EXCEPTION_DEBUG_EVENT
  			.IF DB_.u.Exception.pExceptionRecord.ExceptionCode == EXCEPTION_BREAKPOINT
  				INC    dwBPCnt
  				.IF dwBPCnt == 1
  					INVOKE TrapEntry, dwEntryVa, OFFSET PI_
  					OR     EAX, EAX
  					JZ     @@LoadU32Err
  					
  				.ELSEIF dwBPCnt == 2
  					INVOKE ForceLibraryDBG, OFFSET szU32, dwEntryVa, OFFSET PI_
  					OR     EAX, EAX
  					JZ     @@LoadU32Err
  					
  				.ELSEIF dwBPCnt == 3
  					INVOKE PerformCleanup, dwEntryVa, OFFSET PI_
  					OR     EAX, EAX
  					JZ     @@LoadU32Err
  					
				  	;---- HOOK IAT ----
				  	MOV    EDX, [ESI].OptionalHeader.ImageBase
				  	ADD    EDX, pGetProcAddrThunkRva
				  	INVOKE WriteProcessMemory, PI_.hProcess, EDX, OFFSET pStub, 4, OFFSET dwBytesWritten
				  	OR     EAX, EAX
				  	.IF ZERO?
						JMP    @@IATFixErr
				  	.ENDIF
  				.ENDIF
  				MOV    dwContStat, DBG_CONTINUE
  			.ENDIF
  			
  		.ELSEIF DB_.dwDebugEventCode == EXIT_PROCESS_DEBUG_EVENT
  			.IF DB_.u.ExitProcess.dwExitCode != DEBUGGEE_KILL_VALUE  ; did we kill the process ?
  				.BREAK
  			.ENDIF
		.ENDIF
  		INVOKE ContinueDebugEvent, DB_.dwProcessId, DB_.dwThreadId, dwContStat
  	.ENDW
  	
  	; -- UNKNOWN ERROR --
  	INVOKE MessageBox, 0, OFFSET szUnknownErr, OFFSET szShit, MB_ICONERROR
  	
  @@ExitProc2:
	INVOKE TerminateProcess, PI_.hProcess, DEBUGGEE_KILL_VALUE
	.IF !bNT
		INVOKE VirtualFree, pStub, dwStubSize, MEM_DECOMMIT
	.ELSE
		INVOKE VirtualFreeEx, PI_.hProcess, pStub, dwStubSize, MEM_DECOMMIT
	.ENDIF
	INVOKE CloseHandle, PI_.hProcess
	INVOKE CloseHandle, PI_.hThread 	  	
	
	ASSUME ESI : NOTHING
	ASSUME EDI : NOTHING	
		
	;---- CLEAN UP ----
  @@ExitProc1:	
	INVOKE VirtualFree, pMap, dwMapSize, MEM_DECOMMIT
  @@ExitProc:
	RET
  
;---- ERROR MESSAGES ----
  @@MapErr:
  	INVOKE MessageBox, 0, OFFSET szMapErr, OFFSET szShit, MB_ICONERROR
  	JMP    @@ExitProc
  @@PeErr:
  	INVOKE MessageBox, 0, OFFSET szPeErr, OFFSET szShit, MB_ICONERROR
  	JMP    @@ExitProc1
  @@SignatureErr:
  	INVOKE MessageBox, 0, OFFSET szSigErr, OFFSET szShit, MB_ICONERROR
  	JMP    @@ExitProc1
  @@FindThunkErr:
  	INVOKE MessageBox, 0, OFFSET szFindThunkErr, OFFSET szShit, MB_ICONERROR
  	JMP    @@ExitProc1
  @@ProcCreateErr:
  	INVOKE MessageBox, 0, OFFSET szProcCreateErr, OFFSET szShit, MB_ICONERROR
  	JMP    @@ExitProc1
  @@ApiStubMemErr:
  	INVOKE MessageBox, 0, OFFSET szApiStubMemErr, OFFSET szShit, MB_ICONERROR
  	JMP    @@ExitProc1
  @@IATFixErr:
  	INVOKE MessageBox, 0, OFFSET szIATFixErr, OFFSET szShit, MB_ICONERROR
  	JMP    @@ExitProc2
  @@LoadU32Err:
  	INVOKE MessageBox, 0, OFFSET szLoadU32Err, OFFSET szShit, MB_ICONERROR
  	JMP    @@ExitProc2
UnpackDaFucker ENDP

DumpAndSave PROC
	ASSUME EDI : PTR IMAGE_SECTION_HEADER
	ASSUME ESI : PTR IMAGE_NT_HEADERS
	
  	;---- DUMP THE PROCESS AND KILL IT ----
  	INVOKE SuspendThread, PI_.hThread
  	INVOKE ImageNtHeader, pMap
  	MOV    ESI, EAX
  	;-> free api stub memory
  	.IF !bNT
		INVOKE VirtualFree, pStub, dwStubSize, MEM_DECOMMIT
	.ELSE
		INVOKE VirtualFreeEx, PI_.hProcess, pStub, dwStubSize, MEM_DECOMMIT
	.ENDIF
	PUSH   [ESI].OptionalHeader.SizeOfImage
	POP    dwDumpSize
	INVOKE GlobalAlloc, GPTR, dwDumpSize
	OR     EAX, EAX
	.IF ZERO?
		INVOKE CloseHandle, PI_.hProcess
		INVOKE CloseHandle, PI_.hThread
		INVOKE TerminateProcess, PI_.hProcess, DEBUGGEE_KILL_VALUE
		JMP    @@MemErr
	.ENDIF
	MOV    pDump, EAX
	INVOKE ReadProcessMemory, PI_.hProcess, [ESI].OptionalHeader.ImageBase, pDump, dwDumpSize, OFFSET dwBytesRead
	OR     EAX, EAX
	.IF ZERO?
		INVOKE GlobalFree, pDump
		INVOKE TerminateProcess, PI_.hProcess, DEBUGGEE_KILL_VALUE
		INVOKE CloseHandle, PI_.hProcess
		INVOKE CloseHandle, PI_.hThread
		JMP    @@DumpErr
	.ENDIF
	INVOKE TerminateProcess, PI_.hProcess, DEBUGGEE_KILL_VALUE
	INVOKE CloseHandle, PI_.hProcess
	INVOKE CloseHandle, PI_.hThread
	
	;---- FIX IAT RVA AND EP ----
	INVOKE ImageNtHeader, pDump
	;-> find asp section
	MOV    ESI, EAX									; ESI -> NT header of dumped image
	INVOKE ImageRvaToSection, ESI, pDump, [ESI].OptionalHeader.AddressOfEntryPoint
	MOV    EDI, EAX
	MOV    EBX, pDump
	ADD    EBX, [EDI].VirtualAddress						; EBX -> dumped image (asp object)
	
	PUSH   D [EBX + 07Dh]
	POP    D [ESI].OptionalHeader.AddressOfEntryPoint
	PUSH   D [EBX + 081h]
	POP    D [ESI].OptionalHeader.DataDirectory[8].VirtualAddress
	
	;---- FIX SECTION TABLE ----
	MOV    EDI, ESI
	ADD    EDI, 0F8h
	MOVZX  EDX, [ESI].FileHeader.NumberOfSections
	.WHILE EDX
		PUSH   [EDI].VirtualAddress
        	POP    [EDI].PointerToRawData
        	PUSH   [EDI].Misc.VirtualSize
        	POP    [EDI].SizeOfRawData
        	ADD    EDI, SIZEOF IMAGE_SECTION_HEADER
        	DEC    EDX
        .ENDW
        
        ;---- WIPE ASPACK DATA SECTION ----
        ; ...the code section contains sometimes a TLS table backup or several resource shit therefore we simply don't
        ; wipe it
        MOV    EDI, pAspSecObj
        ADD    EDI, pDump
        ADD    EDI, SIZEOF IMAGE_SECTION_HEADER							; EDI -> aspack data section
        DEC    [ESI].FileHeader.NumberOfSections  
        
        ;-> fix ImageSize
        MOV    EBX, [EDI].SizeOfRawData
        SUB    [ESI].OptionalHeader.SizeOfImage, EBX
        
        ;---- paste trademark :) ----
        INVOKE PasteTradeMark, pDump, OFFSET szSign
        
        ;---- SAVE THE EXE IMAGE TO DISK ----
        INVOKE lstrcpy, OFFSET cFname, OFFSET szUnpacked
        MOV    ofn.Flags, OFN_FILEMUSTEXIST + OFN_PATHMUSTEXIST + OFN_LONGNAMES + OFN_EXPLORER + \
    					OFN_HIDEREADONLY + OFN_OVERWRITEPROMPT
 	MOV    ofn.lpstrFilter, OFFSET szOfnAllFilter
 	MOV    ofn.lpstrTitle, OFFSET szOfnSave
        INVOKE GetSaveFileName, OFFSET ofn
        OR     EAX, EAX
        .IF !ZERO?
        	INVOKE CreateFile, OFFSET cFname, GENERIC_WRITE + GENERIC_READ, FILE_SHARE_WRITE + FILE_SHARE_READ,\
	                   NULL, CREATE_ALWAYS, FILE_ATTRIBUTE_NORMAL, 0
        	INC    EAX
        	OR     EAX, EAX
        	.IF ZERO?
        		INVOKE MessageBox, 0, OFFSET szFileCreateErr, OFFSET szShit, MB_ICONERROR
        		JMP    SkipFileSaving
        	.ENDIF
        	DEC    EAX
        	MOV    hOutFile, EAX
        	INVOKE WriteFile, EAX, pDump, dwDumpSize, OFFSET dwBytesWritten, NULL        	
        	INVOKE CloseHandle, hOutFile
        	INVOKE MessageBox, 0, OFFSET szUnpackDone, OFFSET szSmile, MB_ICONINFORMATION
        .ENDIF
  SkipFileSaving:
	INVOKE GlobalFree, pDump
	
	;---- CLEAN UP ----
  @@ExitProc1:	
	INVOKE VirtualFree, pMap, dwMapSize, MEM_DECOMMIT
  @@ExitProc:
	RET
	
;---- ERROR MESSAGES ----
  @@MemErr:
  	INVOKE MessageBox, 0, OFFSET szMemErr, OFFSET szShit, MB_ICONERROR
  	JMP    @@ExitProc1
  @@DumpErr:
  	INVOKE MessageBox, 0, OFFSET szDumpErr, OFFSET szShit, MB_ICONERROR
  	JMP    @@ExitProc1	
DumpAndSave ENDP

DbgWndProc PROC USES ESI EDI EBX, hWnd : HWND, Msg : UINT, wParam : WPARAM, lParam : LPARAM
	.IF Msg == WM_CLOSE
		INVOKE DestroyWindow, hWnd
		JMP    @@ExitProc
		
	.ELSEIF Msg == WM_CREATE
		XOR    EAX, EAX
		MOV    dwApiCallCnt, EAX
		
	.ELSEIF Msg == WM_DEBUGGEE_GETPROC_CALL  ; Debuggee is calling "GetProcAddress"
		INC    dwApiCallCnt
		.IF dwApiCallCnt == 3
			CALL   DumpAndSave
			INVOKE ExitProcess, 0
		.ENDIF	
	.ENDIF	
	INVOKE DefWindowProc, hWnd, Msg, wParam, lParam
  @@ExitProc:
	RET
DbgWndProc ENDP

DbgWindowProc PROC pArg : LPVOID
	LOCAL wc   : WNDCLASS
	LOCAL msg  : MSG

	;---- CREATE WINDOW ----
	INVOKE memset, ADDR wc, SIZEOF wc, 0
	MOV    wc.style, CS_HREDRAW OR CS_VREDRAW
	MOV    wc.lpfnWndProc, OFFSET DbgWndProc
	MOV    wc.hbrBackground, COLOR_WINDOW
	MOV    wc.lpszClassName, OFFSET szWndCls
	PUSH   hInst
	POP    wc.hInstance
	INVOKE RegisterClass, ADDR wc
	INVOKE CreateWindowEx, NULL, OFFSET szWndCls, OFFSET szWndTitle, WS_OVERLAPPED, 0, 0, 100, 100, NULL, 0, hInst, NULL
	MOV    hDbgWnd, EAX
	
	;---- MSG LOOP ----
	.WHILE TRUE
		INVOKE GetMessage, ADDR msg, NULL, 0, 0
		OR     EAX, EAX
		JZ     @@ExitMsgLoop
		INVOKE TranslateMessage, ADDR msg
		INVOKE DispatchMessage, ADDR msg
	.ENDW
  @@ExitMsgLoop:	
	RET
DbgWindowProc ENDP

CreateDbgWindow PROC 
	LOCAL dwThId : DWORD

	INVOKE CreateThread, NULL, 0, OFFSET DbgWindowProc, NULL, 0, ADDR dwThId
	INVOKE WaitForSingleObject, EAX, 500 ; wait a bit until the new thread created the window
	RET
CreateDbgWindow ENDP

memset PROC USES EDI ECX, pAddr : LPVOID, dwSize : DWORD, dwByte : DWORD
	;-> zero buffer
	MOV    EDI, pAddr
	MOV    ECX, dwSize
	MOV    EAX, dwByte
      @@ZeroLoop:
        STOSB
        LOOP   @@ZeroLoop	
	RET
memset ENDP

; returns TRUE if a NT OS is present else FALSE
IsNT PROC USES ECX EDX
	INVOKE GetVersion
	SHR    EAX, 31
	XOR    EAX, 1
	RET
IsNT ENDP

PasteTradeMark PROC USES ECX EDI ESI, pPE : LPVOID, szTradeMark : LPSTR
	INVOKE ImageNtHeader, pPE
	OR     EAX, EAX
	JZ     @@ExitProc
	LEA    EDI, (IMAGE_NT_HEADERS PTR [EAX]).FileHeader.TimeDateStamp
	MOV    ESI, szTradeMark
	INVOKE lstrlen, szTradeMark
	MOV    ECX, EAX
	REP    MOVSB
  @@ExitProc:
	RET
PasteTradeMark ENDP

end Main