; Program name:	ASPack 2.11 unpacker
; Version:	1.0
; Author:	Unknown One
; Target:	ASPack 2.11 (Copyright by Alexey Solodovnikov)
; Music:	None
; Greetings:	Alexey Solodovnikov, Iczelion, totnak, Daemon, r!sc, VAG, bane, everyone :)

; Special greetings to:
;	Alexey Solodovnikov for the best .EXE compressor around
; 	bane/DTG for his great source of unaspack

; Important note:
; This unpacker is tested only with ASPack 2.11 registered by SAC version
; (located on Aaron's site at www.exetools.com) and with unregistered
; ASPack 2.11 located on playtools.cjb.net (downloaded unregged version at 12-15-2000)

; History
; 12-11-2000	09:20am	Started analizing of the ASPack 2.11 polymorph layer
;		10:30am	Stop working on ASPack polymorph layer - taking a rest ;)
;		01:30pm	Coded decryptor for the polymorph layer (lame method against
;			fixed key decryption). To Alexey: use sliding key in your engine, please
;		03:00pm	ASPack 2.11 layer disassembled and starting to comment it
; 12-12-2000	10:30am	Ripped the decompression engine from ASPack 2.11 and implement it into
;			unpacker - works OK
;		10:40am	Ripped JMP/CALL (e8/e9) decryptor for first (.code section)
; 12-13-2000	08:40am	A terrible news for me. I feel disappointed from life :((
;		....	Feel better now. Starting to code
;		04:02pm	After few hours of coding got first unpacked file to work. Still many
;			many bugs left.
;		04:10pm	Fixed shit bug that causes crash on unpacking most files. Now most files
;			work after decompressing. Resources rebuilder must be coded
;		04:25pm	Every tested file works after decompressing ;))
;		04:30pm	The fucking terrible news are still in my brain. I'm gonna die :(
; 12-15-2000	10:30am	Tested the unpacker with files packed with unregistered ASPack 2.11
;			All tests are OK. My big problem still is writing resource rebuilder
        .586p
        .model  flat,stdcall
        locals
        jumps

UNICODE =       0
        include w32.inc                 ; Very usefull include file

.data

ofn_struc       OPENFILENAME    <>
ofn_filter      db      'Executable file',00h,'*.exe',00h,00h
ofn_title       db      'Select file to unpack',00h
f_name          db      200h dup(?)
f_handle        dd      ?
f_size          dd      ?
read_len        dd      ?
write_len       dd      ?

out_fhandle	dd	?
outfname        db      'out.exe',00h

buffer          dd      ?

pe_header_ptr   dd      ?
sections_start  dd      ?
entry_addr      dd      ?
image_base      dd      ?
section_size    dd      ?
sections_num	dd	?
phys_alignment	dd	?
sect_alignment	dd	?


; Messages
error_caption   db      'Error!',00h
cant_open_err   db      'Cannot open input file!',00h
no_mem_err      db      'Cannot allocate memory!',00h
not_mz_err      db      'Not valid EXE file (''MZ'' signature does not present)!',00h
not_pe_err      db      'Not valid PE file (''PE'' signature does not present)!',00h
import_err      db      'Cannot rebuild import section (not found)!',00h
success_msg     db      'File successfully unpacked!',00h

.code

start   proc
; Prepare the OpenFileName structure and get file name
        mov     ofn_struc.on_lStructSize,OPENFILENAME_
        mov     ofn_struc.on_lpstrFilter,offset ofn_filter
        mov     ofn_struc.on_lpstrFile,offset f_name
        mov     ofn_struc.on_lpstrTitle,offset ofn_title
        mov     ofn_struc.on_nMaxFile,0200h
        mov     ofn_struc.on_Flags,OFN_FILEMUSTEXIST or \
                                   OFN_PATHMUSTEXIST or OFN_LONGNAMES or\
                                   OFN_EXPLORER or OFN_HIDEREADONLY
        call    GetOpenFileNameA, offset ofn_struc
        or      eax,eax                 ; Nothing selected?
        jz      exit                    ; If so - exit

        call    CreateFileA, offset f_name, GENERIC_READ+GENERIC_WRITE,\
                             NULL,NULL,\
                             OPEN_EXISTING,FILE_ATTRIBUTE_NORMAL,NULL
        cmp     eax,INVALID_HANDLE_VALUE
        jne     open_ok

        call    MessageBoxA, NULL, offset cant_open_err, offset error_caption, NULL
        jmp     exit

;------ File is opened OK
open_ok:
        mov     f_handle,eax

;------ Load file in memory
        call    GetFileSize, f_handle, 00h
        mov     f_size,eax

        call    GlobalAlloc, GMEM_FIXED, f_size ; Allocate memory
        or      eax,eax
        jnz     mem_alloc_ok

	call	CloseHandle, f_handle
        call    MessageBoxA, NULL, offset no_mem_err, offset error_caption, NULL
        jmp     exit

;------ Memory allocated OK
mem_alloc_ok:
        mov     buffer,eax

        call    ReadFile, f_handle, buffer, f_size, offset read_len, NULL

	call	CloseHandle, f_handle

;------ Check for valid EXE file
check_valid_exe:
        mov     edx,buffer              ; EDI points to read buffer
        cmp     word ptr [edx],'MZ'
        jz      exe_ok
        cmp     word ptr [edx],'ZM'
        jz      exe_ok

        call    MessageBoxA, NULL, offset not_mz_err, offset error_caption, NULL
        jmp     free_mem_exit

exe_ok:
;------ Check for valid PE file
        add     edx,dword ptr [edx+003ch]       ; EDX -> PE header
        cmp     word ptr [edx],'EP'             ; PE file?
        jz      pe_ok

        call    MessageBoxA, NULL, offset not_pe_err, offset error_caption, NULL
        jmp     free_mem_exit

pe_ok:
        mov     pe_header_ptr,edx

        movzx	eax,word ptr [edx+0006h]	; Get sections number and save it
        mov	sections_num,eax		;

        mov     eax,dword ptr [edx+0034h]       ; Get image base and save it for later use
        mov     image_base,eax                  ;

	mov	eax,dword ptr [edx+003ch]	; Physical file alignment of objects (sections)
	mov	phys_alignment,eax		;

	mov	eax,dword ptr [edx+0038h]	; Virtual sections alignment
	mov	sect_alignment,eax		;

;###### UNPACKING START ##############################################

        .radix  16d                             ; Too many hex values

        mov     eax,dword ptr [edx+0028h]       ; EAX points to entry point of program
        call    rva2fo
	or	eax,eax
	jz	free_mem_exit

	mov	ebp,eax				; EBP is entry point offset
	dec	ebp				; Align to start of section

;----- Detect ASPack 2.11 layer
	cmp	word ptr [ebp+0001h],0e960h		; NOP/JMP xxxx
	jne	free_mem_exit

	cmp	dword ptr [ebp+0003h],0000043dh	; JMP offset of real polymorph decryptor
	jne	free_mem_exit			; (always the same?)

	call	decrypt_aspack_poly		; Try to decrypt ASPack 2.11 polymorph layer
	or	al,al				; Check if polymorph layer is decrypted
	jz	free_mem_exit			; If not - exit

	call	unpack_sections			; Unpack aspacked sections


;###### Write unpacked file to disk ##################################
;write_file:
;        call    CreateFileA, offset outfname, GENERIC_WRITE,\
;                             NULL, NULL, CREATE_ALWAYS, FILE_ATTRIBUTE_NORMAL, NULL
;        push    eax
;        call    WriteFile, eax, buffer, f_size, offset write_len, NULL
;        call    CloseHandle


;----- Free used memory buffer
free_mem_exit:
        call    GlobalFree,buffer

exit:
        call    ExitProcess, NULL       ; Exit program
start   endp


; Convert RVA in EAX to file offset in EAX. Return NULL if bad RVA!!!
; [section          ][gap][section]	<- File loaded by OS view
;        |-----------------|		<- Decrypt length
; [section          ][section]		<- File layout (as on disk/loaded by unpacker)
;
; if (rva > section_start + section length) and (rva < next_section_start) then EAX=0
rva2fo  proc
        uses    ecx,esi,edi

        mov     esi,pe_header_ptr       ; ESI points to PE header in memory
        movzx   ecx,word ptr [esi+0006h]; ECX=sections number

        movzx   edi,word ptr [esi+14h]  ; Get PE Header Size
        add     edi,18h                 ; Add offset of Flags field
        add     edi,esi                 ; Make EDI = Object Table Address
        mov     sections_start,edi      ; Save for later use

        mov     esi,edi
@@scan_section:
        cmp     eax,dword ptr [esi+000ch]; Compare RVA with section RVA
        jae     @@sect_found

@@go_scan_next_section:
        add     esi,0028h               ; ESI points to next section in memory
        loop    @@scan_section
	jmp	@@wrong_rva

@@sect_found:
	cmp	ecx,0001h
	je	@@its_last_section
	cmp	eax,dword ptr [esi+000ch+0028h]	; Compare with the start RVA of next section
	jae	@@go_scan_next_section

        mov     edi,dword ptr [esi+000ch]; EDI is section start RVA
        add     edi,dword ptr [esi+0010h]; EDI is the end RVA of the section in file
	cmp	eax,edi
	jae	@@wrong_rva


@@its_last_section:
        sub     eax,dword ptr [esi+000ch]; EAX is offset withing section
        add     eax,dword ptr [esi+0014h]; EAX=physical address of section + offset
        add     eax,buffer              ; EAX is offset in our memory buffer!
        ret

@@wrong_rva:
	xor	eax,eax
	ret
rva2fo  endp

;###### Unpack sections ##############################################
.data

temp_buffer_ptr	dd	?	; Temp buffer used by the ASPack decompression routine
aspack_start	dd	?	; ASPack layer offset in memory
physical_offset	dd	?	; Physical offset of sections (aligned to file alignment

decrypt_e8e9	db	?	; Flag for decrypting JMPs/CALLs in first (.code) section

.code

; Unpack sections into memory (this is bane's source with my little changes)
; EBP points to ASPack 2.11 start
unpack_sections	proc
;----- Init some variables
	mov	aspack_start,ebp		; Save pointer to ASPack
	mov	decrypt_e8e9,00h		; Set flag to FALSE

;----- Get memory for temp buffer used when decompressing
	call	VirtualAlloc,NULL,1800h,1000h,0004h	; Ripped values
	mov	temp_buffer_ptr,eax		; No error checking for now

;----- Start unpacking sections
	mov	edi,sections_start		; ESI points to sections in PE header
	mov	ecx,sections_num		; ECX is counter of sections

	mov	eax,dword ptr [edi+0014h]	; Get physical offset of first section
	mov	physical_offset,eax		; which is used to align next ones

unpack_next_section:
	push	ecx				; Save sections that left

	mov	esi,aspack_start		; ESI points to ASPack layer
	lea	esi,[esi+06e9h]			; ESI points to sections info (RVA/size)

;----- Find section in ASPack layer section info list
@@1:
	mov	eax,dword ptr [esi]		; EAX=section RVA in ASPack sections table
	or	eax,eax				; End of table?
	jz	not_packed			; If so then the section is not compressed

	cmp	eax,dword ptr [edi+000ch]	; Compare with section RVA
	jb	@@2
	sub	eax,dword ptr [edi+000ch]	; Get offset in section of compressed data
	cmp	eax,dword ptr [edi+0008h]	; vsize > unpack_rva-section_rva ?
	jb	@@3				; If so then RVA is in current section
@@2:
	add	esi,0008h			; ESI points to next section info
	jmp	@@1

;----- Section is compressed so let's decompress it
@@3:
	mov	edx,eax				; ECX is the offset of packed data into section

	add	eax,dword ptr [esi+0004h]	; Add the unpack size
	mov	ecx,dword ptr [edi+0010h]	; ECX is compressed physical size
	mov	dword ptr [edi+0010h],eax	; Save it as physical size in section header
						; (used later to calc next physical offset)

	add	eax,010eh			; Enlarge a little the alloc memory (ripped)

	push	ecx edx
	call	VirtualAlloc,NULL,eax,1000h,0004h	; Alloc memory for decompress
	mov	dword ptr [edi+0018h],eax	; Save ptr to reserved dword in section header
						; which is used as flag too
	pop	edx ecx

	push	eax ecx edx esi edi		; Save regs

	mov	eax,dword ptr [edi+000ch]	; EAX is section RVA
	call	rva2fo				; Convert to file offset in memory
	xchg	esi,eax				; ESI points to section in memory

	mov	edi,dword ptr [edi+0018h]	; EAX is pointer to destination block
        repe	movsb				; Copy uncompressed data

	pop	edi esi edx ecx eax		; Restore regs


	push	edi				; Save pointer to sections in PE header

	mov	eax,dword ptr [esi]		; Source RVA
	call	rva2fo				; Convert to file offset in memory

	mov	ebx,dword ptr [edi+0018h]
	add	ebx,edx

	call	aspack211_decompress,	\	; Decompress block
		eax,			\	; Source RVA
		ebx,			\	; Pointer to destination buffer
		dword ptr [esi+0004h],	\	; Size of decompressed data
		temp_buffer_ptr			; Pointer to temp buffer

	pop	edi				; Restore pointer to sections

	mov	eax,physical_offset		; Store new physical offset of section
	mov	dword ptr [edi+0014h],eax	;
	mov	eax,dword ptr [edi+0010h]	; EAX is physical size of section
	add	physical_offset,eax		; Update physical offset for next section


	cmp	decrypt_e8e9,00h		; First unpacked section decrypted?
	jnz	dont_decrypt_e8e9		; If so - skip JMP/CALL decryption

	pushad
	mov	ebp,aspack_start		; EBP points to ASPack layer in memory
	mov	dl,byte ptr [ebp+014bh]		; Get byte to scan for when decrypt
	mov	esi,dword ptr [edi+0018h]	; EDI points to decompressed section
	mov	eax,dword ptr [edi+0010h]	; EAX is physical size of section
	call	decrypt_jmp_call		; ESI and EAX as params
	popad

	inc	decrypt_e8e9			; Set flag to TRUE
dont_decrypt_e8e9:
	jmp	go_to_unpack_next_section

;----- The section is not packed (cannot find it's RVA in sections info saved in ASPack layer)
not_packed:
	mov	eax,dword ptr [edi+0014h]	; Get file offset of section
	or	eax,eax
	jz	not_packed_not_exist
	add	eax,buffer			; EAX is offset in memory of non-packed section

not_packed_not_exist:
	mov	dword ptr [edi+0018h],eax	; Save it to reserved space used when write file

	cmp	dword ptr [edi+0014h],0000h	; Check if file offset of section is zero
	jz	dont_set_phys_offset		;

	mov	eax,physical_offset		; Set new physical offset
	mov	dword ptr [edi+0014h],eax	;

dont_set_phys_offset:
	mov	eax,dword ptr [edi+0010h]	; Get physical size
	add	physical_offset,eax

	jmp	go_to_unpack_next_section

;-----
go_to_unpack_next_section:
	add	edi,0028h			; EDI points to next section
	pop	ecx
	loop	unpack_next_section

;###### Write file to disk ###########################################
	mov	esi,aspack_start
	mov	edi,pe_header_ptr

	mov	eax,dword ptr [esi+0081h]	; Get import RVA
	mov	dword ptr [edi+0080h],eax	; Store at PE header

	mov	eax,dword ptr [esi+007dh]	; EAX is original entry point RVA
	mov	dword ptr [edi+0028h],eax	;

;;;; Next line is commented because there is no resource rebuilding done
;	dec	word ptr [edi+0006h]		; Decrease sections number by 2 (.aspack
;	dec	word ptr [edi+0006h]		; and & .data used by aspack 2.11)

	movzx	ecx,word ptr [edi+0006h]	; ECX is sections number
	push	ecx

;----- Write sections loop
        call    CreateFileA, offset outfname, GENERIC_WRITE,\
                             NULL, NULL, CREATE_ALWAYS, FILE_ATTRIBUTE_NORMAL, NULL
	mov	out_fhandle,eax

	mov	edi,sections_start

;----- Write header
	mov	eax,dword ptr [edi+0014h]	; EAX is file offset of first section
						; and it will be used as write length
	call	WriteFile, out_fhandle, buffer, eax, offset write_len, NULL


	pop	ecx
write_section:
	push	ecx
	cmp	dword ptr [edi+0010h],0000h
	jz	dont_write_empty_section

	mov	eax,dword ptr [edi+0018h]
	mov	dword ptr [edi+0018h],0000h
	or	eax,eax
	jz	dont_write_empty_section


	mov	ebx,dword ptr [edi+0010h]		; Physical size
        call    WriteFile, out_fhandle, eax, ebx, offset write_len, NULL
	call	VirtualFree,dword ptr [edi+0018h],0000h,8000h	; Free mem

dont_write_empty_section:
	add	edi,0028h
	pop	ecx
	loop	write_section

        call    CloseHandle,out_fhandle

	call	VirtualFree,temp_buffer_ptr,0000h,8000h	; Ripped values
	ret
unpack_sections	endp


; Decrypt JMPs and CALLs in first (.code) section
; On entry ESI points to decompress buffer, EAX is size of decompressed section,
; DL is magic byte to scan for (high byte of the jmp DWORD)
decrypt_jmp_call	proc
	mov ecx, eax				; ECX is size of decompressed data
	sub ecx, 00000006			; Length of JMP/CALL dword instruction
	xor ebx, ebx

dcr_e8e9_1:
	or ecx, ecx
	je decr_e8e9_exit
	js decr_e8e9_exit

	lodsb					; Get byte

	cmp al, 0E8h				; CALL dword
	je dcr_e8e9_3

	cmp al, 0E9h				; JMP dword
	je dcr_e8e9_3

dcr_e8e9_2:
	inc ebx					; Bytes offset from beginning of area
	dec ecx					; Dec counter
	jmp dcr_e8e9_1				; Scan again

dcr_e8e9_3:
	mov eax, dword ptr [esi]		; EAX is JMP/CALL offset

	cmp byte ptr [esi], dl			; 01h is different for every file!!!
	jne dcr_e8e9_2
	and al, 00h
	rol eax, 18h
	sub eax, ebx				; Decrypt the item!
	mov dword ptr [esi], eax
	add ebx, 00000005h
	add esi, 00000004h
	sub ecx, 00000005h
	jmp dcr_e8e9_1
decr_e8e9_exit:
	ret
decrypt_jmp_call	endp

; Align section RVA in EAX to alignment set in ECX (PE header + 38h for section align,
; +3ch for file align)
section_align	proc
        xor	edx, edx
        div	ecx
        or	eax, eax
        jnz	sect_align_1
        inc	eax
sect_align_1:
	xor	edx, edx
	mul	ecx
	ret
section_align	endp



;#####################################################################
; Polymorph layer decryptor - lame method because fixed/unchanging key is used for the
; whole decrypt area (byte/dword decryption). No need to analize the polymorph code :)
.data

dm_unknown	equ	00h
dm_byte_xor	equ	01h
dm_byte_sub	equ	02h
dm_byte_add	equ	03h
dm_dword_xor	equ	04h
dm_dword_sub	equ	05h
dm_dword_add	equ	06h

decrypt_method	db	?		; Shows which decrypt method is detected

decr_byte_key	db	?		; The found byte key for decryption
decr_dword_key	dd	?

add_sub_byte_key	dd	?	; Used for correcting the key

.code

; Checks if the byte key in EAX and BL is always the same
; Returns in BL result of test: 00h - not good key, 01h - good key
; Leave the good key in EAX
chk_byte_decr_key	proc
	push	eax			; Save key!
	cmp	al,bl
	jne	chk_bdck_bad
	cmp	al,ah
	jne	chk_bdck_bad

	shr	eax,10h			; AX is the high word of EAX

	cmp	al,bl
	jne	chk_bdck_bad
	cmp	al,ah
	jne	chk_bdck_bad

chk_bdck_good:
	pop	eax
	mov	bl,01h
	ret
chk_bdck_bad:
	pop	eax
	xor	bl,bl
	ret
chk_byte_decr_key	endp

; Test decrypt some dwords by XORing with byte key
; EAX is the key
test_decr_byte_xor	proc
	xor	byte ptr [ebp+0007h],al
	xor	byte ptr [ebp+0008h],al
	xor	byte ptr [ebp+0009h],al
	xor	byte ptr [ebp+000ah],al

	xor	byte ptr [ebp+000bh],al
	xor	byte ptr [ebp+000ch],al
	xor	byte ptr [ebp+000dh],al
	xor	byte ptr [ebp+000eh],al

	xor	byte ptr [ebp+0055h],al
	xor	byte ptr [ebp+0056h],al
	xor	byte ptr [ebp+0057h],al
	xor	byte ptr [ebp+0058h],al

	xor	byte ptr [ebp+0059h],al
	xor	byte ptr [ebp+005ah],al
	xor	byte ptr [ebp+005bh],al
	xor	byte ptr [ebp+005ch],al
	ret
test_decr_byte_xor	endp

; Test decrypt some dwords by SUBing with byte key
; EAX is the key
test_decr_byte_sub	proc
	sub	byte ptr [ebp+0007h],al
	sub	byte ptr [ebp+0008h],al
	sub	byte ptr [ebp+0009h],al
	sub	byte ptr [ebp+000ah],al

	sub	byte ptr [ebp+000bh],al
	sub	byte ptr [ebp+000ch],al
	sub	byte ptr [ebp+000dh],al
	sub	byte ptr [ebp+000eh],al

	sub	byte ptr [ebp+0055h],al
	sub	byte ptr [ebp+0056h],al
	sub	byte ptr [ebp+0057h],al
	sub	byte ptr [ebp+0058h],al

	sub	byte ptr [ebp+0059h],al
	sub	byte ptr [ebp+005ah],al
	sub	byte ptr [ebp+005bh],al
	sub	byte ptr [ebp+005ch],al
	ret
test_decr_byte_sub	endp

; Test decrypt some dwords by ADDing with byte key
; EAX is the key
test_decr_byte_add	proc
	add	byte ptr [ebp+0007h],al
	add	byte ptr [ebp+0008h],al
	add	byte ptr [ebp+0009h],al
	add	byte ptr [ebp+000ah],al

	add	byte ptr [ebp+000bh],al
	add	byte ptr [ebp+000ch],al
	add	byte ptr [ebp+000dh],al
	add	byte ptr [ebp+000eh],al

	add	byte ptr [ebp+0055h],al
	add	byte ptr [ebp+0056h],al
	add	byte ptr [ebp+0057h],al
	add	byte ptr [ebp+0058h],al

	add	byte ptr [ebp+0059h],al
	add	byte ptr [ebp+005ah],al
	add	byte ptr [ebp+005bh],al
	add	byte ptr [ebp+005ch],al
	ret
test_decr_byte_add	endp

; Test decrypt some dwords by XORing with dword key
; EAX is the key
test_decr_dword_xor	proc
	xor	dword ptr [ebp+0007h],eax
	xor	dword ptr [ebp+000bh],eax
	xor	dword ptr [ebp+0055h-2],eax
	xor	dword ptr [ebp+0059h-2],eax
	xor	dword ptr [ebp+005dh-2],eax
	ret
test_decr_dword_xor	endp

; Test decrypt some dwords by SUBing with dword key
; EAX is the key
test_decr_dword_sub	proc
	sub	dword ptr [ebp+0007h],eax
	sub	dword ptr [ebp+000bh],eax
	sub	dword ptr [ebp+0055h-2],eax
	sub	dword ptr [ebp+0059h-2],eax
	sub	dword ptr [ebp+005dh-2],eax
	ret
test_decr_dword_sub	endp

; Test decrypt some dwords by ADDing with dword key
; EAX is the key
test_decr_dword_add	proc
	add	dword ptr [ebp+0007h],eax
	add	dword ptr [ebp+000bh],eax
	add	dword ptr [ebp+0055h-2],eax
	add	dword ptr [ebp+0059h-2],eax
	add	dword ptr [ebp+005dh-2],eax
	ret
test_decr_dword_add	endp


; Check if for real aspack layer after test decrypting
; Return result in BL (00h - not found, 01h - found)
check_real_aspack	proc
	cmp	dword ptr [ebp+0007h],000424e8h	; call get_delta_offset
	jne	chk_rasp_bad
	cmp	dword ptr [ebp+000bh],0bb00eb00h; JMP $+2
	jne	chk_rasp_bad
	cmp	dword ptr [ebp+0055h],4afc95ffh	;
	jne	chk_rasp_bad
	cmp	dword ptr [ebp+0059h],85890044h	;
	jne	chk_rasp_bad

chk_rasp_good:
	mov	bl,01h
	ret
chk_rasp_bad:
	xor	bl,bl
	ret
check_real_aspack	endp

; Decrypt ASPack 2.11 polymorph layer using lame detection (static key one)
; On entry EBP points to ASPack entry point - 1 (because EP is section start + 1)
decrypt_aspack_poly	proc
	mov	decrypt_method,dm_unknown	; At start set decrypt method to unknown

; This is the test instruction that must be decrypted
;3b|3c 3d 3e 3f		- offset from entry + 400h
;E9 C7 FB FF FF		- jmp entry_point+0007h	; jmp real_aspack_layer

;###### Try byte decryption ##########################################

;----- XOR
	mov	eax,dword ptr [ebp+043ch]
	mov	bl,byte ptr [ebp+043bh]

	xor	bl,0e9h
	xor	eax,0fffffbc7h

	call	chk_byte_decr_key		; Check if all bytes are the same
	or	bl,bl				; Good key?
	jz	isnt_xor_byte

	call	test_decr_byte_xor		; Decrypt some test bytes
	call	check_real_aspack		; Check if ASPack is correct decrypted
	call	test_decr_byte_xor		; Encrypt the test bytes (restore)
	or	bl,bl				; Test result of aspack check
	jz	isnt_xor_byte			; If bad key - test another method

	mov	decrypt_method,dm_byte_xor
	mov	decr_byte_key,al
	jmp	decrypt_byte

isnt_xor_byte:

;----- ADD
	sub	byte ptr [ebp+043bh],0e9h	; Decrypt
	sub	byte ptr [ebp+043ch],0c7h
	sub	byte ptr [ebp+043dh],0fbh
	sub	byte ptr [ebp+043eh],0ffh
	sub	byte ptr [ebp+043fh],0ffh

	mov	eax,dword ptr [ebp+043ch]
	mov	bl,byte ptr [ebp+043bh]

	add	byte ptr [ebp+043bh],0e9	; Restore bytes
	add	byte ptr [ebp+043ch],0c7h
	add	byte ptr [ebp+043dh],0fbh
	add	byte ptr [ebp+043eh],0ffh
	add	byte ptr [ebp+043fh],0ffh

	call	chk_byte_decr_key		; Check if all bytes are the same
	or	bl,bl				; Good key?
	jz	isnt_add_byte

	neg	al				; Correct key
	call	test_decr_byte_add		; Decrypt some test bytes
	call	check_real_aspack		; Check if ASPack is correct decrypted
	call	test_decr_byte_sub		; Encrypt the test bytes (restore)
	or	bl,bl				; Test result of aspack check
	jz	isnt_add_byte			; If bad key - test another method

	mov	decrypt_method,dm_byte_add
	mov	decr_byte_key,al
	jmp	decrypt_byte

isnt_add_byte:
;----- SUB
	add	byte ptr [ebp+043bh],0e9h	; Decrypt
	add	byte ptr [ebp+043ch],0c7h
	add	byte ptr [ebp+043dh],0fbh
	add	byte ptr [ebp+043eh],0ffh
	add	byte ptr [ebp+043fh],0ffh

	mov	eax,dword ptr [ebp+043ch]
	mov	bl,byte ptr [ebp+043bh]

	sub	byte ptr [ebp+043bh],0e9h	; Restore bytes
	sub	byte ptr [ebp+043ch],0c7h
	sub	byte ptr [ebp+043dh],0fbh
	sub	byte ptr [ebp+043eh],0ffh
	sub	byte ptr [ebp+043fh],0ffh

	call	chk_byte_decr_key		; Check if all bytes are the same
	or	bl,bl				; Good key?
	jz	isnt_sub_byte

	neg	al				; Correct key

	call	test_decr_byte_sub		; Decrypt some test bytes
	call	check_real_aspack		; Check if ASPack is correct decrypted
	call	test_decr_byte_add		; Encrypt the test bytes (restore)
	or	bl,bl				; Test result of aspack check
	jz	isnt_sub_byte			; If bad key - test another method

	mov	decrypt_method,dm_byte_sub
	mov	decr_byte_key,al
	jmp	decrypt_byte

isnt_sub_byte:

;###### Try dword decryption #########################################

;----- XOR
	mov	eax,dword ptr [ebp+004bh]
	xor	eax,9d8df88bh			; Check part of instruction

	call	test_decr_dword_xor		; Decrypt some test bytes
	call	check_real_aspack		; Check if ASPack is correct decrypted
	call	test_decr_dword_xor		; Encrypt the test bytes (restore)
	or	bl,bl				; Test result of aspack check
	jz	isnt_xor_dword			; If bad key - test another method

	mov	decrypt_method,dm_dword_xor
	mov	decr_dword_key,eax
	jmp	decrypt_dword

isnt_xor_dword:

;----- ADD
	mov	eax,dword ptr [ebp+004bh]
	sub	eax,9d8df88bh			; Check part of instruction
	neg	eax				; Correct
	call	test_decr_dword_add		; Decrypt some test bytes
	call	check_real_aspack		; Check if ASPack is correct decrypted
	call	test_decr_dword_sub		; Encrypt the test bytes (restore)
	or	bl,bl				; Test result of aspack check
	jz	isnt_add_dword			; If bad key - test another method

	mov	decrypt_method,dm_dword_add
	mov	decr_dword_key,eax
	jmp	decrypt_dword

isnt_add_dword:

;----- SUB
	mov	eax,dword ptr [ebp+004bh]
	add	eax,9d8df88bh			; Check part of instruction
	neg	eax				; Correct
	call	test_decr_dword_sub		; Decrypt some test bytes
	call	check_real_aspack		; Check if ASPack is correct decrypted
	call	test_decr_dword_add		; Encrypt the test bytes (restore)
	or	bl,bl				; Test result of aspack check
	jz	isnt_sub_dword			; If bad key - test another method

	mov	decrypt_method,dm_dword_sub
	mov	decr_dword_key,eax
	jmp	decrypt_dword

isnt_sub_dword:

;----- Exit with error (not found)
	xor	al,al
	ret

;###### Decrypt using dword key ######################################
decrypt_dword:
	lea	esi,[ebp+043bh]			; ESI is pointer to data
	mov	ecx,010eh			; Length of data
	mov	eax,decr_dword_key		; Get key

decrypt_dword_1:

	cmp	decrypt_method,dm_dword_add
	jne	dcrdw_1
	add	dword ptr [esi],eax		; Decrypt
	jmp	decrypt_dword_loop

dcrdw_1:
	cmp	decrypt_method,dm_dword_sub
	jne	dcrdw_2
	sub	dword ptr [esi],eax		; Decrypt
	jmp	decrypt_dword_loop

dcrdw_2:
	cmp	decrypt_method,dm_dword_xor
	jne	dcrdw_3
	xor	dword ptr [esi],eax		; Decrypt
	jmp	decrypt_dword_loop

dcrdw_3:

decrypt_dword_loop:
	sub	esi,0004h
	dec	ecx
	jnz	decrypt_dword_1

;----- Exit with flag set to true
	mov	al,01h
	ret

;###### Decrypt using byte key #######################################
decrypt_byte:
	lea	esi,[ebp+043Fh]			; ESI is pointer to data
	mov	ecx,0439h			; Length of data
	mov	al,decr_byte_key		; Get key
decrypt_byte_1:

	cmp	decrypt_method,dm_byte_add
	jne	dcrb_1
	add	byte ptr [esi],al		; Decrypt
	jmp	decrypt_byte_loop

dcrb_1:
	cmp	decrypt_method,dm_byte_sub
	jne	dcrb_2
	sub	byte ptr [esi],al		; Decrypt
	jmp	decrypt_byte_loop

dcrb_2:
	cmp	decrypt_method,dm_byte_xor
	jne	dcrb_3
	xor	byte ptr [esi],al		; Decrypt
	jmp	decrypt_byte_loop

dcrb_3:

decrypt_byte_loop:
	dec	esi
	dec	ecx
	jnz	decrypt_byte_1

;----- Exit with flag set to true
	mov	al,01h
	ret
decrypt_aspack_poly	endp


;###### ASPack 2.11 routines #########################################

.data

; ASPack 2.11 data - DON'T MOVE ANYTHING!
table_1	db	00h, 01h, 02h, 03h, 04h, 05h, 06h, 07h, 08h, 0Ah, 0Ch, 0Eh, 10h
	db	14h, 18h, 1Ch, 20h, 28h, 30h, 38h, 40h, 50h, 60h, 70h, 80h, 0A0h, 0C0h, 0E0h
table_3	db	00h, 00h, 00h, 00h, 00h, 00h, 00h, 00h, 01h, 01h, 01h
	db	01h, 02h, 02h, 02h, 02h, 03h
	db	03h, 03h, 03h, 04h, 04h, 04h, 04h, 05h, 05h, 05h, 05h
table_2 db	00h, 00h, 00h, 00h, 01h, 01h, 02h, 02h, 03h, 03h, 04h, 04h, 05h, 05h, 06h, 06h
	db	07h, 07h, 08h, 08h, 09h
	db	09h, 0Ah, 0Ah, 0Bh, 0Bh, 0Ch, 0Ch, 0Dh, 0Dh, 0Eh, 0Eh, 0Fh, 0Fh, 10h, 10h, 11h
	db	11h, 11h, 11h, 11h, 11h, 11h, 11h, 11h, 11h, 11h, 11h, 11h, 11h, 12h, 12h, 12h
	db	12h, 12h, 12h, 12h, 12h

.code

;#####################################################################
; ASPack decompression routines (ripped from w32dasm disassembly)
; Decompress(lp_section_rva,lp_decompress_buffer,section_decomp_size,lp_temp_buffer)
;
;#####################################################################
.radix 16d					; Too many hex numbers
; esp+10 ptr to temp buffer
; esp+0c compressed size
; esp+08 ptr to destination buffer
; esp+04 ptr to source buffer
; esp+00 ret addr

aspack211_decompress	proc
        mov eax, dword ptr [esp+10h]		; EAX points to temp buffer
        sub esp, 00000354h
        lea ecx, dword ptr [esp+04h]
        push eax
        call init_asp_decompress		; Initialize decompressor (temp buffer)
        mov ecx, dword ptr [esp+0000035Ch]	; Pointer to destination buffer
        mov edx, dword ptr [esp+00000358h]	; Pointer to source buffer
        push ecx
        push edx
        lea ecx, dword ptr [esp+0Ch]
        call sub_5
        test al, al
        jne asp211_d1
        or eax, 0FFFFFFFFh
        add esp, 00000354h
        ret

asp211_d1:
        mov ecx, dword ptr [esp+00000360h]
        lea eax, dword ptr [esp]
        push eax
        push ecx
        lea ecx, dword ptr [esp+0Ch]
        call sub_7
        test al, al
        jne asp211_d2
        or eax, 0FFFFFFFFh
        add esp, 00000354
        ret

asp211_d2:
        mov eax, dword ptr [esp]
        add esp, 00000354h
        ret 0010h
aspack211_decompress	endp

;-----
sub_1	proc
        push ecx
        mov edx, ecx
        push esi
        mov ecx, 00000008
        push edi
        cmp dword ptr [edx+04], ecx
        jb s1_2
        push ebx
        mov esi, 0FFFFFFF8h

s1_1:
        mov eax, dword ptr [edx]
        mov bl, byte ptr [eax]
        inc eax
        mov byte ptr [esp+0Ch], bl
        mov dword ptr [edx], eax
        mov eax, dword ptr [edx+08]
        mov edi, dword ptr [esp+0Ch]
        shl eax, 08
        and edi, 000000FFh
        or eax, edi
        mov edi, dword ptr [edx+04]
        add edi, esi
        mov dword ptr [edx+08], eax
        mov eax, edi
        mov dword ptr [edx+04], edi
        cmp eax, ecx
        jnb s1_1
        pop ebx

s1_2:
        mov esi, dword ptr [edx+04h]
        mov eax, dword ptr [edx+08h]
        mov edi, dword ptr [esp+10h]
        sub ecx, esi
        shr eax, cl
        mov ecx, 00000018h
        sub ecx, edi
        and eax, 00FFFFFFh
        shr eax, cl
        add esi, edi
        pop edi
        mov dword ptr [edx+04], esi
        pop esi
        pop ecx
        ret 0004
sub_1	endp

;-----
sub_2	proc
        mov eax, dword ptr [esp+04]
        mov edx, dword ptr [esp+08]
        mov dword ptr [ecx+00000084h], eax
        mov dword ptr [ecx+00000088h], edx
        lea eax, dword ptr [edx+4*eax]
        mov dword ptr [ecx+0000008Ch], eax
        add eax, 00000100h
        ret 0008
sub_2	endp

;-----
sub_3	proc
        sub esp, 00000098h
        push ebx
        push ebp
        push esi
        mov edx, ecx
        push edi
        mov ecx, 0000000Fh
        mov ebp, dword ptr [edx+00000084h]
        xor eax, eax
        lea edi, dword ptr [esp+2Ch]
        xor esi, esi
        repz
        stosd
        mov edi, dword ptr [esp+000000ACh]
        cmp ebp, esi
        mov dword ptr [esp+20h], edx
        jbe s3_2

s3_1:
        xor ecx, ecx
        mov cl, byte ptr [eax+edi]
        mov ebx, dword ptr [esp+4*ecx+28h]
        lea ecx, dword ptr [esp+4*ecx+28h]
        inc ebx
        inc eax
        cmp eax, ebp
        mov dword ptr [ecx], ebx
        jb s3_1

s3_2:
        mov ecx, 00000017
        mov dword ptr [esp+28h], esi
        mov dword ptr [edx+04h], esi
        mov dword ptr [edx+44h], esi
        mov dword ptr [esp+68h], esi
        xor edi, edi
        mov dword ptr [esp+1Ch], esi
        mov dword ptr [esp+10h], 00000001h
        mov dword ptr [esp+18h], ecx
        lea ebp, dword ptr [edx+08]
        mov dword ptr [esp+14h], esi

s3_3:
        mov eax, dword ptr [esp+esi+2Ch]
        shl eax, cl
        add edi, eax
        cmp edi, 01000000h
        mov dword ptr [esp+24h], edi
        ja s3_5
        mov eax, dword ptr [esp+esi+28h]
        mov dword ptr [ebp+00], edi
        mov ebx, dword ptr [ebp+3Ch]
        add eax, ebx
        cmp ecx, 00000010h
        mov dword ptr [ebp+40h], eax
        mov dword ptr [esp+esi+6Ch], eax
        jl s3_4
        mov esi, dword ptr [ebp+00h]
        mov eax, dword ptr [esp+10h]
        mov ebx, dword ptr [esp+1Ch]
        mov edi, dword ptr [edx+0000008Ch]
        shr esi, 10h
        mov ecx, esi
        and eax, 000000FFh
        sub ecx, ebx
        add edi, ebx
        mov bl, al
        mov edx, ecx
        mov bh, bl
        mov dword ptr [esp+1Ch], esi
        mov eax, ebx
        mov esi, dword ptr [esp+14h]
        shl eax, 10h
        mov ax, bx
        shr ecx, 02h
        repz
        stosd
        mov ecx, edx
        mov edx, dword ptr [esp+20h]
        and ecx, 00000003h
        repz stosb
        mov edi, dword ptr [esp+24h]
        mov ecx, dword ptr [esp+18h]

s3_4:
        mov eax, dword ptr [esp+10h]
        add esi, 00000004
        inc eax
        dec ecx
        add ebp, 00000004
        cmp ecx, 00000009
        mov dword ptr [esp+10h], eax
        mov dword ptr [esp+18h], ecx
        mov dword ptr [esp+14h], esi
        jnl s3_3
        cmp edi, 01000000
        je s3_6

s3_5:
        pop edi
        pop esi
        pop ebp
        xor al, al
        pop ebx
        add esp, 00000098h
        ret 0004

s3_6:
        mov eax, dword ptr [edx+00000084h]
        xor ecx, ecx
        test eax, eax
        jbe s3_9
        mov esi, dword ptr [esp+000000ACh]

s3_7:
        mov al, byte ptr [ecx+esi]
        test al, al
        je s3_8
        mov edi, dword ptr [edx+00000088h]
        and eax, 000000FFh
        mov eax, dword ptr [esp+4*eax+68h]
        mov dword ptr [edi+4*eax], ecx
        xor eax, eax
        mov al, byte ptr [ecx+esi]
        mov edi, dword ptr [esp+4*eax+68h]
        lea eax, dword ptr [esp+4*eax+68h]
        inc edi
        mov dword ptr [eax], edi

s3_8:
        mov eax, dword ptr [edx+00000084h]
        inc ecx
        cmp ecx, eax
        jb s3_7

s3_9:
        pop edi
        pop esi
        pop ebp
        mov al, 01
        pop ebx
        add esp, 00000098h
        ret 0004
sub_3	endp

;-----
sub_4	proc
        push ecx
        push ebx
        push esi
        mov esi, ecx
        push edi
        mov eax, dword ptr [esi]
        cmp dword ptr [eax+04], 00000008h
        jb s4_2

s4_1:
        mov ecx, dword ptr [eax]
        mov dl, byte ptr [ecx]
        inc ecx
        mov byte ptr [esp+0Ch], dl
        mov dword ptr [eax], ecx
        mov ecx, dword ptr [eax+08h]
        mov edx, dword ptr [esp+0Ch]
        shl ecx, 08h
        and edx, 000000FFh
        or ecx, edx
        mov edx, dword ptr [eax+04h]
        add edx, 0FFFFFFF8h
        mov dword ptr [eax+08h], ecx
        mov ecx, edx
        mov dword ptr [eax+04h], edx
        cmp ecx, 00000008h
        jnb s4_1

s4_2:
        mov edx, dword ptr [eax+04h]
        mov eax, dword ptr [eax+08h]
        mov ecx, 00000008h
        sub ecx, edx
        shr eax, cl
        mov ecx, dword ptr [esi+24h]
        and eax, 00FFFE00h
        cmp eax, ecx
        jnb s4_3
        mov edx, dword ptr [esi+0000008Ch]
        mov ecx, eax
        shr ecx, 10h
        xor ebx, ebx
        mov bl, byte ptr [ecx+edx]
        mov edx, ebx
        jmp s4_8

s4_3:
        cmp eax, dword ptr [esi+2Ch]
        jnb s4_4
        cmp eax, dword ptr [esi+28h]
        sbb edx, edx
        add edx, 0000000Ah
        jmp s4_8

s4_4:
        cmp eax, dword ptr [esi+30h]
        jnb s4_5
        mov edx, 0000000Bh
        jmp s4_8

s4_5:
        cmp eax, dword ptr [esi+34h]
        jnb s4_6
        mov edx, 0000000Ch
        jmp s4_8

s4_6:
        cmp eax, dword ptr [esi+38h]
        jnb s4_7
        mov edx, 0000000Dh
        jmp s4_8

s4_7:
        cmp eax, dword ptr [esi+3Ch]
        sbb edx, edx
        add edx, 0000000Fh

s4_8:
        mov ecx, dword ptr [esi]
        mov edi, dword ptr [ecx+04]
        add edi, edx
        mov dword ptr [ecx+04], edi
        mov ebx, dword ptr [esi+4*edx]
        mov ecx, 00000018h
        sub eax, ebx
        sub ecx, edx
        pop edi
        shr eax, cl
        mov ecx, dword ptr [esi+4*edx+44h]
        add eax, ecx
        mov ecx, dword ptr [esi+00000088h]
        pop esi
        pop ebx
        mov eax, dword ptr [ecx+4*eax]
        pop ecx
        ret
sub_4	endp

;-----
init_asp_decompress	proc
        push ebx
        push esi
        push edi
        mov edi, ecx
        xor edx, edx
        xor eax, eax
        lea esi, dword ptr [edi+00000268h]

init_asp_1:
        mov dword ptr [esi], edx
        mov cl, byte ptr [eax+table_2]		; 40687B (4 zeros here)
        mov ebx, 00000001
        add esi, 00000004
        shl ebx, cl
        add edx, ebx
        inc eax
        cmp eax, 0000003A
        jb init_asp_1
        mov eax, dword ptr [esp+10]
        lea ecx, dword ptr [edi+10]
        push eax
        push 000002D1
        call sub_2				; XCHG 2 values and adds 100h to EAX
        push eax
        push 0000001C
        lea ecx, dword ptr [edi+000000A0]
        call sub_2
        push eax
        push 00000008
        lea ecx, dword ptr [edi+00000130]
        call sub_2
        push eax
        push 00000013
        lea ecx, dword ptr [edi+000001C0]
        call sub_2
        mov dword ptr [edi+00000260], eax
        pop edi
        pop esi
        add eax, 000002F5
        pop ebx
        ret 0004
init_asp_decompress	endp

;-----
sub_5	proc
        mov eax, dword ptr [esp+08]		; Ptr to source
        mov edx, ecx				; Ptr to local buffer on stack
        mov ecx, dword ptr [esp+04]		; Ptr to destination
        push edi
        mov dword ptr [edx], eax
        lea eax, dword ptr [edx+04]
        mov dword ptr [eax], ecx
        mov dword ptr [eax+04], 00000020h
        mov dword ptr [edx+10], eax
        mov dword ptr [edx+000000A0h], eax
        mov dword ptr [edx+00000130h], eax
        mov dword ptr [edx+000001C0h], eax
        xor eax, eax
        mov ecx, 000000BDh
        mov dword ptr [edx+00000250h], eax
        mov dword ptr [edx+00000254h], eax
        mov dword ptr [edx+00000258h], eax
        mov edi, dword ptr [edx+00000260h]
        mov dword ptr [edx+0000025Ch], eax
        repz
        stosd
        mov ecx, edx
        stosb
        call sub_6
        pop edi
        ret 0008
sub_5	endp

;-----
sub_6	proc
        sub esp, 0000030Ch
        push ebx
        mov ebx, ecx
        push ebp
        push esi
        lea ebp, dword ptr [ebx+04]
        push edi
        push 00000001
        mov ecx, ebp
        call sub_1
        test eax, eax
        jne s6_1
        mov edi, dword ptr [ebx+00000260h]
        mov ecx, 000000BDh
        repz stosd
        stosb

s6_1:
        xor esi, esi

s6_2:
        push 00000004
        mov ecx, ebp
        call sub_1
        mov byte ptr [esp+esi+10h], al
        inc esi
        cmp esi, 00000013h
        jb s6_2
        lea edi, dword ptr [ebx+000001C0h]
        lea eax, dword ptr [esp+10h]
        push eax
        mov ecx, edi
        call sub_3
        test al, al
        jne s6_3
        pop edi
        pop esi
        pop ebp
        pop ebx
        add esp, 0000030Ch
        ret

s6_3:
        xor esi, esi

s6_4:
        mov ecx, edi
        call sub_4
        cmp eax, 00000010h
        jnb s6_5
        mov ecx, dword ptr [ebx+00000260h]
        mov dl, byte ptr [ecx+esi]
        add dl, al
        and dl, 0Fh
        mov byte ptr [esp+esi+24h], dl
        inc esi
        jmp s6_11

s6_5:
        jne s6_7
        push 00000002
        mov ecx, ebp
        call sub_1
        add eax, 00000003
        test eax, eax
        jle s6_11

s6_6:
        cmp esi, 000002F5h
        jge s6_12
        mov cl, byte ptr [esp+esi+23h]
        dec eax
        mov byte ptr [esp+esi+24h], cl
        inc esi
        test eax, eax
        jg s6_6
        jmp s6_11

s6_7:
        cmp eax, 00000011h
        jne s6_8
        push 00000003
        mov ecx, ebp
        call sub_1
        add eax, 00000003
        jmp s6_9

s6_8:
        push 00000007
        mov ecx, ebp
        call sub_1
        add eax, 0000000Bh

s6_9:
        test eax, eax
        jle s6_11

s6_10:
        cmp esi, 000002F5h
        jge s6_12
        mov byte ptr [esp+esi+24], 00
        inc esi
        dec eax
        test eax, eax
        jg s6_10

s6_11:
        cmp esi, 000002F5h
        jl s6_4

s6_12:
        lea edx, dword ptr [esp+24h]
        lea ecx, dword ptr [ebx+10h]
        push edx
        call sub_3
        test al, al
        jne s6_13
        pop edi
        pop esi
        pop ebp
        pop ebx
        add esp, 0000030Ch
        ret

s6_13:
        lea eax, dword ptr [esp+000002F5h]
        lea ecx, dword ptr [ebx+000000A0h]
        push eax
        call sub_3
        test al, al
        jne s6_14
        pop edi
        pop esi
        pop ebp
        pop ebx
        add esp, 0000030Ch
        ret

s6_14:
        lea ecx, dword ptr [esp+00000311h]
        push ecx
        lea ecx, dword ptr [ebx+00000130h]
        call sub_3
        test al, al
        jne s6_15
        pop edi
        pop esi
        pop ebp
        pop ebx
        add esp, 0000030Ch
        ret

s6_15:
        mov byte ptr [ebx+00000264h], 00
        xor eax, eax

s6_16:
        cmp byte ptr [esp+eax+00000311h], 03
        jne s6_17
        inc eax
        cmp eax, 00000008h
        jb s6_16
        jmp s6_18

s6_17:
        mov byte ptr [ebx+00000264h], 01

s6_18:
        mov edi, dword ptr [ebx+00000260h]
        lea esi, dword ptr [esp+24h]
        mov ecx, 000002F5h
        repz movsb
        pop edi
        pop esi
        pop ebp
        mov al, 01
        pop ebx
        add esp, 0000030Ch
        ret
sub_6	endp

;-----
sub_7	proc
        sub esp, 00000014h
        mov eax, dword ptr [esp+1Ch]
        push ebx
        push ebp
        push esi
        mov dword ptr [eax], 00000000h
        mov eax, dword ptr [esp+24h]
        push edi
        xor edi, edi
        test eax, eax
        mov esi, ecx
        mov dword ptr [esp+10h], edi
        jbe s7_19

s7_1:
        lea ecx, dword ptr [esi+10h]
        call sub_4
        cmp eax, 00000100h
        jnb s7_2
        mov ecx, dword ptr [esi]
        mov byte ptr [ecx], al
        mov ecx, dword ptr [esi]
        inc ecx
        inc edi
        mov dword ptr [esi], ecx
        mov dword ptr [esp+10h], edi
        jmp s7_18

s7_2:
        cmp eax, 000002D0h
        jnb s7_17
        add eax, 0FFFFFF00h
        mov ebp, eax
        and eax, 00000007h
        shr ebp, 03h
        lea edx, dword ptr [eax+02]
        cmp eax, 00000007h
        mov dword ptr [esp+14h], edx
        jne s7_5
        lea ecx, dword ptr [esi+000000A0h]
        call sub_4
        mov ecx, dword ptr [esi+08]
        xor ebx, ebx
        mov bl, byte ptr [eax+table_3]		; 40685F
        cmp ecx, 00000008
        jb s7_4

s7_3:
        mov ecx, dword ptr [esi+04]
        mov dl, byte ptr [ecx]
        inc ecx
        mov byte ptr [esp+18h], dl
        mov dword ptr [esi+04h], ecx
        mov ecx, dword ptr [esi+0Ch]
        mov edx, dword ptr [esp+18h]
        shl ecx, 08h
        and edx, 000000FFh
        or ecx, edx
        mov edx, dword ptr [esi+08h]
        add edx, 0FFFFFFF8h
        mov dword ptr [esi+0Ch], ecx
        mov ecx, edx
        mov dword ptr [esi+08h], edx
        cmp ecx, 00000008h
        jnb s7_3

s7_4:
        mov edi, dword ptr [esi+08h]
        mov edx, dword ptr [esi+0Ch]
        mov ecx, 00000008h
        sub ecx, edi
        add edi, ebx
        shr edx, cl
        mov ecx, 00000018h
        mov dword ptr [esi+08], edi
        sub ecx, ebx
        and edx, 00FFFFFFh
        shr edx, cl
        xor ecx, ecx
        mov cl, byte ptr [eax+table_1]		; 406843
        mov eax, dword ptr [esp+14h]
        add ecx, edx
        add eax, ecx
        mov dword ptr [esp+14h], eax

s7_5:
        mov al, byte ptr [esi+00000264h]
        mov ebx, dword ptr [esi+4*ebp+00000268h]
        xor edx, edx
        mov dl, byte ptr [ebp+table_2]		; 40687B
        test al, al
        mov edi, edx
        je s7_8
        cmp edi, 00000003h
        jb s7_8
        mov eax, dword ptr [esi+08]
        lea ebp, dword ptr [edi-03]
        cmp eax, 00000008
        jb s7_7

s7_6:
        mov eax, dword ptr [esi+04h]
        mov edx, dword ptr [esi+0Ch]
        shl edx, 08h
        mov cl, byte ptr [eax]
        inc eax
        mov byte ptr [esp+1Ch], cl
        mov ecx, dword ptr [esi+08h]
        mov dword ptr [esi+04h], eax
        mov eax, dword ptr [esp+1Ch]
        and eax, 000000FFh
        add ecx, 0FFFFFFF8h
        or edx, eax
        mov eax, ecx
        cmp eax, 00000008
        mov dword ptr [esi+0Ch], edx
        mov dword ptr [esi+08h], ecx
        jnb s7_6

s7_7:
        mov eax, dword ptr [esi+08h]
        mov edi, dword ptr [esi+0Ch]
        mov ecx, 00000008
        sub ecx, eax
        add eax, ebp
        shr edi, cl
        mov ecx, 00000018
        mov dword ptr [esi+08], eax
        sub ecx, ebp
        and edi, 00FFFFFFh
        shr edi, cl
        lea ecx, dword ptr [esi+00000130h]
        call sub_4
        add eax, ebx
        lea ebx, dword ptr [eax+8*edi]
        jmp s7_11

s7_8:
        cmp dword ptr [esi+08], 00000008
        jb s7_10

s7_9:
        mov eax, dword ptr [esi+04h]
        mov edx, dword ptr [esi+0Ch]
        shl edx, 08h
        mov cl, byte ptr [eax]
        inc eax
        mov byte ptr [esp+20h], cl
        mov ecx, dword ptr [esi+08]
        mov dword ptr [esi+04], eax
        mov eax, dword ptr [esp+20h]
        and eax, 000000FFh
        add ecx, 0FFFFFFF8h
        or edx, eax
        mov eax, ecx
        cmp eax, 00000008
        mov dword ptr [esi+0Ch], edx
        mov dword ptr [esi+08h], ecx
        jnb s7_9

s7_10:
        mov edx, dword ptr [esi+08h]
        mov eax, dword ptr [esi+0Ch]
        mov ecx, 00000008h
        sub ecx, edx
        add edx, edi
        shr eax, cl
        mov ecx, 00000018h
        mov dword ptr [esi+08], edx
        sub ecx, edi
        and eax, 00FFFFFFh
        shr eax, cl
        add ebx, eax

s7_11:
        cmp ebx, 00000003
        jnb s7_12
        mov ecx, dword ptr [esi+4*ebx+00000250h]
        test ebx, ebx
        je s7_14
        mov edx, dword ptr [esi+00000250h]
        mov dword ptr [esi+4*ebx+00000250h], edx
        jmp s7_13

s7_12:
        mov eax, dword ptr [esi+00000254h]
        mov edx, dword ptr [esi+00000250h]
        lea ecx, dword ptr [ebx-03]
        mov dword ptr [esi+00000258h], eax
        mov dword ptr [esi+00000254h], edx

s7_13:
        mov dword ptr [esi+00000250h], ecx

s7_14:
        mov eax, dword ptr [esi]
        mov edi, dword ptr [esp+14h]
        inc ecx
        lea edx, dword ptr [eax+edi]
        cmp eax, edx
        mov dword ptr [esi], edx
        jnb s7_16

s7_15:
        mov edx, eax
        sub edx, ecx
        inc eax
        mov dl, byte ptr [edx]
        mov byte ptr [eax-01], dl
        mov edx, dword ptr [esi]
        cmp eax, edx
        jb s7_15

s7_16:
        mov eax, dword ptr [esp+10h]
        add eax, edi
        mov dword ptr [esp+10h], eax
        mov edi, eax
        jmp s7_18

s7_17:
        mov ecx, esi
        call sub_6
        test al, al
        je s7_20

s7_18:
        cmp edi, dword ptr [esp+28h]
        jb s7_1
        mov eax, dword ptr [esp+2Ch]
        mov dword ptr [eax], edi

s7_19:
        pop edi
        pop esi
        pop ebp
        mov al, 01
        pop ebx
        add esp, 00000014h
        ret 0008

s7_20:
        pop edi
        pop esi
        pop ebp
        xor al, al
        pop ebx
        add esp, 00000014h
        ret 0008
sub_7	endp

        end     start
