
org 100h

start:
	mov ax,cs
	push ax
	push ax
	pop ds
	pop es

	push word Banner
	call print_message

	mov dx,Serial_Len
	mov ah,0ah
	int 21h

	push word CRLF
	call print_message

	mov si,Serial
	mov di,Key

	call verify_serial
	or ax,ax
	jnz prep_calc_loop

	push word Error1
	call print_message
	
	call exit_program

prep_calc_loop:
	mov cx,2

calc_loop:

	xor edx,edx

	push cx

	call calculate_key_digit

	inc di

	pop cx

	dec cx
	jnz calc_loop

	inc si

	cmp di,Key+8
	jnz prep_calc_loop

	push word Key_Msg
	call print_message

	mov si,Key
	call print_key
	mov si,Key+4
	call print_key

	call exit_program


; subroutines
;---------------------------------


; verify_serial
;
; input: si = points to serial to check
;
; returns: ax=1 if serial is ok

verify_serial:

	cmp byte [si+4] ,  0x2d
	jnz .bad_return

	cmp byte [si+9],  0x2d
	jnz .bad_return

	cmp byte [si+14], 0x2d
	jnz .bad_return

	cmp byte [si+19], 0dh
	jnz .bad_return

	mov ax,1
	ret

.bad_return:
	xor ax,ax
	ret


; input: si = points to serial,2 letters must be there for us to use
;	 ds = points to key, this is where the calculated key digit 
;	      will be stored
;
; returns: 
;	 places digit in [di], si=si+2 

calculate_key_digit:

	lodsw		; move 2 letters of entered serial at ds:si into ax
	mov bx,ax	; make copy of letters, for later

	ror al,3
	rol ah,7	; shuffle the bits around a bit

	xor bl,ah
	xor bh,al	; cross-xor just for the hell of it

	push ax
	push di

	mov cx,4
	movzx ax,bl
	xor edx,edx
	idiv cx		; div by 4, this way we get a number that's no 
			; larger then 3

	mov edi,edx	; save leftover for later in edi	

	movzx ax,bh
	mov cx,8
	xor edx,edx
	idiv cx		; div by 8, this way we get a number that's no 
			; larger then 7

	lea edi,[edi*4+edx] ; calculate address of item in data table
			    ; edi is line number ( edi<=4 * 8 ) + edx (offset)
	

	mov dl, [Magic_Table+edi]	; move data item into dl

	pop di
	pop ax

	add al,ah
	xor al,dl
	
	
	mov [di],al

	ret

; print_key
;
; input: si=4 digit Key (just a hex number really)
print_key:
	mov eax,[si]
	mov ebx,10
	xor cx,cx

decode_key_loop:
	xor edx,edx
	idiv ebx
	push dx
	inc cx

	or eax,eax
	jnz decode_key_loop

	mov ah,2
print_key_loop:
	pop dx
	or dx,30h
	int 21h
	
	dec cx
	jnz print_key_loop

	ret
	

; print_message
print_message:
	push bp
	mov bp,sp

	push dx
	push ax

	mov dx,[bp+4]
	mov ah,9
	int 21h

	pop ax
	pop dx

	pop bp

	ret

; exit_program

exit_program:
	mov ax,4c00h
	int 21h


; Data	
;---------------------------------


Key		db	"00000000"

;Serial 		db	"AbCd-EfGh-IjKl-MnOp",0dh

Serial_Len	db	20,0
Serial		db	"00000000000000000000"

Magic_Table	db	0x47,0x74,0x68,0x6f,0x72,0x6e,0x65,0x20
		db	0x47,0x69,0x6a,0x20,0x4b,0x65,0x79,0x20
		db	0x31,0x32,0x33,0x34,0x35,0x36,0x37,0x38
		db	0x48,0x61,0x6e,0x73,0x6f,0x6e,0x20,0x21


Error1		db	"Invalid Serial!$"
Key_Msg		db	"Calculated Key Is: $"
CRLF		db 0ah,0dh,"$"

Banner		db	"(***************************)",0ah,0dh
		db	"(      Little KG Demo       )",0ah,0dh
		db	"(***************************)",0ah,0dh,0ah,0dh
		db	"Enter Serial Please: $"


