ver	equ	7

	include	defs.asm

;Ported from Phil Karn's asy.c and slip.c, a C-language driver for the IBM-PC
;8250 by Russell Nelson.  Any bugs are due to Russell Nelson.
;16550 support ruthlessly stolen from Phil Karn's 8250.c. 
;  Bugs by Denis DeLaRoca
;
; Stopped failures from lost transmit interrupts (by eliminating the ints
; altogether). Remove unneeded transmitter buffer.
; Version 6 by Joe Doupnik, jrd@cc.usu.edu, Utah State University, Dec 1991.
; Fix hardware handshaking problems.  Philip R. "Pib" Burns,
;   Northwestern University, September, 1992.

;  Copyright, 1988, 1991, Russell Nelson

;   This program is free software; you can redistribute it and/or modify
;   it under the terms of the GNU General Public License as published by
;   the Free Software Foundation, version 1.
;
;   This program is distributed in the hope that it will be useful,
;   but WITHOUT ANY WARRANTY; without even the implied warranty of
;   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;   GNU General Public License for more details.
;
;   You should have received a copy of the GNU General Public License
;   along with this program; if not, write to the Free Software
;   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

code	segment	word public
	assume	cs:code, ds:code

	include	8250defs.asm

	public	int_no
int_no		db	4,0,0,0		; interrupt number.
io_addr		dw	03f8h,0		; I/O address for COM1
baud_rate	dw	12c0h,0		; support baud higher than 65535
baudclk		label	word
		dd	115200		; 1.8432 Mhz / 16
hardware_switch	db	0		; if zero, don't use hw handshaking
is_16550        db      0               ; 0=no, 1=yes (try using fifo)

	public	driver_class, driver_type, driver_name 
	public	driver_function, parameter_list
driver_class	db	9,0,0,0		;from the packet spec
driver_type	db	0,0,0,0		;from the packet spec
driver_name	db	'YAM',0		;name of the driver.

driver_function	db	2
parameter_list	label	byte
	db	1	;major rev of packet driver
	db	1	;minor rev of packet driver
	db	14	;length of parameter list
	db	EADDR_LEN	;length of MAC-layer address
	dw	GIANT	;MTU, including MAC headers
	dw	MAX_MULTICAST * EADDR_LEN    ;buffer size of multicast addrs
	dw	0	;(# of back-to-back MTU rcvs) - 1
	dw	0	;(# of successive xmits) - 1
int_num	dw	0	;Interrupt # to hook for post-EOI
			;processing, 0 == none,

  ifdef debug
	public recv_buf_size, recv_buf,	recv_buf_end, recv_buf_head
	public recv_buf_tail, recv_pkt_ready
  endif

recv_buf_size	dw	3000,0		;receive buffer size
recv_buf	dw	?		;->receive buffer
recv_buf_end	dw	?		;->after end of buffer
recv_buf_headp	dw	?		;->size of next pkt to get
recv_buf_tailp	dw	?		;->size of next pkt to store
recv_buf_wr	dw	?		;->next character to store
recv_buf_wrcnt	dw	?		; count of chars in pkt to store
recv_buf_rd	dw	?		;->next character to get

IP_TYPE	DW	0800H

  ifdef debug
	public packet_sem, xmit_time
  endif
packet_sem	dw	0		; semaphore for	packets received
asyrxint_cnt	dw	0		; loop counter in asyrxint
xmit_time	dw	0		; loop timer for asyrxint
raw_mode	db	0		;=1 if we send and receive raw chars.

	public	rcv_modes
rcv_modes	dw	8		;number	of receive modes in our table
		dw	0,0,0,rcv_mode_3
		dw	0,0,0,rcv_mode_7

	public bad_command_intercept
bad_command_intercept:
;called with ah=command, unknown to the skeleton.
;exit with nc if okay, cy, dh=error if not.
	mov	dh,BAD_COMMAND
	stc
	ret

	public	as_send_pkt
; The Asynchronous Transmit Packet routine.
; Enter with es:di -> i/o control block, ds:si -> packet, cx = packet length,
;   interrupts possibly enabled.
; Exit with nc if ok, or else cy if error, dh set to error number.
;   es:di and interrupt enable flag preserved on exit.
as_send_pkt:
	ret

	public	drop_pkt
; Drop a packet from the queue.
; Enter with es:di -> iocb.
drop_pkt:
	assume	ds:nothing
	ret

	public	xmit
; Process a transmit interrupt with the least possible latency to achieve
;   back-to-back packet transmissions.
; May only use ax and dx.
xmit:
	assume	ds:nothing
	ret

dumpstat:
	push	es
	push	si

	push	0b800h
	pop	es
	mov	si,798
	mov	[es:si],al
	pop	si
	pop	es
	ret

dumpw:
	push	es
	push	si

	push	0b800h
	pop	es
	mov	si,316
	mov	[es:si],ah
	add	si,2
	mov	[es:si],al
	pop	si
	pop	es
	ret

setvideo	macro
	push es
	push 0b800h
	pop  es
	endm


	public	send_pkt
;
; mod 7/25/89 John Grover
; - operates with interrupts on. Xmits one byte per interrupt
; - only turns transmitter buffer empty interrupt off when
; - all bytes of all packets are transmitted.

send_pkt:
;enter with es:di->upcall routine, (0:0) if no upcall is desired.
;  (only if the high-performance bit is set in driver_function)

;enter with ds:si -> packet, cx = packet length.
;exit with nc if ok, or else cy if error, dh set to error number.
;called from telnet layer via software interrupt
; We just send each byte in turn. No UART interrupts are needed nor wanted.
; In fact the overdone receiver material omits to note that xmtr interrupts
; can be lost while processing rcvr ones. Small benefits are no stalled
; programs, no transmitter buffer, no problems at 19200 b/s. Joe Doupnik
;
; Unfortunately the revised code didn't handle hardware handshaking.
; Added back by Pib, September, 1992.
;
	assume	ds:nothing, es:nothing
	sti				; enable interrupts

	push	cx
	xor	cx,cx
send_delay:
	jmp	$+2			; wait
	jmp	$+2
	jmp	$+2
	jmp	$+2
	loop	send_delay

send_chk_dcd:
	xor	cx,cx
	loadport
	setport MSR
send_dcd_loop:
	in 	al,dx
	test	al,MSR_RLSD		; is DCD active ?
	je	send_go			; No - go to send
	jmp	$+2			; wait
	jmp	$+2
	jmp	$+2
	jmp	$+2
	loop	send_dcd_loop		; If no timeout test DCD again
send_go:
	pop	cx

	call	crc_calc
	push	ax			; save crc

	cli
	loadport
	setport MCR			; enable transmitter
	mov	al,MCR_RTS or MCR_OUT2 or MCR_OUT1
	out	dx,al

	mov	ax,40			; send leading flags
	call	send_flags

send_chars:
	lodsb
	call	send_char
	loop	send_chars

	pop	ax       		; ax = crc
	mov	bl,ah			; bl = crch

	call	send_char		; send crcl
	mov	al,bl
	call	send_char		; send crch

	mov	ax,4    		; send trailing flags
	call	send_flags

	loadport
	setport MCR
	mov	al,MCR_DTR or MCR_OUT2 or MCR_OUT1
	out	dx,al			; disable transmitter

	sti
	clc
	ret

send_flags:
; ax = no. of flag to send

	push	bx
	push	cx
	push	dx

	mov	bx,ax
	inc	bx	 ; bx = no. of dtcs to wait for

	loadport
	setport MSR

sendf_next:
	xor	cx,cx
	in	al,dx
	mov	ah,al
	jmp $+2

sendf_wait_dcts:
	in	al,dx
	xor	al,ah
	test	al,MSR_CTS	; has CTS toggled ?
	jne	sendf_on_dcts	; Yes - output flag
	loop	sendf_wait_dcts	; try another time

	stc			; signal timeout with c=1
sendf_end:
	pop	dx
	pop	cx
	pop	bx
	ret

sendf_on_dcts:
	dec	bx
	cmp	bx,0000h
	jne	sendf_next
	clc
	jmp	short sendf_end

; Send chars on DTCS
send_char:
	push	cx
	push	dx
	push	ax		; save char

	loadport
	setport MSR
	in	al,dx
	jmp $+2
	mov	ah,al
	xor 	cx,cx		; 64K retry counter
sendc_wait_dcts:
	in 	al,dx
	xor	al,ah
	test	al,MSR_CTS	; has CTS toggled ?
	jne	sendc_on_dtcs	; Yes - output char
	loop	sendc_wait_dcts	; try another time

	stc			; signal timeout
	pop	ax
sendc_end:
	pop	dx
	pop	cx
	ret
sendc_on_dtcs:
	pop	ax
	setport THR
	out	dx,al		; and output char
	clc
	jmp	short sendc_end

	public	set_address
set_address:
;set the address of the interface.
;enter with es:di -> place to get the address, cx = size of address buffer.
;exit with nc, cx = actual size of address, or cy if buffer not big enough.
	assume	ds:nothing
	clc
	ret

rcv_mode_3:
;exit raw mode
	mov	raw_mode,0
	ret

rcv_mode_7:
;enter raw mode
	mov	raw_mode,1
	ret


	public	set_multicast_list
set_multicast_list:
;enter with ds:si ->list of multicast addresses, ax = number of addresses,
;  cx = number of bytes.
;return nc if we set all of them, or cy,dh=error if we didn't.
	mov	dh,NO_MULTICAST
	stc
	ret


	public	terminate
terminate:
	ret

	public	reset_interface
reset_interface:
;reset the interface.
	assume	ds:code
	ret


;called	when we	want to determine what to do with a received packet.
;enter with cx = packet length, es:di -> packet type, dl = packet class.
	extrn	recv_find: near

;called after we have copied the packet into the buffer.
;enter with ds:si ->the packet, cx = length of the packet.
	extrn	recv_copy: near

;call this routine to schedule a subroutine that gets run after the
;recv_isr.  This is done by stuffing routine's address in place
;of the recv_isr iret's address.  This routine should push the flags when it
;is entered, and should jump to recv_exiting_exit to leave.
;enter with ax = address of routine to run.
	extrn	schedule_exiting: near

;recv_exiting jumps here to exit, after pushing the flags.
	extrn	recv_exiting_exit: near

;enter with dx = amount of memory desired.
;exit with nc, dx -> that memory, or cy if there isn't enough memory.
	extrn	malloc: near

	extrn	count_in_err: near
	extrn	count_out_err: near

; Receiver Packet Buffer Handling
	public rxpbput
	public rxpbnew

rxpbput:
	mov	di,recv_buf_wr
	cmp	di,recv_buf_headp	; check for buffer collision
	je	pbput_drop

	stosb

	cmp	di,recv_buf_end		; did we hit the end of the buffer?
	jne	pbput_nowrap		; no.
	mov	di,recv_buf		; yes - wrap around.

pbput_nowrap:
	mov	recv_buf_wr,di		; save write pointer
	inc	recv_buf_wrcnt		; and char count in current packet

pbput_end:
	ret

pbput_drop:
	mov	di,recv_buf_tailp	; reset packet
	add	di,2
	cmp	di,recv_buf_end
	jne	pbput_drop_ok
	mov	di,recv_buf
pbput_drop_ok:
	mov	recv_buf_wr,di
	xor	ax,ax
	mov	recv_buf_wrcnt,ax
	ret

rxpbnew:
	mov     di,recv_buf_wr		; get ptr to char  to store

	mov	ax,recv_buf_wrcnt
	test	ax,1                    ; is size of packet odd ?
	je	pbnew_even		; No - Write on word boundaries

	add	di,1			; make sure address is even

	cmp	di,recv_buf_end		; did we reach the end of buffer
	jne     pbnew_even		; No - Continue

	mov	di,recv_buf		; Wrap around

pbnew_even:
	cmp	di,recv_buf_headp	; is buffer full ?
	je	pbnew_drop		; Yes. Nothing to do but to drop

	push	di			; remember new pkt header

	mov	di,recv_buf_headp	; store packet size
	mov	[di],ax			; in the packet header

	pop	di			; get new pkt header

	xor	ax,ax			; mark as empty packet
	mov	[di],ax
	mov	recv_buf_wrcnt,ax	; clr char count

	mov	recv_buf_tailp,di	; store new header location

	add	di,2			; set write ptr to next word
	cmp	di,recv_buf_end
	jne	pbnew_nowrap
	mov	di,recv_buf

pbnew_nowrap:
	mov	recv_buf_wr,di

pbnew_end:
pbnew_drop:
	ret


	public	recv
;
; mod 7/25/89 John Grover
;
; - added code to check modem status change interrupt. If CTS is
; - low  turn off transmitter buffer empty interrupt. If CTS is
; - high turn it on.

recv:

;called from the recv isr.  All registers have been saved, and ds=cs.
;Upon exit, the interrupt will be acknowledged.

	assume	ds:code
	mov	ax,offset recv_exiting	;schedule recv_exiting to be called
	call	schedule_exiting	;  on exit.

recv_intloop:

	loadport
	setport	IIR
	in	al,dx			;any interrupts at all?
	test	al,IIR_IP
	jne	recv_noip		;no.

	and	al,IIR_ID		; mask int bits
	cmp	al,IIR_RDA		;Receiver interrupt ?
	je	asyrxint

	cmp	al,IIR_MSTAT            ;Modem Status interrupt ?
	je	asymstat

	jmp	recv_intloop

recv_noip:
	ret

asymstat:
;process IIR_MSTAT here.
	loadport
	setport MSR
	in 	al,dx
	jmp	recv_intloop

asyrxtst:
	loadport
	setport RBR
	in 	al,dx
	jmp	recv_intloop

;Process 8250 receiver interrupts
; - Upon receiving the FR_END character for the first frame in the
; - buffer a semaphore is set which tells recv_frame to run.

asyrxint:
	movseg	es,ds

asyrxint_in:

	loadport
	setport	RBR
	in	al,dx
	mov	bl,al			; save char in bl

	setport MSR
	in 	al,dx
	test	al,MSR_RLSD		; is DCD active ?
	je	recv_intloop		; No - skip noise

	test	al,MSR_RI		; might this be the end of a frame?
	jne	asyrxint_sync		; yes - it's a sync!

astrxint_data:
	mov	al,bl
	call	rxpbput			; store char in packet buffer
	jmp	recv_intloop

asyrxint_sync:
	mov	ax,recv_buf_wrcnt
	cmp	ax,0			; is the current packet empty ?
	je	recv_intloop		; Yes - nothing to do

	call	rxpbnew

	jmp	recv_intloop

; --------------------------------------------------------------
;
;  recv_exiting
;
recv_exiting:
	assume	ds:nothing
	pushf

	push	ax
	push	ds
	push	di

	movseg	ds,cs
	assume	ds:code

	mov	di,recv_buf_headp
	cmp	word ptr[di], 0000h		; is a packet ready?
	je	recv_isr_exit          	    	; no - skip to end

	push	bx
	push	cx
	push	dx
	push	es
	push	bp
	push	si
	sti				; enable interrupts

	call	recv_frame

	pop	si
	pop	bp
	pop	es
	pop	dx
	pop	cx
	pop	bx

recv_isr_exit:
	pop	di
	pop	ds
	pop	ax
	jmp	recv_exiting_exit

crc_tab dw    	    0,  4489,  8978, 12955, 17956, 22445, 25910, 29887
	dw	35912, 40385, 44890, 48851, 51820, 56293, 59774, 63735
	dw	 4225,   264, 13203,  8730, 22181, 18220, 30135, 25662
	dw	40137, 36160, 49115, 44626, 56045, 52068, 63999, 59510
	dw	 8450, 12427,   528,  5017, 26406, 30383, 17460, 21949
	dw	44362, 48323, 36440, 40913, 60270, 64231, 51324, 55797
	dw	12675,  8202,  4753,   792, 30631, 26158, 21685, 17724
	dw	48587, 44098, 40665, 36688, 64495, 60006, 55549, 51572
	dw	16900, 21389, 24854, 28831,  1056,  5545, 10034, 14011
	dw	52812, 57285, 60766, 64727, 34920, 39393, 43898, 47859
	dw	21125, 17164, 29079, 24606,  5281,  1320, 14259,  9786
	dw	57037, 53060, 64991, 60502, 39145, 35168, 48123, 43634
	dw	25350, 29327, 16404, 20893,  9506, 13483,  1584,  6073
	dw	61262, 65223, 52316, 56789, 43370, 47331, 35448, 39921
	dw	29575, 25102, 20629, 16668, 13731,  9258,  5809,  1848
	dw	65487, 60998, 56541, 52564, 47595, 43106, 39673, 35696
	dw	33800, 38273, 42778, 46739, 49708, 54181, 57662, 61623
	dw	 2112,  6601, 11090, 15067, 20068, 24557, 28022, 31999
	dw	38025, 34048, 47003, 42514, 53933, 49956, 61887, 57398
	dw	 6337,  2376, 15315, 10842, 24293, 20332, 32247, 27774
	dw	42250, 46211, 34328, 38801, 58158, 62119, 49212, 53685
	dw	10562, 14539,  2640,  7129, 28518, 32495, 19572, 24061
	dw	46475, 41986, 38553, 34576, 62383, 57894, 53437, 49460
	dw	14787, 10314,  6865,  2904, 32743, 28270, 23797, 19836
	dw	50700, 55173, 58654, 62615, 32808, 37281, 41786, 45747
	dw	19012, 23501, 26966, 30943,  3168,  7657, 12146, 16123
	dw	54925, 50948, 62879, 58390, 37033, 33056, 46011, 41522
	dw	23237, 19276, 31191, 26718,  7393,  3432, 16371, 11898
	dw	59150, 63111, 50204, 54677, 41258, 45219, 33336, 37809
	dw	27462, 31439, 18516, 23005, 11618, 15595,  3696,  8185
	dw	63375, 58886, 54429, 50452, 45483, 40994, 37561, 33584
	dw	31687, 27214, 22741, 18780, 15843, 11370,  7921,  3960

crc		dw	?
recv_lbuf	db 512 dup(?)

crc_calc:
; cx 	     packet lenght
; [ds:si] -> packet data
; return     ax = crc
;	     z=1 if crc computed == crc in buffer

	push	bx
	push	cx
	push	dx
	push	si
	push	es
	movseg	es,cs
	assume	es:code

	mov	dx,0ffffh	; preset crc

crc_loop:
;	t = *p++ ^ (crc & 0xff);
;	crc >>= 8;
;	crc ^= crc_table[t];

	lodsb			; nxt char in al
	mov	bl,al		; bl = nxt char

	xor	bl,dl		; bx = ch ^ crcl
	mov	bh,0		;

	shl 	bx,1            ; bx = offset in crc_tab

	mov	dl,dh		; crc>>=8
	mov	dh,0

	xor	dx, crc_tab[es:bx] ; crc = (crc>>8) ^ crc_tab[ch^crcl]
	loop	crc_loop

	not	dx		; dx = crc computed
	lodsw			; ax = crc in buffer
	xchg	ax,dx		; ax = crc computed
	cmp	ax,dx		; z=1 if crc computed = crc in buffer

	pop	es
	pop	si
	pop	dx
	pop	cx
	pop	bx

	ret


cpy_packet:
; copy packet from ds:si to recv_lbuf

	push	si
	push	di

	push	cx			; save packet len

	push	es
	movseg	es,ds

	mov	di,word ptr recv_lbuf	; es:di -> recv_lbuf
cpy_loop:
	movsb				; nxt char -> recv_lbuf
	cmp	si,recv_buf_end
	jne	cpy_nwrap
	mov	si,recv_buf
cpy_nwrap:
	loop	cpy_loop		;get another.
	pop	es

	pop	cx			; get byte count
	push	cx			; and save again

	test	cx,1			; is lenght even ?
	je	cpy_even		; Yes - go to update headp

	inc	si
	cmp	si,recv_buf_end
	jne	cpy_even

	mov	si,recv_buf
cpy_even:
	mov	recv_buf_headp,si	; recv_buf_headp = nxt packet
	pop	cx

	pop	di
	pop	si
	ret

; --------------------------------------------------------------
;
;  recv_frame
;
; mod 7/25/89 John Grover
;
; - recv_frame now operates with interrupts on. It is triggered
; - by the recv_pkt_ready flag and continues until all bytes
; - in all packets in the buffer have been transmitted to the upper
; - layer.
;
  ifdef debug
	public recv_frame
  endif
recv_frame:
	mov	si,recv_buf_headp
	mov	cx,[si]          	; cx = packet lenght
	cmp	cx,0			; more packet ready ?
	jnz	recv_1			; yes - execute again
	ret

recv_1:
	add	si,2			; si -> init of packet
	cmp	si,recv_buf_end
	jne	recv_1ok
	mov	si,recv_buf

recv_1ok:
	cmp	cx,14			; lenght > 2  ?
	jb      recv_drop_rej		; no - it hasn't crc
	cmp	cx,512          	; lenght > 512 ?
	ja	recv_drop_rej		; yes - packet too long

recv_2ok:
	call	cpy_packet		; copy packet into linear buffer

	sub	cx,2			; subtract crc lenght
	call	crc_calc
	jne	recv_frame

	push	cx			; save byte count

	MOV	DI,CS
	MOV	ES,DI
	mov	di,0                    ; set pkt type to CS:0000

	mov	dl,cs:driver_class
	call	recv_find		;look up our type.

	pop	cx			; cx -> our count

	mov	ax,es			;is this pointer null?
	or	ax,di
	je	recv_frame		;yes - just free the frame.

; Copia pacchetto nel loro buffer
	push	cx
	push	di

	mov	si,word ptr recv_lbuf
recv_cpy:
	rep	movsb			; recv_lbuf -> [es:di]

	movseg	ds,es
	pop	si			; [ds:si] -> their buffer
	pop	cx			; cx -> packet lenght
	assume	ds:nothing

	call	recv_copy

	movseg	ds,cs
	assume	ds:code

	jmp	recv_frame		; and check next packet

recv_drop_rej:
	test	cx,1
	je	recv_drop_even
	inc	cx

recv_drop_even:

	add	si,cx
	cmp	si,recv_buf_end
	jb	recv_drop_store

	sub	si,recv_buf_size

recv_drop_store:
	mov	recv_buf_headp,si
	jmp	recv_frame

;Set bit(s) in I/O port
setbit:
;enter with dx = port, ah = bit to set.
	in	al,dx
	or	al,ah
	out	dx,al
	ret


;Clear bit(s) in I/O port
clrbit:
;enter with dx = port, ah = bit to set.
	in	al,dx
	not	al			;perform an and-not using DeMorgan's.
	or	al,ah
	not	al
	out	dx,al
	ret


	public	timer_isr
timer_isr:
;if the first instruction is an iret, then the timer is not hooked
	iret

;any code after this will not be kept after initialization. Buffers
;used by the program, if any, are allocated from the memory between
;end_resident and end_free_mem.
	public end_resident,end_free_mem
end_resident	label	byte
	db	3000 dup(?)
end_free_mem	label	byte

	public	usage_msg
usage_msg	db	"usage: YAM [options] <packet_int_no> "
		db	"[-h] [driver_class] [hardware_irq]",CR,LF
		db	"   [io_addr] [baud_rate]",CR,LF
		db	"   [recv_buf_size]",CR,LF
		db	"   -h enables hardware handshaking",CR,LF
		db	"   The driver_class should be SLIP, KISS, AX.25,"
		db	" or a number.",CR,LF,'$'

	public	copyright_msg
copyright_msg	db	"Packet driver for YAM, version "
		db	'0'+(majver / 10),'0'+(majver mod 10),".",'0'+ver,CR,LF
		db	"Portions Copyright 1988 Phil Karn",CR,LF
		db	"Portions Copyright 1991 Joe Doupnik",CR,LF
		db	"Portions Copyright 1992 Crynwr Software",CR,LF
		db	"YAM - Copyright 1997 Nico Palermo - IV3NWV",CR,LF,'$'

approximate_msg	db	"Warning: This baud rate can only be approximated"
		db	"using the 8250",CR,LF
		db	"because it is not an even divisor of 115200"
		db	CR,LF,'$'

is_16550_msg    db      "16550 Uart detected, FIFO will be used",CR,LF,'$'

no_memory_msg	db	"Unable to allocate enough memory, look at end_resident in SLIP8250.ASM",CR,LF,'$'

class_name_ptr	dw	?
class_name	db	"Interface class ",'$'
kiss_name	db	"KISS",CR,LF,'$'
ax25_name	db	"AX.25",CR,LF,'$'
slip_name	db	"SLIP",CR,LF,'$'
int_no_name	db	"Interrupt number ",'$'
io_addr_name	db	"I/O port ",'$'
baud_rate_name	db	"Baud rate ",'$'
recv_buf_name	db	"Receive buffer size ",'$'
unusual_com1	db	"That's unusual!  Com1 (0x3f8) usually uses IRQ 4!"
		db	CR,LF,'$'
unusual_com2	db	"That's unusual!  Com2 (0x2f8) usually uses IRQ 3!"
		db	CR,LF,'$'

	extrn	set_recv_isr: near
	extrn	maskint: near

;enter with si -> argument string, di -> word to store.
;if there is no number, don't change the number.
	extrn	get_number: near

;enter with dx -> name of word, di -> dword to print.
	extrn	print_number: near

;enter with si -> argument string.
;skip spaces and tabs.  Exit with si -> first non-blank char.
	extrn	skip_blanks: near


;-> the assigned Ethernet address of the card.
	extrn	rom_address: byte

	public	parse_args
parse_args:
;exit with nc if all went well, cy otherwise.
	call	skip_blanks
	cmp	al,'-'			;did they specify a switch?
	jne	not_switch
	cmp	byte ptr [si+1],'h'	;did they specify '-h'?
	je	got_hardware_switch
	stc				;no, must be an error.
	ret
got_hardware_switch:
	mov	hardware_switch,1
	add	si,2			;skip past the switch's characters.
	jmp	parse_args		;go parse more arguments.
not_switch:
	or	al,20h			; to lower case (assuming letter)
	cmp	al,'k'
	jne	parse_args_2
	mov	driver_class,10		;KISS, from packet spec
	mov	dx,offset kiss_name
	jmp	short parse_args_1
parse_args_2:
	cmp	al,'s'
	jne	parse_args_3
	mov	driver_class,6		;SLIP, from packet spec
	mov	dx,offset slip_name
	jmp	short parse_args_1
parse_args_3:
	cmp	al,'a'
	jne	parse_args_4
	mov	driver_class,9		;AX.25, from packet spec.
	mov	dx,offset ax25_name
	jmp	short parse_args_1
parse_args_4:
	mov	di,offset driver_class
	mov	bx,offset class_name
	call	get_number
	mov	class_name_ptr,0
	jmp	short parse_args_6
parse_args_1:
	mov	class_name_ptr,dx
parse_args_5:
	mov	al,[si]			;skip to the next blank or CR.
	cmp	al,' '
	je	parse_args_6
	cmp	al,CR
	je	parse_args_6
	inc	si			;skip the character.
	jmp	parse_args_5
parse_args_6:
	mov	di,offset int_no
	call	get_number
	mov	di,offset io_addr
	call	get_number
	mov	di,offset baud_rate
	call	get_number
	mov	di,offset recv_buf_size
	call	get_number
	clc
	ret


; --------------------------------------------------------------
;
;  etopen
;
	public	etopen
etopen:
	mov	al,int_no
	call	maskint			;disable these interrupts.

not_16550:
	loadport			;Purge the receive data buffer
	setport	RBR
	in	al,dx

	;Set line control register: 8 bits, no parity
	mov	al,LCR_8BITS
	setport	LCR
	out	dx,al

	;Turn on receive interrupt enable in 8250, leave transmit
	; and modem status interrupts turned off for now
	mov	al,IER_DAV
	setport	IER
	out	dx,al

	;Set modem control register: assert DTR, turn on 8250
	; master interrupt enable (connected to OUT2)

	mov	al,MCR_DTR or MCR_OUT2
	setport	MCR
	out	dx,al

;compute the divisor given the baud rate.
	mov	dx,baudclk+2
	mov	ax,baudclk
	mov	bx,0
asy_speed_1:
	inc	bx
	sub	ax,baud_rate
	sbb	dx,baud_rate+2
	jnc	asy_speed_1
	dec	bx
	add	ax,baud_rate
	adc	dx,baud_rate+2
	or	ax,dx
	je	asy_speed_2

	mov	dx,offset approximate_msg
	mov	ah,9
	int	21h

asy_speed_2:

	loadport			;Purge the receive data buffer
	setport	RBR
	in	al,dx

	mov	ah,LCR_DLAB		;Turn on divisor latch access bit
	setport	LCR
	call	setbit

	mov	al,bl			;Load the two bytes of the divisor.
	setport	DLL
	out	dx,al
	mov	al,bh
	setport	DLM
	out	dx,al

	mov	ah,LCR_DLAB		;Turn off divisor latch access bit
	setport	LCR
	call	clrbit

;set up the various pointers.

	mov	dx,recv_buf_size
	call	malloc
	jnc	have_memory
	mov	dx,offset no_memory_msg
	stc
	ret
have_memory:

	mov	recv_buf,dx
	mov	recv_buf_headp,dx
	mov	recv_buf_tailp,dx

	mov	si,dx
	xor	ax,ax
	mov	word ptr [si],ax	; clr packet header
	mov	recv_buf_wrcnt,ax	; clr packet size

	add	dx,recv_buf_size
	mov	recv_buf_end,dx

	mov	dx,si
	add	dx,2
	mov	recv_buf_wr,dx		; wr -> next char to write

	call	set_recv_isr		;Set interrupt vector to SIO handler

	mov	al, int_no		; Get board's interrupt vector
	add	al, 8
	cmp	al, 8+8			; Is it a slave 8259 interrupt?
	jb	set_int_num		; No.
	add	al, 70h - 8 - 8		; Map it to the real interrupt.
set_int_num:
	xor	ah, ah			; Clear high byte
	mov	int_num, ax		; Set parameter_list int num.

	clc				;indicate no errors.
	ret

	public	print_parameters
print_parameters:
;echo our command-line parameters
	cmp	class_name_ptr,0
	je	echo_args_1

	mov	dx,offset class_name
	mov	ah,9
	int	21h
	mov	dx,class_name_ptr
	mov	ah,9
	int	21h
	jmp	short echo_args_2
echo_args_1:
	mov	di,offset driver_class
	mov	dx,offset class_name
	call	print_number
echo_args_2:

	mov	di,offset int_no
	mov	dx,offset int_no_name
	call	print_number
	mov	di,offset io_addr
	mov	dx,offset io_addr_name
	call	print_number

	cmp	io_addr,03f8h		;is this com1?
	jne	ia_com2
	mov	dx,offset unusual_com1
	cmp	int_no,4		;com1 usually uses IRQ 4.
	jne	ia_unusual
	jmp	short ia_usual
ia_com2:
	cmp	io_addr,02f8h		;is this com2?
	jne	ia_usual		;no.
	mov	dx,offset unusual_com2
	cmp	int_no,3		;com2 usually uses IRQ 3.
	je	ia_usual
ia_unusual:
	mov	ah,9
	int	21h
ia_usual:
	mov	di,offset baud_rate
	mov	dx,offset baud_rate_name
	call	print_number
	mov	di,offset recv_buf_size
	mov	dx,offset recv_buf_name
	call	print_number
	ret
code	ends
	end

