; AX.25 datagram (address) definitions

MAXDIGIS    EQU     7	    ; Maximum number of digipeaters
ALEN	    EQU     6	    ; Number of chars in callsign field
AXALEN      EQU     7	    ; Total AX.25 address length, including SSID
AXBUF	    EQU     10	    ; Buffer size for maximum-length ascii call

; Bits within SSID field of AX.25 address
SSID        EQU	    1eh	    ; Sub station ID
REPEATED    EQU     80h	    ; Has-been-repeated bit in repeater field
E	    EQU	    01h     ; Address extension bit
C	    EQU     80h	    ; Command/response designation
RSRVD	    EQU     60h	    ; Reserved

; AX.25 Control Field values
UI          EQU     3       ; UI Frame

; AX.25 Level 3 Protocol IDs (PIDs)
PID_X25	    EQU     01h	    ; CCITT X.25 PLP
PID_SEGMENT EQU     08h     ; Segmentation fragment
PID_TEXNET  EQU	    0c3h    ; TEXNET datagram protocol
PID_LQ	    EQU     0c4h    ; Link quality protocol
PID_APPLETALK EQU   0cah    ; Appletalk
PID_APPLEARP EQU    0cbh    ; Appletalk ARP
PID_IP      EQU     0cch    ; ARPA Internet Protocol
PID_ARP	    EQU     0cdh    ; ARPA Address Resolution Protocol
PID_NETROM  EQU     0cfh    ; NET/ROM
PID_NO_L3   EQU     0f0h    ; No level 3 protocol


