/*  AX25UTIL.H - Utility routines for Ether to AX.25 packet driver
**  Copyright (C) 1994  Gary L. Grebus
**
**  This program is free software; you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation; version 2.
**
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program; if not, write to the Free Software
**  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#define AXALEN 7                /* AX.25 address length, including SSID */
#define AXABUF 10               /* Buffer size for longest addr in ASCII*/
#define PSEUDOLEN 6             /* Length of pseudo-Ethernet address */

#ifdef DRIVER
typedef unsigned far char ether_t;
#else
typedef unsigned char ether_t;
#endif

void AX25ToEther(unsigned char far *ax25, ether_t *ether);
void EtherToAX25(ether_t *ether, unsigned char *ax25);

#ifndef DRIVER
void StrToAX25(char *s, unsigned char *ax25);
void AX25ToStr(unsigned char *ax25, char *s);
#endif

