/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import net.sourceforge.jpcap.capture.CaptureDeviceOpenException;
import net.sourceforge.jpcap.capture.CapturePacketException;
import net.sourceforge.jpcap.capture.PacketCapture;
import net.sourceforge.jpcap.capture.RawPacketListener;
import net.sourceforge.jpcap.net.RawPacket;

public class ConsoleCapture
implements RawPacketListener {
    private static File logfile = null;
    private static DataOutputStream dos = null;
    private static int frameCount = 0;
    private static LogWriter lw = null;

    public void rawPacketArrived(RawPacket rawPacket) {
        try {
            byte[] byArray = rawPacket.getData();
            lw.write(byArray);
            System.out.print("\rwrote frame " + ++frameCount);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public ConsoleCapture(String string) {
        try {
            lw = new LogWriter();
            PacketCapture packetCapture = new PacketCapture();
            packetCapture.addRawPacketListener((RawPacketListener)this);
            System.out.println("opening device " + string);
            packetCapture.open(string, true);
            packetCapture.capture(-1);
            System.out.println("capturing, CTRL-C to quit");
        }
        catch (IOException iOException) {
            System.out.println("error saving to file");
            System.exit(1);
        }
        catch (CaptureDeviceOpenException captureDeviceOpenException) {
            System.out.println("Invalid device name passed to Mognet.");
            System.out.println("Check device name and status.");
            System.exit(1);
        }
        catch (CapturePacketException capturePacketException) {
            System.out.println("Device not available.");
            System.out.println("Try 'ifconfig " + string + " up' and re-run Mognet.");
            System.exit(1);
        }
    }

    public static void main(String[] stringArray) {
        String string = stringArray[0];
        if (string == null) {
            System.out.println("Specify a device on the command line, ex: java Mognet eth1");
            System.exit(1);
        }
        new ConsoleCapture(string);
    }
}

