// $Id: IPPorts.java,v 1.3 2001/06/27 02:15:49 pcharles Exp $

/***************************************************************************
 * Copyright (C) 2001, Patrick Charles and Jonas Lehmann                   *
 * Distributed under the Mozilla Public License                            *
 *   http://www.mozilla.org/NPL/MPL-1.1.txt                                *
 ***************************************************************************/
package net.sourceforge.jpcap.net;


/**
 * Code constants for ip ports.
 *
 * @author Patrick Charles and Jonas Lehmann
 * @version $Revision: 1.3 $
 * @lastModifiedBy $Author: pcharles $
 * @lastModifiedAt $Date: 2001/06/27 02:15:49 $
 */
public interface IPPorts
{
  int NONE = -1; // dummy value for protocols that don't use ports
  int RESERVED_0 = 0;
  int TCPMUX =  1;
  int COMPRESSNET2 = 2;
  int COMPRESSNET = 3;
  int RJE = 5;
  int ECHO = 7;
  int DISCARD = 9;
  int SYSTAT = 11;
  int DAYTIME = 13;
  int QOTD = 17;
  int MSP = 18;
  int CHARGEN = 19;
  int FTP_DATA = 20;
  int FTP = 21;
  int SSH = 22;
  int TELNET = 23;
  int PRIV_MAIL =  24;
  int SMTP = 25;
  int NSW_FE = 27;
  int MSG_ICP = 29;
  int MSG_AUTH = 31;
  int DSP = 33;
  int PRIV_PRINT =  35;
  int TIME = 37;
  int RAP = 38;
  int RLP = 39;
  int GRAPHICS = 41;
  int NAME = 42;
  int NAMESERVER = 42;
  int NICNAME = 43;
  int MPM_FLAGS = 44;
  int MPM = 45;
  int MPM_SND = 46;
  int NI_FTP = 47;
  int AUDITD = 48;
  int TACACS = 49;
  int RE_MAIL_CK = 50;
  int LA_MAINT = 51;
  int XNS_TIME = 52;
  int DOMAIN = 53;
  int XNS_CH = 54;
  int ISI_GL = 55;
  int XNS_AUTH = 56;
  int PRIV_TERMINAL =  57;
  int XNS_MAIL = 58;
  int PRIV_FILE =  59;
  int NI_MAIL = 61;
  int ACAS = 62;
  int WHOIS = 63;
  int COVIA = 64;
  int TACACS_DS = 65;
  int SQLSNET = 66;
  int BOOTPS = 67;
  int BOOTPC = 68;
  int TFTP = 69;
  int GOPHER = 70;
  int NETRJS_1 = 71;
  int NETRJS_2 = 72;
  int NETRJS_3 = 73;
  int NETRJS_4 = 74;
  int PRIV_DIALOUT =  75;
  int DEOS = 76;
  int PRIV_RJE =  77;
  int VETTCP = 78;
  int FINGER = 79;
  int HTTP = 80;
  int WWW = 80;
  int HOSTS2_NS = 81;
  int XFER = 82;
  int MIT_ML_DEV = 83;
  int CTF = 84;
  int MIT_ML_DEV2 = 85;
  int MFCOBOL = 86;
  int PRIV_TERMLINK =  87;
  int KERBEROS = 88;
  int SU_MIT_TG = 89;
  int DNSIX = 90;
  int MIT_DOV = 91;
  int NPP = 92;
  int DCP = 93;
  int OBJCALL = 94;
  int SUPDUP = 95;
  int DIXIE = 96;
  int SWIFT_RVF = 97;
  int TACNEWS = 98;
  int METAGRAM = 99;
  int NEWACCT = 100;
  int HOSTNAME = 101;
  int ISO_TSAP = 102;
  int GPPITNP = 103;
  int ACR_NEMA = 104;
  int CSO = 105;
  int CSNET_NS = 105;
  int TSMUX_3COM = 106;
  int RTELNET = 107;
  int SNAGAS = 108;
  int POP2 = 109;
  int POP3 = 110;
  int SUNRPC = 111;
  int MCIDAS = 112;
  int IDENT = 113;
  int AUTH = 113;
  int AUDIONEWS = 114;
  int SFTP = 115;
  int ANSANOTIFY = 116;
  int UUCP_PATH = 117;
  int SQLSERV = 118;
  int NNTP = 119;
  int CFDPTKT = 120;
  int ERPC = 121;
  int SMAKYNET = 122;
  int NTP = 123;
  int ANSATRADER = 124;
  int LOCUS_MAP = 125;
  int NXEDIT = 126;
  int LOCUS_CON = 127;
  int GSS_XLICEN = 128;
  int PWDGEN = 129;
  int CISCO_FNA = 130;
  int CISCO_TNA = 131;
  int CISCO_SYS = 132;
  int STATSRV = 133;
  int INGRES_NET = 134;
  int EPMAP = 135;
  int PROFILE = 136;
  int NETBIOS_NS = 137;
  int NETBIOS_DGM = 138;
  int NETBIOS_SSN = 139;
  int EMFIS_DATA = 140;
  int EMFIS_CNTL = 141;
  int BL_IDM = 142;
  int IMAP = 143;
  int UMA = 144;
  int UAAC = 145;
  int ISO_TP0 = 146;
  int ISO_IP = 147;
  int JARGON = 148;
  int AED_512 = 149;
  int SQL_NET = 150;
  int HEMS = 151;
  int BFTP = 152;
  int SGMP = 153;
  int NETSC_PROD = 154;
  int NETSC_DEV = 155;
  int SQLSRV = 156;
  int KNET_CMP = 157;
  int PCMAIL_SRV = 158;
  int NSS_ROUTING = 159;
  int SGMP_TRAPS = 160;
  int SNMP = 161;
  int SNMPTRAP = 162;
  int CMIP_MAN = 163;
  int CMIP_AGENT = 164;
  int XNS_COURIER = 165;
  int S_NET = 166;
  int NAMP = 167;
  int RSVD = 168;
  int SEND = 169;
  int PRINT_SRV = 170;
  int MULTIPLEX = 171;
  int CL1 = 172;
  int XYPLEX_MUX = 173;
  int MAILQ = 174;
  int VMNET = 175;
  int GENRAD_MUX = 176;
  int XDMCP = 177;
  int NEXTSTEP = 178;
  int BGP = 179;
  int RIS = 180;
  int UNIFY = 181;
  int AUDIT = 182;
  int OCBINDER = 183;
  int OCSERVER = 184;
  int REMOTE_KIS = 185;
  int KIS = 186;
  int ACI = 187;
  int MUMPS = 188;
  int QFT = 189;
  int GACP = 190;
  int PROSPERO = 191;
  int OSU_NMS = 192;
  int SRMP = 193;
  int IRC = 194;
  int DN6_NLM_AUD = 195;
  int DN6_SMM_RED = 196;
  int DLS = 197;
  int DLS_MON = 198;
  int SMUX = 199;
  int SRC = 200;
  int AT_RTMP = 201;
  int AT_NBP = 202;
  int AT_3 = 203;
  int AT_ECHO = 204;
  int AT_5 = 205;
  int AT_ZIS = 206;
  int AT_7 = 207;
  int AT_8 = 208;
  int QMTP = 209;
  int Z39_50 = 210;
  int N914C = 211;
  int ANET = 212;
  int IPX = 213;
  int VMPWSCS = 214;
  int SOFTPC = 215;
  int CAILIC = 216;
  int DBASE = 217;
  int MPP = 218;
  int UARPS = 219;
  int IMAP3 = 220;
  int FLN_SPX = 221;
  int RSH_SPX = 222;
  int CDC = 223;
  int MASQDIALER = 224;
  int DIRECT = 242;
  int SUR_MEAS = 243;
  int INBUSINESS = 244;
  int LINK = 245;
  int DSP3270 = 246;
  int SUBNTBCST_TFTP = 247;
  int BHFHS = 248;
  int RAP2 = 256;
  int SET = 257;
  int YAK_CHAT = 258;
  int ESRO_GEN = 259;
  int OPENPORT = 260;
  int NSIIOPS = 261;
  int ARCISDMS = 262;
  int HDAP = 263;
  int BGMP = 264;
  int X_BONE_CTL = 265;
  int SST = 266;
  int TD_SERVICE = 267;
  int TD_REPLICA = 268;
  int HTTP_MGMT = 280;
  int PERSONAL_LINK = 281;
  int CABLEPORT_AX = 282;
  int RESCAP = 283;
  int CORERJD = 284;
  int FXP_1 = 286;
  int K_BLOCK = 287;
  int NOVASTORBAKCUP = 308;
  int ENTRUSTTIME = 309;
  int BHMDS = 310;
  int ASIP_WEBADMIN = 311;
  int VSLMP = 312;
  int MAGENTA_LOGIC = 313;
  int OPALIS_ROBOT = 314;
  int DPSI = 315;
  int DECAUTH = 316;
  int ZANNET = 317;
  int PKIX_TIMESTAMP = 318;
  int PTP_EVENT = 319;
  int PTP_GENERAL = 320;
  int PIP = 321;
  int RTSPS = 322;
  int TEXAR = 333;
  int PDAP = 344;
  int PAWSERV = 345;
  int ZSERV = 346;
  int FATSERV = 347;
  int CSI_SGWP = 348;
  int MFTP = 349;
  int MATIP_TYPE_A = 350;
  int MATIP_TYPE_B = 351;
  int BHOETTY = 351;
  int DTAG_STE_SB = 352;
  int BHOEDAP4 = 352;
  int NDSAUTH = 353;
  int BH611 = 354;
  int DATEX_ASN = 355;
  int CLOANTO_NET = 356;
  int BHEVENT = 357;
  int SHRINKWRAP = 358;
  int NSRMP = 359;
  int SCOI2ODIALOG = 360;
  int SEMANTIX = 361;
  int SRSSEND = 362;
  int RSVP_TUNNEL = 363;
  int AURORA_CMGR = 364;
  int DTK = 365;
  int ODMR = 366;
  int MORTGAGEWARE = 367;
  int QBIKGDP = 368;
  int RPC2PORTMAP = 369;
  int CODAAUTH = 370;
  int CLEARCASE = 371;
  int ULISTPROC = 372;
  int LEGENT_1 = 373;
  int LEGENT_2 = 374;
  int HASSLE = 375;
  int NIP = 376;
  int TNETOS = 377;
  int DSETOS = 378;
  int IS99C = 379;
  int IS99S = 380;
  int HP_COLLECTOR = 381;
  int HP_MANAGED_NODE = 382;
  int HP_ALARM_MGR = 383;
  int ARNS = 384;
  int IBM_APP = 385;
  int ASA = 386;
  int AURP = 387;
  int UNIDATA_LDM = 388;
  int UIS = 390;
  int SYNOTICS_RELAY = 391;
  int SYNOTICS_BROKER = 392;
  int META5 = 393;
  int EMBL_NDT = 394;
  int NETCP = 395;
  int NETWARE_IP = 396;
  int MPTN = 397;
  int KRYPTOLAN = 398;
  int ISO_TSAP_C2 = 399;
  int WORK_SOL = 400;
  int UPS = 401;
  int GENIE = 402;
  int DECAP = 403;
  int NCED = 404;
  int NCLD = 405;
  int IMSP = 406;
  int TIMBUKTU = 407;
  int PRM_SM = 408;
  int PRM_NM = 409;
  int DECLADEBUG = 410;
  int RMT = 411;
  int SYNOPTICS_TRAP = 412;
  int SMSP = 413;
  int INFOSEEK = 414;
  int BNET = 415;
  int SILVERPLATTER = 416;
  int ONMUX = 417;
  int HYPER_G = 418;
  int ARIEL1 = 419;
  int SMPTE = 420;
  int ARIEL2 = 421;
  int ARIEL3 = 422;
  int OPC_JOB_START = 423;
  int OPC_JOB_TRACK = 424;
  int ICAD_EL = 425;
  int SMARTSDP = 426;
  int SVRLOC = 427;
  int OCS_CMU = 428;
  int OCS_AMU = 429;
  int UTMPSD = 430;
  int UTMPCD = 431;
  int IASD = 432;
  int NNSP = 433;
  int MOBILEIP_AGENT = 434;
  int MOBILIP_MN = 435;
  int DNA_CML = 436;
  int COMSCM = 437;
  int DSFGW = 438;
  int DASP = 439;
  int SGCP = 440;
  int DECVMS_SYSMGT = 441;
  int CVC_HOSTD = 442;
  int HTTPS = 443;
  int SNPP = 444;
  int MICROSOFT_DS = 445;
  int DDM_RDB = 446;
  int DDM_DFM = 447;
  int DDM_SSL = 448;
  int AS_SERVERMAP = 449;
  int TSERVER = 450;
  int SFS_SMP_NET = 451;
  int SFS_CONFIG = 452;
  int CREATIVESERVER = 453;
  int CONTENTSERVER = 454;
  int CREATIVEPARTNR = 455;
  int MACON_TCP = 456;
  int SCOHELP = 457;
  int APPLEQTC = 458;
  int AMPR_RCMD = 459;
  int SKRONK = 460;
  int DATASURFSRV = 461;
  int DATASURFSRVSEC = 462;
  int ALPES = 463;
  int KPASSWD = 464;
  int DIGITAL_VRC = 466;
  int MYLEX_MAPD = 467;
  int PHOTURIS = 468;
  int RCP = 469;
  int SCX_PROXY = 470;
  int MONDEX = 471;
  int LJK_LOGIN = 472;
  int HYBRID_POP = 473;
  int TN_TL_W1 = 474;
  int TCPNETHASPSRV = 475;
  int TN_TL_FD1 = 476;
  int SS7NS = 477;
  int SPSC = 478;
  int IAFSERVER = 479;
  int IAFDBASE = 480;
  int PH = 481;
  int BGS_NSI = 482;
  int ULPNET = 483;
  int INTEGRA_SME = 484;
  int POWERBURST = 485;
  int AVIAN = 486;
  int SAFT = 487;
  int GSS_HTTP = 488;
  int NEST_PROTOCOL = 489;
  int MICOM_PFS = 490;
  int GO_LOGIN = 491;
  int TICF_1 = 492;
  int TICF_2 = 493;
  int POV_RAY = 494;
  int INTECOURIER = 495;
  int PIM_RP_DISC = 496;
  int DANTZ = 497;
  int SIAM = 498;
  int ISO_ILL = 499;
  int ISAKMP = 500;
  int STMF = 501;
  int ASA_APPL_PROTO = 502;
  int INTRINSA = 503;
  int CITADEL = 504;
  int MAILBOX_LM = 505;
  int OHIMSRV = 506;
  int CRS = 507;
  int XVTTP = 508;
  int SNARE = 509;
  int FCP = 510;
  int PASSGO = 511;
  int EXEC = 512;
  int LOGIN = 513;
  int SHELL = 514;
  int PRINTER = 515;
  int VIDEOTEX = 516;
  int TALK = 517;
  int NTALK = 518;
  int UTIME = 519;
  int EFS = 520;
  int RIPNG = 521;
  int ULP = 522;
  int IBM_DB2 = 523;
  int NCP = 524;
  int TIMED = 525;
  int TEMPO = 526;
  int STX = 527;
  int CUSTIX = 528;
  int IRC_SERV = 529;
  int COURIER = 530;
  int CONFERENCE = 531;
  int NETNEWS = 532;
  int NETWALL = 533;
  int MM_ADMIN = 534;
  int IIOP = 535;
  int OPALIS_RDV = 536;
  int NMSP = 537;
  int GDOMAP = 538;
  int APERTUS_LDP = 539;
  int UUCP = 540;
  int UUCP_RLOGIN = 541;
  int COMMERCE = 542;
  int KLOGIN = 543;
  int KSHELL = 544;
  int APPLEQTCSRVR = 545;
  int DHCPV6_CLIENT = 546;
  int DHCPV6_SERVER = 547;
  int AFPOVERTCP = 548;
  int IDFP = 549;
  int NEW_RWHO = 550;
  int CYBERCASH = 551;
  int DEVICESHARE = 552;
  int PIRP = 553;
  int RTSP = 554;
  int DSF = 555;
  int REMOTEFS = 556;
  int OPENVMS_SYSIPC = 557;
  int SDNSKMP = 558;
  int TEEDTAP = 559;
  int RMONITOR = 560;
  int MONITOR = 561;
  int CHSHELL = 562;
  int NNTPS = 563;
  int N9PFS = 564;
  int WHOAMI = 565;
  int STREETTALK = 566;
  int BANYAN_RPC = 567;
  int MS_SHUTTLE = 568;
  int MS_ROME = 569;
  int METER = 570;
  int METER2 = 571;
  int SONAR = 572;
  int BANYAN_VIP = 573;
  int FTP_AGENT = 574;
  int VEMMI = 575;
  int IPCD = 576;
  int VNAS = 577;
  int IPDD = 578;
  int DECBSRV = 579;
  int SNTP_HEARTBEAT = 580;
  int BDP = 581;
  int SCC_SECURITY = 582;
  int PHILIPS_VC = 583;
  int KEYSERVER = 584;
  int IMAP4_SSL = 585;
  int PASSWORD_CHG = 586;
  int SUBMISSION = 587;
  int CAL = 588;
  int EYELINK = 589;
  int TNS_CML = 590;
  int HTTP_ALT = 591;
  int EUDORA_SET = 592;
  int HTTP_RPC_EPMAP = 593;
  int TPIP = 594;
  int CAB_PROTOCOL = 595;
  int SMSD = 596;
  int PTCNAMESERVICE = 597;
  int SCO_WEBSRVRMG3 = 598;
  int ACP = 599;
  int IPCSERVER = 600;
  int URM = 606;
  int NQS = 607;
  int SIFT_UFT = 608;
  int NPMP_TRAP = 609;
  int NPMP_LOCAL = 610;
  int NPMP_GUI = 611;
  int HMMP_IND = 612;
  int HMMP_OP = 613;
  int SSHELL = 614;
  int SCO_INETMGR = 615;
  int SCO_SYSMGR = 616;
  int SCO_DTMGR = 617;
  int DEI_ICDA = 618;
  int DIGITAL_EVM = 619;
  int SCO_WEBSRVRMGR = 620;
  int ESCP_IP = 621;
  int COLLABORATOR = 622;
  int AUX_BUS_SHUNT = 623;
  int CRYPTOADMIN = 624;
  int DEC_DLM = 625;
  int ASIA = 626;
  int PASSGO_TIVOLI = 627;
  int QMQP = 628;
  int AMP3_3COM = 629;
  int RDA = 630;
  int IPP = 631;
  int BMPP = 632;
  int SERVSTAT = 633;
  int GINAD = 634;
  int RLZDBASE = 635;
  int LDAPS = 636;
  int LANSERVER = 637;
  int MCNS_SEC = 638;
  int MSDP = 639;
  int ENTRUST_SPS = 640;
  int REPCMD = 641;
  int ESRO_EMSDP = 642;
  int SANITY = 643;
  int DWR = 644;
  int PSSC = 645;
  int LDP = 646;
  int DHCP_FAILOVER = 647;
  int RRP = 648;
  int AMINET = 649;
  int OBEX = 650;
  int IEEE_MMS = 651;
  int HELLO_PORT = 652;
  int REPSCMD = 653;
  int AODV = 654;
  int TINC = 655;
  int SPMP = 656;
  int RMC = 657;
  int TENFOLD = 658;
  int URL_RENDEZVOUS = 659;
  int MAC_SRVR_ADMIN = 660;
  int HAP = 661;
  int PFTP = 662;
  int PURENOISE = 663;
  int SECURE_AUX_BUS = 664;
  int SUN_DR = 665;
  int MDQS = 666;
  int DOOM = 666;
  int DISCLOSE = 667;
  int MECOMM = 668;
  int MEREGISTER = 669;
  int VACDSM_SWS = 670;
  int VACDSM_APP = 671;
  int VPPS_QUA = 672;
  int CIMPLEX = 673;
  int ACAP = 674;
  int DCTP = 675;
  int VPPS_VIA = 676;
  int VPP = 677;
  int GGF_NCP = 678;
  int MRM = 679;
  int ENTRUST_AAAS = 680;
  int ENTRUST_AAMS = 681;
  int XFR = 682;
  int CORBA_IIOP = 683;
  int CORBA_IIOP_SSL = 684;
  int MDC_PORTMAPPER = 685;
  int HCP_WISMAR = 686;
  int ASIPREGISTRY = 687;
  int REALM_RUSD = 688;
  int NMAP = 689;
  int VATP = 690;
  int MSEXCH_ROUTING = 691;
  int HYPERWAVE_ISP = 692;
  int CONNENDP = 693;
  int HA_CLUSTER = 694;
  int IEEE_MMS_SSL = 695;
  int RUSHD = 696;
  int UUIDGEN = 697;
  int OLSR = 698;
  int ACCESSNETWORK = 699;
  int ELCSD = 704;
  int AGENTX = 705;
  int SILC = 706;
  int BORLAND_DSJ = 707;
  int ENTRUST_KMSH = 709;
  int ENTRUST_ASH = 710;
  int CISCO_TDP = 711;
  int NETVIEWDM1 = 729;
  int NETVIEWDM2 = 730;
  int NETVIEWDM3 = 731;
  int NETGW = 741;
  int NETRCS = 742;
  int FLEXLM = 744;
  int FUJITSU_DEV = 747;
  int RIS_CM = 748;
  int KERBEROS_ADM = 749;
  int RFILE = 750;
  int PUMP = 751;
  int QRH = 752;
  int RRH = 753;
  int TELL = 754;
  int NLOGIN = 758;
  int CON = 759;
  int NS = 760;
  int RXE = 761;
  int QUOTAD = 762;
  int CYCLESERV = 763;
  int OMSERV = 764;
  int WEBSTER = 765;
  int PHONEBOOK = 767;
  int VID = 769;
  int CADLOCK = 770;
  int RTIP =  771;
  int CYCLESERV2 = 772;
  int SUBMIT = 773;
  int RPASSWD = 774;
  int ENTOMB = 775;
  int WPAGES = 776;
  int MULTILING_HTTP = 777;
  int WPGS = 780;
  int CONCERT = 786;
  int QSC = 787;
  int MDBS_DAEMON = 800;
  int DEVICE = 801;
  int FCP_UDP = 810;
  int ITM_MCELL_S = 828;
  int PKIX_3_CA_RA = 829;
  int DHCP_FAILOVER2 = 847;
  int RSYNC = 873;
  int ICLCNET_LOCATE = 886;
  int ICLCNET_SVINFO = 887;
  int ACCESSBUILDER = 888;
  int CDDBP = 888;
  int OMGINITIALREFS = 900;
  int SMPNAMERES = 901;
  int IDEAFARM_CHAT = 902;
  int IDEAFARM_CATCH = 903;
  int XACT_BACKUP = 911;
  int FTPS_DATA = 989;
  int FTPS = 990;
  int NAS = 991;
  int TELNETS = 992;
  int IMAPS = 993;
  int IRCS = 994;
  int POP3S = 995;
  int VSINET = 996;
  int MAITRD = 997;
  int BUSBOY = 998;
  int GARCON = 999;
  int PUPROUTER = 999;
  int CADLOCK2 = 1000;
  int SURF = 1010;
  int RESERVED_1023 = 1023;
  int RESERVED_1024 = 1024;
  int SOCKS = 1080;
  int HSRP = 1985;
  int CVS = 2401;
  int AISES = 2783;
  int X11 = 6000; int X11_BEGIN = 6000;
  int X11_END = 6063;


  /**
   * Number of well-known (aka. privileged) ports.
   */
  int LIMIT_PRIVILEGED = 1024;

  /**
   * IP port mask.
   */
  int MASK = 0xffff;
}
