// $Id: PacketEncoding.java,v 1.2 2001/06/27 01:50:01 pcharles Exp $

/***************************************************************************
 * Copyright (C) 2001, Patrick Charles and Jonas Lehmann                   *
 * Distributed under the Mozilla Public License                            *
 *   http://www.mozilla.org/NPL/MPL-1.1.txt                                *
 ***************************************************************************/
package net.sourceforge.jpcap.net;


/**
 * Packet encoding.
 * <p>
 * Contains utility methods for decoding generic packets.
 *
 * @author Patrick Charles and Jonas Lehmann
 * @version $Revision: 1.2 $
 * @lastModifiedBy $Author: pcharles $
 * @lastModifiedAt $Date: 2001/06/27 01:50:01 $
 */
public class PacketEncoding
{
  /**
   * Extract a header from a packet.
   *
   * @param offset the offset in bytes to the start of the embedded header.
   * @param headerLen the length of the header embedded in the packet.
   * @param bytes the packet data, including the embedded header and data.
   * @return the extracted header data.
   */
  public static byte [] extractHeader(int offset, int headerLen, 
                                      byte [] bytes) {
    byte [] header = new byte[headerLen];
    
    System.arraycopy(bytes, offset, header, 0, headerLen);
    return header;
  }

  /**
   * Extract data from a packet.
   *
   * @param offset the offset in bytes to the start of the embedded header.
   * @param headerLen the length of the header embedded in the packet.
   * @param bytes the packet data, including the embedded header and data.
   * @return the extracted packet data.
   */
  public static byte [] extractData(int offset, int headerLen, 
                                    byte [] bytes) {
    int dataLength = bytes.length - headerLen - offset;
    byte [] data = new byte[dataLength];

    System.arraycopy(bytes, offset + headerLen, data, 0, dataLength);
    return data;
  }


  private static void dump(byte [] bytes) {
    for(int i=0; i<bytes.length; i++)
      System.err.print(bytes[i] + " ");
    System.err.println();
  }
  
  /**
   * Unit test.
   */
  public static void main(String [] args) {
    byte [] bytes = new byte [] {1, 2, 3, 4, 5, 6, 7, 8, 9, 10};

    byte [] header = extractHeader(8, 1, bytes);
    dump(header);
    byte [] data = extractData(8, 1, bytes);
    dump(data);
  }

  private String _rcsid = 
    "$Id: PacketEncoding.java,v 1.2 2001/06/27 01:50:01 pcharles Exp $";
}
