// $Id: Example4.java,v 1.2 2001/07/02 16:44:21 pcharles Exp $

/***************************************************************************
 * Copyright (C) 2001, Patrick Charles and Jonas Lehmann                   *
 * Distributed under the Mozilla Public License                            *
 *   http://www.mozilla.org/NPL/MPL-1.1.txt                                *
 ***************************************************************************/

package net.sourceforge.jpcap.tutorial.example4;

import net.sourceforge.jpcap.capture.*;
import net.sourceforge.jpcap.net.*;


/**
 * jpcap Tutorial - Example 4
 *
 * @author Jonas Lehmann and Patrick Charles
 * @version $Revision: 1.2 $
 * @lastModifiedBy $Author: pcharles $
 * @lastModifiedAt $Date: 2001/07/02 16:44:21 $
 *
 * Run example and then initiate a ping on the network.
 * The example will produce output only if ICMP (ping)
 * packets are captured.
 *
 */
public class Example4 
{
  private static final int INFINITE = -1;
  private static final int PACKET_COUNT = INFINITE; 

  private PacketCapture m_pcap;
  private String m_device;

  public Example4() throws Exception {
    // Step 1:  Instantiate Capturing Engine
    m_pcap = new PacketCapture();

    // Step 2:  Check for devices 
    m_device = m_pcap.findDevice();

    // Step 3:  Open Device for Capturing (requires root)
    m_pcap.open(m_device, true);

    // Step 4:  Register a Listener for jpcap Packets
    m_pcap.addPacketListener(new PacketHandler());

    // Step 5:  Capture Data (max. PACKET_COUNT packets)
    m_pcap.capture(PACKET_COUNT);
  }

  public static void main(String[] args) {
    try {
      Example4 example = new Example4();
    } catch(Exception e) {
      e.printStackTrace();
      System.exit(1);
    }
  }
}


class PacketHandler implements PacketListener 
{
  private static int m_counter = 0;
  private static int m_icmpCounter = 0;

  public void packetArrived(Packet packet) {
    m_counter++;

    // Only handle ICMP packets.  Ignore all others.
    if(!(packet instanceof ICMPPacket))
      return;

    m_icmpCounter++;
    System.out.println("Total Packets: " + m_counter + 
                       "   ICMP Packets: " + m_icmpCounter);
  }
}
