/*
Mognet, 802.11b Frame Analyzer
Copyright (C) 2001 Sean Whalen <lucidity@gmx.net>
http://chocobospore.org/mognet/

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

import java.io.*;
import java.util.*;
import net.sourceforge.jpcap.net.*;
import net.sourceforge.jpcap.capture.*;

public class ConsoleCapture implements RawPacketListener
{
	public void rawPacketArrived(RawPacket packet)
	{
		try
		{
			byte[] data=packet.getData();
			lw.write(data);
			frameCount++;
			System.out.print("\rwrote frame "+frameCount);
		}
		catch(Exception ex)
		{
			ex.printStackTrace();
		}
	}

	public ConsoleCapture(String device)
	{
		try
		{
			lw=new LogWriter();

			PacketCapture pc=new PacketCapture();
			pc.addRawPacketListener(this);

			System.out.println("opening device "+device);
			pc.open(device, true);
			
			pc.capture(-1);
			System.out.println("capturing, CTRL-C to quit");
		}
		catch(IOException ioex)
		{
			System.out.println("error saving to file");
			System.exit(1);
		}
		catch(CaptureDeviceOpenException cdoEx)
		{
			System.out.println("Invalid device name passed to Mognet.");
			System.out.println("Check device name and status.");
			System.exit(1);
		}
		catch(CapturePacketException cpEx)
		{
			System.out.println("Device not available.");
			System.out.println("Try 'ifconfig "+device+" up' and re-run Mognet.");
			System.exit(1);
		}
	}

	public static void main(String[] args)
	{
		String 	device=args[0];

		if(device==null)
		{
			System.out.println("Specify a device on the command line, ex: java Mognet eth1");
			System.exit(1);
		}

		new ConsoleCapture(device);
	}

	private static File logfile		=null;
	private static DataOutputStream dos	=null;
	private static int frameCount		=0;
	private static LogWriter lw		=null;
}
