#!/usr/bin/perl
#
# Small Makefile to cat the needed sub_routines from ./src/
#
# Tue Jan 15 20:13:39 CET 2002 Martin J. Muench (mjm@remote-exploit.org)

# Oh yeah, be hard, be tough, just be #
use strict;

# Define needed variables #
my $source;
my @make;
my $i=0;

# OS Detection #

if ($^O =~ m/bsd/) { 

  # open(BSD), sometimes called OpenBSD by some kiddies ;-P
  open(BSD, '<src/bsd.h') || die "Cannot open bsd.h: $!\n";

  while(<BSD>) {
	chomp($_);
	$make[$i++]=$_;
  }
  close(BSD);
}

elsif ($^O =~ m/linux/) { 

  # open(Linux)
  open(LINUX, '<src/linux.h') || die "Cannot open linux.h: $!\n";

  while(<LINUX>) {
        chomp($_);
        $make[$i++]=$_;
  }
  close(LINUX);
}

else { print "OS unknown, mail author\n\n"; exit; }

# Open Outputfile and say hello #
open(WELLENREITER, '>Wellenreiter.pl') || die "Cannot open Outputfile: $!\n";
print "\nBuilding Wellenreiter for $^O\n\n";

# Cat content of every needed file into Outputfile #
foreach $source (@make) {

	print "Including file: $source\n";

	open(TEMP, "src/$source") || die "Cannot open Tempfile: $!\n";
	while(<TEMP>) { print WELLENREITER $_; } 
	close(TEMP);

}

# Say Good-bye #
print "\nSuccessfully build 'Wellenreiter.pl'\n\n";
close(WELLENREITER);


# Build the config-file '~/.wellenreiter.rc'


## Location of the configfile

my $conffile=%ENV->{HOME}."/.wellenreiter.rc";

## Function prototyping

sub bsd_conf;
sub linux_conf;
sub common;

##-- Begin of Main --##

## Welcome screen

print "\nWellenreiter config generator by Martin J. Muench (mjm\@remote-exploit.org)\n\n";
print "Press the any-key to continue\n"; sleep until <STDIN>;

## Create configfile

open(CONF, ">$conffile") || die "Error while opening config-file: $!";
print CONF "# Wellenreiter config-file, created by make-config\n\n";

if ($^O =~ m/bsd/) { 
	print "You are using BSD, if not please abort and drop me a mail\n\n";
	bsd_conf;
}

elsif ($^O =~ m/linux/) {
	print "You are using Linux, if not please abort and drop me a mail\n\n";
	linux_conf;
}

else { print "Unknown OS, try to build your config-file manually\n"; }

## Add the common stuff to configfile

common;

## Everythings done

close(CONF); exit(1);

##-- End of Main --##

## BSD_Conf

sub bsd_conf {

## We use BSD, yeah

# Get the interface
  print "Set your wireless interface [default: wi0] : ";
  chomp(my $device=<STDIN>);
  if(!$device) { print CONF "interface=wi0\n"; }
  else { print CONF "interface=$device\n"; }

# Get the path to wicontrol
  print "Set path to wicontrol [default: /usr/sbin/wicontrol] : ";
  chomp(my $path=<STDIN>);
  if(!$path) { print CONF "wicontrol=/usr/sbin/wicontrol\n"; }
  else { print CONF "wicontrol=$path\n"; }

# Fix the buttons
  print CONF "mwbuttons=Linkquality,Signallevel,Noiselevel,MISC-Stats,Card-Config,About\n";

# Enough for now, the rest is done by hand
  print "For more options, look at ~/.wellenreiter.rc\n\n";
  print "All necessary things are now configured\n\n";

}

## Linux_Conf

sub linux_conf {

## Well, lets use linux

# Get the interface
  print "Set your wireless interface [default: eth1] : ";
  chomp(my $device=<STDIN>);
  if(!$device) { print CONF "interface=eth1\n"; }
  else { print CONF "interface=$device\n"; }

# Get the path to wicontrol
  print "Set path to iwconfig [default: /sbin/iwconfig]: ";
  chomp(my $path=<STDIN>);
  if(!$path) { print CONF "iwpath=/sbin/iwconfig\n"; }
  else { print CONF "iwpath=$path\n"; }

# Ipaq, are u there?
  print "Activate low-resolution? (only useful with Ipaq) [y/n]: ";
  print CONF "lowres=".<STDIN>;

# Resolution
  print CONF "screenwidth=320\n";
  print CONF "screenheight=240\n";

# Fix the buttons
  print CONF "mwbuttons=Linkquality,Signallevel,Noiselevel,RX-Stats,TX-Stats,MISC-Stats,Card-Config,About\n";
  print CONF "mwbuttons_cisco=Linkquality,Signallevel,RX-Stats,TX-Stats,MISC-Stats,Card-Config,About\n";

# Add path and dev
  print CONF "wirelessfile=/proc/net/wireless\n";
  print CONF "netstatsfile=/proc/net/dev\n";

# Enough for now, the rest is done by hand
  print "For more options, look at ~/.wellenreiter.rc\n\n";
  print "All necessary things are now configured\n\n";

}

## Add the common stuff to configfile

sub common {

print CONF qq~
#############################################################
### Here you can define what action has to be taken     ####
### when wellenreiter finds a new network               ###
### Default: c_newnetfound='printf "\a"'  this beeps    ##
### change it to what you like to                       #
########################################################
c_newnetfound= printf '\\a'
c_netlost= printf '\\a'

#############################################################
### You can change the following parameters if you want ####
### to change the default layout of the windows, but    ###
### it should match for anyone. If you want to be safe  ##
### leave it as it is.                                  #
########################################################

#-- Mainwindow layout --#
#How many buttons to display in a single row on the mainwindow?
columncount=1

#-- Reiceive-Statistics-Window layout --#
rxcolumn=4
rxtitle=Receive-Statistics

#-- Send-Statistics-Window layout --#
txcolumn=4
txtitle=Send-Statistics

#-- MISC-Statistics-Window layout --#
misccolumn=4
misctitle=Misc-Statistics

#-- About-Window layout --#
abouttitle=About

#-- Config-Window layout --#
configtitle=Configuration
configcolumn=4

#-- Signallevel-Window layout --#
signaltitle=Signallevel

#-- Linkquality-Window layout --#
linktitle=Linkquality

#-- Noiselevel-Window layout --#
noisetitle=Noiselevel

##########################################################
###       Don't change anything below this line       ###
########################################################

#-- General definitions --#
progname=Wellenreiter
version=v0.6

#-- Linux-wireless-extension-path  -  This should be right for all--#
wirelessfile=/proc/net/wireless

#-- Netpackets statistics file  -  This should be right for all --#
netstatsfile=/proc/net/dev

##########################################################
###             End of the config file                ###
########################################################
~;

}




# EOF #
