#ifndef __PCAPSOURCE_H__
#define __PCAPSOURCE_H__

#include "config.h"

#ifdef HAVE_LIBPCAP

#include "packet.h"
#include "packetsource.h"

extern "C" {
#ifndef HAVE_PCAPPCAP_H
#include <pcap.h>
#else
#include <pcap/pcap.h>
#endif
}

class PcapSource : public PacketSource {
public:
    int OpenSource(const char *dev);
    int CloseSource();

    int FetchPacket(pkthdr *in_header, u_char *in_data);

    static void Callback(u_char *bp, const struct pcap_pkthdr *header,
                         const u_char *data);

protected:
    int Pcap2Common(pkthdr *in_header, u_char *in_data);

    pcap_t *pd;
};

#endif

#endif

