/* am930di.c: Handles the PCMCIA device instance
*	--------------------------------------------------------------------
*
*   Linux WLAN 
*
*   The contents of this file are subject to the Mozilla Public
*   License Version 1.0 (the "License"); you may not use this file
*   except in compliance with the License. You may obtain a copy of
*   the License at http://www.mozilla.org/MPL/
*
*   Software distributed under the License is distributed on an "AS
*   IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
*   implied. See the License for the specific language governing
*   rights and limitations under the License.
*
*   The initial developer of the original code is Mark S. Mathews
*   <mark@absoval.com>.  Portions created by Mark S. Mathews
*   are Copyright (C) 1998 AbsoluteValue Software, Inc.  All Rights Reserved.
*
*	--------------------------------------------------------------------
*/


#ifndef _LINUX_AM930DI_H
#define _LINUX_AM930DI_H

/*===== Constants ===================================*/
#define AM930DI_TPL_BUFSIZE 64
#define AM930DI_FAILURE		0
#define AM930DI_SUCCESS		1

/*===== Types   =====================================*/


/*===== Variables  ==================================*/

extern dev_info_t	am930_driver_name;
extern int			am930_use_mmio;		/* use memory mapped i/o or not */

/*===== Methods =====================================*/
dev_link_t* am930DI_construct(void);
void 		am930DI_destruct(dev_link_t* instance);

int am930DI_event( event_t event, int priority,
					event_callback_args_t *args);

#ifdef PCMCIA_DI_DEBUG
	#define AM930_DI_DB( DB_LEVEL, OUTLVL, FORMAT, A1) if ( DB_LEVEL <= pcmcia_di_debug ) printk(OUTLVL __FILE__ ": " __FUNCTION__ ": " FORMAT, A1);
#else
	#define AM930_DI_DB( DB_LEVEL, OUTLVL, FORMAT, A1) 
#endif

/*===== Some other funcs (didn't have a better place) =*/

void am930_drvr_cs_error(client_handle_t handle, int func, int ret);
void am930_drvr_detach(dev_link_t *instance);


#endif /* _LINUX_AM930DI_H */

