/*
*	Debugging methods for the hw object.
*	--------------------------------------------------------------------
*
*   Linux WLAN 
*
*   The contents of this file are subject to the Mozilla Public
*   License Version 1.0 (the "License"); you may not use this file
*   except in compliance with the License. You may obtain a copy of
*   the License at http://www.mozilla.org/MPL/
*
*   Software distributed under the License is distributed on an "AS
*   IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
*   implied. See the License for the specific language governing
*   rights and limitations under the License.
*
*   The initial developer of the original code is Mark S. Mathews
*   <mark@absoval.com>.  Portions created by Mark S. Mathews
*   are Copyright (C) 1998 AbsoluteValue Software, Inc.  All Rights Reserved.
*   
*	--------------------------------------------------------------------
*
*	The author may be reached as mark@absoval.com, or C/O AbsoluteValue
*	Software Inc., P.O. Box 941149, Maitland, FL, 32794-1149
*
*	Thanks to David Hinds, Donald Becker, and the rest of the Linux
*	developers worldwide for making all of this possible.
*/

void am930hw_dbprintregs( am930hw_t *hw)
{
	UINT8	a[8];
	int		i;
	UINT8	sir1;

	for ( i =0; i < 8; i++)
		a[i] = inb_p( hw->iobase + i );
	printk( KERN_DEBUG "SIR0-7   %02x %02x %02x %02x %02x %02x %02x %02x\n",
			a[0], a[1], a[2], a[3], a[4], a[5], a[6], a[7] );

	sir1 = inb_p( hw->iobase + 1 );
	sir1 &= ~(BIT2 | BIT1 | BIT0);
	outb_p( sir1, hw->iobase + 1);
	
	for ( i =0; i < 8; i++)
		a[i] = inb_p( hw->iobase + 8 + i );
	printk( KERN_DEBUG "SIR1:TIR0-7   %02x %02x %02x %02x %02x %02x %02x %02x %02x\n",
			inb_p(hw->iobase + 1), a[0], a[1], a[2], a[3], a[4], a[5], a[6], a[7] );

	sir1 = inb_p( hw->iobase + 1 );
	sir1 &= ~(BIT2 | BIT1 | BIT0);
	outb_p( sir1 | BIT0, hw->iobase + 1);
	for ( i =0; i < 8; i++)
		a[i] = inb_p( hw->iobase + 8 + i );
	printk( KERN_DEBUG "SIR1:TIR8-15  %02x %02x %02x %02x %02x %02x %02x %02x %02x\n",
			inb_p(hw->iobase + 1), a[0], a[1], a[2], a[3], a[4], a[5], a[6], a[7] );

	sir1 = inb_p( hw->iobase + 1 );
	sir1 &= ~(BIT2 | BIT1 | BIT0);
	outb_p( sir1 | BIT1, hw->iobase + 1);
	for ( i =0; i < 8; i++)
		a[i] = inb_p( hw->iobase + 8 + i );
	printk( KERN_DEBUG "SIR1:TIR16-23 %02x %02x %02x %02x %02x %02x %02x %02x %02x\n",
			inb_p(hw->iobase + 1), a[0], a[1], a[2], a[3], a[4], a[5], a[6], a[7] );

	sir1 = inb_p( hw->iobase + 1 );
	sir1 &= ~(BIT2 | BIT1 | BIT0);
	outb_p( sir1 | BIT1 | BIT0, hw->iobase + 1 );
	for ( i =0; i < 8; i++)
		a[i] = inb_p( hw->iobase + 8 + i );
	printk( KERN_DEBUG "SIR1:TIR24-31 %02x %02x %02x %02x %02x %02x %02x %02x %02x\n",
			inb_p(hw->iobase + 1), a[0], a[1], a[2], a[3], a[4], a[5], a[6], a[7] );

}

void am930hw_dbprintCS_blk( am930hw_t *hw)
{
	am930cs_blk_t cs;

	readcard(hw, hw->cs, &cs, sizeof(cs));

	printk( KERN_DEBUG "cs_blk.self_test_status = 0x%x\n", cs.self_test_status);
	printk( KERN_DEBUG "cs_blk.sta_state = 0x%x\n", cs.sta_state);
	printk( KERN_DEBUG "cs_blk.rsvd_user_rtn = 0x%x\n", cs.rsvd_user_rtn);
	printk( KERN_DEBUG "cs_blk.int_status = 0x%x\n", cs.int_status);
	printk( KERN_DEBUG "cs_blk.int_mask = 0x%x\n", cs.int_mask);
	printk( KERN_DEBUG "cs_blk.lockout_fw = 0x%x\n", cs.lockout_fw);
	printk( KERN_DEBUG "cs_blk.lockout_host = 0x%x\n", cs.lockout_host);
	printk( KERN_DEBUG "cs_blk.last_completed_tx_desc = 0x%lx\n", cs.last_completed_tx_desc);
	printk( KERN_DEBUG "cs_blk.disable_pwr_dn = 0x%x\n", cs.disable_pwr_dn);
}


void am930hw_dbprintCMD_blk( am930hw_t *hw)
{
	am930cmd_blk_t	cmd;

	readcard(hw, hw->cmd, &cmd, sizeof(cmd));

	printk( KERN_DEBUG "cmd_blk.code          = 0x%x\n", cmd.code);
	printk( KERN_DEBUG "cmd_blk.status        = 0x%x\n", cmd.status);
	printk( KERN_DEBUG "cmd_blk.error_offset  = 0x%x\n", cmd.error_offset);
}


void am930hw_dbprintRXdesc( am930rx_desc_t *d)
{
	printk( KERN_DEBUG 
		"rxdesc:next=%08lx stat=%02x ss=%02x ch=%02x "
		"t=%08lx off=%08lx len=%d\n" ,
		d->next & 0x8000ffff,
		d->state,
		d->rssi,
		d->channel,
		d->local_time,
		d->rx_start_frame & 0x0000ffff,
		d->rx_len);
}


void am930hw_dbprintTXdesc( am930tx_desc_t *d)
{
	printk( KERN_DEBUG 
	"txdesc:off=%08lx next=%08lx len=%d stat=%02x rate=%02x "
	"drvr=%04x sifa=%02x siff=%02x difa=%02x diff=%02x\n",
	d->tx_start_frame,
	d->next,
	d->tx_len,
	d->state,
	d->rate,
	d->driver,
	d->sifsAttempts,
	d->sifsFailures,
	d->difsAttempts,
	d->difsFailures);
}


void am930hw_dbprintallMIBs(am930hw_t *hw)
{
	/*----- Local MIB */
	am930hw_dbprintMIBlocal(hw);

	/*----- addr stat group MIB */
	am930hw_dbprintMIBmac_addr_stat_grp(hw);

	/*----- mac MIB */
	am930hw_dbprintMIBmac(hw);

	/*----- mac statistics MIB */
	am930hw_dbprintMIBmac_statistics(hw);

	/*----- mac mgmt MIB */
	am930hw_dbprintMIBmac_mgmt(hw);

	/*----- physical MIB */
	am930hw_dbprintMIBphy(hw);
}



void am930hw_dbprintMIBlocal( am930hw_t *hw )
{
	su_mib_local_t	mib;
	su_mib_local_t	*m = &mib;

	am930hw_mibget( hw, SUMIB_LOCAL, 0, sizeof(mib), &mib);

	printk(KERN_DEBUG "mib_local.frag_disable           =0x%x\n", m->frag_disable);
	printk(KERN_DEBUG "mib_local.add_plcp_disable       =0x%x\n", m->add_plcp_disable);
	printk(KERN_DEBUG "mib_local.mac_hdr_preserve       =0x%x\n", m->mac_hdr_preserve);
	printk(KERN_DEBUG "mib_local.reassembly_disable     =0x%x\n", m->reassembly_disable);
	printk(KERN_DEBUG "mib_local.strip_plcp_disable     =0x%x\n", m->strip_plcp_disable);
	printk(KERN_DEBUG "mib_local.rx_error_disable       =0x%x\n", m->rx_error_disable);
	printk(KERN_DEBUG "mib_local.power_save_mode_disable=0x%x\n", m->power_save_mode_disable);
	printk(KERN_DEBUG "mib_local.accept_all_multicast_disable=0x%x", m->accept_all_multicast_disable);
	printk(KERN_DEBUG "mib_local.check_seq_cntl_disable =0x%x\n", m->check_seq_cntl_disable);
	printk(KERN_DEBUG "mib_local.loopback               =0x%x\n", m->loopback);
	printk(KERN_DEBUG "mib_local.network_mode           =0x%x\n", m->network_mode);
	printk(KERN_DEBUG "mib_local.pwd_level              =0x%x\n", m->pwd_level);
	printk(KERN_DEBUG "mib_local.tx_buffer_offset       =0x%lx\n", m->tx_buffer_offset);
	printk(KERN_DEBUG "mib_local.tx_buffer_size         =0x%lx\n", m->tx_buffer_size);
	printk(KERN_DEBUG "mib_local.rx_buffer_offset       =0x%lx\n", m->rx_buffer_offset);
	printk(KERN_DEBUG "mib_local.rx_buffer_size         =0x%lx\n", m->rx_buffer_size);
	printk(KERN_DEBUG "mib_local.phy_type               =0x%x\n", m->phy_type);
}

void am930hw_dbprintMIBmac_addr_stat_grp( am930hw_t *hw )
{
	char	atemp[40];
	UINT32	i;
	UINT8	*p;
	su_mib_mac_addr_stat_grp_t	mib;
	su_mib_mac_addr_stat_grp_t	*m = &mib;

	am930hw_mibget( hw, SUMIB_ADDR, 0, sizeof(mib), &mib);

	p = (UINT8*)&(m->mac_address);
	sprintf( atemp, "%x:%x:%x:%x:%x:%x", p[0], p[1], p[2], p[3], p[4], p[5]);
	printk(KERN_DEBUG "mib_mac_addr_stat_grp.mac_address  = %s\n", atemp);

	for ( i = 0; i < SUMIB_MAX_GRP_ADDR; i++)
	{
		p = (UINT8*)&(m->group_addresses[i]);
		sprintf( atemp, "%x:%x:%x:%x:%x:%x", p[0], p[1], p[2], p[3], p[4], p[5]);
		printk(KERN_DEBUG "mib_mac_addr_stat_grp.group_addresses[%ld] = %s\n", i, atemp);
	}

	printk(KERN_DEBUG "mib_mac_addr_stat_grp.tx_enable_status = 0x%x\n", m->tx_enable_status);
	printk(KERN_DEBUG "mib_mac_addr_stat_grp.promisc = 0x%x\n", m->promisc);
}

void am930hw_dbprintMIBmac( am930hw_t *hw )
{
	su_mib_mac_t	mib;
	su_mib_mac_t	*m = &mib;
	char			buf[80];
	int				i;

	am930hw_mibget( hw, SUMIB_MAC, 0, sizeof(mib), &mib);

	printk(KERN_DEBUG "mib_mac.rate_factor            =%ud\n", m->rate_factor);
	printk(KERN_DEBUG "mib_mac.handshake_overhead     =%ud\n", m->handshake_overhead);
	printk(KERN_DEBUG "mib_mac.rts_threshold          =%ud\n", m->rts_threshold);
	printk(KERN_DEBUG "mib_mac.cw_max                 =%ud\n", m->cw_max);
	printk(KERN_DEBUG "mib_mac.cw_min                 =%ud\n", m->cw_min);
	printk(KERN_DEBUG "mib_mac.cts_time               =%ud\n", m->cts_time);
	printk(KERN_DEBUG "mib_mac.ack_time               =%ud\n", m->ack_time);
	printk(KERN_DEBUG "mib_mac.ack_timeout            =%ud\n", m->ack_timeout);
	printk(KERN_DEBUG "mib_mac.cts_timeout            =%ud\n", m->cts_timeout);
	printk(KERN_DEBUG "mib_mac.short_retry_limit      =%ud\n", m->short_retry_limit);
	printk(KERN_DEBUG "mib_mac.long_retry_limit       =%ud\n", m->long_retry_limit);
	printk(KERN_DEBUG "mib_mac.max_frame_length       =%ud\n", m->max_frame_length);
	printk(KERN_DEBUG "mib_mac.fragmentation_threshold=%ud\n", m->fragmentation_threshold);
	printk(KERN_DEBUG "mib_mac.probe_delay            =%ud\n", m->probe_delay);
	printk(KERN_DEBUG "mib_mac.min_probe_response_time=%ud\n", m->min_probe_response_time);
	printk(KERN_DEBUG "mib_mac.max_probe_response_time=%ud\n", m->max_probe_response_time);
	printk(KERN_DEBUG "mib_mac.max_tx_msdu_lifetime   =%lud\n", m->max_tx_msdu_lifetime);
	printk(KERN_DEBUG "mib_mac.max_rx_msdu_lifetime   =%lud\n", m->max_rx_msdu_lifetime);
	printk(KERN_DEBUG "mib_mac.sta_basic_rate         =%ud\n", m->sta_basic_rate);
	for ( i = 0; i < WLAN_SSID_MAXLEN + 2; i++)
	{
		sprintf(&buf[i*3], ":%02x", m->desired_essid[i]); 
	}
	printk(KERN_DEBUG "mib_mac.desired_essid         =%s\n", &buf[1]);
}

void am930hw_dbprintMIBmac_statistics( am930hw_t *hw )
{
	su_mib_mac_statistics_t	mib;
	su_mib_mac_statistics_t	*m;

	m = &mib;
	am930hw_mibget( hw, SUMIB_STAT, 0, sizeof(mib), &mib);

	printk( KERN_DEBUG "mib_mac_stats.tx_mpdu_cnt        =%lud\n", m->tx_mpdu_cnt);
	printk( KERN_DEBUG "mib_mac_stats.tx_msdu_cnt        =%lud\n", m->tx_msdu_cnt);
	printk( KERN_DEBUG "mib_mac_stats.tx_octets_cnt      =%lud\n", m->tx_octets_cnt);
	printk( KERN_DEBUG "mib_mac_stats.tx_multicast_cnt   =%ud\n", m->tx_multicast_cnt);
	printk( KERN_DEBUG "mib_mac_stats.tx_broadcast_cnt   =%ud\n", m->tx_broadcast_cnt);
	printk( KERN_DEBUG "mib_mac_stats.failed_cnt         =%lud\n", m->failed_cnt);
	printk( KERN_DEBUG "mib_mac_stats.retry_cnt          =%lud\n", m->retry_cnt);
	printk( KERN_DEBUG "mib_mac_stats.multiple_retry_cnt =%lud\n", m->multiple_retry_cnt);
	printk( KERN_DEBUG "mib_mac_stats.frame_dup_cnt      =%lud\n", m->frame_dup_cnt);
	printk( KERN_DEBUG "mib_mac_stats.rts_success_cnt    =%lud\n", m->rts_success_cnt);
	printk( KERN_DEBUG "mib_mac_stats.rts_failure_cnt    =%lud\n", m->rts_failure_cnt);
	printk( KERN_DEBUG "mib_mac_stats.ack_failure_cnt    =%lud\n", m->ack_failure_cnt);
	printk( KERN_DEBUG "mib_mac_stats.rx_frame_cnt       =%lud\n", m->rx_frame_cnt);
	printk( KERN_DEBUG "mib_mac_stats.rx_octets_cnt      =%lud\n", m->rx_octets_cnt);
	printk( KERN_DEBUG "mib_mac_stats.rx_multicast_cnt   =%lud\n", m->rx_multicast_cnt);
	printk( KERN_DEBUG "mib_mac_stats.rx_broadcast_cnt   =%lud\n", m->rx_broadcast_cnt);
	printk( KERN_DEBUG "mib_mac_stats.fcs_error_cnt      =%lud\n", m->fcs_error_cnt);
	printk( KERN_DEBUG "mib_mac_stats.error_cnt          =%lud\n", m->error_cnt);
	printk( KERN_DEBUG "mib_mac_stats.total_backoff_time =%lud\n", m->total_backoff_time);
}

void am930hw_dbprintMIBmac_mgmt( am930hw_t *hw)
{
	char				atemp[40];
	UINT8				*p;
	su_mib_mac_mgmt_t	mib;
	su_mib_mac_mgmt_t	*m;
	char			buf[80];
	int				i;

	m = &mib;
	am930hw_mibget( hw, SUMIB_MGMT, 0, sizeof(mib), &mib);
	printk( KERN_DEBUG "mib_mac_mgmt.pwr_mgmt_mode         = 0x%x\n", m->pwr_mgmt_mode);
	printk( KERN_DEBUG "mib_mac_mgmt.scan_mode             = 0x%x\n", m->scan_mode);

	printk( KERN_DEBUG "mib_mac_mgmt.scan_state            = 0x%x\n", m->scan_state);
	printk( KERN_DEBUG "mib_mac_mgmt.dtim_period           = %ud\n", m->dtim_period);
	printk( KERN_DEBUG "mib_mac_mgmt.atim_window           = %lu\n", m->atim_window);
	printk( KERN_DEBUG "mib_mac_mgmt.beacon_period         = %ud\n", m->beacon_period);
	udelay(20);
	printk( KERN_DEBUG "mib_mac_mgmt.passive_scan_duration = %ud\n", m->passive_scan_duration);
	printk( KERN_DEBUG "mib_mac_mgmt.listen_interval       = %ud\n", m->listen_interval);
	printk( KERN_DEBUG "mib_mac_mgmt.med_occupancy_limit   = %ud\n", m->med_occupancy_limit);
	printk( KERN_DEBUG "mib_mac_mgmt.max_mpdu_time         = %ud\n", m->max_mpdu_time);
	printk( KERN_DEBUG "mib_mac_mgmt.cfp_max_duration      = %ud\n", m->cfp_max_duration);
	printk( KERN_DEBUG "mib_mac_mgmt.cfp_rate              = %ud\n", m->cfp_rate);
	printk( KERN_DEBUG "mib_mac_mgmt.station_id            = %ud\n", m->station_id);

	p = (UINT8*)&(m->current_bssid);
	sprintf( atemp, "%x:%x:%x:%x:%x:%x", p[0], p[1], p[2], p[3], p[4], p[5]);
	printk(KERN_DEBUG "mib_mac_mgmt.current_bssid         = %s\n", atemp);

	for ( i = 0; i < WLAN_MAXSSID_LEN + 2; i++)
	{
		sprintf(&buf[i*3], ":%02x", m->current_essid[i]); 
	}
	printk(KERN_DEBUG "mib_mac_mgmt.current_essid         =%s\n", &buf[1]);
}

void am930hw_dbprintMIBphy( am930hw_t *hw)
{
	su_mib_phy_t	mib;
	su_mib_phy_t	*m = &mib;

	am930hw_mibget( hw, SUMIB_PHY, 0, sizeof(mib), &mib);

	printk( KERN_DEBUG "mib_phy.slot_time = %ud\n", m->slot_time);
	printk( KERN_DEBUG "mib_phy.sifs      = %ud\n", m->sifs);
	printk( KERN_DEBUG "mib_phy.mpdu_max  = %ud\n", m->mpdu_max);
	printk( KERN_DEBUG "mib_phy.hop_time  = %ud\n", m->hop_time);
	printk( KERN_DEBUG "mib_phy.supported_data_rates 0x%x 0x%x 0x%x 0x%x\n",
		m->supported_data_rates[0],
		m->supported_data_rates[1],
		m->supported_data_rates[2],
		m->supported_data_rates[3] );
	printk( KERN_DEBUG "mib_phy.current_reg_domain = 0x%x\n", m->current_reg_domain);		/* 10=FCC,20=DOC,30=ETSI,40=MKK */
	printk( KERN_DEBUG "mib_phy.preamble_length = %ud\n", m->preamble_length);
	printk( KERN_DEBUG "mib_phy.plcp_hdr_length = %ud\n", m->plcp_hdr_length);
	printk( KERN_DEBUG "mib_phy.pwr_up_time[0,1,2,3] = %ud,%ud,%ud,%ud\n",
		m->pwr_up_time[0], m->pwr_up_time[1], m->pwr_up_time[2], m->pwr_up_time[3] );
}


