/* am930mgr.h: Handles the 802.11 mac managment functions
*	--------------------------------------------------------------------
*
*   Linux WLAN 
*
*   The contents of this file are subject to the Mozilla Public
*   License Version 1.0 (the "License"); you may not use this file
*   except in compliance with the License. You may obtain a copy of
*   the License at http://www.mozilla.org/MPL/
*
*   Software distributed under the License is distributed on an "AS
*   IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
*   implied. See the License for the specific language governing
*   rights and limitations under the License.
*
*   The initial developer of the original code is Mark S. Mathews
*   <mark@absoval.com>.  Portions created by Mark S. Mathews
*   are Copyright (C) 1998 AbsoluteValue Software, Inc.  All Rights Reserved.
*
*	--------------------------------------------------------------------
*/

#ifndef _LINUX_AM930MGR_H
#define _LINUX_AM930MGR_H

#include <wlan/wlan_stable.h>

/*=============================================================*/
/*--- Constants -----------------------------------------------*/
/*=============================================================*/
#define MGR_ISSCANNING		BIT1

#define WLAN_STABLE_LEN		128		/* must be power of 2 */
#define WLAN_STABLE_MASK	0x007f	/* Masks the hash bits we're using */

#define WLAN_AIDTABLE_LEN	128		/* must be power of 2 */
#define WLAN_AIDTABLE_MASK	0x007f	/* Masks the hash bits we're using */

/*=============================================================*/
/*--- Macros --------------------------------------------------*/
/*=============================================================*/

/*--------------------------------------------------------------*/
/* Simple xor hash, ignores the organizationally unique ID	    */
/*  since in most installations it orgID will always be the same*/
/* Expects the address of a 6 byte region conatining a MAC      */
/*  address.                                                    */
/*--------------------------------------------------------------*/

#define WLAN_MACADDR_HASH8(a) (((a)[5])^((a)[4])^((a)[3]))


/*===== Variables  ==================================*/
extern int			am930_isap;			/* are we an AP? */

/*=============================================================*/
/*--- Types ---------------------------------------------------*/
/*=============================================================*/
typedef struct knownbss
{
	/* BSS info */
	UINT8			bssid[WLAN_BSSID_LEN];
	UINT32			channel;
	UINT32			rate;
	UINT16			bcn_int;
	UINT16			cap_info;
	UINT8			ssid[WLAN_SSID_MAXLEN+2+1];  /* extra for \0 */
	wlan_bss_ts_t	bss_timestamp;
	UINT32			sutro_reftime;	/* am930 specific */

	/* Driver support */
	UINT32			ttl;			/* TODO: add aging of BSS's */
	struct knownbss	*next;
} knownbss_t;


typedef struct wlan_stable_item
{
	wlan_stable_sinfo_t			sta;
	struct wlan_stable_item		*next;
	struct wlan_stable_item		*prev;
} wlan_stable_item_t;


typedef struct am930mgr
{
	/* general state vars */
	am930mac_t	*mac;
	am930hw_t	*hw;
	UINT32		curr_ch;
	UINT16		curr_rate;
	UINT8		curr_ssid[WLAN_IEHDR_LEN + WLAN_SSID_MAXLEN];
	UINT8		curr_bssid[WLAN_BSSID_LEN];
	UINT16		curr_cap_info;
	UINT16		curr_aid;
	UINT8		challengekey[19];
	void		(*timerfunc)(struct am930mgr *mgr);

	/* scan state vars */
	UINT32		scanstate;	/* 0 = notscanning, MGR_ISCANNING = we're scanning? */
	UINT		scantype;	/* 0 = passive, 1 = active */
	UINT		scanch;		/* curr. scan channel */
	UINT		scanendch;	/* last ch. in scan seq. */
	UINT		scantimech;	/* Kus spent scanning each ch. */
	UINT8		scanbssid[WLAN_BSSID_LEN];	/* bssid to scan for (usually bcast) */
	UINT		scanbsstype;/* BIT0:independent,BIT1:infrastructure */
	UINT8       scanssid[WLAN_IEHDR_LEN + WLAN_SSID_MAXLEN]; 

	/* station table */
	UINT32				stable_lock;
	wlan_stable_item_t	*stable[WLAN_STABLE_LEN];
	wlan_stable_item_t	*aidtable[WLAN_AIDTABLE_LEN];

	/* timer settings */
	UINT32		mgmt_trans_timeout;	/* timeout for auth and assoc transactions */
	UINT32		ap_auth_timeout;	/* AP timeout for idle authenticated STAs */
	UINT32		ap_assoc_timeout;	/* AP timeout for idle associated STAs */

	/* list of known bss's (scan results) */
	knownbss_t	*bsslist;

} am930mgr_t;

/*=============================================================*/
/*--- Methods -------------------------------------------------*/
/*=============================================================*/

am930mgr_t* am930mgr_construct(am930mac_t *mac, am930hw_t *hw);
void am930mgr_destruct( am930mgr_t *mgr );

void am930mgr_assoc_begin_sta(am930mgr_t *mgr);
void am930mgr_assoc_stop(am930mgr_t *mgr);
void am930mgr_assocreq_rx( am930mgr_t *mgr, wlan_pb_t *rxpb, am930rxstats_t *stats);
void am930mgr_assocresp_rx( am930mgr_t *mgr, wlan_pb_t *rxpb, am930rxstats_t *stats);
void am930mgr_authen_begin_sta(am930mgr_t *mgr, UINT16 authalg);
void am930mgr_authen_stop( am930mgr_t *mgr );
void am930mgr_authen_rx( am930mgr_t *mgr, wlan_pb_t *rxpb, am930rxstats_t *stats);

void am930mgr_beacon_rx( am930mgr_t *mgr, wlan_pb_t *rxpb, am930rxstats_t *stats);

void am930mgr_class2err(am930mgr_t *mgr, UINT8 *daddr);
void am930mgr_class3err(am930mgr_t *mgr, UINT8 *daddr);

UINT32 am930mgr_createbss(	am930mgr_t *mgr, UINT32 ch, wlan_ie_ssid_t *ie_ssid,
							UINT32 bcn, UINT32 atimwindow);

void am930mgr_deauth_rx( am930mgr_t *mgr, wlan_pb_t *rxpb, am930rxstats_t *stats);
void am930mgr_disassoc_rx( am930mgr_t *mgr, wlan_pb_t *rxpb, am930rxstats_t *stats);

UINT32 am930mgr_joinbss( am930mgr_t *mgr, UINT8 *bssid );

UINT32 am930mgr_mibget( am930mgr_t *mgr, UINT32 mibsec, UINT32 len, void *buf);
UINT32 am930mgr_mibset( am930mgr_t *mgr, UINT32 mibsec, UINT32 len, void *buf);
UINT32 am930mgr_mibgetitem( am930mgr_t *mgr, UINT32 itemid, 
							void *buf, UINT32 len);
UINT32 am930mgr_mibsetitem( am930mgr_t *mgr, UINT32 itemid, 
							void *buf, UINT32 len);

void am930mgr_proberesp_rx( am930mgr_t *mgr, wlan_pb_t *rxpb, am930rxstats_t *stats);
void am930mgr_probereq_rx( am930mgr_t *mgr, wlan_pb_t *rxpb, am930rxstats_t *stats);
void am930mgr_prstatus(am930mgr_t *mgr, UINT16 status );

void am930mgr_reassocreq_rx( am930mgr_t *mgr, wlan_pb_t *rxpb, am930rxstats_t *stats);
void am930mgr_rxmgmt( am930mgr_t *mgr, wlan_pb_t *rxpb, am930rxstats_t *stats);

UINT32 am930mgr_scanbegin( am930mgr_t *mgr, UINT scantype, UINT bsstype,
		      UINT8 *bssid, UINT startch, UINT endch, UINT timech,
		      wlan_ie_ssid_t *ie_ssid);
void am930mgr_scanstop(am930mgr_t *mgr);

void am930mgr_scancomplete( void *argp );

UINT16 am930mgr_stable_alloc_aid( am930mgr_t *mgr, wlan_stable_item_t *sta);
void am930mgr_stable_insert( am930mgr_t *mgr, wlan_stable_item_t *sta);
wlan_stable_item_t *am930mgr_stable_lookup( am930mgr_t *mgr, UINT8 *addr);


#endif /* _LINUX_AM930MGR_H */


