/* am930mod.c: ISA module for PRISM/AM79C930 card from Harris
*	--------------------------------------------------------------------
*
*   Linux WLAN 
*
*   The contents of this file are subject to the Mozilla Public
*   License Version 1.0 (the "License"); you may not use this file
*   except in compliance with the License. You may obtain a copy of
*   the License at http://www.mozilla.org/MPL/
*
*   Software distributed under the License is distributed on an "AS
*   IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
*   implied. See the License for the specific language governing
*   rights and limitations under the License.
*
*   The initial developer of the original code is Mark S. Mathews
*   <mark@absoval.com>.  Portions created by Mark S. Mathews
*   are Copyright (C) 1998 AbsoluteValue Software, Inc.  All Rights Reserved.
*   
*	--------------------------------------------------------------------
*
*	The author may be reached as mark@absoval.com, or C/O AbsoluteValue
*	Software Inc., P.O. Box 941149, Maitland, FL, 32794-1149
*
*	Thanks to David Hinds, Donald Becker, and the rest of the Linux
*	developers worldwide for making all of this possible.
*
*	--------------------------------------------------------------------
*
*	This file contains the entry points/cleanup routines for modules and
*	ISA drivers.  Additionally, all "driver global" variables are
*	defined here.
*
*	MSM 02/13/97
*/

#include <linux/config.h>
#include <wlan/wlan_compat.h>

/* Module related headers, non-module drivers should not include */
#include <linux/version.h>
#include <linux/module.h>
#include <linux/kernel.h>
#include <linux/sched.h>

/* Ethernet and network includes */
#include <linux/if_ether.h>
#include <linux/netdevice.h>
#include <linux/etherdevice.h>
#include <linux/skbuff.h>
#include <linux/if_arp.h>

/* Standard driver includes */
#include <linux/kernel.h>
#include <linux/types.h>
#include <linux/sched.h>
#include <linux/fcntl.h>
#include <asm/system.h>
#include <linux/ptrace.h>
#include <linux/interrupt.h>
#include <linux/ioport.h>
#include <linux/in.h>
#include <linux/malloc.h>
#include <linux/string.h>
#include <linux/timer.h>
#include <linux/kernel_stat.h>
#include <linux/delay.h>

#include <asm/bitops.h>
#include <asm/io.h>

#include <linux/errno.h>

/*================================================================*/
/* Local Includes */

#include <wlan/version.h>
#include <wlan/p80211hdr.h>
#include "am930llc.h"
#include "am930mac.h"


/*================================================================*/
/* Local macros */

#if (LINUX_VERSION_CODE < KERNEL_VERSION(2,2,0))
#define ioremap_nocache ioremap
#endif

/*================================================================*/
/* Local statics */

static char *version = "am930mod.c 0.1.3 1998/10/20";

static am930mac_t *irq2mac_map[16] =
{
	NULL, NULL, NULL, NULL,
	NULL, NULL, NULL, NULL,
	NULL, NULL, NULL, NULL,
	NULL, NULL, NULL, NULL 
};


/*================================================================*/
/* Module Parameters */

int		am930_use_mmio=0;		/* use memory mapped i/o or not */
MODULE_PARM( am930_use_mmio, "i");

int		am930_iodelay=0;		/* udelay between memory or i/o reads */
MODULE_PARM( am930_iodelay, "i");

int		am930_iobase=0;			/* IO address */
MODULE_PARM( am930_iobase, "i");

int		am930_irq=0;			/* IRQ */
MODULE_PARM( am930_irq, "i");

int		am930_membase=0;		/* Memory base */
MODULE_PARM( am930_membase, "i");

int		am930_isap=0;			/* are we an AP? */
MODULE_PARM( am930_isap, "i");

int		wlan_debug=0;			/* Debug output level, declared in */
MODULE_PARM( wlan_debug, "i");	/* wlan_compat.h */


/*================================================================*/
/* Local functions */
int	init_module(void);
void	cleanup_module(void);

/*----------------------------------------------------------------
*	am930isa_interrupt
*
*	This is a holdover from our (foolish?) original, pcmcia-specific,
*	implementation.  Basically, the problem is that we don't have
*	our hands on the dev structure yet, but the code in am930hw
*	needs the IRQ active.  So we didn't have a dev pointer when
*	request_irq was called.  The original ISA implementation just
*	used a single pointer to a mac structure...but that limited us
*	to just one card.  Now, like the bad old days, we use an
*	irq2dev_map array to keep track of interrupts and the devices
*	they belong to.
*
*	returns: zero on success, non-zero on failure.
----------------------------------------------------------------*/
static void
am930mod_interrupt(int irq, void *dev_id, struct pt_regs *regs)
{
  DBFENTER;

	if ( irq2mac_map[irq] != NULL )
	{
		am930mac_ISR(irq2mac_map[irq]);
	}

  DBFEXIT;
}

/*----------------------------------------------------------------
*	init_module
*
*	Module initialization routine. For an ISA device this has to
*	setup a dev_link structure, fill it in with information provided
*	and request the IRQ.
*
*	returns: zero on success, non-zero on failure.
----------------------------------------------------------------*/
int init_module(void)
{
	int		result = 0;

	DBFENTER;

	printk( KERN_DEBUG"init_module:%s\n", version);

	printk(KERN_INFO "Linux WLAN " WLAN_RELEASE "\n");

	request_irq (am930_irq, am930mod_interrupt, 0, "am930isa", NULL);
	am930_membase = (UINT32)ioremap_nocache (am930_membase, 0x8000);

	irq2mac_map[am930_irq] = 
		am930mac_construct(NULL, am930_iobase, am930_membase, am930_irq);

	if ( irq2mac_map[am930_irq] == NULL ) {
		result = 1;
	}

	DBFEXIT;
	return result;
}


/*----------------------------------------------------------------
*	cleanup_module
*
*	This is the destructor for the am930_drvr object.
*
*	Standard module unload callback function. For ISA, that
*	means that the IRQ must be release.
*
*	returns: nothing
----------------------------------------------------------------*/
void cleanup_module(void)
{
        DBFENTER;

/*
	Not sure how to handle this just yet.
	am930mac_destruct(tricky_di. priv);
*/

	/* TODO: handle destruction cleanly, call subobject destructors
	         after testing subobject pointers for NULL */

	free_irq(am930_irq, NULL);

	DBFEXIT;
	return;
}

