/* am930mib.h: Declares constants and types for the MIBs
*	--------------------------------------------------------------------
*
*   Linux WLAN 
*
*   The contents of this file are subject to the Mozilla Public
*   License Version 1.0 (the "License"); you may not use this file
*   except in compliance with the License. You may obtain a copy of
*   the License at http://www.mozilla.org/MPL/
*
*   Software distributed under the License is distributed on an "AS
*   IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
*   implied. See the License for the specific language governing
*   rights and limitations under the License.
*
*   The initial developer of the original code is Mark S. Mathews
*   <mark@absoval.com>.  Portions created by Mark S. Mathews
*   are Copyright (C) 1998 AbsoluteValue Software, Inc.  All Rights Reserved.
*    
*	--------------------------------------------------------------------
*/

#ifndef _LINUX_AM930HW_MIB_H
#define _LINUX_AM930HW_MIB_H


#include <wlan/wlan_compat.h>
#include <wlan/p80211hdr.h>
#include <wlan/p80211mgmt.h>

/*--- Firmware MIB section identifiers ----------------------*/
#define SUMIB_LOCAL					0x00
#define SUMIB_ADDR					0x02
#define SUMIB_MAC					0x03
#define SUMIB_STAT					0x04
#define SUMIB_MGMT					0x05
#define SUMIB_DRVR					0x06
#define SUMIB_PHY					0x07


/*--- MIB Constants -------------------------------------------*/

/*---MIB item identifiers----------------------------*/
/* each is a 32bit unsigned int, 
	bits 0-7		unique identifying int
	bits 8-15		item offset in section
	bits 16-23		item size
	bits 23-31		section code
*/

/* Item ID construction */
#define SEC(a)			((a) << 24)
#define SZ(a)			((a) << 16)
#define OFF(a)			((a) << 8)
#define ID(a)			(a)
#define MKID(a,b,c,d)	(SEC(a)|SZ(b)|OFF(c)|ID(d))

/* Item ID deconstruction */
#define MI_SEC(a)		(((UINT32)(a)) >> 24)
#define MI_SZ(a)		((((UINT32)(a)) & 0x00ff0000) >> 16)
#define MI_OFF(a)		((((UINT32)(a)) & 0x0000ff00) >> 8)
#define MI_ID(a)		(((UINT32)(a)) & 0x000000ff)

/*=============================================================*/
/*--- Local MIB ----------- SUMIB_LOCAL -----------------------*/
__WLAN_PRAGMA_PACK1__
typedef struct su_mib_local
{
	UINT8	frag_disable					__WLAN_ATTRIB_PACK__;
	UINT8	add_plcp_disable				__WLAN_ATTRIB_PACK__;
	UINT8	mac_hdr_preserve				__WLAN_ATTRIB_PACK__;
	UINT8	rx_mgmt_q_enable				__WLAN_ATTRIB_PACK__;
	UINT8	reassembly_disable				__WLAN_ATTRIB_PACK__;
	UINT8	strip_plcp_disable				__WLAN_ATTRIB_PACK__;
	UINT8	rx_error_disable				__WLAN_ATTRIB_PACK__;
	UINT8	power_save_mode_disable			__WLAN_ATTRIB_PACK__;
	UINT8	accept_all_multicast_disable	__WLAN_ATTRIB_PACK__;
	UINT8	check_seq_cntl_disable			__WLAN_ATTRIB_PACK__;
	UINT8	flush_CFP_q_on_CF_end	  		__WLAN_ATTRIB_PACK__;
	UINT8	network_mode					__WLAN_ATTRIB_PACK__;
	UINT8	pwd_level						__WLAN_ATTRIB_PACK__;
	UINT8	CFP_mode						__WLAN_ATTRIB_PACK__;
	UINT32	tx_buffer_offset				__WLAN_ATTRIB_PACK__;
	UINT32	tx_buffer_size					__WLAN_ATTRIB_PACK__;
	UINT32	rx_buffer_offset				__WLAN_ATTRIB_PACK__;
	UINT32	rx_buffer_size					__WLAN_ATTRIB_PACK__;
	UINT8	acting_as_AP					__WLAN_ATTRIB_PACK__;
	UINT8	fill_CFP						__WLAN_ATTRIB_PACK__;
} su_mib_local_t;
__WLAN_PRAGMA_PACKDFLT__
/* Constants for the local mib */
/* PHY type used in MIB_Local */
#define SUMIB_PHY_FH	0x01
#define SUMIB_PHY_DS	0x02
#define SUMIB_PHY_IR	0x03

#define NITEMS_SUMIB_LOCAL			20
#define LOC_FRAGDISABLE				MKID(SUMIB_LOCAL, sizeof(UINT8), 0, 0)
#define LOC_ADD_PLCP_DISABLE		MKID(SUMIB_LOCAL, sizeof(UINT8), 1, 1)
#define LOC_MAC_HDR_PRESERVE		MKID(SUMIB_LOCAL, sizeof(UINT8), 2, 2)
#define LOC_RX_MGMT_Q_ENABLE		MKID(SUMIB_LOCAL, sizeof(UINT8), 3, 17)
#define LOC_REASSEMBLY_DISABLE		MKID(SUMIB_LOCAL, sizeof(UINT8), 4, 3)
#define LOC_STRIP_PLCP_DISABLE		MKID(SUMIB_LOCAL, sizeof(UINT8), 5, 4)
#define LOC_RX_ERROR_DISABLE		MKID(SUMIB_LOCAL, sizeof(UINT8), 6, 5)
#define LOC_PWR_SAVE_MODE_DIS		MKID(SUMIB_LOCAL, sizeof(UINT8), 7, 6)
#define LOC_ACCEPT_ALL_MULTI_DIS	MKID(SUMIB_LOCAL, sizeof(UINT8), 8, 7)
#define LOC_CHECK_SEQ_CNTL_DISABLE	MKID(SUMIB_LOCAL, sizeof(UINT8), 9, 8)
#define LOC_FLUSH_CFP_Q_ON_CF_END	MKID(SUMIB_LOCAL, sizeof(UINT8), 10, 9)
#define LOC_NETWORK_MODE			MKID(SUMIB_LOCAL, sizeof(UINT8), 11, 10)
#define LOC_PWD_LEVEL				MKID(SUMIB_LOCAL, sizeof(UINT8), 12, 11)
#define LOC_CFP_MODE				MKID(SUMIB_LOCAL, sizeof(UINT8), 13, 18)
#define LOC_TX_BUFFER_OFFSET		MKID(SUMIB_LOCAL, sizeof(UINT32), 14, 12)
#define LOC_TX_BUFFER_SIZE			MKID(SUMIB_LOCAL, sizeof(UINT32), 18, 13)
#define LOC_RX_BUFFER_OFFSET		MKID(SUMIB_LOCAL, sizeof(UINT32), 22, 14)
#define LOC_RX_BUFFER_SIZE			MKID(SUMIB_LOCAL, sizeof(UINT32), 26, 15)
#define LOC_ACTING_AS_AP			MKID(SUMIB_LOCAL, sizeof(UINT8) , 30, 16)
#define LOC_FILL_CFP				MKID(SUMIB_LOCAL, sizeof(UINT8) , 31, 19)


/*=============================================================*/
/*--- MAC Addr Status Grp MIB -- SU_MIB_MAC_ADDR_STAT_GRP -----*/
/* struct member sizes*/
#define SUMIB_MAX_GRP_ADDR	4

__WLAN_PRAGMA_PACK1__
typedef struct su_mib_mac_addr_stat_grp
{
	UINT8	mac_address[WLAN_ADDR_LEN]				__WLAN_ATTRIB_PACK__;
	UINT8	group_addresses[SUMIB_MAX_GRP_ADDR][WLAN_ADDR_LEN]	__WLAN_ATTRIB_PACK__;
	UINT8	tx_enable_status						__WLAN_ATTRIB_PACK__;
	UINT8	rsvd									__WLAN_ATTRIB_PACK__;
} su_mib_mac_addr_stat_grp_t;
__WLAN_PRAGMA_PACKDFLT__

/* member identifiers */
#define NITEMS_MIB_ADDR		4
#define ADDR_MAC_ADDR		MKID(SUMIB_ADDR, 6,  0,  0)
#define ADDR_GROUP_ADDR		MKID(SUMIB_ADDR, 24, 6,  1)
#define ADDR_TX_EN			MKID(SUMIB_ADDR, 1,  30, 2)
#define ADDR_RSVD			MKID(SUMIB_ADDR, 1,  31, 3)


/*=============================================================*/
/*--- MAC MIB ------------- SU_MIB_MAC ------------------------*/

__WLAN_PRAGMA_PACK1__
typedef struct su_mib_mac
{
	UINT16	rsvd1								__WLAN_ATTRIB_PACK__;
	UINT16	rsvd2								__WLAN_ATTRIB_PACK__;
	UINT16	rts_threshold						__WLAN_ATTRIB_PACK__;
	UINT16	cw_max								__WLAN_ATTRIB_PACK__;
	UINT16	cw_min								__WLAN_ATTRIB_PACK__;
	UINT8	promisc_en							__WLAN_ATTRIB_PACK__;
	UINT8	rsvd3								__WLAN_ATTRIB_PACK__;
	UINT32	rsvd4								__WLAN_ATTRIB_PACK__;
	UINT8	short_retry_limit					__WLAN_ATTRIB_PACK__;
	UINT8	long_retry_limit					__WLAN_ATTRIB_PACK__;
	UINT16	max_frame_length					__WLAN_ATTRIB_PACK__;
	UINT16	fragmentation_threshold				__WLAN_ATTRIB_PACK__;
	UINT16	probe_delay							__WLAN_ATTRIB_PACK__;
	UINT16	min_probe_response_time				__WLAN_ATTRIB_PACK__;
	UINT16	max_probe_response_time				__WLAN_ATTRIB_PACK__;
	UINT32	max_tx_msdu_lifetime				__WLAN_ATTRIB_PACK__;
	UINT32	max_rx_msdu_lifetime				__WLAN_ATTRIB_PACK__;
	UINT16	sta_basic_rate						__WLAN_ATTRIB_PACK__;
	UINT8	desired_essid[WLAN_SSID_MAXLEN + 2]	__WLAN_ATTRIB_PACK__;
} su_mib_mac_t;
__WLAN_PRAGMA_PACKDFLT__

#define NITEMS_MIB_MAC				19
#define MAC_RSVD1					MKID(SUMIB_MAC, sizeof(UINT16),  0, 0)
#define MAC_RSVD2					MKID(SUMIB_MAC, sizeof(UINT16),  2, 1)
#define MAC_RTS_THRESHOLD			MKID(SUMIB_MAC, sizeof(UINT16),  4, 2)
#define MAC_CW_MAX					MKID(SUMIB_MAC, sizeof(UINT16),  6, 3)
#define MAC_CW_MIN					MKID(SUMIB_MAC, sizeof(UINT16),  8, 4)
#define MAC_PROMISC_EN				MKID(SUMIB_MAC, sizeof(UINT8),  10, 5)
#define MAC_RSVD3					MKID(SUMIB_MAC, sizeof(UINT8),  11, 6)
#define MAC_RSVD4					MKID(SUMIB_MAC, sizeof(UINT32), 12, 7)
#define MAC_SHORT_RETRY_LIMIT		MKID(SUMIB_MAC, sizeof(UINT8),  16, 8)
#define MAC_LONG_RETRY_LIMIT		MKID(SUMIB_MAC, sizeof(UINT8),  17, 9)
#define MAC_MAX_FRAME_LENGTH		MKID(SUMIB_MAC, sizeof(UINT16), 18, 10)
#define MAC_FRAG_THRESHOLD			MKID(SUMIB_MAC, sizeof(UINT16), 20, 11)
#define MAC_PROBE_DELAY				MKID(SUMIB_MAC, sizeof(UINT16), 22, 12)
#define MAC_MIN_PROBE_RESP_TIME		MKID(SUMIB_MAC, sizeof(UINT16), 24, 13)
#define MAC_MAX_PROBE_RESP_TIME		MKID(SUMIB_MAC, sizeof(UINT16), 26, 14)
#define MAC_MAX_TX_MSDU_LIFETIME	MKID(SUMIB_MAC, sizeof(UINT32), 28, 15)
#define MAC_MAX_RX_MSDU_LIFETIME	MKID(SUMIB_MAC, sizeof(UINT32), 32, 16)
#define MAC_STA_BASIC_RATE			MKID(SUMIB_MAC, sizeof(UINT16), 36, 17)
#define MAC_DESIRED_ESSID			MKID(SUMIB_MAC, sizeof(UINT8) * (WLAN_SSID_MAXLEN+2), 38, 18)


/*=============================================================*/
/*--- MAC Statistics MIB -- SU_MIB_MAC_STATISTICS -------------*/

__WLAN_PRAGMA_PACK1__
typedef struct su_mib_mac_statistics
{
	UINT32	tx_mpdu_cnt			__WLAN_ATTRIB_PACK__;
	UINT32	tx_msdu_cnt			__WLAN_ATTRIB_PACK__;
	UINT32	tx_octets_cnt		__WLAN_ATTRIB_PACK__;
	UINT16	tx_multicast_cnt	__WLAN_ATTRIB_PACK__;
	UINT16	tx_broadcast_cnt	__WLAN_ATTRIB_PACK__;
	UINT32	failed_cnt			__WLAN_ATTRIB_PACK__;
	UINT32	retry_cnt			__WLAN_ATTRIB_PACK__;
	UINT32	multiple_retry_cnt	__WLAN_ATTRIB_PACK__;
	UINT32	frame_dup_cnt		__WLAN_ATTRIB_PACK__;
	UINT32	rts_success_cnt		__WLAN_ATTRIB_PACK__;
	UINT32	rts_failure_cnt		__WLAN_ATTRIB_PACK__;
	UINT32	ack_failure_cnt		__WLAN_ATTRIB_PACK__;
	UINT32	rx_frame_cnt		__WLAN_ATTRIB_PACK__;
	UINT32	rx_octets_cnt		__WLAN_ATTRIB_PACK__;
	UINT16	rx_multicast_cnt	__WLAN_ATTRIB_PACK__;
	UINT16	rx_broadcast_cnt	__WLAN_ATTRIB_PACK__;
	UINT32	fcs_error_cnt		__WLAN_ATTRIB_PACK__;
	UINT32	error_cnt			__WLAN_ATTRIB_PACK__;
	UINT32	undecryptable_cnt	__WLAN_ATTRIB_PACK__;
} su_mib_mac_statistics_t;
__WLAN_PRAGMA_PACKDFLT__


#define NITEMS_MIB_STAT				19
#define STAT_TX_MPDU_CNT			MKID(SUMIB_STAT, sizeof(UINT32), 0, 0)
#define STAT_TX_MSDU_CNT			MKID(SUMIB_STAT, sizeof(UINT32), 4, 1)
#define STAT_TX_OCTETS_CNT			MKID(SUMIB_STAT, sizeof(UINT32), 8, 2)
#define STAT_TX_MULTICAST_CNT		MKID(SUMIB_STAT, sizeof(UINT16), 12, 3)
#define STAT_TX_BROADCAST_CNT		MKID(SUMIB_STAT, sizeof(UINT16), 14, 4)
#define STAT_FAILED_CNT				MKID(SUMIB_STAT, sizeof(UINT32), 16, 5)
#define STAT_RETRY_CNT				MKID(SUMIB_STAT, sizeof(UINT32), 20, 6)
#define STAT_MULTIPLE_RETRY_CNT		MKID(SUMIB_STAT, sizeof(UINT32), 24, 7)
#define STAT_FRAME_DUP_CNT			MKID(SUMIB_STAT, sizeof(UINT32), 28, 8)
#define STAT_RTS_SUCCESS_CNT		MKID(SUMIB_STAT, sizeof(UINT32), 32, 9)
#define STAT_RTS_FAILURE_CNT		MKID(SUMIB_STAT, sizeof(UINT32), 36, 10)
#define STAT_ACK_FAILURE_CNT		MKID(SUMIB_STAT, sizeof(UINT32), 40, 11)
#define STAT_RX_FRAME_CNT			MKID(SUMIB_STAT, sizeof(UINT32), 44, 12)
#define STAT_RX_OCTETS_CNT			MKID(SUMIB_STAT, sizeof(UINT32), 48, 13)
#define STAT_RX_MULTICAST_CNT		MKID(SUMIB_STAT, sizeof(UINT16), 52, 14)
#define STAT_RX_BROADCAST_CNT		MKID(SUMIB_STAT, sizeof(UINT16), 54, 15)
#define STAT_FCS_ERROR_CNT			MKID(SUMIB_STAT, sizeof(UINT32), 56, 16)
#define STAT_ERROR_CNT				MKID(SUMIB_STAT, sizeof(UINT32), 60, 17)
#define STAT_UNDECRYTABLE_CNT		MKID(SUMIB_STAT, sizeof(UINT32), 64, 18)


/*=============================================================*/
/*--- MAC Management MIB -- SU_MIB_MAC_MGMT -------------------*/

__WLAN_PRAGMA_PACK1__
typedef struct su_mib_mac_mgmt
{
	UINT8	pwr_mgmt_mode						__WLAN_ATTRIB_PACK__;
	UINT8	scan_mode							__WLAN_ATTRIB_PACK__;
	UINT8	scan_state							__WLAN_ATTRIB_PACK__;
	UINT8	dtim_period							__WLAN_ATTRIB_PACK__;
	UINT16	atim_window							__WLAN_ATTRIB_PACK__;
	UINT8	wep_required						__WLAN_ATTRIB_PACK__;
	UINT8	rsvd								__WLAN_ATTRIB_PACK__;
	UINT16	beacon_period						__WLAN_ATTRIB_PACK__;
	UINT16	passive_scan_duration				__WLAN_ATTRIB_PACK__;
	UINT16	listen_interval						__WLAN_ATTRIB_PACK__;
	UINT16	med_occupancy_limit					__WLAN_ATTRIB_PACK__;
	UINT16	max_mpdu_time						__WLAN_ATTRIB_PACK__;
	UINT16	cfp_max_duration					__WLAN_ATTRIB_PACK__;
	UINT8	cfp_rate							__WLAN_ATTRIB_PACK__;
	UINT8	dont_rx_dtim						__WLAN_ATTRIB_PACK__;
	UINT16	station_id							__WLAN_ATTRIB_PACK__;
	UINT8	current_bssid[WLAN_BSSID_LEN]		__WLAN_ATTRIB_PACK__;
	UINT8	current_essid[WLAN_SSID_MAXLEN + 2]	__WLAN_ATTRIB_PACK__;
} su_mib_mac_mgmt_t;
__WLAN_PRAGMA_PACKDFLT__

/* PWR_MGMT_MODE constants */
#define SUMIB_PWR_MGMT_MODE_ACTIVE	0x00
#define SUMIB_PWR_MGMT_MODE_PSMODE	0x10

/* SCAN_MODE constants */
#define SUMIB_SCANMODE_PASSIVE			0x00
#define SUMIB_SCANMODE_ACTIVE			0x01
#define SUMIB_SCANMODE_BACKGROUND		0x02

/* SCAN_STATE constants */
#define SUMIB_SCANSTATE_IDLE			0x00
#define SUMIB_SCANSTATE_PASSIVE			0x01
#define SUMIB_SCANSTATE_PROBEDELAY		0x02
#define SUMIB_SCANSTATE_MINPROBERESP	0x03
#define SUMIB_SCANSTATE_MAXPROBERESP	0x04

/* WEP_REQUIRED constants */
#define SUMIB_WEP_REQUIRED_NO			0x00
#define SUMIB_WEP_REQUIRED_YES			0x10

/* Item IDs */
#define NITEMS_MIB_MGMT				18
#define MGMT_PWR_MGMT_MODE			MKID(SUMIB_MGMT, sizeof(UINT8),  0, 0)
#define MGMT_SCAN_MODE				MKID(SUMIB_MGMT, sizeof(UINT8),  1, 1)
#define MGMT_SCAN_STATE				MKID(SUMIB_MGMT, sizeof(UINT8),  2, 2)
#define MGMT_DTIM_PERIOD			MKID(SUMIB_MGMT, sizeof(UINT8),  3, 3)
#define MGMT_ATIM_WINDOW			MKID(SUMIB_MGMT, sizeof(UINT16), 4, 4)
#define MGMT_WEP_REQUIRED			MKID(SUMIB_MGMT, sizeof(UINT8),  6, 5)
#define MGMT_RSVD					MKID(SUMIB_MGMT, sizeof(UINT8),  7, 6)
#define MGMT_BEACON_PERIOD			MKID(SUMIB_MGMT, sizeof(UINT16), 8, 7)
#define MGMT_PASSIVE_SCAN_DUR		MKID(SUMIB_MGMT, sizeof(UINT16), 10, 8)
#define MGMT_LISTEN_INTERVAL		MKID(SUMIB_MGMT, sizeof(UINT16), 12, 9)
#define MGMT_MED_OCCUPANCY_LIMIT	MKID(SUMIB_MGMT, sizeof(UINT16), 14, 10)
#define MGMT_MAX_MPDU_TIME			MKID(SUMIB_MGMT, sizeof(UINT16), 16, 11)
#define MGMT_CFP_MAX_DURATION		MKID(SUMIB_MGMT, sizeof(UINT16), 18, 12)
#define MGMT_CFP_RATE				MKID(SUMIB_MGMT, sizeof(UINT8),  20, 13)
#define MGMT_DONT_RX_DTIM			MKID(SUMIB_MGMT, sizeof(UINT8),  21, 14)
#define MGMT_STATION_ID				MKID(SUMIB_MGMT, sizeof(UINT16), 22, 15)
#define MGMT_CURRENT_BSSID			MKID(SUMIB_MGMT, WLAN_BSSID_LEN, 24, 16)
#define MGMT_CURRENT_ESSID	  MKID(SUMIB_MGMT, WLAN_SSID_MAXLEN + 2, 30, 17)

/*=============================================================*/
/*--- Driver MAC Mgmt MIB - SU_MIB_DRVR_MAC_MGMT --------------*/

/* Size contstants */
#define	SUMIB_MAX_AUTH_ALG			2		/*TBD*/
#define SUMIB_MAX_DEF_WEP_KEYS		4		/*TBD*/
#define	SUMIB_MAX_WEP_KEY_MAPS		4		/*TBD*/
#define SUMIB_MAX_KNOWN_APS			4		/*TBD*/

__WLAN_PRAGMA_PACK1__
typedef struct su_mib_drvr_mac_mgmt
{
	UINT8	privacy_option_implemented				__WLAN_ATTRIB_PACK__;
	UINT8	wep_default								__WLAN_ATTRIB_PACK__;
	UINT8	exclude_unencrypted						__WLAN_ATTRIB_PACK__;
	UINT8	associate_state							__WLAN_ATTRIB_PACK__;
	UINT8	auth_algorithms[SUMIB_MAX_AUTH_ALG]		__WLAN_ATTRIB_PACK__;
	UINT8	auth_type								__WLAN_ATTRIB_PACK__;
	UINT8	privacy_invoked							__WLAN_ATTRIB_PACK__;
	UINT32	default_wep_key[SUMIB_MAX_DEF_WEP_KEYS]	__WLAN_ATTRIB_PACK__;
	UINT32	icv_err_cnt								__WLAN_ATTRIB_PACK__;
	UINT32	wep_key_mapping[SUMIB_MAX_WEP_KEY_MAPS]	__WLAN_ATTRIB_PACK__;
	UINT8	known_aps[SUMIB_MAX_KNOWN_APS][WLAN_BSSID_LEN]	__WLAN_ATTRIB_PACK__;
} su_mib_drvr_mac_mgmt_t;
__WLAN_PRAGMA_PACKDFLT__

#define NITEMS_MIB_DRVR				11
#define DRVR_PRIV_OPT_IMP			MKID(SUMIB_DRVR, sizeof(UINT8), 0, 0)
#define DRVR_WEP_DEFAULT			MKID(SUMIB_DRVR, sizeof(UINT8), 1, 1)
#define DRVR_EXCLUDE_UNENCRYPTED	MKID(SUMIB_DRVR, sizeof(UINT8), 2, 2)
#define DRVR_ASSOCIATE_STATE		MKID(SUMIB_DRVR, sizeof(UINT8), 3, 3)
#define DRVR_AUTH_ALGORITHMS		MKID(SUMIB_DRVR, sizeof(UINT8) * SUMIB_MAX_AUTH_ALG, 4, 4)
#define DRVR_AUTH_TYPE				MKID(SUMIB_DRVR, sizeof(UINT8), 6, 5)
#define DRVR_PRIVACY_INVOKED		MKID(SUMIB_DRVR, sizeof(UINT8), 7, 6)
#define DRVR_DEFAULT_WEP_KEY		MKID(SUMIB_DRVR, sizeof(UINT32)*SUMIB_MAX_DEF_WEP_KEYS, 8, 7)
#define DRVR_ICV_ERR_CNT			MKID(SUMIB_DRVR, sizeof(UINT32), 24, 8)
#define DRVR_WEP_KEY_MAPPING		MKID(SUMIB_DRVR, sizeof(UINT32)*SUMIB_MAX_WEP_KEY_MAPS, 28, 9)
#define DRVR_KNOWN_APS				MKID(SUMIB_DRVR, SUMIB_MAX_KNOWN_APS * WLAN_BSSID_LEN, 44, 10)


/*=============================================================*/
/*--- Physical Layer MIB -- SU_MIB_PHY ------------------------*/

#define SUMIB_MAX_SUPP_DATA_RATES	4
#define SUMIB_MAX_PWR_UP_TIME		4
#define SUMIB_MAX_RCR				8

__WLAN_PRAGMA_PACK1__
typedef struct su_mib_phy
{
	UINT16	slot_time										__WLAN_ATTRIB_PACK__;
	UINT16	sifs											__WLAN_ATTRIB_PACK__;
	UINT16	mpdu_max										__WLAN_ATTRIB_PACK__;
	UINT16	hop_time										__WLAN_ATTRIB_PACK__;
	UINT8	supported_data_rates[SUMIB_MAX_SUPP_DATA_RATES]	__WLAN_ATTRIB_PACK__;
	UINT8	current_reg_domain								__WLAN_ATTRIB_PACK__;
	UINT8	preamble_length									__WLAN_ATTRIB_PACK__;
	UINT8	plcp_hdr_length									__WLAN_ATTRIB_PACK__;
	UINT16	pwr_up_time[SUMIB_MAX_PWR_UP_TIME]				__WLAN_ATTRIB_PACK__;
	UINT8	phy_type										__WLAN_ATTRIB_PACK__;
	UINT8	RCR_33A_bits[SUMIB_MAX_RCR]						__WLAN_ATTRIB_PACK__;
} su_mib_phy_t;
__WLAN_PRAGMA_PACKDFLT__

#define NITEMS_MIB_PHY				11
#define PHY_SLOT_TIME				MKID(SUMIB_PHY, sizeof(UINT16), 0, 0)
#define PHY_SIFS					MKID(SUMIB_PHY, sizeof(UINT16), 2, 1)
#define PHY_MPDU_MAX				MKID(SUMIB_PHY, sizeof(UINT16), 4, 2)
#define PHY_HOP_TIME				MKID(SUMIB_PHY, sizeof(UINT16), 6, 3)
#define PHY_SUPPORTED_DATA_RATES	MKID(SUMIB_PHY, sizeof(UINT8) * SUMIB_MAX_SUP_DATA_RATES, 8, 4)
#define PHY_CURRENT_REG_DOMAIN		MKID(SUMIB_PHY, sizeof(UINT8), 12, 5)
#define PHY_PREAMBLE_LENGTH			MKID(SUMIB_PHY, sizeof(UINT8), 13, 6)
#define PHY_PLCP_HDR_LENGTH			MKID(SUMIB_PHY, sizeof(UINT8), 14, 7)
#define PHY_PWR_UP_TIME				MKID(SUMIB_PHY, sizeof(UINT16) * SUMIB_MAX_PWR_UP_TIME, 15, 8)
#define PHY_PHY_TYPE				MKID(SUMIB_PHY, sizeof(UINT8), 23, 9)
#define PHY_RCR_33A_BITS			MKID(SUMIB_PHY, sizeof(UINT8) * SUMIB_MAX_RCR, 24, 10)

#endif /* _LINUX_AM930HW_MIB_H */

