/* wlan_ioctl.h: Declares constants and types for the private ioctls
*	--------------------------------------------------------------------
*
*   Linux WLAN 
*
*   The contents of this file are subject to the Mozilla Public
*   License Version 1.0 (the "License"); you may not use this file
*   except in compliance with the License. You may obtain a copy of
*   the License at http://www.mozilla.org/MPL/
*
*   Software distributed under the License is distributed on an "AS
*   IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
*   implied. See the License for the specific language governing
*   rights and limitations under the License.
*
*   The initial developer of the original code is Mark S. Mathews
*   <mark@absoval.com>.  Portions created by Mark S. Mathews
*   are Copyright (C) 1998 AbsoluteValue Software, Inc.  All Rights Reserved.
*    
*	--------------------------------------------------------------------
*/

#ifndef _LINUX_WLAN_IOCTL_H
#define _LINUX_WLAN_IOCTL_H

/* netlink i/f constants */
#define NETLINK_WLAN	NETLINK_USERSOCK

/* ioctl cmd codes */
#define WLAN_TEST			(SIOCDEVPRIVATE + 0)
#define WLAN_SCAN			(SIOCDEVPRIVATE + 1)
#define WLAN_NETLIST_LEN	(SIOCDEVPRIVATE + 2)
#define WLAN_NETLIST		(SIOCDEVPRIVATE + 3)
#define WLAN_BSSCREATE		(SIOCDEVPRIVATE + 4)
#define WLAN_BSSJOIN		(SIOCDEVPRIVATE + 5)
#define WLAN_GETMIB			(SIOCDEVPRIVATE + 6)
#define WLAN_GETMIBITEM		(SIOCDEVPRIVATE + 7)
#define WLAN_SETMIBITEM		(SIOCDEVPRIVATE + 8)
#define WLAN_PRIVACY		(SIOCDEVPRIVATE + 9)
#define WLAN_ETHCONV		(SIOCDEVPRIVATE + 10)
#define WLAN_SNIFFERCMD		(SIOCDEVPRIVATE + 11)
#define WLAN_AUTHENTICATE	(SIOCDEVPRIVATE + 12)
#define WLAN_ASSOCIATE		(SIOCDEVPRIVATE + 13)

typedef struct wlan_req
{
	char 	name[16]	__WLAN_ATTRIB_PACK__;
	void	*data		__WLAN_ATTRIB_PACK__;
	UINT16	result		__WLAN_ATTRIB_PACK__;
	UINT16	len			__WLAN_ATTRIB_PACK__;
} wlan_req_t;


#define BSSTYPE_IND		BIT0
#define BSSTYPE_INFRA	BIT1

typedef struct wlan_scan
{
	UINT	scantype;
	UINT	bsstype;
	UINT8	bssid[WLAN_BSSID_LEN];
	UINT	startch;
	UINT	endch;
	UINT	timech;
	UINT8	ssid[WLAN_SSID_MAXLEN + 2];
} wlan_scan_t;

typedef struct wlan_netlist_len
{
	UINT	nitems;
} wlan_netlist_len_t;

typedef struct netitem
{
	UINT	channel;
	UINT8	bssid[WLAN_BSSID_LEN];
	UINT	bcn_int;
	UINT16	cap_info;
	UINT8	ssid[WLAN_SSID_MAXLEN + 2];
} netitem_t;

typedef struct wlan_netlist
{
	UINT		nitems;
	netitem_t	netlist[0];
} wlan_netlist_t;

typedef struct wlan_bsscreate
{
	UINT32	channel;
	char	ssid[WLAN_SSID_MAXLEN];
	UINT32	beacon_int;
	UINT32	atim_win;
} wlan_bsscreate_t;

typedef struct wlan_bssjoin
{
	UINT8	bssid[WLAN_BSSID_LEN];
} wlan_bssjoin_t;

typedef struct wlan_getmib
{
	UINT32	mibcode;
	union _data
	{
		su_mib_local_t				local;
		su_mib_mac_addr_stat_grp_t	addr;
		su_mib_mac_t				mac;
		su_mib_mac_statistics_t		stats;
		su_mib_mac_mgmt_t			mgmt;
		su_mib_drvr_mac_mgmt_t		drvr;
		su_mib_phy_t				phy;
	} data;
} wlan_getmib_t;


typedef struct wlan_privacy
{
	UINT	defkey;
	UINT	exclude_unencrypted;
	UINT8	keys[WLAN_WEP_NKEYS][WLAN_WEP_KEYLEN];
} wlan_privacy_t;


#define WLAN_ETHCONV_ENCAP		1
#define WLAN_ETHCONV_RFC1042	2
#define WLAN_ETHCONV_8021h		3

typedef struct wlan_ethconv
{
	UINT	ethconv_type;
} wlan_ethconv_t;


#define SNIFFERCMD_REG		1
#define SNIFFERCMD_UNREG	2

#define SNIFFLAG_SNIFRX			0x01
#define SNIFFLAG_SNIFTX			0x08

typedef struct wlan_sniffercmd
{
	UINT	cmd;
	UINT	pid;	/* I know, I could get this from current...I'm lazy */
	UINT	flags;	/* SNIFRX is assumed, all others must be explicitly set */
	UINT	result;	/* Set by driver and returned */
} wlan_sniffercmd_t;

/*------------------------------------------------------------------*/
/* The following type is the header for netlink messages containing */
/* sniffed frames.                                                  */

typedef struct wlan_sniffer_t
{
	UINT32	time	/* in jiffies */	__WLAN_ATTRIB_PACK__;
	UINT8	rssi						__WLAN_ATTRIB_PACK__;
	UINT8	ch							__WLAN_ATTRIB_PACK__;
	UINT8	rate						__WLAN_ATTRIB_PACK__;
	UINT8	istx						__WLAN_ATTRIB_PACK__;
	UINT32	len							__WLAN_ATTRIB_PACK__;
} wlan_sniffer_t;


#endif
