/* wlan_stable.h: Elements for the Station Table
*	--------------------------------------------------------------------
*
*   Linux WLAN 
*
*   The contents of this file are subject to the Mozilla Public
*   License Version 1.0 (the "License"); you may not use this file
*   except in compliance with the License. You may obtain a copy of
*   the License at http://www.mozilla.org/MPL/
*
*   Software distributed under the License is distributed on an "AS
*   IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
*   implied. See the License for the specific language governing
*   rights and limitations under the License.
*
*   The initial developer of the original code is Mark S. Mathews
*   <mark@absoval.com>.  Portions created by Mark S. Mathews
*   are Copyright (C) 1998 AbsoluteValue Software, Inc.  All Rights Reserved.
*
*	--------------------------------------------------------------------
*/

#ifndef _WLAN_STABLE_H
#define _WLAN_STABLE_H

typedef struct wlan_stable_sinfo
{
	UINT8		addr[WLAN_ADDR_LEN];
	UINT32		state;					/* see WLAN_STA_STATE_xxx */
	UINT32		info;					/* see WLAN_STA_INFO_xxx */
	UINT16		listen_int;
	UINT16		max_rate;
	UINT16		rate;
	UINT8		last_rssi;
	UINT16		last_seq;
	UINT32		last_rxtime;
	UINT32		ndataqueued;
	UINT32		npsqueued;
	UINT32		ps_stale;
	UINT32		timer;
	UINT32		timeout;
	UINT32		timer_state;			/* see WLAN_STA_TSTATE_xxx */
	UINT16		aid;
} wlan_stable_sinfo_t;


#define WLAN_STA_TSTATE_IDLE		0x00	/* not timing */
#define WLAN_STA_TSTATE_AUTH		0x01	/* timing an auth exchange (AP&STA) */
#define WLAN_STA_TSTATE_ASSOC		0x02	/* timing an assoc exchage (STA only, INFRA) */
#define WLAN_STA_TSTATE_ACTIVITY	0x03	/* timing rx activity (AP) */
#define WLAN_STA_TSTATE_BEACON		0x04	/* timing beacon activity (STA, INFRA) */

#define WLAN_STA_STATE_FREE				0x00
#define WLAN_STA_STATE_PENDING_ACTIVE	0x01
#define WLAN_STA_STATE_PENDING_REMOVAL	0x02
#define WLAN_STA_STATE_ACTIVE			0x03

#define WLAN_STA_INFO_AUTH				BIT0
#define WLAN_STA_INFO_ASSOC				BIT1
#define WLAN_STA_INFO_PSMODE			BIT2
#define WLAN_STA_INFO_ETHENCAP			BIT3
#define WLAN_STA_INFO_CFAWARE			BIT4
#define WLAN_STA_INFO_POLLLIST			BIT5
#define WLAN_STA_INFO_WEPON				BIT6
#define WLAN_STA_INFO_USE_PKEY			BIT7

/* state pending active && info no auth, means we're waiting on auth to finish */

typedef struct wlan_stable_stats
{
	UINT32		retry_rate;
	UINT32		difs_attempts;
	UINT32		difs_failures;
	UINT32		sifs_attempts;
	UINT32		sifs_failures;
	UINT32		rts_attempts;
	UINT32		data_attempts;
	UINT32		rx_msdu;
	UINT32		tx_msdu;
	UINT32		ps_timeout_count;
} wlan_stable_stats_t;

#endif
