#include <stdlib.h>
#include <stdio.h>
#include <wlan/wlan_compat.h>
#include <wlan/p80211hdr.h>


void zoomair_wepgen(char *genstr, UINT8 wep_key[WLAN_WEP_NKEYS][WLAN_WEP_KEYLEN]);

int main(int argc, char *argv[])
{
	UINT8	wep_key[WLAN_WEP_NKEYS][WLAN_WEP_KEYLEN];
	int		i;
	int		j;

	if ( argc < 2 )
	{
		printf("zwepgen: generates ZoomAir compatible WEP keys from a string\n");
		printf("  Usage:  zwepgen <genstr>\n");
		return 0;
	}

	zoomair_wepgen( argv[1], wep_key);

	for ( i = 0; i < WLAN_WEP_NKEYS; i++)
	{
		printf("%d-", i);
		for ( j=0; j < WLAN_WEP_KEYLEN; j++)
		{
			printf("%02x", wep_key[i][j]);
			if ( j < WLAN_WEP_KEYLEN - 1)
			{
				printf(":");
			}
		}
		printf("\n");
	}

	return 0;
}

/*----------------------------------------------------------------
* 	zoomair_wepgen
*
*	Generates a set of WEP keys from a generator string.  This is 
*	intendedas a convenience.  Entering 20 hex bytes can be a pain.
*
*	This function was authored by Zoom Telephonics Engineer Juan Arango.
*
*	Juan's Note: 
*		Changing the code in this function could make this product 
*		incompatible with other ZoomAir wireless products because 
*		these other products rely on Microsoft's rand() and srand() 
*		function implementations!!!  This code uses the same algorithm.
*
*	Arguments:
*		genstr		a null terminated string
*		wep_key     a 2d array that is filled with the wep keys
*
*
* NOTE: this code belongs to Zoom!!!! Don't distribute w/out permission
*
----------------------------------------------------------------*/
void zoomair_wepgen(char *genstr, UINT8 wep_key[WLAN_WEP_NKEYS][WLAN_WEP_KEYLEN])
{
    unsigned int i,j;
    unsigned char pseed[4]={0,0,0,0};
    unsigned int len;
    int randNumber=0;

	len = strlen(genstr);
    if (len)
    {
        // generate seed for random number generator using key string...
        for (i=0; i<len; i++)
        {
            pseed[i%4]^= genstr[i];
        }

        // init PRN generator... note that this is equivalent to the Microsoft srand() function...
        randNumber = (int)pseed[0] | ((int)pseed[1])<<8 | ((int)pseed[2])<<16 | ((int)pseed[3])<<24;

        // generate keys... 
        for (i=0; i<4; i++)
        {
            for (j=0; j<5; j++)
            {
                // Note that these three lines are equivalent to the Microsoft rand() function...
                randNumber *= 0x343fd;
                randNumber += 0x269ec3;
                wep_key[i][j] = (unsigned char)( (randNumber>>16) & 0x7fff);
            }
        }
    }
    return;
}
