/*


    Linux WLAN 

    The contents of this file are subject to the Mozilla Public
    License Version 1.0 (the "License"); you may not use this file
    except in compliance with the License. You may obtain a copy of
    the License at http://www.mozilla.org/MPL/

    Software distributed under the License is distributed on an "AS
    IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
    implied. See the License for the specific language governing
    rights and limitations under the License.

    The initial developer of the original code is Mark S. Mathews
    <mark@absoval.com>.  Portions created by Mark S. Mathews
    are Copyright (C) 1998 AbsoluteValue Software, Inc.  All Rights Reserved.
    
*/

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <sys/socket.h>
#include <sys/types.h>
#include <sys/ioctl.h>
#include <wlan/wlan_compat.h>
#include <wlan/am930mib.h>
#include <wlan/wlan_ioctl.h>
#include "prmib.h"

void mac2str( UINT8 *ma, char *str)
{
	sprintf( str, "%02x:%02x:%02x:%02x:%02x:%02x", 
		ma[0], ma[1], ma[2], ma[3], ma[4], ma[5]);
}

void prlocalmib( su_mib_local_t *mib ) 
{
	char tmp[18];
	printf("LOCAL MIB:\n");
	sprintf( tmp, "0x%02x", mib->frag_disable);
	printf("%20s: %-16s  ", "frag_dis", tmp);
	sprintf( tmp, "0x%02x", mib->add_plcp_disable);
	printf("%20s: %-16s\n", "add_plcp_dis", tmp);

	sprintf( tmp, "0x%02x", mib->add_plcp_disable);
	printf("%20s: %-16s  ", "add_plcp_disable", tmp);
	sprintf( tmp, "0x%02x", mib->mac_hdr_preserve);
	printf("%20s: %-16s\n", "mac_hdr_preserve", tmp);

	sprintf( tmp, "0x%02x", mib->rx_mgmt_q_enable);
	printf("%20s: %-16s  ", "rx_mgmt_q_enable", tmp);

	sprintf( tmp, "0x%02x", mib->reassembly_disable);
	printf("%20s: %-16s  ", "reassembly_disable", tmp);
	sprintf( tmp, "0x%02x", mib->strip_plcp_disable);
	printf("%20s: %-16s\n", "strip_plcp_disable", tmp);

	sprintf( tmp, "0x%02x", mib->rx_error_disable);
	printf("%20s: %-16s  ", "rx_error_disable", tmp);
	sprintf( tmp, "0x%02x", mib->power_save_mode_disable);
	printf("%20s: %-16s\n", "pwr_save_mode_dis", tmp);

	sprintf( tmp, "0x%02x", mib->accept_all_multicast_disable);
	printf("%20s: %-16s  ", "accept_all_multi_dis", tmp);
	sprintf( tmp, "0x%02x", mib->check_seq_cntl_disable);
	printf("%20s: %-16s\n", "chk_seq_cntl_dis", tmp);

/*	sprintf( tmp, "0x%02x", mib->loopback);
	printf("%20s: %-16s  ", "loopback", tmp);
*/
 	sprintf( tmp, "0x%02x", mib->network_mode);
	printf("%20s: %-16s\n", "network_mode", tmp);

	sprintf( tmp, "0x%02x", mib->pwd_level);
	printf("%20s: %-16s  ", "pwd_level", tmp);
/*	sprintf( tmp, "0x%02x", mib->phy_type);
	printf("%20s: %-16s\n", "phy_type", tmp);
*/
	sprintf( tmp, "0x%04lx", mib->tx_buffer_offset);
	printf("%20s: %-16s  ", "tx_buffer_offset", tmp);
	sprintf( tmp, "0x%04lx", mib->tx_buffer_size);
	printf("%20s: %-16s\n", "tx_buffer_size", tmp);
	
	sprintf( tmp, "0x%04lx", mib->rx_buffer_offset);
	printf("%20s: %-16s  ", "rx_buffer_offset", tmp);
	sprintf( tmp, "0x%04lx", mib->rx_buffer_size);
	printf("%20s: %-16s\n", "rx_buffer_size", tmp);
}

void prstatsmib( su_mib_mac_statistics_t *mib ) 
{
	char tmp[18];
	printf("STATISTICS MIB:\n");
	sprintf( tmp, "%lud",  mib->tx_mpdu_cnt);
	printf("%20s: %-16s  ", "tx_mpdu_cnt", tmp);
	sprintf( tmp, "%lud", mib->tx_msdu_cnt);
	printf("%20s: %-16s\n", "tx_msdu_cnt", tmp);
	
	sprintf( tmp, "%lud", mib->tx_octets_cnt);
	printf("%20s: %-16s  ", "tx_octets_cnt", tmp);
	sprintf( tmp, "%ud", mib->tx_multicast_cnt);
	printf("%20s: %-16s\n", "tx_multicast_cnt", tmp);

	sprintf( tmp, "%ud", mib->tx_broadcast_cnt);
	printf("%20s: %-16s  ", "tx_broadcast_cnt", tmp);
	sprintf( tmp, "%lud", mib->failed_cnt);
	printf("%20s: %-16s\n", "failed_cnt", tmp);

	sprintf( tmp, "%lud", mib->retry_cnt);
	printf("%20s: %-16s  ", "retry_cnt", tmp);
	sprintf( tmp, "%lud", mib->multiple_retry_cnt);
	printf("%20s: %-16s\n", "multiple_retry_cnt", tmp);

	sprintf( tmp, "%lud", mib->frame_dup_cnt);
	printf("%20s: %-16s  ", "frame_dup_cnt", tmp);
	sprintf( tmp, "%lud", mib->rts_success_cnt);
	printf("%20s: %-16s\n", "rts_success_cnt", tmp);

	sprintf( tmp, "%lud", mib->rts_failure_cnt);
	printf("%20s: %-16s  ", "rts_failure_cnt", tmp);
	sprintf( tmp, "%lud", mib->ack_failure_cnt);
	printf("%20s: %-16s\n", "ack_failure_cnt", tmp);

	sprintf( tmp, "%lud", mib->rx_frame_cnt);
	printf("%20s: %-16s  ", "rx_frame_cnt", tmp);
	sprintf( tmp, "%lud", mib->rx_octets_cnt);
	printf("%20s: %-16s\n", "rx_octets_cnt", tmp);

	sprintf( tmp, "%ud", mib->rx_multicast_cnt);
	printf("%20s: %-16s  ", "rx_multicast_cnt", tmp);
	sprintf( tmp, "%ud", mib->rx_broadcast_cnt);
	printf("%20s: %-16s\n", "rx_broadcast_cnt", tmp);

	sprintf( tmp, "%lud", mib->fcs_error_cnt);
	printf("%20s: %-16s  ", "fcs_error_cnt", tmp);
	sprintf( tmp, "%lud", mib->error_cnt);
	printf("%20s: %-16s\n", "error_cnt", tmp);

}


void praddrmib( su_mib_mac_addr_stat_grp_t *mib )
{
	char	tmp[40];
	int		i;

	printf("ADDRESS MIB:\n");

	mac2str( mib->mac_address, tmp);
	printf("%20s: %-16s\n", "mac_address", tmp);
	for ( i = 0; i < SUMIB_MAX_GRP_ADDR; i+=2)
	{
		mac2str( mib->group_addresses[i], tmp);
		printf("%17s[%1d]: %-16s  ", "grp_addr", i, tmp);
		mac2str( mib->group_addresses[i+1], tmp);
		printf("%17s[%1d]: %-16s\n", "grp_addr", i + 1, tmp);
	}
	sprintf(tmp, "0x%02x", mib->tx_enable_status);
	printf("%20s: %-16s\n", "tx_ena_status", tmp);
}


void prmacmib( su_mib_mac_t *mib )
{
	char			tmp[80];

	printf("MAC MIB:\n");

/*
	sprintf(tmp, "%ud", mib->rate_factor); 
	printf( "%20s: %-16s  ", "rate_factor", tmp);
	sprintf(tmp, "%ud", mib->handshake_overhead);
	printf( "%20s: %-16s\n", "handshake_overhead", tmp);
*/

	sprintf(tmp, "%ud", mib->rts_threshold);
	printf( "%20s: %-16s  ", "rts_threshold", tmp);
	sprintf(tmp, "%ud", mib->cw_max);
	printf( "%20s: %-16s\n", "cw_max", tmp);

	sprintf(tmp, "%ud", mib->cw_min);
	printf("%20s: %-16s  ", "cw_min", tmp);
/*	sprintf(tmp, "%ud", mib->cts_time);
	printf("%20s: %-16s\n", "cts_time", tmp);
*/
	sprintf(tmp, "0x%02x", mib->promisc_en);
	printf("%20s: %-16s\n", "promiscuous_status", tmp);

/*
	sprintf(tmp, "%ud", mib->ack_time);
	printf("%20s: %-16s  ", "ack_time", tmp);
	sprintf(tmp, "%ud", mib->ack_timeout);
	printf("%20s: %-16s\n", "ack_timeout", tmp);

	sprintf(tmp, "%ud", mib->cts_timeout);
	printf("%20s: %-16s  ", "cts_timeout", tmp);
*/
	sprintf(tmp, "%ud", mib->short_retry_limit);
	printf("%20s: %-16s\n", "short_retry_limit", tmp);

	sprintf(tmp, "%ud", mib->long_retry_limit);
	printf("%20s: %-16s  ", "long_retry_limit", tmp);
	sprintf(tmp, "%ud", mib->max_frame_length);
	printf("%20s: %-16s\n", "max_frame_length", tmp);

	sprintf(tmp, "%ud", mib->fragmentation_threshold);
	printf("%20s: %-16s  ", "frag_threshold", tmp);
	sprintf(tmp, "%ud", mib->probe_delay);
	printf("%20s: %-16s\n", "probe_delay", tmp);

	sprintf(tmp, "%ud", mib->min_probe_response_time);
	printf("%20s: %-16s  ", "min_probe_resp_time", tmp);
	sprintf(tmp, "%ud", mib->max_probe_response_time);
	printf("%20s: %-16s\n", "max_probe_resp_time", tmp);

	sprintf(tmp, "%lud", mib->max_tx_msdu_lifetime);
	printf("%20s: %-16s  ", "max_tx_msdu_lifetime", tmp);
	sprintf(tmp, "%lud", mib->max_rx_msdu_lifetime);
	printf("%20s: %-16s\n", "max_rx_msdu_lifetime", tmp);

	sprintf(tmp, "%ud", mib->sta_basic_rate);
	printf("%20s: %-16s\n", "sta_basic_rate", tmp);

	strncpy( tmp, &mib->desired_essid[2], mib->desired_essid[1]);
	tmp[mib->desired_essid[1]] = '\0';
	printf("%20s: %s\n", "desired_essid", tmp);
}


void prmgmtmib( su_mib_mac_mgmt_t *mib )
{
	char			tmp[80];

	printf("MAC MGMT MIB:\n");

	sprintf(tmp, "0x%x", mib->pwr_mgmt_mode);
	printf("%20s: %-16s  ", "pwr_mgmt_mode", tmp);
	sprintf(tmp, "0x%x", mib->scan_mode);
	printf("%20s: %-16s\n", "scan_mode", tmp);

	sprintf(tmp, "0x%x", mib->scan_state);
	printf("%20s: %-16s  ", "scan_state", tmp);
	sprintf(tmp, "0x%x", mib->dtim_period);
	printf("%20s: %-16s\n", "dtim_period", tmp);

	sprintf(tmp, "0x%x", mib->atim_window);
	printf("%20s: %-16s  ", "atim_window", tmp);
	sprintf(tmp, "0x%x", mib->beacon_period);
	printf("%20s: %-16s\n", "beacon_period", tmp);

	sprintf(tmp, "0x%x", mib->passive_scan_duration);
	printf("%20s: %-16s  ", "passive_scan_dur", tmp);
	sprintf(tmp, "0x%x", mib->listen_interval);
	printf("%20s: %-16s\n", "listen_interval", tmp);

	sprintf(tmp, "0x%x", mib->med_occupancy_limit);
	printf("%20s: %-16s  ", "med_occupancy_limit", tmp);
	sprintf(tmp, "0x%x", mib->max_mpdu_time);
	printf("%20s: %-16s\n", "max_mpdu_time", tmp);

	sprintf(tmp, "0x%x", mib->cfp_max_duration);
	printf("%20s: %-16s  ", "cfp_max_duration", tmp);
	sprintf(tmp, "0x%x", mib->cfp_rate);
	printf("%20s: %-16s\n", "cfp_rate", tmp);

	sprintf(tmp, "0x%x", mib->station_id);
	printf("%20s: %-16s  ", "station_id", tmp);
	mac2str(mib->current_bssid, tmp);
	printf("%20s: %-16s\n", "current_bssid", tmp);

	strncpy( tmp, &mib->current_essid[2], mib->current_essid[1]);

	{
	   int i;

	   for ( i = 0; i < (WLAN_SSID_MAXLEN + 2); i++ )
	      printf("mib->current_essid[%d] = %lu, 0x%02lx, %c\n", i,
	              (unsigned long)mib->current_essid[i],
	              (unsigned long)mib->current_essid[i],
	              (char)mib->current_essid[i]);
	}
/*
	tmp[mib->current_essid[1]] = '\0';
	printf("%20s: %s\n", "current_essid", tmp);
*/
}

void prdrvrmib( su_mib_drvr_mac_mgmt_t *mib )
{
	printf("DRVR MAC MGMT MIB:\n");
	printf("	Currently unsupported\n\n");
}


void prphymib( su_mib_phy_t *mib )
{
	char tmp[40];
	printf("PHY MIB:\n");

	sprintf(tmp, "%ud", mib->slot_time);
	printf("%20s: %-16s  ", "slot_time", tmp);
	sprintf(tmp, "%ud", mib->sifs);
	printf("%20s: %-16s\n", "sifs", tmp);

	sprintf(tmp, "%ud", mib->mpdu_max);
	printf("%20s: %-16s  ", "mpdu_max", tmp); 
	sprintf(tmp, "%ud", mib->hop_time);
	printf("%20s: %-16s\n", "hop_time", tmp);

	sprintf(tmp, "%ud", mib->preamble_length);
	printf("%20s: %-16s  ", "preamble_length", tmp); 
	sprintf(tmp, "%ud", mib->plcp_hdr_length);
	printf("%20s: %-16s\n", "plcp_hdr_length", tmp);

	sprintf(tmp, "0x%x", mib->current_reg_domain);		
	printf("%20s: %-16s\n", "current_reg_domain", tmp);

	sprintf(tmp, "0x%02x, 0x%02x, 0x%02x, 0x%02x", 
		mib->supported_data_rates[0],
		mib->supported_data_rates[1],
		mib->supported_data_rates[2],
		mib->supported_data_rates[3] );
	printf("%20s: %-16s\n", "supp_data_rates", tmp);

	sprintf(tmp, "%ud, %ud, %ud, %ud", mib->pwr_up_time[0], 
		mib->pwr_up_time[1], mib->pwr_up_time[2], mib->pwr_up_time[3] );
	printf("%20s: %-16s\n", "pwr_up_times", tmp);
}



