#ifndef _FRDUMPER_H
#define _FRDUMPER_H 					(1)

#ifndef		TRUE
#define		TRUE						(1)
#endif

#define		APPNAME_MAX					(32)
#define		INPUT_FILE_FRAME_MAXLEN		((WLAN_A3FR_MAXLEN * 3) + 2)
#define		STYPE_NAME_MAX				(19)
#define		TOTAL_MGMT_FIXED_FIELDS		(10)
#define		TOTAL_MGMT_INFO_ELEMENTS	(8)
#define		TYPE_NAME_MAX				(5)

/*   Management Frame Fixed Field Types   */
#define		MGMT_FF_AUTH_ALG			(0)
#define		MGMT_FF_AUTH_SEQ			(1)
#define		MGMT_FF_BCN_INT				(2)
#define		MGMT_FF_CAP_INFO			(3)
#define		MGMT_FF_CURR_AP				(4)
#define		MGMT_FF_LISTEN_INT			(5)
#define		MGMT_FF_REASON				(6)
#define		MGMT_FF_AID					(7)
#define		MGMT_FF_STATUS				(8)
#define		MGMT_FF_TS					(9)

/*   Management Frame Information Element Types   */
#define		MGMT_IE_SSID				(0)
#define		MGMT_IE_SUPP_RATES			(1)
#define		MGMT_IE_FH_PARMS			(2)
#define		MGMT_IE_DS_PARMS			(3)
#define		MGMT_IE_CF_PARMS			(4)
#define		MGMT_IE_TIM					(5)
#define		MGMT_IE_IBSS_PARMS			(6)
#define		MGMT_IE_CHALLENGE			(7)

/*   Management Frame Types   */
#define		MGMT_TYPE_ASSOCREQ			(0)
#define		MGMT_TYPE_ASSOCRESP			(1)
#define		MGMT_TYPE_ATIM				(2)
#define		MGMT_TYPE_AUTHEN			(3)
#define		MGMT_TYPE_BEACON			(4)
#define		MGMT_TYPE_DEAUTHEN			(5)
#define		MGMT_TYPE_DISASSOC			(6)
#define		MGMT_TYPE_PROBEREQ			(7)
#define		MGMT_TYPE_PROBERESP			(8)
#define		MGMT_TYPE_REASSOCREQ		(9)
#define		MGMT_TYPE_REASSOCRESP		(10)

/*   Data Frame Types   */
#define		DATA_TYPE_DATAONLY			(11)
#define		DATA_TYPE_DATA_CFACK		(12)
#define		DATA_TYPE_DATA_CFPOLL		(13)
#define		DATA_TYPE_DATA_CFACK_CFPOLL	(14)
#define		DATA_TYPE_NULL				(15)
#define		DATA_TYPE_CFACK				(16)
#define		DATA_TYPE_CFPOLL			(17)
#define		DATA_TYPE_CFACK_CFPOLL		(18)

/*   Control Frame Types   */
#define		CTL_TYPE_PSPOLL				(19)
#define		CTL_TYPE_RTS				(20)
#define		CTL_TYPE_CTS				(21)
#define		CTL_TYPE_ACK				(22)
#define		CTL_TYPE_CFEND				(23)
#define		CTL_TYPE_CFENDCFACK			(24)

typedef struct wlan_p80211_frame
{
	char	type[TYPE_NAME_MAX + 1];
	char	stype[STYPE_NAME_MAX + 1];
	void	(*pfunc)( UINT8 *, int,  UINT16 );
} wlan_p80211_frame_t;

typedef struct wlan_p80211_frame_fields
{
	UINT8	exists;
	void	*info;
} wlan_p80211_frame_fields_t;

extern char appname[APPNAME_MAX + 1];

extern int	opt_nobeacon;
extern int	opt_showrx;
extern int	opt_showtx;
extern int	opt_noshowctl;
extern int	opt_noshowmgmt;
extern int	opt_noshowdata;
extern int	opt_showdatalen;
extern int	opt_showraw;
extern int	opt_nodecrypt;
extern int	opt_nodefrag;
extern int	opt_showfrags;
extern int	opt_wepkeyset;
extern UINT8	wep_key[WLAN_WEP_NKEYS][WLAN_WEP_KEYLEN];

int		print_80211_frame( wlan_sniffer_t *snif, UINT8 *frame_buffer, UINT16 len );
void	print_80211_frame_ctl( p80211_hdr_t *phdr, int index );
void	print_80211_mgmt_header( p80211_hdr_t *phdr, int index, UINT16 len );
void	print_ctl_frame( UINT8 *pbuf, int index, UINT16 len );
void	print_ctl_ack( UINT8 *pbuf, int index, UINT16 len );
void	print_ctl_cfend( UINT8 *pbuf, int index, UINT16 len );
void	print_ctl_cfendcfack( UINT8 *pbuf, int index, UINT16 len );
void	print_ctl_cts( UINT8 *pbuf, int index, UINT16 len );
void	print_ctl_pspoll( UINT8 *pbuf, int index, UINT16 len );
void	print_ctl_rts( UINT8 *pbuf, int index, UINT16 len );
void	print_data_frame( UINT8 *pbuf, int index, UINT16 len );
void	print_fixed_fields( wlan_p80211_frame_fields_t  *ff, UINT16 len );
void	print_info_elements( wlan_p80211_frame_fields_t  *ie, UINT16 len );
void	print_mgmt_assocreq( UINT8 *pbuf, int index, UINT16 len );
void	print_mgmt_assocresp( UINT8 *pbuf, int index, UINT16 len );
void	print_mgmt_authen( UINT8 *pbuf, int index, UINT16 len );
void	print_mgmt_beacon( UINT8 *pbuf, int index, UINT16 len );
void	print_mgmt_deauthen( UINT8 *pbuf, int index, UINT16 len );
void	print_mgmt_disassoc( UINT8 *pbuf, int index, UINT16 len );
void	print_mgmt_ibssatim( UINT8 *pbuf, int index, UINT16 len );
void	print_mgmt_probereq( UINT8 *pbuf, int index, UINT16 len );
void	print_mgmt_proberesp( UINT8 *pbuf, int index, UINT16 len );
void	print_mgmt_reassocreq( UINT8 *pbuf, int index, UINT16 len );
void	print_mgmt_reassocresp( UINT8 *pbuf, int index, UINT16 len );

void wlandump_crc32_mktable(void);
void wlandump_wep_decrypt( UINT8 *f, UINT16 len);

#endif /* _FRDUMPER_H */

