/* p80211netdev.h: WLAN net device structure and functions
* --------------------------------------------------------------------
*
* Linux WLAN 
*
*   The contents of this file are subject to the Mozilla Public
*   License Version 1.1 (the "License"); you may not use this file
*   except in compliance with the License. You may obtain a copy of
*   the License at http://www.mozilla.org/MPL/
*
*   Software distributed under the License is distributed on an "AS
*   IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
*   implied. See the License for the specific language governing
*   rights and limitations under the License.
*
*   The initial developer of the original code is Mark S. Mathews
*   <mark@absoval.com>.  Portions created by Mark S. Mathews are 
*   Copyright (C) 1999 AbsoluteValue Software, Inc.  All Rights Reserved.
*
*   Alternatively, the contents of this file may be used under the
*   terms of the GNU Public License version 2 (the "GPL"), in which
*   case the provisions of the GPL are applicable instead of the
*   above.  If you wish to allow the use of your version of this file
*   only under the terms of the GPL and not to allow others to use
*   your version of this file under the MPL, indicate your decision
*   by deleting the provisions above and replace them with the notice
*   and other provisions required by the GPL.  If you do not delete
*   the provisions above, a recipient may use your version of this
*   file under either the MPL or the GPL.
*
* --------------------------------------------------------------------
*
* The initial author may be reached as mark@absoval.com, or 
* C/O AbsoluteValue Software Inc., P.O. Box 941149, 
* Maitland, FL, 32794-1149
*
* --------------------------------------------------------------------
*
* Portions of the development of this software were funded by 
* Intersil Corporation as part of PRISM(R) chipset product development.
*
* --------------------------------------------------------------------
*
* This file declares the structure type that represents each wlan
* interface.  
*
* --------------------------------------------------------------------
*/

#ifndef _LINUX_P80211NETDEV_H

/*================================================================*/
/* Constants */

#define WLAN_DEVICE_CLOSED	0
#define WLAN_DEVICE_OPEN	1

#define WLAN_MACMODE_NONE	0
#define WLAN_MACMODE_IBSS_STA	1
#define WLAN_MACMODE_ESS_STA	2
#define WLAN_MACMODE_ESS_AP	3

/*================================================================*/
/* Macros */

/*================================================================*/
/* Types */

/* struct device from linux/netdevice.h */
typedef struct device netdevice_t;

/* WLAN device type */
typedef struct wlandevice
{
	char		*name;	/* Dev name, assigned in call to register_wlandev */
	UINT32		state;	/* Device Interface state (open/closed) */

	/* Hardware config */
	UINT		irq;
	UINT		iobase;
	UINT		membase;

	/* Config vars */
	UINT		ethconv;

	/* device methods (init by MSD, used by p80211 */
	int		(*open)(struct wlandevice *wlandev);
	int		(*close)(struct wlandevice *wlandev);
	void		(*reset)(struct wlandevice *wlandev );
	int		(*txframe)(struct wlandevice *wlandev, wlan_pb_t *pb );
	int		(*mlmerequest)(struct wlandevice *wlandev, p80211msg_t *msg);

	/* 802.11 State */
	UINT8		bssid[WLAN_BSSID_LEN];
	UINT32		macmode;

	/* Request/Confirm i/f state (used by p80211) */
	UINT32			request_pending; /* flag, access atomically */
	p80211msg_t		*curr_msg;
	struct timer_list	reqtimer;
	struct wait_queue	*reqwq;

	/* Indication i/f state */
		/* netlink socket */
		/* queue for indications waiting for cmd completion */
	/* Linux netdevice and support */
	netdevice_t		*netdev;	/* ptr to linux netdevice */
	struct net_device_stats linux_stats;



	void			*priv;		/* private data for MSD */
	struct wlandevice	*next;		/* link for list of devices */
} wlandevice_t;


/*================================================================*/
/* Externs */

/*================================================================*/
/* Function Declarations */

void	p80211netdev_startup(void);
int	wlan_setup(wlandevice_t *wlandev);
int	wlan_unsetup(wlandevice_t *wlandev);
int	register_wlandev(wlandevice_t *wlandev);
int	unregister_wlandev(wlandevice_t *wlandev);
void	p80211netdev_rx(wlandevice_t *wlandev, wlan_pb_t *pb);

#endif
