/* p80211req.h: Request handling functions
* --------------------------------------------------------------------
*
* Linux WLAN 
*
*   The contents of this file are subject to the Mozilla Public
*   License Version 1.1 (the "License"); you may not use this file
*   except in compliance with the License. You may obtain a copy of
*   the License at http://www.mozilla.org/MPL/
*
*   Software distributed under the License is distributed on an "AS
*   IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
*   implied. See the License for the specific language governing
*   rights and limitations under the License.
*
*   The initial developer of the original code is Mark S. Mathews
*   <mark@absoval.com>.  Portions created by Mark S. Mathews are 
*   Copyright (C) 1999 AbsoluteValue Software, Inc.  All Rights Reserved.
*
*   Alternatively, the contents of this file may be used under the
*   terms of the GNU Public License version 2 (the "GPL"), in which
*   case the provisions of the GPL are applicable instead of the
*   above.  If you wish to allow the use of your version of this file
*   only under the terms of the GPL and not to allow others to use
*   your version of this file under the MPL, indicate your decision
*   by deleting the provisions above and replace them with the notice
*   and other provisions required by the GPL.  If you do not delete
*   the provisions above, a recipient may use your version of this
*   file under either the MPL or the GPL.
*
* --------------------------------------------------------------------
*
* The initial author may be reached as mark@absoval.com, or 
* C/O AbsoluteValue Software Inc., P.O. Box 941149, 
* Maitland, FL, 32794-1149
*
* --------------------------------------------------------------------
*
* Portions of the development of this software were funded by 
* Intersil Corporation as part of PRISM(R) chipset product development.
*
* --------------------------------------------------------------------
*
*
* --------------------------------------------------------------------
*/

#ifndef _LINUX_P80211REQ_H

/*================================================================*/
/* Constants */

/*================================================================*/
/* Macros */

/*================================================================*/
/* Types */

/*================================================================*/
/* Externs */

/*================================================================*/
/* Function Declarations */

int	p80211req_dorequest(wlandevice_t *wlandev, UINT8 *msgbuf);
void	p80211req_confirm(wlandevice_t *wlandev);
void	p80211indicate( wlandevice_t *wlandev, p80211msg_t *msg, int len);
void	p80211indicate_init(void);
void	p80211indicate_shutdown(void);
void	p80211ind_mlme( wlandevice_t *wlandev, struct sk_buff *skb);
void	p80211ind_sniff( wlandevice_t *wlandev, struct sk_buff *skb);
void	p80211ind_distribution( wlandevice_t *wlandev, struct sk_buff *skb);

#endif
