/* p80211metamsg.c: Defines the metadata 802.11 message items
* --------------------------------------------------------------------
*
* Linux WLAN 
*
*   The contents of this file are subject to the Mozilla Public
*   License Version 1.1 (the "License"); you may not use this file
*   except in compliance with the License. You may obtain a copy of
*   the License at http://www.mozilla.org/MPL/
*
*   Software distributed under the License is distributed on an "AS
*   IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
*   implied. See the License for the specific language governing
*   rights and limitations under the License.
*
*   The initial developer of the original code is Jo-Ellen F. Mathews
*   <joellen@absoval.com>.  Portions created by Jo-Ellen F. Mathews are 
*   Copyright (C) 1999 AbsoluteValue Software, Inc.  All Rights Reserved.
*
*   Alternatively, the contents of this file may be used under the
*   terms of the GNU Public License version 2 (the "GPL"), in which
*   case the provisions of the GPL are applicable instead of the
*   above.  If you wish to allow the use of your version of this file
*   only under the terms of the GPL and not to allow others to use
*   your version of this file under the MPL, indicate your decision
*   by deleting the provisions above and replace them with the notice
*   and other provisions required by the GPL.  If you do not delete
*   the provisions above, a recipient may use your version of this
*   file under either the MPL or the GPL.
*
* --------------------------------------------------------------------
*
* The initial author may be reached as joellen@absoval.com, or 
* C/O AbsoluteValue Software Inc., P.O. Box 941149, 
* Maitland, FL, 32794-1149
*
* --------------------------------------------------------------------
*
* Portions of the development of this software were funded by 
* Intersil Corporation as part of PRISM(R) chipset product development.
*
* --------------------------------------------------------------------
*
* This file defines the metadata for message contents and argument
* metadata.
*
* --------------------------------------------------------------------
*/


/*================================================================*/
/* System Includes */

#include <stdio.h>
#include <stdlib.h>


/*================================================================*/
/* Project Includes */

#include <wlan/wlan_compat.h>
#include <wlan/p80211types.h>
#include <wlan/p80211meta.h>
#include <wlan/p80211msg.h>
#include <wlan/p80211metamsg.h>

/*================================================================*/
/* Local Constants */


/*================================================================*/
/* Local Macros */


/*================================================================*/
/* Local Types */


/*================================================================*/
/* Local Static Definitions */

/*====================================================================*/
/* Message Argument Metadata                                          */
/*====================================================================*/

/*--------------------------------------------------------------------*/
/* metadata for the mibget request message arguments */

extern	UINT32	MKREQMETASIZE(dot11req_mibget);

p80211meta_t MKREQMETANAME(dot11req_mibget)[] = {
{
	/* name        */ (char *)&(MKREQMETASIZE(dot11req_mibget)),
	/* did         */ 0,
	/* flags       */ 0,
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 0,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ NULL,
	/* fromtextptr */ NULL,
	/* validfunptr */ NULL
},
{
	/* name        */ MKITEMNAME("mibattribute"),
	/* did         */ P80211DID_MKID(0,0,0,0,0,0,P80211_TYPE_UNKDATA),
	/* flags       */ P80211ITEM_SETFLAGS(ISREQUIRED, ISREQUEST, 0UL),
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ MAXLEN_MIBATTRIBUTE,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_getmibattribute,
	/* fromtextptr */ p80211_fromtext_getmibattribute,
	/* validfunptr */ p80211_isvalid_getmibattribute
},
{
	/* name        */ MKITEMNAME("resultcode"),
	/* did         */ P80211DID_MKID(0,0,0,0,0,0,P80211_TYPE_ENUMINT),
	/* flags       */ P80211ITEM_SETFLAGS(ISREQUIRED, 0UL, ISCONFIRM),
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 0,
	/* enumptr     */ &MKENUMNAME(resultcode),
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_enumint,
	/* fromtextptr */ p80211_fromtext_enumint,
	/* validfunptr */ p80211_isvalid_enumint
}
};  /* end of mibget request message metadata list */

UINT32	MKREQMETASIZE(dot11req_mibget) = sizeof(MKREQMETANAME(dot11req_mibget))/sizeof(p80211meta_t);

/*--------------------------------------------------------------------*/
/* metadata for the dot11req_mibset request message arguments */

extern	UINT32	MKREQMETASIZE(dot11req_mibset);

p80211meta_t MKREQMETANAME(dot11req_mibset)[] = {
{
	/* name        */ (char *)&(MKREQMETASIZE(dot11req_mibset)),
	/* did         */ 0,
	/* flags       */ 0,
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 0,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ NULL,
	/* fromtextptr */ NULL,
	/* validfunptr */ NULL
},
{
	/* name        */ MKITEMNAME("mibattribute"),
	/* did         */ P80211DID_MKID(0,0,0,0,0,0,P80211_TYPE_UNKDATA),
	/* flags       */ P80211ITEM_SETFLAGS(ISREQUIRED, ISREQUEST, 0UL),
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ MAXLEN_MIBATTRIBUTE,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_setmibattribute,
	/* fromtextptr */ p80211_fromtext_setmibattribute,
	/* validfunptr */ p80211_isvalid_setmibattribute
},
{
	/* name        */ MKITEMNAME("resultcode"),
	/* did         */ P80211DID_MKID(0,0,0,0,0,0,P80211_TYPE_ENUMINT),
	/* flags       */ P80211ITEM_SETFLAGS(ISREQUIRED, 0UL, ISCONFIRM),
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 0,
	/* enumptr     */ &MKENUMNAME(resultcode),
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_enumint,
	/* fromtextptr */ p80211_fromtext_enumint,
	/* validfunptr */ p80211_isvalid_enumint
}
};  /* end of dot11req_mibset request message metadata list */

UINT32	MKREQMETASIZE(dot11req_mibset) = 
		sizeof(MKREQMETANAME(dot11req_mibset))/sizeof(p80211meta_t);

/*--------------------------------------------------------------------*/
/* metadata for the dot11req_powermgmt request message arguments */

extern	UINT32	MKREQMETASIZE(dot11req_powermgmt);

p80211meta_t MKREQMETANAME(dot11req_powermgmt)[] = {
{
	/* name        */ (char *)&(MKREQMETASIZE(dot11req_powermgmt)),
	/* did         */ 0,
	/* flags       */ 0,
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 0,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ NULL,
	/* fromtextptr */ NULL,
	/* validfunptr */ NULL
},
{
	/* name        */ MKITEMNAME("powermgmtmode"),
	/* did         */ P80211DID_MKID(0,0,0,0,0,0,P80211_TYPE_ENUMINT),
	/* flags       */ P80211ITEM_SETFLAGS(ISREQUIRED, ISREQUEST, 0UL),
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 0,
	/* enumptr     */ &MKENUMNAME(powermgmt),
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_enumint,
	/* fromtextptr */ p80211_fromtext_enumint,
	/* validfunptr */ p80211_isvalid_enumint
},
{
	/* name        */ MKITEMNAME("wakeup"),
	/* did         */ P80211DID_MKID(0,0,0,0,0,0,P80211_TYPE_ENUMINT),
	/* flags       */ P80211ITEM_SETFLAGS(ISREQUIRED, ISREQUEST, 0UL),
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 0,
	/* enumptr     */ &MKENUMNAME(truth),
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_enumint,
	/* fromtextptr */ p80211_fromtext_enumint,
	/* validfunptr */ p80211_isvalid_enumint
},
{
	/* name        */ MKITEMNAME("receivedtims"),
	/* did         */ P80211DID_MKID(0,0,0,0,0,0,P80211_TYPE_ENUMINT),
	/* flags       */ P80211ITEM_SETFLAGS(ISREQUIRED, ISREQUEST, 0UL),
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 0,
	/* enumptr     */ &MKENUMNAME(truth),
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_enumint,
	/* fromtextptr */ p80211_fromtext_enumint,
	/* validfunptr */ p80211_isvalid_enumint
},
{
	/* name        */ MKITEMNAME("resultcode"),
	/* did         */ P80211DID_MKID(0,0,0,0,0,0,P80211_TYPE_ENUMINT),
	/* flags       */ P80211ITEM_SETFLAGS(ISREQUIRED, 0UL, ISCONFIRM),
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 0,
	/* enumptr     */ &MKENUMNAME(resultcode),
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_enumint,
	/* fromtextptr */ p80211_fromtext_enumint,
	/* validfunptr */ p80211_isvalid_enumint
}
};  /* end of dot11req_powermgmt request message metadata list */

UINT32	MKREQMETASIZE(dot11req_powermgmt) = 
		sizeof(MKREQMETANAME(dot11req_powermgmt))/sizeof(p80211meta_t);

/*--------------------------------------------------------------------*/
/* metadata for the dot11req_scan request message arguments */

extern	UINT32	MKREQMETASIZE(dot11req_scan);

p80211meta_t MKREQMETANAME(dot11req_scan)[] = {
{
	/* name        */ (char *)&(MKREQMETASIZE(dot11req_scan)),
	/* did         */ 0,
	/* flags       */ 0,
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 0,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ NULL,
	/* fromtextptr */ NULL,
	/* validfunptr */ NULL
},
{
	/* name        */ MKITEMNAME("bsstype"),
	/* did         */ P80211DID_MKID(0,0,0,0,0,0,P80211_TYPE_ENUMINT),
	/* flags       */ P80211ITEM_SETFLAGS(ISREQUIRED, ISREQUEST, 0UL),
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 0,
	/* enumptr     */ &MKENUMNAME(bsstype),
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_enumint,
	/* fromtextptr */ p80211_fromtext_enumint,
	/* validfunptr */ p80211_isvalid_enumint
},
{
	/* name        */ MKITEMNAME("bssid"),
	/* did         */ P80211DID_MKID(0,0,0,0,0,0,P80211_TYPE_OCTETSTR),
	/* flags       */ P80211ITEM_SETFLAGS(ISREQUIRED, ISREQUEST, 0UL),
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ MAXLEN_PSTR6,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_octetstr,
	/* fromtextptr */ p80211_fromtext_octetstr,
	/* validfunptr */ p80211_isvalid_octetstr
},
{
	/* name        */ MKITEMNAME("ssid"),
	/* did         */ P80211DID_MKID(0,0,0,0,0,0,P80211_TYPE_DISPLAYSTR),
	/* flags       */ P80211ITEM_SETFLAGS(ISREQUIRED, ISREQUEST, 0UL),
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ MAXLEN_PSTR32,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_displaystr,
	/* fromtextptr */ p80211_fromtext_displaystr,
	/* validfunptr */ p80211_isvalid_displaystr
},
{
	/* name        */ MKITEMNAME("scantype"),
	/* did         */ P80211DID_MKID(0,0,0,0,0,0,P80211_TYPE_ENUMINT),
	/* flags       */ P80211ITEM_SETFLAGS(ISREQUIRED, ISREQUEST, 0UL),
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 0,
	/* enumptr     */ &MKENUMNAME(scantype),
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_enumint,
	/* fromtextptr */ p80211_fromtext_enumint,
	/* validfunptr */ p80211_isvalid_enumint
},
{
	/* name        */ MKITEMNAME("probedelay"),
	/* did         */ P80211DID_MKID(0,0,0,0,0,0,P80211_TYPE_INT),
	/* flags       */ P80211ITEM_SETFLAGS(ISREQUIRED, ISREQUEST, 0UL),
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 0,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_int,
	/* fromtextptr */ p80211_fromtext_int,
	/* validfunptr */ p80211_isvalid_int
},
{
	/* name        */ MKITEMNAME("channellist"),
	/* did         */ P80211DID_MKID(0,0,0,0,0,0,P80211_TYPE_OCTETSTR),
	/* flags       */ P80211ITEM_SETFLAGS(ISREQUIRED, ISREQUEST, 0UL),
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ MAXLEN_PSTR14,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_octetstr,
	/* fromtextptr */ p80211_fromtext_octetstr,
	/* validfunptr */ p80211_isvalid_octetstr
},
{
	/* name        */ MKITEMNAME("minchanneltime"),
	/* did         */ P80211DID_MKID(0,0,0,0,0,0,P80211_TYPE_INT),
	/* flags       */ P80211ITEM_SETFLAGS(ISREQUIRED, ISREQUEST, 0UL),
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 0,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_int,
	/* fromtextptr */ p80211_fromtext_int,
	/* validfunptr */ p80211_isvalid_int
},
{
	/* name        */ MKITEMNAME("maxchanneltime"),
	/* did         */ P80211DID_MKID(0,0,0,0,0,0,P80211_TYPE_INT),
	/* flags       */ P80211ITEM_SETFLAGS(ISREQUIRED, ISREQUEST, 0UL),
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 0,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_int,
	/* fromtextptr */ p80211_fromtext_int,
	/* validfunptr */ p80211_isvalid_int
},
{
	/* name        */ MKITEMNAME("resultcode"),
	/* did         */ P80211DID_MKID(0,0,0,0,0,0,P80211_TYPE_ENUMINT),
	/* flags       */ P80211ITEM_SETFLAGS(ISREQUIRED, 0UL, ISCONFIRM),
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 0,
	/* enumptr     */ &MKENUMNAME(resultcode),
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_enumint,
	/* fromtextptr */ p80211_fromtext_enumint,
	/* validfunptr */ p80211_isvalid_enumint
},
{
	/* name        */ MKITEMNAME("numbss"),
	/* did         */ P80211DID_MKID(0,0,0,0,0,0,P80211_TYPE_INT),
	/* flags       */ P80211ITEM_SETFLAGS(ISREQUIRED, 0UL, ISCONFIRM),
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 0,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_int,
	/* fromtextptr */ p80211_fromtext_int,
	/* validfunptr */ p80211_isvalid_int
}
};  /* end of dot11req_scan request message metadata list */

UINT32	MKREQMETASIZE(dot11req_scan) = 
		sizeof(MKREQMETANAME(dot11req_scan))/sizeof(p80211meta_t);

/*--------------------------------------------------------------------*/
/* metadata for the dot11req_scan_results request message arguments */

extern	UINT32	MKREQMETASIZE(dot11req_scan_results);

p80211meta_t MKREQMETANAME(dot11req_scan_results)[] = {
{
	/* name        */ (char *)&(MKREQMETASIZE(dot11req_scan_results)),
	/* did         */ 0,
	/* flags       */ 0,
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 0,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ NULL,
	/* fromtextptr */ NULL,
	/* validfunptr */ NULL
},
{
	/* name        */ MKITEMNAME("bssindex"),
	/* did         */ P80211DID_MKID(0,0,0,0,0,0,P80211_TYPE_INT),
	/* flags       */ P80211ITEM_SETFLAGS(ISREQUIRED, ISREQUEST, 0UL),
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 0,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_int,
	/* fromtextptr */ p80211_fromtext_int,
	/* validfunptr */ p80211_isvalid_int
},
{
	/* name        */ MKITEMNAME("resultcode"),
	/* did         */ P80211DID_MKID(0,0,0,0,0,0,P80211_TYPE_ENUMINT),
	/* flags       */ P80211ITEM_SETFLAGS(ISREQUIRED, 0UL, ISCONFIRM),
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 0,
	/* enumptr     */ &MKENUMNAME(resultcode),
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_enumint,
	/* fromtextptr */ p80211_fromtext_enumint,
	/* validfunptr */ p80211_isvalid_enumint
},
{
	/* name        */ "bssid",
	/* did         */ P80211DID_MKID(0,0,0,0,0,0,P80211_TYPE_OCTETSTR),
	/* flags       */ P80211ITEM_SETFLAGS(ISREQUIRED, 0UL, ISCONFIRM),
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ MAXLEN_PSTR6,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_octetstr,
	/* fromtextptr */ p80211_fromtext_octetstr,
	/* validfunptr */ p80211_isvalid_octetstr
},
{
	/* name        */ "ssid",
	/* did         */ P80211DID_MKID(0,0,0,0,0,0,P80211_TYPE_DISPLAYSTR),
	/* flags       */ P80211ITEM_SETFLAGS(ISREQUIRED, 0UL, ISCONFIRM),
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ MAXLEN_PSTR32,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_displaystr,
	/* fromtextptr */ p80211_fromtext_displaystr,
	/* validfunptr */ p80211_isvalid_displaystr
},
{
	/* name        */ MKITEMNAME("bsstype"),
	/* did         */ P80211DID_MKID(0,0,0,0,0,0,P80211_TYPE_ENUMINT),
	/* flags       */ P80211ITEM_SETFLAGS(ISREQUIRED, 0UL, ISCONFIRM),
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 0,
	/* enumptr     */ &MKENUMNAME(bsstype),
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_enumint,
	/* fromtextptr */ p80211_fromtext_enumint,
	/* validfunptr */ p80211_isvalid_enumint
},
{
	/* name        */ MKITEMNAME("beaconperiod"),
	/* did         */ P80211DID_MKID(0,0,0,0,0,0,P80211_TYPE_INT),
	/* flags       */ P80211ITEM_SETFLAGS(ISREQUIRED, 0UL, ISCONFIRM),
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 0,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_int,
	/* fromtextptr */ p80211_fromtext_int,
	/* validfunptr */ p80211_isvalid_int
},
{
	/* name        */ MKITEMNAME("dtimperiod"),
	/* did         */ P80211DID_MKID(0,0,0,0,0,0,P80211_TYPE_BOUNDEDINT),
	/* flags       */ P80211ITEM_SETFLAGS(ISREQUIRED, 0UL, ISCONFIRM),
	/* min         */ 1,
	/* max         */ 255,
	/* maxlen      */ 0,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_boundedint,
	/* fromtextptr */ p80211_fromtext_boundedint,
	/* validfunptr */ p80211_isvalid_boundedint
},
{
	/* name        */ MKITEMNAME("timestamp"),
	/* did         */ P80211DID_MKID(0,0,0,0,0,0,P80211_TYPE_INT),
	/* flags       */ P80211ITEM_SETFLAGS(ISREQUIRED, 0UL, ISCONFIRM),
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 0,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_int,
	/* fromtextptr */ p80211_fromtext_int,
	/* validfunptr */ p80211_isvalid_int
},
{
	/* name        */ MKITEMNAME("localtime"),
	/* did         */ P80211DID_MKID(0,0,0,0,0,0,P80211_TYPE_INT),
	/* flags       */ P80211ITEM_SETFLAGS(ISREQUIRED, 0UL, ISCONFIRM),
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 0,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_int,
	/* fromtextptr */ p80211_fromtext_int,
	/* validfunptr */ p80211_isvalid_int
},
{
	/* name        */ MKITEMNAME("fhdwelltime"),
	/* did         */ P80211DID_MKID(0,0,0,0,0,0,P80211_TYPE_BOUNDEDINT),
	/* flags       */ P80211ITEM_SETFLAGS(ISREQUIRED, 0UL, ISCONFIRM),
	/* min         */ 1,
	/* max         */ 65535,
	/* maxlen      */ 0,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_boundedint,
	/* fromtextptr */ p80211_fromtext_boundedint,
	/* validfunptr */ p80211_isvalid_boundedint
},
{
	/* name        */ MKITEMNAME("fhhopset"),
	/* did         */ P80211DID_MKID(0,0,0,0,0,0,P80211_TYPE_BOUNDEDINT),
	/* flags       */ P80211ITEM_SETFLAGS(ISREQUIRED, 0UL, ISCONFIRM),
	/* min         */ 1,
	/* max         */ 255,
	/* maxlen      */ 0,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_boundedint,
	/* fromtextptr */ p80211_fromtext_boundedint,
	/* validfunptr */ p80211_isvalid_boundedint
},
{
	/* name        */ MKITEMNAME("fhhoppattern"),
	/* did         */ P80211DID_MKID(0,0,0,0,0,0,P80211_TYPE_BOUNDEDINT),
	/* flags       */ P80211ITEM_SETFLAGS(ISREQUIRED, 0UL, ISCONFIRM),
	/* min         */ 0,
	/* max         */ 255,
	/* maxlen      */ 0,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_boundedint,
	/* fromtextptr */ p80211_fromtext_boundedint,
	/* validfunptr */ p80211_isvalid_boundedint
},
{
	/* name        */ MKITEMNAME("fhhopindex"),
	/* did         */ P80211DID_MKID(0,0,0,0,0,0,P80211_TYPE_BOUNDEDINT),
	/* flags       */ P80211ITEM_SETFLAGS(ISREQUIRED, 0UL, ISCONFIRM),
	/* min         */ 1,
	/* max         */ 255,
	/* maxlen      */ 0,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_boundedint,
	/* fromtextptr */ p80211_fromtext_boundedint,
	/* validfunptr */ p80211_isvalid_boundedint
},
{
	/* name        */ MKITEMNAME("dschannel"),
	/* did         */ P80211DID_MKID(0,0,0,0,0,0,P80211_TYPE_BOUNDEDINT),
	/* flags       */ P80211ITEM_SETFLAGS(ISREQUIRED, 0UL, ISCONFIRM),
	/* min         */ 1,
	/* max         */ 14,
	/* maxlen      */ 0,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_boundedint,
	/* fromtextptr */ p80211_fromtext_boundedint,
	/* validfunptr */ p80211_isvalid_boundedint
},
{
	/* name        */ MKITEMNAME("cfpcount"),
	/* did         */ P80211DID_MKID(0,0,0,0,0,0,P80211_TYPE_INT),
	/* flags       */ P80211ITEM_SETFLAGS(ISREQUIRED, 0UL, ISCONFIRM),
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 0,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_int,
	/* fromtextptr */ p80211_fromtext_int,
	/* validfunptr */ p80211_isvalid_int
},
{
	/* name        */ MKITEMNAME("cfpperiod"),
	/* did         */ P80211DID_MKID(0,0,0,0,0,0,P80211_TYPE_BOUNDEDINT),
	/* flags       */ P80211ITEM_SETFLAGS(ISREQUIRED, 0UL, ISCONFIRM),
	/* min         */ 0,
	/* max         */ 255,
	/* maxlen      */ 0,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_boundedint,
	/* fromtextptr */ p80211_fromtext_boundedint,
	/* validfunptr */ p80211_isvalid_boundedint
},
{
	/* name        */ MKITEMNAME("cfpmaxduration"),
	/* did         */ P80211DID_MKID(0,0,0,0,0,0,P80211_TYPE_BOUNDEDINT),
	/* flags       */ P80211ITEM_SETFLAGS(ISREQUIRED, 0UL, ISCONFIRM),
	/* min         */ 0,
	/* max         */ 65535,
	/* maxlen      */ 0,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_boundedint,
	/* fromtextptr */ p80211_fromtext_boundedint,
	/* validfunptr */ p80211_isvalid_boundedint
},
{
	/* name        */ MKITEMNAME("cfpdurremaining"),
	/* did         */ P80211DID_MKID(0,0,0,0,0,0,P80211_TYPE_INT),
	/* flags       */ P80211ITEM_SETFLAGS(ISREQUIRED, 0UL, ISCONFIRM),
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 0,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_int,
	/* fromtextptr */ p80211_fromtext_int,
	/* validfunptr */ p80211_isvalid_int
},
{
	/* name        */ MKITEMNAME("ibssatimwindow"),
	/* did         */ P80211DID_MKID(0,0,0,0,0,0,P80211_TYPE_INT),
	/* flags       */ P80211ITEM_SETFLAGS(ISREQUIRED, 0UL, ISCONFIRM),
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 0,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_int,
	/* fromtextptr */ p80211_fromtext_int,
	/* validfunptr */ p80211_isvalid_int
},
{
	/* name        */ MKITEMNAME("cfpollable"),
	/* did         */ P80211DID_MKID(0,0,0,0,0,0,P80211_TYPE_ENUMINT),
	/* flags       */ P80211ITEM_SETFLAGS(ISREQUIRED, 0UL, ISCONFIRM),
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 0,
	/* enumptr     */ &MKENUMNAME(truth),
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_enumint,
	/* fromtextptr */ p80211_fromtext_enumint,
	/* validfunptr */ p80211_isvalid_enumint
},
{
	/* name        */ MKITEMNAME("cfpollreq"),
	/* did         */ P80211DID_MKID(0,0,0,0,0,0,P80211_TYPE_ENUMINT),
	/* flags       */ P80211ITEM_SETFLAGS(ISREQUIRED, 0UL, ISCONFIRM),
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 0,
	/* enumptr     */ &MKENUMNAME(truth),
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_enumint,
	/* fromtextptr */ p80211_fromtext_enumint,
	/* validfunptr */ p80211_isvalid_enumint
},
{
	/* name        */ MKITEMNAME("privacy"),
	/* did         */ P80211DID_MKID(0,0,0,0,0,0,P80211_TYPE_ENUMINT),
	/* flags       */ P80211ITEM_SETFLAGS(ISREQUIRED, 0UL, ISCONFIRM),
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 0,
	/* enumptr     */ &MKENUMNAME(truth),
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_enumint,
	/* fromtextptr */ p80211_fromtext_enumint,
	/* validfunptr */ p80211_isvalid_enumint
},
{
	/* name        */ MKITEMNAME("basicrate1"),
	/* did         */ P80211DID_MKID(0,0,0,0,0,0,P80211_TYPE_BOUNDEDINT),
	/* flags       */ P80211ITEM_SETFLAGS(ISREQUIRED, 0UL, ISCONFIRM),
	/* min         */ 2,
	/* max         */ 127,
	/* maxlen      */ 0,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_boundedint,
	/* fromtextptr */ p80211_fromtext_boundedint,
	/* validfunptr */ p80211_isvalid_boundedint
},
{
	/* name        */ MKITEMNAME("basicrate2"),
	/* did         */ P80211DID_MKID(0,0,0,0,0,0,P80211_TYPE_BOUNDEDINT),
	/* flags       */ P80211ITEM_SETFLAGS(ISREQUIRED, 0UL, ISCONFIRM),
	/* min         */ 2,
	/* max         */ 127,
	/* maxlen      */ 0,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_boundedint,
	/* fromtextptr */ p80211_fromtext_boundedint,
	/* validfunptr */ p80211_isvalid_boundedint
},
{
	/* name        */ MKITEMNAME("basicrate3"),
	/* did         */ P80211DID_MKID(0,0,0,0,0,0,P80211_TYPE_BOUNDEDINT),
	/* flags       */ P80211ITEM_SETFLAGS(ISREQUIRED, 0UL, ISCONFIRM),
	/* min         */ 2,
	/* max         */ 127,
	/* maxlen      */ 0,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_boundedint,
	/* fromtextptr */ p80211_fromtext_boundedint,
	/* validfunptr */ p80211_isvalid_boundedint
},
{
	/* name        */ MKITEMNAME("basicrate4"),
	/* did         */ P80211DID_MKID(0,0,0,0,0,0,P80211_TYPE_BOUNDEDINT),
	/* flags       */ P80211ITEM_SETFLAGS(ISREQUIRED, 0UL, ISCONFIRM),
	/* min         */ 2,
	/* max         */ 127,
	/* maxlen      */ 0,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_boundedint,
	/* fromtextptr */ p80211_fromtext_boundedint,
	/* validfunptr */ p80211_isvalid_boundedint
},
{
	/* name        */ MKITEMNAME("basicrate5"),
	/* did         */ P80211DID_MKID(0,0,0,0,0,0,P80211_TYPE_BOUNDEDINT),
	/* flags       */ P80211ITEM_SETFLAGS(ISREQUIRED, 0UL, ISCONFIRM),
	/* min         */ 2,
	/* max         */ 127,
	/* maxlen      */ 0,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_boundedint,
	/* fromtextptr */ p80211_fromtext_boundedint,
	/* validfunptr */ p80211_isvalid_boundedint
},
{
	/* name        */ MKITEMNAME("basicrate6"),
	/* did         */ P80211DID_MKID(0,0,0,0,0,0,P80211_TYPE_BOUNDEDINT),
	/* flags       */ P80211ITEM_SETFLAGS(ISREQUIRED, 0UL, ISCONFIRM),
	/* min         */ 2,
	/* max         */ 127,
	/* maxlen      */ 0,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_boundedint,
	/* fromtextptr */ p80211_fromtext_boundedint,
	/* validfunptr */ p80211_isvalid_boundedint
},
{
	/* name        */ MKITEMNAME("basicrate7"),
	/* did         */ P80211DID_MKID(0,0,0,0,0,0,P80211_TYPE_BOUNDEDINT),
	/* flags       */ P80211ITEM_SETFLAGS(ISREQUIRED, 0UL, ISCONFIRM),
	/* min         */ 2,
	/* max         */ 127,
	/* maxlen      */ 0,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_boundedint,
	/* fromtextptr */ p80211_fromtext_boundedint,
	/* validfunptr */ p80211_isvalid_boundedint
},
{
	/* name        */ MKITEMNAME("basicrate8"),
	/* did         */ P80211DID_MKID(0,0,0,0,0,0,P80211_TYPE_BOUNDEDINT),
	/* flags       */ P80211ITEM_SETFLAGS(ISREQUIRED, 0UL, ISCONFIRM),
	/* min         */ 2,
	/* max         */ 127,
	/* maxlen      */ 0,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_boundedint,
	/* fromtextptr */ p80211_fromtext_boundedint,
	/* validfunptr */ p80211_isvalid_boundedint
}
};  /* end of dot11req_scan_results metadata list */

UINT32	MKREQMETASIZE(dot11req_scan_results) = 
		sizeof(MKREQMETANAME(dot11req_scan_results))/sizeof(p80211meta_t);

/*--------------------------------------------------------------------*/
/* metadata for the dot11req_join request message arguments */

extern	UINT32	MKREQMETASIZE(dot11req_join);

p80211meta_t MKREQMETANAME(dot11req_join)[] = {
{
	/* name        */ (char *)&(MKREQMETASIZE(dot11req_join)),
	/* did         */ 0,
	/* flags       */ 0,
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 0,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ NULL,
	/* fromtextptr */ NULL,
	/* validfunptr */ NULL
},
{
	/* name        */ "bssid",
	/* did         */ P80211DID_MKID(0,0,0,0,0,0,P80211_TYPE_OCTETSTR),
	/* flags       */ P80211ITEM_SETFLAGS(ISREQUIRED, ISREQUEST, 0UL),
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ MAXLEN_PSTR6,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_octetstr,
	/* fromtextptr */ p80211_fromtext_octetstr,
	/* validfunptr */ p80211_isvalid_octetstr
},
{
	/* name        */ "joinfailuretimeout",
	/* did         */ P80211DID_MKID(0,0,0,0,0,0,P80211_TYPE_BOUNDEDINT),
	/* flags       */ P80211ITEM_SETFLAGS(ISREQUIRED, ISREQUEST, 0UL),
	/* min         */ 1,
	/* max         */ UINT32_MAX,
	/* maxlen      */ 0,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_boundedint,
	/* fromtextptr */ p80211_fromtext_boundedint,
	/* validfunptr */ p80211_isvalid_boundedint
},
{
	/* name        */ MKITEMNAME("basicrate1"),
	/* did         */ P80211DID_MKID(0,0,0,0,0,0,P80211_TYPE_BOUNDEDINT),
	/* flags       */ P80211ITEM_SETFLAGS(ISREQUIRED, ISREQUEST, 0UL),
	/* min         */ 2,
	/* max         */ 127,
	/* maxlen      */ 0,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_boundedint,
	/* fromtextptr */ p80211_fromtext_boundedint,
	/* validfunptr */ p80211_isvalid_boundedint
},
{
	/* name        */ MKITEMNAME("basicrate2"),
	/* did         */ P80211DID_MKID(0,0,0,0,0,0,P80211_TYPE_BOUNDEDINT),
	/* flags       */ P80211ITEM_SETFLAGS(0UL, ISREQUEST, 0UL),
	/* min         */ 2,
	/* max         */ 127,
	/* maxlen      */ 0,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_boundedint,
	/* fromtextptr */ p80211_fromtext_boundedint,
	/* validfunptr */ p80211_isvalid_boundedint
},
{
	/* name        */ MKITEMNAME("basicrate3"),
	/* did         */ P80211DID_MKID(0,0,0,0,0,0,P80211_TYPE_BOUNDEDINT),
	/* flags       */ P80211ITEM_SETFLAGS(0UL, ISREQUEST, 0UL),
	/* min         */ 2,
	/* max         */ 127,
	/* maxlen      */ 0,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_boundedint,
	/* fromtextptr */ p80211_fromtext_boundedint,
	/* validfunptr */ p80211_isvalid_boundedint
},
{
	/* name        */ MKITEMNAME("basicrate4"),
	/* did         */ P80211DID_MKID(0,0,0,0,0,0,P80211_TYPE_BOUNDEDINT),
	/* flags       */ P80211ITEM_SETFLAGS(0UL, ISREQUEST, 0UL),
	/* min         */ 2,
	/* max         */ 127,
	/* maxlen      */ 0,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_boundedint,
	/* fromtextptr */ p80211_fromtext_boundedint,
	/* validfunptr */ p80211_isvalid_boundedint
},
{
	/* name        */ MKITEMNAME("basicrate5"),
	/* did         */ P80211DID_MKID(0,0,0,0,0,0,P80211_TYPE_BOUNDEDINT),
	/* flags       */ P80211ITEM_SETFLAGS(0UL, ISREQUEST, 0UL),
	/* min         */ 2,
	/* max         */ 127,
	/* maxlen      */ 0,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_boundedint,
	/* fromtextptr */ p80211_fromtext_boundedint,
	/* validfunptr */ p80211_isvalid_boundedint
},
{
	/* name        */ MKITEMNAME("basicrate6"),
	/* did         */ P80211DID_MKID(0,0,0,0,0,0,P80211_TYPE_BOUNDEDINT),
	/* flags       */ P80211ITEM_SETFLAGS(0UL, ISREQUEST, 0UL),
	/* min         */ 2,
	/* max         */ 127,
	/* maxlen      */ 0,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_boundedint,
	/* fromtextptr */ p80211_fromtext_boundedint,
	/* validfunptr */ p80211_isvalid_boundedint
},
{
	/* name        */ MKITEMNAME("basicrate7"),
	/* did         */ P80211DID_MKID(0,0,0,0,0,0,P80211_TYPE_BOUNDEDINT),
	/* flags       */ P80211ITEM_SETFLAGS(0UL, ISREQUEST, 0UL),
	/* min         */ 2,
	/* max         */ 127,
	/* maxlen      */ 0,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_boundedint,
	/* fromtextptr */ p80211_fromtext_boundedint,
	/* validfunptr */ p80211_isvalid_boundedint
},
{
	/* name        */ MKITEMNAME("basicrate8"),
	/* did         */ P80211DID_MKID(0,0,0,0,0,0,P80211_TYPE_BOUNDEDINT),
	/* flags       */ P80211ITEM_SETFLAGS(0UL, ISREQUEST, 0UL),
	/* min         */ 2,
	/* max         */ 127,
	/* maxlen      */ 0,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_boundedint,
	/* fromtextptr */ p80211_fromtext_boundedint,
	/* validfunptr */ p80211_isvalid_boundedint
},
{
	/* name        */ MKITEMNAME("operationalrate1"),
	/* did         */ P80211DID_MKID(0,0,0,0,0,0,P80211_TYPE_BOUNDEDINT),
	/* flags       */ P80211ITEM_SETFLAGS(ISREQUIRED, ISREQUEST, 0UL),
	/* min         */ 2,
	/* max         */ 127,
	/* maxlen      */ 0,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_boundedint,
	/* fromtextptr */ p80211_fromtext_boundedint,
	/* validfunptr */ p80211_isvalid_boundedint
},
{
	/* name        */ MKITEMNAME("operationalrate2"),
	/* did         */ P80211DID_MKID(0,0,0,0,0,0,P80211_TYPE_BOUNDEDINT),
	/* flags       */ P80211ITEM_SETFLAGS(0UL, ISREQUEST, 0UL),
	/* min         */ 2,
	/* max         */ 127,
	/* maxlen      */ 0,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_boundedint,
	/* fromtextptr */ p80211_fromtext_boundedint,
	/* validfunptr */ p80211_isvalid_boundedint
},
{
	/* name        */ MKITEMNAME("operationalrate3"),
	/* did         */ P80211DID_MKID(0,0,0,0,0,0,P80211_TYPE_BOUNDEDINT),
	/* flags       */ P80211ITEM_SETFLAGS(0UL, ISREQUEST, 0UL),
	/* min         */ 2,
	/* max         */ 127,
	/* maxlen      */ 0,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_boundedint,
	/* fromtextptr */ p80211_fromtext_boundedint,
	/* validfunptr */ p80211_isvalid_boundedint
},
{
	/* name        */ MKITEMNAME("operationalrate4"),
	/* did         */ P80211DID_MKID(0,0,0,0,0,0,P80211_TYPE_BOUNDEDINT),
	/* flags       */ P80211ITEM_SETFLAGS(0UL, ISREQUEST, 0UL),
	/* min         */ 2,
	/* max         */ 127,
	/* maxlen      */ 0,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_boundedint,
	/* fromtextptr */ p80211_fromtext_boundedint,
	/* validfunptr */ p80211_isvalid_boundedint
},
{
	/* name        */ MKITEMNAME("operationalrate5"),
	/* did         */ P80211DID_MKID(0,0,0,0,0,0,P80211_TYPE_BOUNDEDINT),
	/* flags       */ P80211ITEM_SETFLAGS(0UL, ISREQUEST, 0UL),
	/* min         */ 2,
	/* max         */ 127,
	/* maxlen      */ 0,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_boundedint,
	/* fromtextptr */ p80211_fromtext_boundedint,
	/* validfunptr */ p80211_isvalid_boundedint
},
{
	/* name        */ MKITEMNAME("operationalrate6"),
	/* did         */ P80211DID_MKID(0,0,0,0,0,0,P80211_TYPE_BOUNDEDINT),
	/* flags       */ P80211ITEM_SETFLAGS(0UL, ISREQUEST, 0UL),
	/* min         */ 2,
	/* max         */ 127,
	/* maxlen      */ 0,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_boundedint,
	/* fromtextptr */ p80211_fromtext_boundedint,
	/* validfunptr */ p80211_isvalid_boundedint
},
{
	/* name        */ MKITEMNAME("operationalrate7"),
	/* did         */ P80211DID_MKID(0,0,0,0,0,0,P80211_TYPE_BOUNDEDINT),
	/* flags       */ P80211ITEM_SETFLAGS(0UL, ISREQUEST, 0UL),
	/* min         */ 2,
	/* max         */ 127,
	/* maxlen      */ 0,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_boundedint,
	/* fromtextptr */ p80211_fromtext_boundedint,
	/* validfunptr */ p80211_isvalid_boundedint
},
{
	/* name        */ MKITEMNAME("operationalrate8"),
	/* did         */ P80211DID_MKID(0,0,0,0,0,0,P80211_TYPE_BOUNDEDINT),
	/* flags       */ P80211ITEM_SETFLAGS(0UL, ISREQUEST, 0UL),
	/* min         */ 2,
	/* max         */ 127,
	/* maxlen      */ 0,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_boundedint,
	/* fromtextptr */ p80211_fromtext_boundedint,
	/* validfunptr */ p80211_isvalid_boundedint
},
{
	/* name        */ MKITEMNAME("resultcode"),
	/* did         */ P80211DID_MKID(0,0,0,0,0,0,P80211_TYPE_ENUMINT),
	/* flags       */ P80211ITEM_SETFLAGS(ISREQUIRED, 0UL, ISCONFIRM),
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 0,
	/* enumptr     */ &MKENUMNAME(resultcode),
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_enumint,
	/* fromtextptr */ p80211_fromtext_enumint,
	/* validfunptr */ p80211_isvalid_enumint
}
};  /* end of dot11req_join request message metadata list */

UINT32	MKREQMETASIZE(dot11req_join) = 
		sizeof(MKREQMETANAME(dot11req_join))/sizeof(p80211meta_t);

/*--------------------------------------------------------------------*/
/* metadata for the dot11req_authenticate request message arguments */

extern	UINT32	MKREQMETASIZE(dot11req_authenticate);

p80211meta_t MKREQMETANAME(dot11req_authenticate)[] = {
{
	/* name        */ (char *)&(MKREQMETASIZE(dot11req_authenticate)),
	/* did         */ 0,
	/* flags       */ 0,
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 0,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ NULL,
	/* fromtextptr */ NULL,
	/* validfunptr */ NULL
},
{
	/* name        */ "peerstaaddress",
	/* did         */ P80211DID_MKID(0,0,0,0,0,0,P80211_TYPE_OCTETSTR),
	/* flags       */ P80211ITEM_SETFLAGS(ISREQUIRED, ISREQUEST, ISCONFIRM),
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ MAXLEN_PSTR6,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_octetstr,
	/* fromtextptr */ p80211_fromtext_octetstr,
	/* validfunptr */ p80211_isvalid_octetstr
},
{
	/* name        */ MKITEMNAME("authenticationtype"),
	/* did         */ P80211DID_MKID(0,0,0,0,0,0,P80211_TYPE_ENUMINT),
	/* flags       */ P80211ITEM_SETFLAGS(ISREQUIRED, ISREQUEST, ISCONFIRM),
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 0,
	/* enumptr     */ &MKENUMNAME(authalg),
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_enumint,
	/* fromtextptr */ p80211_fromtext_enumint,
	/* validfunptr */ p80211_isvalid_enumint
},
{
	/* name        */ "authenticationfailuretimeout",
	/* did         */ P80211DID_MKID(0,0,0,0,0,0,P80211_TYPE_BOUNDEDINT),
	/* flags       */ P80211ITEM_SETFLAGS(ISREQUIRED, ISREQUEST, 0UL),
	/* min         */ 1,
	/* max         */ UINT32_MAX,
	/* maxlen      */ 0,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_boundedint,
	/* fromtextptr */ p80211_fromtext_boundedint,
	/* validfunptr */ p80211_isvalid_boundedint
},
{
	/* name        */ MKITEMNAME("resultcode"),
	/* did         */ P80211DID_MKID(0,0,0,0,0,0,P80211_TYPE_ENUMINT),
	/* flags       */ P80211ITEM_SETFLAGS(ISREQUIRED, 0UL, ISCONFIRM),
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 0,
	/* enumptr     */ &MKENUMNAME(resultcode),
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_enumint,
	/* fromtextptr */ p80211_fromtext_enumint,
	/* validfunptr */ p80211_isvalid_enumint
}
};  /* end of dot11req_authenticate request message metadata list */

UINT32	MKREQMETASIZE(dot11req_authenticate) = 
		sizeof(MKREQMETANAME(dot11req_authenticate))/sizeof(p80211meta_t);

/*--------------------------------------------------------------------*/
/* metadata for the dot11req_deauthenticate request message arguments */

extern	UINT32	MKREQMETASIZE(dot11req_deauthenticate);

p80211meta_t MKREQMETANAME(dot11req_deauthenticate)[] = {
{
	/* name        */ (char *)&(MKREQMETASIZE(dot11req_deauthenticate)),
	/* did         */ 0,
	/* flags       */ 0,
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 0,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ NULL,
	/* fromtextptr */ NULL,
	/* validfunptr */ NULL
},
{
	/* name        */ "peerstaaddress",
	/* did         */ P80211DID_MKID(0,0,0,0,0,0,P80211_TYPE_OCTETSTR),
	/* flags       */ P80211ITEM_SETFLAGS(ISREQUIRED, ISREQUEST, ISCONFIRM),
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ MAXLEN_PSTR6,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_octetstr,
	/* fromtextptr */ p80211_fromtext_octetstr,
	/* validfunptr */ p80211_isvalid_octetstr
},
{
	/* name        */ MKITEMNAME("reasoncode"),
	/* did         */ P80211DID_MKID(0,0,0,0,0,0,P80211_TYPE_ENUMINT),
	/* flags       */ P80211ITEM_SETFLAGS(ISREQUIRED, ISREQUEST, 0UL),
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 0,
	/* enumptr     */ &MKENUMNAME(reason),
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_enumint,
	/* fromtextptr */ p80211_fromtext_enumint,
	/* validfunptr */ p80211_isvalid_enumint
},
{
	/* name        */ MKITEMNAME("resultcode"),
	/* did         */ P80211DID_MKID(0,0,0,0,0,0,P80211_TYPE_ENUMINT),
	/* flags       */ P80211ITEM_SETFLAGS(ISREQUIRED, 0UL, ISCONFIRM),
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 0,
	/* enumptr     */ &MKENUMNAME(resultcode),
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_enumint,
	/* fromtextptr */ p80211_fromtext_enumint,
	/* validfunptr */ p80211_isvalid_enumint
}
};  /* end of dot11req_deauthenticate request message metadata list */

UINT32	MKREQMETASIZE(dot11req_deauthenticate) = 
		sizeof(MKREQMETANAME(dot11req_deauthenticate))/sizeof(p80211meta_t);

/*--------------------------------------------------------------------*/
/* metadata for the dot11req_associate request message arguments */

extern	UINT32	MKREQMETASIZE(dot11req_associate);

p80211meta_t MKREQMETANAME(dot11req_associate)[] = {
{
	/* name        */ (char *)&(MKREQMETASIZE(dot11req_associate)),
	/* did         */ 0,
	/* flags       */ 0,
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 0,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ NULL,
	/* fromtextptr */ NULL,
	/* validfunptr */ NULL
},
{
	/* name        */ "peerstaaddress",
	/* did         */ P80211DID_MKID(0,0,0,0,0,0,P80211_TYPE_OCTETSTR),
	/* flags       */ P80211ITEM_SETFLAGS(0UL, ISREQUEST, 0UL),
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ MAXLEN_PSTR6,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_octetstr,
	/* fromtextptr */ p80211_fromtext_octetstr,
	/* validfunptr */ p80211_isvalid_octetstr
},
{
	/* name        */ "associatefailuretimeout",
	/* did         */ P80211DID_MKID(0,0,0,0,0,0,P80211_TYPE_BOUNDEDINT),
	/* flags       */ P80211ITEM_SETFLAGS(0UL, ISREQUEST, 0UL),
	/* min         */ 1,
	/* max         */ UINT32_MAX,
	/* maxlen      */ 0,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_boundedint,
	/* fromtextptr */ p80211_fromtext_boundedint,
	/* validfunptr */ p80211_isvalid_boundedint
},
{
	/* name        */ MKITEMNAME("cfpollable"),
	/* did         */ P80211DID_MKID(0,0,0,0,0,0,P80211_TYPE_ENUMINT),
	/* flags       */ P80211ITEM_SETFLAGS(0UL, ISREQUEST, 0UL),
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 0,
	/* enumptr     */ &MKENUMNAME(truth),
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_enumint,
	/* fromtextptr */ p80211_fromtext_enumint,
	/* validfunptr */ p80211_isvalid_enumint
},
{
	/* name        */ MKITEMNAME("cfpollreq"),
	/* did         */ P80211DID_MKID(0,0,0,0,0,0,P80211_TYPE_ENUMINT),
	/* flags       */ P80211ITEM_SETFLAGS(0UL, ISREQUEST, 0UL),
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 0,
	/* enumptr     */ &MKENUMNAME(truth),
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_enumint,
	/* fromtextptr */ p80211_fromtext_enumint,
	/* validfunptr */ p80211_isvalid_enumint
},
{
	/* name        */ MKITEMNAME("privacy"),
	/* did         */ P80211DID_MKID(0,0,0,0,0,0,P80211_TYPE_ENUMINT),
	/* flags       */ P80211ITEM_SETFLAGS(0UL, ISREQUEST, 0UL),
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 0,
	/* enumptr     */ &MKENUMNAME(truth),
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_enumint,
	/* fromtextptr */ p80211_fromtext_enumint,
	/* validfunptr */ p80211_isvalid_enumint
},
{
	/* name        */ MKITEMNAME("listeninterval"),
	/* did         */ P80211DID_MKID(0,0,0,0,0,0,P80211_TYPE_INT),
	/* flags       */ P80211ITEM_SETFLAGS(ISREQUIRED, ISREQUEST, 0UL),
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 0,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_int,
	/* fromtextptr */ p80211_fromtext_int,
	/* validfunptr */ p80211_isvalid_int
},
{
	/* name        */ MKITEMNAME("resultcode"),
	/* did         */ P80211DID_MKID(0,0,0,0,0,0,P80211_TYPE_ENUMINT),
	/* flags       */ P80211ITEM_SETFLAGS(ISREQUIRED, 0UL, ISCONFIRM),
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 0,
	/* enumptr     */ &MKENUMNAME(resultcode),
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_enumint,
	/* fromtextptr */ p80211_fromtext_enumint,
	/* validfunptr */ p80211_isvalid_enumint
}
};  /* end of dot11req_associate request message metadata list */

UINT32	MKREQMETASIZE(dot11req_associate) = 
		sizeof(MKREQMETANAME(dot11req_associate))/sizeof(p80211meta_t);

/*--------------------------------------------------------------------*/
/* metadata for the dot11req_reassociate request message arguments */

extern	UINT32	MKREQMETASIZE(dot11req_reassociate);

p80211meta_t MKREQMETANAME(dot11req_reassociate)[] = {
{
	/* name        */ (char *)&(MKREQMETASIZE(dot11req_reassociate)),
	/* did         */ 0,
	/* flags       */ 0,
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 0,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ NULL,
	/* fromtextptr */ NULL,
	/* validfunptr */ NULL
},
{
	/* name        */ "newapaddress",
	/* did         */ P80211DID_MKID(0,0,0,0,0,0,P80211_TYPE_OCTETSTR),
	/* flags       */ P80211ITEM_SETFLAGS(ISREQUIRED, ISREQUEST, 0UL),
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ MAXLEN_PSTR6,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_octetstr,
	/* fromtextptr */ p80211_fromtext_octetstr,
	/* validfunptr */ p80211_isvalid_octetstr
},
{
	/* name        */ "dot11req_reassociatefailuretimeout",
	/* did         */ P80211DID_MKID(0,0,0,0,0,0,P80211_TYPE_BOUNDEDINT),
	/* flags       */ P80211ITEM_SETFLAGS(ISREQUIRED, ISREQUEST, 0UL),
	/* min         */ 1,
	/* max         */ UINT32_MAX,
	/* maxlen      */ 0,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_boundedint,
	/* fromtextptr */ p80211_fromtext_boundedint,
	/* validfunptr */ p80211_isvalid_boundedint
},
{
	/* name        */ MKITEMNAME("cfpollable"),
	/* did         */ P80211DID_MKID(0,0,0,0,0,0,P80211_TYPE_ENUMINT),
	/* flags       */ P80211ITEM_SETFLAGS(ISREQUIRED, ISREQUEST, 0UL),
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 0,
	/* enumptr     */ &MKENUMNAME(truth),
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_enumint,
	/* fromtextptr */ p80211_fromtext_enumint,
	/* validfunptr */ p80211_isvalid_enumint
},
{
	/* name        */ MKITEMNAME("cfpollreq"),
	/* did         */ P80211DID_MKID(0,0,0,0,0,0,P80211_TYPE_ENUMINT),
	/* flags       */ P80211ITEM_SETFLAGS(ISREQUIRED, ISREQUEST, 0UL),
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 0,
	/* enumptr     */ &MKENUMNAME(truth),
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_enumint,
	/* fromtextptr */ p80211_fromtext_enumint,
	/* validfunptr */ p80211_isvalid_enumint
},
{
	/* name        */ MKITEMNAME("privacy"),
	/* did         */ P80211DID_MKID(0,0,0,0,0,0,P80211_TYPE_ENUMINT),
	/* flags       */ P80211ITEM_SETFLAGS(ISREQUIRED, ISREQUEST, 0UL),
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 0,
	/* enumptr     */ &MKENUMNAME(truth),
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_enumint,
	/* fromtextptr */ p80211_fromtext_enumint,
	/* validfunptr */ p80211_isvalid_enumint
},
{
	/* name        */ MKITEMNAME("listeninterval"),
	/* did         */ P80211DID_MKID(0,0,0,0,0,0,P80211_TYPE_INT),
	/* flags       */ P80211ITEM_SETFLAGS(ISREQUIRED, ISREQUEST, 0UL),
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 0,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_int,
	/* fromtextptr */ p80211_fromtext_int,
	/* validfunptr */ p80211_isvalid_int
},
{
	/* name        */ MKITEMNAME("resultcode"),
	/* did         */ P80211DID_MKID(0,0,0,0,0,0,P80211_TYPE_ENUMINT),
	/* flags       */ P80211ITEM_SETFLAGS(ISREQUIRED, 0UL, ISCONFIRM),
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 0,
	/* enumptr     */ &MKENUMNAME(resultcode),
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_enumint,
	/* fromtextptr */ p80211_fromtext_enumint,
	/* validfunptr */ p80211_isvalid_enumint
}
};  /* end of dot11req_reassociate request message metadata list */

UINT32	MKREQMETASIZE(dot11req_reassociate) = sizeof(MKREQMETANAME(dot11req_reassociate))/sizeof(p80211meta_t);

/*--------------------------------------------------------------------*/
/* metadata for the dot11req_disassociate request message arguments */

extern	UINT32	MKREQMETASIZE(dot11req_disassociate);

p80211meta_t MKREQMETANAME(dot11req_disassociate)[] = {
{
	/* name        */ (char *)&(MKREQMETASIZE(dot11req_disassociate)),
	/* did         */ 0,
	/* flags       */ 0,
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 0,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ NULL,
	/* fromtextptr */ NULL,
	/* validfunptr */ NULL
},
{
	/* name        */ "peerstaaddress",
	/* did         */ P80211DID_MKID(0,0,0,0,0,0,P80211_TYPE_OCTETSTR),
	/* flags       */ P80211ITEM_SETFLAGS(ISREQUIRED, ISREQUEST, ISCONFIRM),
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ MAXLEN_PSTR6,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_octetstr,
	/* fromtextptr */ p80211_fromtext_octetstr,
	/* validfunptr */ p80211_isvalid_octetstr
},
{
	/* name        */ MKITEMNAME("reasoncode"),
	/* did         */ P80211DID_MKID(0,0,0,0,0,0,P80211_TYPE_ENUMINT),
	/* flags       */ P80211ITEM_SETFLAGS(ISREQUIRED, ISREQUEST, 0UL),
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 0,
	/* enumptr     */ &MKENUMNAME(reason),
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_enumint,
	/* fromtextptr */ p80211_fromtext_enumint,
	/* validfunptr */ p80211_isvalid_enumint
},
{
	/* name        */ MKITEMNAME("resultcode"),
	/* did         */ P80211DID_MKID(0,0,0,0,0,0,P80211_TYPE_ENUMINT),
	/* flags       */ P80211ITEM_SETFLAGS(ISREQUIRED, 0UL, ISCONFIRM),
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 0,
	/* enumptr     */ &MKENUMNAME(resultcode),
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_enumint,
	/* fromtextptr */ p80211_fromtext_enumint,
	/* validfunptr */ p80211_isvalid_enumint
}
};  /* end of dot11req_disassociate request message metadata list */

UINT32	MKREQMETASIZE(dot11req_disassociate) = sizeof(MKREQMETANAME(dot11req_disassociate))/sizeof(p80211meta_t);

/*--------------------------------------------------------------------*/
/* metadata for the dot11req_start request message arguments */

extern	UINT32	MKREQMETASIZE(dot11req_start);

p80211meta_t MKREQMETANAME(dot11req_start)[] = {
{
	/* name        */ (char *)&(MKREQMETASIZE(dot11req_start)),
	/* did         */ 0,
	/* flags       */ 0,
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 0,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ NULL,
	/* fromtextptr */ NULL,
	/* validfunptr */ NULL
},
{
	/* name        */ "ssid",
	/* did         */ P80211DID_MKID(0,0,0,0,0,0,P80211_TYPE_DISPLAYSTR),
	/* flags       */ P80211ITEM_SETFLAGS(ISREQUIRED, ISREQUEST, 0UL),
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ MAXLEN_PSTR32,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_displaystr,
	/* fromtextptr */ p80211_fromtext_displaystr,
	/* validfunptr */ p80211_isvalid_displaystr
},
{
	/* name        */ MKITEMNAME("bsstype"),
	/* did         */ P80211DID_MKID(0,0,0,0,0,0,P80211_TYPE_ENUMINT),
	/* flags       */ P80211ITEM_SETFLAGS(ISREQUIRED, ISREQUEST, 0UL),
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 0,
	/* enumptr     */ &MKENUMNAME(bsstype),
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_enumint,
	/* fromtextptr */ p80211_fromtext_enumint,
	/* validfunptr */ p80211_isvalid_enumint
},
{
	/* name        */ MKITEMNAME("beaconperiod"),
	/* did         */ P80211DID_MKID(0,0,0,0,0,0,P80211_TYPE_BOUNDEDINT),
	/* flags       */ P80211ITEM_SETFLAGS(ISREQUIRED, ISREQUEST, 0UL),
	/* min         */ 1,
	/* max         */ 65535,
	/* maxlen      */ 0,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_boundedint,
	/* fromtextptr */ p80211_fromtext_boundedint,
	/* validfunptr */ p80211_isvalid_boundedint
},
{
	/* name        */ MKITEMNAME("dtimperiod"),
	/* did         */ P80211DID_MKID(0,0,0,0,0,0,P80211_TYPE_BOUNDEDINT),
	/* flags       */ P80211ITEM_SETFLAGS(ISREQUIRED, ISREQUEST, 0UL),
	/* min         */ 1,
	/* max         */ 255,
	/* maxlen      */ 0,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_boundedint,
	/* fromtextptr */ p80211_fromtext_boundedint,
	/* validfunptr */ p80211_isvalid_boundedint
},
{
	/* name        */ MKITEMNAME("cfpperiod"),
	/* did         */ P80211DID_MKID(0,0,0,0,0,0,P80211_TYPE_BOUNDEDINT),
	/* flags       */ P80211ITEM_SETFLAGS(0UL, ISREQUEST, 0UL),
	/* min         */ 0,
	/* max         */ 255,
	/* maxlen      */ 0,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_boundedint,
	/* fromtextptr */ p80211_fromtext_boundedint,
	/* validfunptr */ p80211_isvalid_boundedint
},
{
	/* name        */ MKITEMNAME("cfpmaxduration"),
	/* did         */ P80211DID_MKID(0,0,0,0,0,0,P80211_TYPE_BOUNDEDINT),
	/* flags       */ P80211ITEM_SETFLAGS(0UL, ISREQUEST, 0UL),
	/* min         */ 0,
	/* max         */ 65535,
	/* maxlen      */ 0,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_boundedint,
	/* fromtextptr */ p80211_fromtext_boundedint,
	/* validfunptr */ p80211_isvalid_boundedint
},
{
	/* name        */ MKITEMNAME("fhdwelltime"),
	/* did         */ P80211DID_MKID(0,0,0,0,0,0,P80211_TYPE_BOUNDEDINT),
	/* flags       */ P80211ITEM_SETFLAGS(0UL, ISREQUEST, 0UL),
	/* min         */ 1,
	/* max         */ 65535,
	/* maxlen      */ 0,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_boundedint,
	/* fromtextptr */ p80211_fromtext_boundedint,
	/* validfunptr */ p80211_isvalid_boundedint
},
{
	/* name        */ MKITEMNAME("fhhopset"),
	/* did         */ P80211DID_MKID(0,0,0,0,0,0,P80211_TYPE_BOUNDEDINT),
	/* flags       */ P80211ITEM_SETFLAGS(0UL, ISREQUEST, 0UL),
	/* min         */ 1,
	/* max         */ 255,
	/* maxlen      */ 0,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_boundedint,
	/* fromtextptr */ p80211_fromtext_boundedint,
	/* validfunptr */ p80211_isvalid_boundedint
},
{
	/* name        */ MKITEMNAME("fhhoppattern"),
	/* did         */ P80211DID_MKID(0,0,0,0,0,0,P80211_TYPE_BOUNDEDINT),
	/* flags       */ P80211ITEM_SETFLAGS(0UL, ISREQUEST, 0UL),
	/* min         */ 0,
	/* max         */ 255,
	/* maxlen      */ 0,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_boundedint,
	/* fromtextptr */ p80211_fromtext_boundedint,
	/* validfunptr */ p80211_isvalid_boundedint
},
{
	/* name        */ MKITEMNAME("dschannel"),
	/* did         */ P80211DID_MKID(0,0,0,0,0,0,P80211_TYPE_BOUNDEDINT),
	/* flags       */ P80211ITEM_SETFLAGS(0UL, ISREQUEST, 0UL),
	/* min         */ 1,
	/* max         */ 14,
	/* maxlen      */ 0,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_boundedint,
	/* fromtextptr */ p80211_fromtext_boundedint,
	/* validfunptr */ p80211_isvalid_boundedint
},
{
	/* name        */ MKITEMNAME("ibssatimwindow"),
	/* did         */ P80211DID_MKID(0,0,0,0,0,0,P80211_TYPE_INT),
	/* flags       */ P80211ITEM_SETFLAGS(0UL, ISREQUEST, 0UL),
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 0,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_int,
	/* fromtextptr */ p80211_fromtext_int,
	/* validfunptr */ p80211_isvalid_int
},
{
	/* name        */ MKITEMNAME("probedelay"),
	/* did         */ P80211DID_MKID(0,0,0,0,0,0,P80211_TYPE_INT),
	/* flags       */ P80211ITEM_SETFLAGS(ISREQUIRED, ISREQUEST, 0UL),
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 0,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_int,
	/* fromtextptr */ p80211_fromtext_int,
	/* validfunptr */ p80211_isvalid_int
},
{
	/* name        */ MKITEMNAME("cfpollable"),
	/* did         */ P80211DID_MKID(0,0,0,0,0,0,P80211_TYPE_ENUMINT),
	/* flags       */ P80211ITEM_SETFLAGS(ISREQUIRED, ISREQUEST, 0UL),
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 0,
	/* enumptr     */ &MKENUMNAME(truth),
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_enumint,
	/* fromtextptr */ p80211_fromtext_enumint,
	/* validfunptr */ p80211_isvalid_enumint
},
{
	/* name        */ MKITEMNAME("cfpollreq"),
	/* did         */ P80211DID_MKID(0,0,0,0,0,0,P80211_TYPE_ENUMINT),
	/* flags       */ P80211ITEM_SETFLAGS(ISREQUIRED, ISREQUEST, 0UL),
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 0,
	/* enumptr     */ &MKENUMNAME(truth),
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_enumint,
	/* fromtextptr */ p80211_fromtext_enumint,
	/* validfunptr */ p80211_isvalid_enumint
},
{
	/* name        */ MKITEMNAME("basicrate1"),
	/* did         */ P80211DID_MKID(0,0,0,0,0,0,P80211_TYPE_BOUNDEDINT),
	/* flags       */ P80211ITEM_SETFLAGS(ISREQUIRED, ISREQUEST, 0UL),
	/* min         */ 2,
	/* max         */ 127,
	/* maxlen      */ 0,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_boundedint,
	/* fromtextptr */ p80211_fromtext_boundedint,
	/* validfunptr */ p80211_isvalid_boundedint
},
{
	/* name        */ MKITEMNAME("basicrate2"),
	/* did         */ P80211DID_MKID(0,0,0,0,0,0,P80211_TYPE_BOUNDEDINT),
	/* flags       */ P80211ITEM_SETFLAGS(0UL, ISREQUEST, 0UL),
	/* min         */ 2,
	/* max         */ 127,
	/* maxlen      */ 0,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_boundedint,
	/* fromtextptr */ p80211_fromtext_boundedint,
	/* validfunptr */ p80211_isvalid_boundedint
},
{
	/* name        */ MKITEMNAME("basicrate3"),
	/* did         */ P80211DID_MKID(0,0,0,0,0,0,P80211_TYPE_BOUNDEDINT),
	/* flags       */ P80211ITEM_SETFLAGS(0UL, ISREQUEST, 0UL),
	/* min         */ 2,
	/* max         */ 127,
	/* maxlen      */ 0,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_boundedint,
	/* fromtextptr */ p80211_fromtext_boundedint,
	/* validfunptr */ p80211_isvalid_boundedint
},
{
	/* name        */ MKITEMNAME("basicrate4"),
	/* did         */ P80211DID_MKID(0,0,0,0,0,0,P80211_TYPE_BOUNDEDINT),
	/* flags       */ P80211ITEM_SETFLAGS(0UL, ISREQUEST, 0UL),
	/* min         */ 2,
	/* max         */ 127,
	/* maxlen      */ 0,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_boundedint,
	/* fromtextptr */ p80211_fromtext_boundedint,
	/* validfunptr */ p80211_isvalid_boundedint
},
{
	/* name        */ MKITEMNAME("basicrate5"),
	/* did         */ P80211DID_MKID(0,0,0,0,0,0,P80211_TYPE_BOUNDEDINT),
	/* flags       */ P80211ITEM_SETFLAGS(0UL, ISREQUEST, 0UL),
	/* min         */ 2,
	/* max         */ 127,
	/* maxlen      */ 0,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_boundedint,
	/* fromtextptr */ p80211_fromtext_boundedint,
	/* validfunptr */ p80211_isvalid_boundedint
},
{
	/* name        */ MKITEMNAME("basicrate6"),
	/* did         */ P80211DID_MKID(0,0,0,0,0,0,P80211_TYPE_BOUNDEDINT),
	/* flags       */ P80211ITEM_SETFLAGS(0UL, ISREQUEST, 0UL),
	/* min         */ 2,
	/* max         */ 127,
	/* maxlen      */ 0,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_boundedint,
	/* fromtextptr */ p80211_fromtext_boundedint,
	/* validfunptr */ p80211_isvalid_boundedint
},
{
	/* name        */ MKITEMNAME("basicrate7"),
	/* did         */ P80211DID_MKID(0,0,0,0,0,0,P80211_TYPE_BOUNDEDINT),
	/* flags       */ P80211ITEM_SETFLAGS(0UL, ISREQUEST, 0UL),
	/* min         */ 2,
	/* max         */ 127,
	/* maxlen      */ 0,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_boundedint,
	/* fromtextptr */ p80211_fromtext_boundedint,
	/* validfunptr */ p80211_isvalid_boundedint
},
{
	/* name        */ MKITEMNAME("basicrate8"),
	/* did         */ P80211DID_MKID(0,0,0,0,0,0,P80211_TYPE_BOUNDEDINT),
	/* flags       */ P80211ITEM_SETFLAGS(0UL, ISREQUEST, 0UL),
	/* min         */ 2,
	/* max         */ 127,
	/* maxlen      */ 0,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_boundedint,
	/* fromtextptr */ p80211_fromtext_boundedint,
	/* validfunptr */ p80211_isvalid_boundedint
},
{
	/* name        */ MKITEMNAME("operationalrate1"),
	/* did         */ P80211DID_MKID(0,0,0,0,0,0,P80211_TYPE_BOUNDEDINT),
	/* flags       */ P80211ITEM_SETFLAGS(ISREQUIRED, ISREQUEST, 0UL),
	/* min         */ 2,
	/* max         */ 127,
	/* maxlen      */ 0,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_boundedint,
	/* fromtextptr */ p80211_fromtext_boundedint,
	/* validfunptr */ p80211_isvalid_boundedint
},
{
	/* name        */ MKITEMNAME("operationalrate2"),
	/* did         */ P80211DID_MKID(0,0,0,0,0,0,P80211_TYPE_BOUNDEDINT),
	/* flags       */ P80211ITEM_SETFLAGS(0UL, ISREQUEST, 0UL),
	/* min         */ 2,
	/* max         */ 127,
	/* maxlen      */ 0,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_boundedint,
	/* fromtextptr */ p80211_fromtext_boundedint,
	/* validfunptr */ p80211_isvalid_boundedint
},
{
	/* name        */ MKITEMNAME("operationalrate3"),
	/* did         */ P80211DID_MKID(0,0,0,0,0,0,P80211_TYPE_BOUNDEDINT),
	/* flags       */ P80211ITEM_SETFLAGS(0UL, ISREQUEST, 0UL),
	/* min         */ 2,
	/* max         */ 127,
	/* maxlen      */ 0,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_boundedint,
	/* fromtextptr */ p80211_fromtext_boundedint,
	/* validfunptr */ p80211_isvalid_boundedint
},
{
	/* name        */ MKITEMNAME("operationalrate4"),
	/* did         */ P80211DID_MKID(0,0,0,0,0,0,P80211_TYPE_BOUNDEDINT),
	/* flags       */ P80211ITEM_SETFLAGS(0UL, ISREQUEST, 0UL),
	/* min         */ 2,
	/* max         */ 127,
	/* maxlen      */ 0,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_boundedint,
	/* fromtextptr */ p80211_fromtext_boundedint,
	/* validfunptr */ p80211_isvalid_boundedint
},
{
	/* name        */ MKITEMNAME("operationalrate5"),
	/* did         */ P80211DID_MKID(0,0,0,0,0,0,P80211_TYPE_BOUNDEDINT),
	/* flags       */ P80211ITEM_SETFLAGS(0UL, ISREQUEST, 0UL),
	/* min         */ 2,
	/* max         */ 127,
	/* maxlen      */ 0,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_boundedint,
	/* fromtextptr */ p80211_fromtext_boundedint,
	/* validfunptr */ p80211_isvalid_boundedint
},
{
	/* name        */ MKITEMNAME("operationalrate6"),
	/* did         */ P80211DID_MKID(0,0,0,0,0,0,P80211_TYPE_BOUNDEDINT),
	/* flags       */ P80211ITEM_SETFLAGS(0UL, ISREQUEST, 0UL),
	/* min         */ 2,
	/* max         */ 127,
	/* maxlen      */ 0,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_boundedint,
	/* fromtextptr */ p80211_fromtext_boundedint,
	/* validfunptr */ p80211_isvalid_boundedint
},
{
	/* name        */ MKITEMNAME("operationalrate7"),
	/* did         */ P80211DID_MKID(0,0,0,0,0,0,P80211_TYPE_BOUNDEDINT),
	/* flags       */ P80211ITEM_SETFLAGS(0UL, ISREQUEST, 0UL),
	/* min         */ 2,
	/* max         */ 127,
	/* maxlen      */ 0,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_boundedint,
	/* fromtextptr */ p80211_fromtext_boundedint,
	/* validfunptr */ p80211_isvalid_boundedint
},
{
	/* name        */ MKITEMNAME("operationalrate8"),
	/* did         */ P80211DID_MKID(0,0,0,0,0,0,P80211_TYPE_BOUNDEDINT),
	/* flags       */ P80211ITEM_SETFLAGS(0UL, ISREQUEST, 0UL),
	/* min         */ 2,
	/* max         */ 127,
	/* maxlen      */ 0,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_boundedint,
	/* fromtextptr */ p80211_fromtext_boundedint,
	/* validfunptr */ p80211_isvalid_boundedint
},
{
	/* name        */ MKITEMNAME("resultcode"),
	/* did         */ P80211DID_MKID(0,0,0,0,0,0,P80211_TYPE_ENUMINT),
	/* flags       */ P80211ITEM_SETFLAGS(ISREQUIRED, 0UL, ISCONFIRM),
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 0,
	/* enumptr     */ &MKENUMNAME(resultcode),
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_enumint,
	/* fromtextptr */ p80211_fromtext_enumint,
	/* validfunptr */ p80211_isvalid_enumint
}
};  /* end of dot11req_start request message metadata list */

UINT32	MKREQMETASIZE(dot11req_start) = 
		sizeof(MKREQMETANAME(dot11req_start))/sizeof(p80211meta_t);

/*--------------------------------------------------------------------*/
/* metadata for the dot11ind_authenticate indication message arguments */

extern	UINT32	MKINDMETASIZE(dot11ind_authenticate);

p80211meta_t MKINDMETANAME(dot11ind_authenticate)[] = {
{
	/* name        */ (char *)&(MKINDMETASIZE(dot11ind_authenticate)),
	/* did         */ 0,
	/* flags       */ 0,
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 0,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ NULL,
	/* fromtextptr */ NULL,
	/* validfunptr */ NULL
},
{
	/* name        */ "peerstaaddress",
	/* did         */ P80211DID_MKID(0,0,0,0,0,0,P80211_TYPE_OCTETSTR),
	/* flags       */ P80211ITEM_SETFLAGS(ISREQUIRED, ISREQUEST, ISCONFIRM),
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ MAXLEN_PSTR6,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_octetstr,
	/* fromtextptr */ p80211_fromtext_octetstr,
	/* validfunptr */ p80211_isvalid_octetstr
},
{
	/* name        */ MKITEMNAME("authenticationtype"),
	/* did         */ P80211DID_MKID(0,0,0,0,0,0,P80211_TYPE_ENUMINT),
	/* flags       */ P80211ITEM_SETFLAGS(ISREQUIRED, ISREQUEST, ISCONFIRM),
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 0,
	/* enumptr     */ &MKENUMNAME(authalg),
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_enumint,
	/* fromtextptr */ p80211_fromtext_enumint,
	/* validfunptr */ p80211_isvalid_enumint
}
};  /* end of dot11ind_authenticate indication metadata list */

UINT32	MKINDMETASIZE(dot11ind_authenticate) = 
		sizeof(MKINDMETANAME(dot11ind_authenticate))/sizeof(p80211meta_t);

/*--------------------------------------------------------------------*/
/* metadata for the authenticate indication message arguments */

extern	UINT32	MKINDMETASIZE(dot11ind_deauthenticate);

p80211meta_t MKINDMETANAME(dot11ind_deauthenticate)[] = {
{
	/* name        */ (char *)&(MKINDMETASIZE(dot11ind_deauthenticate)),
	/* did         */ 0,
	/* flags       */ 0,
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 0,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ NULL,
	/* fromtextptr */ NULL,
	/* validfunptr */ NULL
},
{
	/* name        */ "peerstaaddress",
	/* did         */ P80211DID_MKID(0,0,0,0,0,0,P80211_TYPE_OCTETSTR),
	/* flags       */ P80211ITEM_SETFLAGS(ISREQUIRED, ISREQUEST, ISCONFIRM),
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ MAXLEN_PSTR6,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_octetstr,
	/* fromtextptr */ p80211_fromtext_octetstr,
	/* validfunptr */ p80211_isvalid_octetstr
},
{
	/* name        */ MKITEMNAME("reasoncode"),
	/* did         */ P80211DID_MKID(0,0,0,0,0,0,P80211_TYPE_ENUMINT),
	/* flags       */ P80211ITEM_SETFLAGS(ISREQUIRED, ISREQUEST, 0UL),
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 0,
	/* enumptr     */ &MKENUMNAME(reason),
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_enumint,
	/* fromtextptr */ p80211_fromtext_enumint,
	/* validfunptr */ p80211_isvalid_enumint
}
};  /* end of dot11ind_deauthenticate indication metadata list */

UINT32	MKINDMETASIZE(dot11ind_deauthenticate) = 
		sizeof(MKINDMETANAME(dot11ind_deauthenticate))/sizeof(p80211meta_t);

/*--------------------------------------------------------------------*/
/* metadata for the dot11ind_associate indication message arguments */

extern	UINT32	MKINDMETASIZE(dot11ind_associate);

p80211meta_t MKINDMETANAME(dot11ind_associate)[] = {
{
	/* name        */ (char *)&(MKINDMETASIZE(dot11ind_associate)),
	/* did         */ 0,
	/* flags       */ 0,
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 0,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ NULL,
	/* fromtextptr */ NULL,
	/* validfunptr */ NULL
},
{
	/* name        */ "peerstaaddress",
	/* did         */ P80211DID_MKID(0,0,0,0,0,0,P80211_TYPE_OCTETSTR),
	/* flags       */ P80211ITEM_SETFLAGS(ISREQUIRED, ISREQUEST, 0UL),
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ MAXLEN_PSTR6,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_octetstr,
	/* fromtextptr */ p80211_fromtext_octetstr,
	/* validfunptr */ p80211_isvalid_octetstr
}
};  /* end of dot11ind_associate indication metadata list */

UINT32	MKINDMETASIZE(dot11ind_associate) =
		sizeof(MKINDMETANAME(dot11ind_associate))/sizeof(p80211meta_t);

/*--------------------------------------------------------------------*/
/* metadata for the reassociate indication message arguments */

extern	UINT32	MKINDMETASIZE(dot11ind_reassociate);

p80211meta_t MKINDMETANAME(dot11ind_reassociate)[] = {
{
	/* name        */ (char *)&(MKINDMETASIZE(dot11ind_reassociate)),
	/* did         */ 0,
	/* flags       */ 0,
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 0,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ NULL,
	/* fromtextptr */ NULL,
	/* validfunptr */ NULL
},
{
	/* name        */ "peerstaaddress",
	/* did         */ P80211DID_MKID(0,0,0,0,0,0,P80211_TYPE_OCTETSTR),
	/* flags       */ P80211ITEM_SETFLAGS(ISREQUIRED, ISREQUEST, 0UL),
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ MAXLEN_PSTR6,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_octetstr,
	/* fromtextptr */ p80211_fromtext_octetstr,
	/* validfunptr */ p80211_isvalid_octetstr
}
};  /* end of dot11ind_reassociate indication metadata list */

UINT32	MKINDMETASIZE(dot11ind_reassociate) = 
		sizeof(MKINDMETANAME(dot11ind_reassociate))/sizeof(p80211meta_t);

/*--------------------------------------------------------------------*/
/* metadata for the dot11ind_disassociate indication message arguments */

extern	UINT32	MKINDMETASIZE(dot11ind_disassociate);

p80211meta_t MKINDMETANAME(dot11ind_disassociate)[] = {
{
	/* name        */ (char *)&(MKINDMETASIZE(dot11ind_disassociate)),
	/* did         */ 0,
	/* flags       */ 0,
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 0,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ NULL,
	/* fromtextptr */ NULL,
	/* validfunptr */ NULL
},
{
	/* name        */ "peerstaaddress",
	/* did         */ P80211DID_MKID(0,0,0,0,0,0,P80211_TYPE_OCTETSTR),
	/* flags       */ P80211ITEM_SETFLAGS(ISREQUIRED, ISREQUEST, ISCONFIRM),
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ MAXLEN_PSTR6,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_octetstr,
	/* fromtextptr */ p80211_fromtext_octetstr,
	/* validfunptr */ p80211_isvalid_octetstr
},
{
	/* name        */ MKITEMNAME("reasoncode"),
	/* did         */ P80211DID_MKID(0,0,0,0,0,0,P80211_TYPE_ENUMINT),
	/* flags       */ P80211ITEM_SETFLAGS(ISREQUIRED, ISREQUEST, 0UL),
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 0,
	/* enumptr     */ &MKENUMNAME(reason),
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_enumint,
	/* fromtextptr */ p80211_fromtext_enumint,
	/* validfunptr */ p80211_isvalid_enumint
}
};  /* end of dot11ind_disassociate indication metadata list */

UINT32	MKINDMETASIZE(dot11ind_disassociate) = 
		sizeof(MKINDMETANAME(dot11ind_disassociate))/sizeof(p80211meta_t);


/*--------------------------------------------------------------------*/
/* metadata for the wlansnif request message arguments */

extern	UINT32	MKREQMETASIZE(lnxreq_wlansniff);

p80211meta_t MKREQMETANAME(lnxreq_wlansniff)[] = {
{
	/* name        */ (char *)&(MKREQMETASIZE(lnxreq_wlansniff)),
	/* did         */ 0,
	/* flags       */ 0,
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 0,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ NULL,
	/* fromtextptr */ NULL,
	/* validfunptr */ NULL
},
{
	/* name        */ "enable",
	/* did         */ P80211DID_MKID(0,0,0,0,0,0,P80211_TYPE_ENUMINT),
	/* flags       */ P80211ITEM_SETFLAGS(ISREQUIRED, ISREQUEST, 0UL),
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 0,
	/* enumptr     */ &MKENUMNAME(truth),
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_enumint,
	/* fromtextptr */ p80211_fromtext_enumint,
	/* validfunptr */ p80211_isvalid_enumint
},
{
	/* name        */ "channel",
	/* did         */ P80211DID_MKID(0,0,0,0,0,0,P80211_TYPE_BOUNDEDINT),
	/* flags       */ P80211ITEM_SETFLAGS(0UL, ISREQUEST, 0UL),
	/* min         */ 1,
	/* max         */ 14,
	/* maxlen      */ 0,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_boundedint,
	/* fromtextptr */ p80211_fromtext_boundedint,
	/* validfunptr */ p80211_isvalid_boundedint
},
{
	/* name        */ MKITEMNAME("resultcode"),
	/* did         */ P80211DID_MKID(0,0,0,0,0,0,P80211_TYPE_ENUMINT),
	/* flags       */ P80211ITEM_SETFLAGS(ISREQUIRED, 0UL, ISCONFIRM),
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 0,
	/* enumptr     */ &MKENUMNAME(resultcode),
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_enumint,
	/* fromtextptr */ p80211_fromtext_enumint,
	/* validfunptr */ p80211_isvalid_enumint
}
};  /* end of lnxreq_wlansniff request metadata list */

UINT32	MKREQMETASIZE(lnxreq_wlansniff) = 
		sizeof(MKREQMETANAME(lnxreq_wlansniff))/sizeof(p80211meta_t);

/*--------------------------------------------------------------------*/
/* metadata for the wlansniffrm indication message arguments */

extern	UINT32	MKINDMETASIZE(lnxind_wlansniffrm);

p80211meta_t MKINDMETANAME(lnxind_wlansniffrm)[] = {
{
	/* name        */ (char *)&(MKINDMETASIZE(lnxind_wlansniffrm)),
	/* did         */ 0,
	/* flags       */ 0,
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 0,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ NULL,
	/* fromtextptr */ NULL,
	/* validfunptr */ NULL
},
{
	/* name        */ "hosttime",
	/* did         */ P80211DID_MKID(0,0,0,0,0,0,P80211_TYPE_INT),
	/* flags       */ P80211ITEM_SETFLAGS(ISREQUIRED, 0UL, 0UL),
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 0,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_int,
	/* fromtextptr */ p80211_fromtext_int,
	/* validfunptr */ p80211_isvalid_int
},
{
	/* name        */ "mactime",
	/* did         */ P80211DID_MKID(0,0,0,0,0,0,P80211_TYPE_INT),
	/* flags       */ P80211ITEM_SETFLAGS(0UL, 0UL, 0UL),
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 0,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_int,
	/* fromtextptr */ p80211_fromtext_int,
	/* validfunptr */ p80211_isvalid_int
},
{
	/* name        */ "channel",
	/* did         */ P80211DID_MKID(0,0,0,0,0,0,P80211_TYPE_INT),
	/* flags       */ P80211ITEM_SETFLAGS(0UL, 0UL, 0UL),
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 0,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_int,
	/* fromtextptr */ p80211_fromtext_int,
	/* validfunptr */ p80211_isvalid_int
},
{
	/* name        */ "rssi",
	/* did         */ P80211DID_MKID(0,0,0,0,0,0,P80211_TYPE_INT),
	/* flags       */ P80211ITEM_SETFLAGS(0UL, 0UL, 0UL),
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 0,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_int,
	/* fromtextptr */ p80211_fromtext_int,
	/* validfunptr */ p80211_isvalid_int
},
{
	/* name        */ "sq",
	/* did         */ P80211DID_MKID(0,0,0,0,0,0,P80211_TYPE_INT),
	/* flags       */ P80211ITEM_SETFLAGS(0UL, 0UL, 0UL),
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 0,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_int,
	/* fromtextptr */ p80211_fromtext_int,
	/* validfunptr */ p80211_isvalid_int
},
{
	/* name        */ "signal",
	/* did         */ P80211DID_MKID(0,0,0,0,0,0,P80211_TYPE_INT),
	/* flags       */ P80211ITEM_SETFLAGS(0UL, 0UL, 0UL),
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 0,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_int,
	/* fromtextptr */ p80211_fromtext_int,
	/* validfunptr */ p80211_isvalid_int
},
{
	/* name        */ "noise",
	/* did         */ P80211DID_MKID(0,0,0,0,0,0,P80211_TYPE_INT),
	/* flags       */ P80211ITEM_SETFLAGS(0UL, 0UL, 0UL),
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 0,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_int,
	/* fromtextptr */ p80211_fromtext_int,
	/* validfunptr */ p80211_isvalid_int
},
{
	/* name        */ "rate",
	/* did         */ P80211DID_MKID(0,0,0,0,0,0,P80211_TYPE_INT),
	/* flags       */ P80211ITEM_SETFLAGS(0UL, 0UL, 0UL),
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 0,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_int,
	/* fromtextptr */ p80211_fromtext_int,
	/* validfunptr */ p80211_isvalid_int
},
{
	/* name        */ "istx",
	/* did         */ P80211DID_MKID(0,0,0,0,0,0,P80211_TYPE_ENUMINT),
	/* flags       */ P80211ITEM_SETFLAGS(ISREQUIRED, 0UL, 0UL),
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 0,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_enumint,
	/* fromtextptr */ p80211_fromtext_enumint,
	/* validfunptr */ p80211_isvalid_enumint
},
{
	/* name        */ "frmlen",
	/* did         */ P80211DID_MKID(0,0,0,0,0,0,P80211_TYPE_INT),
	/* flags       */ P80211ITEM_SETFLAGS(ISREQUIRED, 0UL, 0UL),
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 0,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_int,
	/* fromtextptr */ p80211_fromtext_int,
	/* validfunptr */ p80211_isvalid_int
}
};  /* end of lnxind_wlansniffrm indication message */

UINT32	MKINDMETASIZE(lnxind_wlansniffrm) = 
		sizeof(MKINDMETANAME(lnxind_wlansniffrm))/sizeof(p80211meta_t);

/*--------------------------------------------------------------------*/
/* metadata for the p2req_readpda request message arguments */

extern	UINT32	MKREQMETASIZE(p2req_readpda);

p80211meta_t MKREQMETANAME(p2req_readpda)[] = {
{
	/* name        */ (char *)&(MKREQMETASIZE(p2req_readpda)),
	/* did         */ 0,
	/* flags       */ 0,
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 0,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ NULL,
	/* fromtextptr */ NULL,
	/* validfunptr */ NULL
},
{
	/* name        */ "pda",
	/* did         */ P80211DID_MKID(0,0,0,0,0,0,P80211_TYPE_UNKDATA),
	/* flags       */ P80211ITEM_SETFLAGS(ISREQUIRED, ISREQUEST, 0UL),
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 1024,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ NULL,  /* data only used by program...*/
	/* fromtextptr */ NULL,
	/* validfunptr */ NULL
},
{
	/* name        */ MKITEMNAME("resultcode"),
	/* did         */ P80211DID_MKID(0,0,0,0,0,0,P80211_TYPE_ENUMINT),
	/* flags       */ P80211ITEM_SETFLAGS(ISREQUIRED, 0UL, ISCONFIRM),
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 0,
	/* enumptr     */ &MKENUMNAME(resultcode),
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_enumint,
	/* fromtextptr */ p80211_fromtext_enumint,
	/* validfunptr */ p80211_isvalid_enumint
}
};  /* end of p2req_readpda request metadata list */

UINT32	MKREQMETASIZE(p2req_readpda) = 
		sizeof(MKREQMETANAME(p2req_readpda))/sizeof(p80211meta_t);

/*--------------------------------------------------------------------*/
/* metadata for the p2req_auxport_state request message arguments */

extern	UINT32	MKREQMETASIZE(p2req_auxport_state);

p80211meta_t MKREQMETANAME(p2req_auxport_state)[] = {
{
	/* name        */ (char *)&(MKREQMETASIZE(p2req_auxport_state)),
	/* did         */ 0,
	/* flags       */ 0,
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 0,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ NULL,
	/* fromtextptr */ NULL,
	/* validfunptr */ NULL
},
{
	/* name        */ "enable",
	/* did         */ P80211DID_MKID(0,0,0,0,0,0,P80211_TYPE_ENUMINT),
	/* flags       */ P80211ITEM_SETFLAGS(ISREQUIRED, ISREQUEST, 0UL),
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 0,
	/* enumptr     */ &MKENUMNAME(truth),
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_enumint,
	/* fromtextptr */ p80211_fromtext_enumint,
	/* validfunptr */ p80211_isvalid_enumint
},
{
	/* name        */ MKITEMNAME("resultcode"),
	/* did         */ P80211DID_MKID(0,0,0,0,0,0,P80211_TYPE_ENUMINT),
	/* flags       */ P80211ITEM_SETFLAGS(ISREQUIRED, 0UL, ISCONFIRM),
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 0,
	/* enumptr     */ &MKENUMNAME(resultcode),
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_enumint,
	/* fromtextptr */ p80211_fromtext_enumint,
	/* validfunptr */ p80211_isvalid_enumint
}
};  /* end of p2req_auxport_state request metadata list */

UINT32	MKREQMETASIZE(p2req_auxport_state) = 
		sizeof(MKREQMETANAME(p2req_auxport_state))/sizeof(p80211meta_t);

/*--------------------------------------------------------------------*/
/* metadata for the p2req_auxport_read request message arguments */

extern	UINT32	MKREQMETASIZE(p2req_auxport_read);

p80211meta_t MKREQMETANAME(p2req_auxport_read)[] = {
{
	/* name        */ (char *)&(MKREQMETASIZE(p2req_auxport_read)),
	/* did         */ 0,
	/* flags       */ 0,
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 0,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ NULL,
	/* fromtextptr */ NULL,
	/* validfunptr */ NULL
},
{
	/* name        */ "addr",
	/* did         */ P80211DID_MKID(0,0,0,0,0,0,P80211_TYPE_INT),
	/* flags       */ P80211ITEM_SETFLAGS(ISREQUIRED, ISREQUEST, 0UL),
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 0,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_int,
	/* fromtextptr */ p80211_fromtext_int,
	/* validfunptr */ p80211_isvalid_int
},
{
	/* name        */ "len",
	/* did         */ P80211DID_MKID(0,0,0,0,0,0,P80211_TYPE_INT),
	/* flags       */ P80211ITEM_SETFLAGS(ISREQUIRED, ISREQUEST, 0UL),
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 0,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_int,
	/* fromtextptr */ p80211_fromtext_int,
	/* validfunptr */ p80211_isvalid_int
},
{
	/* name        */ "data",
	/* did         */ P80211DID_MKID(0,0,0,0,0,0,P80211_TYPE_UNKDATA),
	/* flags       */ P80211ITEM_SETFLAGS(ISREQUIRED, 0UL, ISCONFIRM),
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 1024,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ NULL,	/* data only handled by programs */
	/* fromtextptr */ NULL,
	/* validfunptr */ NULL
},
{
	/* name        */ MKITEMNAME("resultcode"),
	/* did         */ P80211DID_MKID(0,0,0,0,0,0,P80211_TYPE_ENUMINT),
	/* flags       */ P80211ITEM_SETFLAGS(ISREQUIRED, 0UL, ISCONFIRM),
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 0,
	/* enumptr     */ &MKENUMNAME(resultcode),
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_enumint,
	/* fromtextptr */ p80211_fromtext_enumint,
	/* validfunptr */ p80211_isvalid_enumint
}
};  /* end of p2req_auxport_read request metadata list */

UINT32	MKREQMETASIZE(p2req_auxport_read) = 
		sizeof(MKREQMETANAME(p2req_auxport_read))/sizeof(p80211meta_t);

/*--------------------------------------------------------------------*/
/* metadata for the p2req_auxport_write request message arguments */

extern	UINT32	MKREQMETASIZE(p2req_auxport_write);

p80211meta_t MKREQMETANAME(p2req_auxport_write)[] = {
{
	/* name        */ (char *)&(MKREQMETASIZE(p2req_auxport_write)),
	/* did         */ 0,
	/* flags       */ 0,
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 0,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ NULL,
	/* fromtextptr */ NULL,
	/* validfunptr */ NULL
},
{
	/* name        */ "addr",
	/* did         */ P80211DID_MKID(0,0,0,0,0,0,P80211_TYPE_INT),
	/* flags       */ P80211ITEM_SETFLAGS(ISREQUIRED, ISREQUEST, 0UL),
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 0,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_int,
	/* fromtextptr */ p80211_fromtext_int,
	/* validfunptr */ p80211_isvalid_int
},
{
	/* name        */ "len",
	/* did         */ P80211DID_MKID(0,0,0,0,0,0,P80211_TYPE_INT),
	/* flags       */ P80211ITEM_SETFLAGS(ISREQUIRED, ISREQUEST, 0UL),
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 0,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_int,
	/* fromtextptr */ p80211_fromtext_int,
	/* validfunptr */ p80211_isvalid_int
},
{
	/* name        */ "data",
	/* did         */ P80211DID_MKID(0,0,0,0,0,0,P80211_TYPE_UNKDATA),
	/* flags       */ P80211ITEM_SETFLAGS(ISREQUIRED, ISREQUEST, 0UL),
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 1024,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ NULL,	/* data only handled by programs */
	/* fromtextptr */ NULL,
	/* validfunptr */ NULL
},
{
	/* name        */ MKITEMNAME("resultcode"),
	/* did         */ P80211DID_MKID(0,0,0,0,0,0,P80211_TYPE_ENUMINT),
	/* flags       */ P80211ITEM_SETFLAGS(ISREQUIRED, 0UL, ISCONFIRM),
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 0,
	/* enumptr     */ &MKENUMNAME(resultcode),
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_enumint,
	/* fromtextptr */ p80211_fromtext_enumint,
	/* validfunptr */ p80211_isvalid_enumint
}
};  /* end of p2req_auxport_write request metadata list */

UINT32	MKREQMETASIZE(p2req_auxport_write) = 
		sizeof(MKREQMETANAME(p2req_auxport_write))/sizeof(p80211meta_t);

/*--------------------------------------------------------------------*/
/* metadata for the p2req_ramdl_state request message arguments */

extern	UINT32	MKREQMETASIZE(p2req_ramdl_state);

p80211meta_t MKREQMETANAME(p2req_ramdl_state)[] = {
{
	/* name        */ (char *)&(MKREQMETASIZE(p2req_ramdl_state)),
	/* did         */ 0,
	/* flags       */ 0,
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 0,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ NULL,
	/* fromtextptr */ NULL,
	/* validfunptr */ NULL
},
{
	/* name        */ "enable",
	/* did         */ P80211DID_MKID(0,0,0,0,0,0,P80211_TYPE_ENUMINT),
	/* flags       */ P80211ITEM_SETFLAGS(ISREQUIRED, ISREQUEST, 0UL),
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 0,
	/* enumptr     */ &MKENUMNAME(truth),
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_enumint,
	/* fromtextptr */ p80211_fromtext_enumint,
	/* validfunptr */ p80211_isvalid_enumint
},
{
	/* name        */ "exeaddr",
	/* did         */ P80211DID_MKID(0,0,0,0,0,0,P80211_TYPE_INT),
	/* flags       */ P80211ITEM_SETFLAGS(ISREQUIRED, ISREQUEST, 0UL),
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 0,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_int,
	/* fromtextptr */ p80211_fromtext_int,
	/* validfunptr */ p80211_isvalid_int
},
{
	/* name        */ MKITEMNAME("resultcode"),
	/* did         */ P80211DID_MKID(0,0,0,0,0,0,P80211_TYPE_ENUMINT),
	/* flags       */ P80211ITEM_SETFLAGS(ISREQUIRED, 0UL, ISCONFIRM),
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 0,
	/* enumptr     */ &MKENUMNAME(resultcode),
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_enumint,
	/* fromtextptr */ p80211_fromtext_enumint,
	/* validfunptr */ p80211_isvalid_enumint
}
};  /* end of p2req_ramdl_state request metadata list */

UINT32	MKREQMETASIZE(p2req_ramdl_state) = 
		sizeof(MKREQMETANAME(p2req_ramdl_state))/sizeof(p80211meta_t);

/*--------------------------------------------------------------------*/
/* metadata for the p2req_ramdl_write request message arguments */

extern	UINT32	MKREQMETASIZE(p2req_ramdl_write);

p80211meta_t MKREQMETANAME(p2req_ramdl_write)[] = {
{
	/* name        */ (char *)&(MKREQMETASIZE(p2req_ramdl_write)),
	/* did         */ 0,
	/* flags       */ 0,
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 0,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ NULL,
	/* fromtextptr */ NULL,
	/* validfunptr */ NULL
},
{
	/* name        */ "addr",
	/* did         */ P80211DID_MKID(0,0,0,0,0,0,P80211_TYPE_INT),
	/* flags       */ P80211ITEM_SETFLAGS(ISREQUIRED, ISREQUEST, 0UL),
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 0,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_int,
	/* fromtextptr */ p80211_fromtext_int,
	/* validfunptr */ p80211_isvalid_int
},
{
	/* name        */ "len",
	/* did         */ P80211DID_MKID(0,0,0,0,0,0,P80211_TYPE_INT),
	/* flags       */ P80211ITEM_SETFLAGS(ISREQUIRED, ISREQUEST, 0UL),
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 0,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_int,
	/* fromtextptr */ p80211_fromtext_int,
	/* validfunptr */ p80211_isvalid_int
},
{
	/* name        */ "data",
	/* did         */ P80211DID_MKID(0,0,0,0,0,0,P80211_TYPE_UNKDATA),
	/* flags       */ P80211ITEM_SETFLAGS(ISREQUIRED, ISREQUEST, 0UL),
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 1024,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ NULL,	/* data only handled by programs */
	/* fromtextptr */ NULL,
	/* validfunptr */ NULL
},
{
	/* name        */ MKITEMNAME("resultcode"),
	/* did         */ P80211DID_MKID(0,0,0,0,0,0,P80211_TYPE_ENUMINT),
	/* flags       */ P80211ITEM_SETFLAGS(ISREQUIRED, 0UL, ISCONFIRM),
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 0,
	/* enumptr     */ &MKENUMNAME(resultcode),
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_enumint,
	/* fromtextptr */ p80211_fromtext_enumint,
	/* validfunptr */ p80211_isvalid_enumint
}
};  /* end of p2req_ramdl_write request metadata list */

UINT32	MKREQMETASIZE(p2req_ramdl_write) = 
		sizeof(MKREQMETANAME(p2req_ramdl_write))/sizeof(p80211meta_t);

/*--------------------------------------------------------------------*/
/* metadata for the p2req_flashdl_state request message arguments */

extern	UINT32	MKREQMETASIZE(p2req_flashdl_state);

p80211meta_t MKREQMETANAME(p2req_flashdl_state)[] = {
{
	/* name        */ (char *)&(MKREQMETASIZE(p2req_flashdl_state)),
	/* did         */ 0,
	/* flags       */ 0,
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 0,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ NULL,
	/* fromtextptr */ NULL,
	/* validfunptr */ NULL
},
{
	/* name        */ "enable",
	/* did         */ P80211DID_MKID(0,0,0,0,0,0,P80211_TYPE_ENUMINT),
	/* flags       */ P80211ITEM_SETFLAGS(ISREQUIRED, ISREQUEST, 0UL),
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 0,
	/* enumptr     */ &MKENUMNAME(truth),
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_enumint,
	/* fromtextptr */ p80211_fromtext_enumint,
	/* validfunptr */ p80211_isvalid_enumint
},
{
	/* name        */ MKITEMNAME("resultcode"),
	/* did         */ P80211DID_MKID(0,0,0,0,0,0,P80211_TYPE_ENUMINT),
	/* flags       */ P80211ITEM_SETFLAGS(ISREQUIRED, 0UL, ISCONFIRM),
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 0,
	/* enumptr     */ &MKENUMNAME(resultcode),
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_enumint,
	/* fromtextptr */ p80211_fromtext_enumint,
	/* validfunptr */ p80211_isvalid_enumint
}
};  /* end of p2req_flashdl_state request metadata list */

UINT32	MKREQMETASIZE(p2req_flashdl_state) = 
		sizeof(MKREQMETANAME(p2req_flashdl_state))/sizeof(p80211meta_t);

/*--------------------------------------------------------------------*/
/* metadata for the p2req_flashdl_write request message arguments */

extern	UINT32	MKREQMETASIZE(p2req_flashdl_write);

p80211meta_t MKREQMETANAME(p2req_flashdl_write)[] = {
{
	/* name        */ (char *)&(MKREQMETASIZE(p2req_flashdl_write)),
	/* did         */ 0,
	/* flags       */ 0,
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 0,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ NULL,
	/* fromtextptr */ NULL,
	/* validfunptr */ NULL
},
{
	/* name        */ "addr",
	/* did         */ P80211DID_MKID(0,0,0,0,0,0,P80211_TYPE_INT),
	/* flags       */ P80211ITEM_SETFLAGS(ISREQUIRED, ISREQUEST, 0UL),
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 0,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_int,
	/* fromtextptr */ p80211_fromtext_int,
	/* validfunptr */ p80211_isvalid_int
},
{
	/* name        */ "len",
	/* did         */ P80211DID_MKID(0,0,0,0,0,0,P80211_TYPE_INT),
	/* flags       */ P80211ITEM_SETFLAGS(ISREQUIRED, ISREQUEST, 0UL),
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 0,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_int,
	/* fromtextptr */ p80211_fromtext_int,
	/* validfunptr */ p80211_isvalid_int
},
{
	/* name        */ "data",
	/* did         */ P80211DID_MKID(0,0,0,0,0,0,P80211_TYPE_UNKDATA),
	/* flags       */ P80211ITEM_SETFLAGS(ISREQUIRED, ISREQUEST, 0UL),
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 1024,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ NULL,	/* data only handled by programs */
	/* fromtextptr */ NULL,
	/* validfunptr */ NULL
},
{
	/* name        */ MKITEMNAME("resultcode"),
	/* did         */ P80211DID_MKID(0,0,0,0,0,0,P80211_TYPE_ENUMINT),
	/* flags       */ P80211ITEM_SETFLAGS(ISREQUIRED, 0UL, ISCONFIRM),
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 0,
	/* enumptr     */ &MKENUMNAME(resultcode),
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_enumint,
	/* fromtextptr */ p80211_fromtext_enumint,
	/* validfunptr */ p80211_isvalid_enumint
}
};  /* end of p2req_flashdl_write request metadata list */

UINT32	MKREQMETASIZE(p2req_flashdl_write) = 
		sizeof(MKREQMETANAME(p2req_flashdl_write))/sizeof(p80211meta_t);

/*--------------------------------------------------------------------*/
/* metadata for the p2req_mm_state request message arguments */

extern	UINT32	MKREQMETASIZE(p2req_mm_state);

p80211meta_t MKREQMETANAME(p2req_mm_state)[] = {
{
	/* name        */ (char *)&(MKREQMETASIZE(p2req_mm_state)),
	/* did         */ 0,
	/* flags       */ 0,
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 0,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ NULL,
	/* fromtextptr */ NULL,
	/* validfunptr */ NULL
},
{
	/* name        */ MKITEMNAME("enable"),
	/* did         */ P80211DID_MKID(0,0,0,0,0,0,P80211_TYPE_ENUMINT),
	/* flags       */ P80211ITEM_SETFLAGS(ISREQUIRED, ISREQUEST, 0UL),
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 0,
	/* enumptr     */ &MKENUMNAME(truth),
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_enumint,
	/* fromtextptr */ p80211_fromtext_enumint,
	/* validfunptr */ p80211_isvalid_enumint
},
{
	/* name        */ MKITEMNAME("level"),
	/* did         */ P80211DID_MKID(0,0,0,0,0,0,P80211_TYPE_BOUNDEDINT),
	/* flags       */ P80211ITEM_SETFLAGS(ISREQUIRED, ISREQUEST, 0UL),
	/* min         */ 0,
	/* max         */ 3,
	/* maxlen      */ 0,
	/* enumptr     */ NULL,
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_boundedint,
	/* fromtextptr */ p80211_fromtext_boundedint,
	/* validfunptr */ p80211_isvalid_boundedint
},
{
	/* name        */ MKITEMNAME("resultcode"),
	/* did         */ P80211DID_MKID(0,0,0,0,0,0,P80211_TYPE_ENUMINT),
	/* flags       */ P80211ITEM_SETFLAGS(ISREQUIRED, 0UL, ISCONFIRM),
	/* min         */ 0,
	/* max         */ 0,
	/* maxlen      */ 0,
	/* enumptr     */ &MKENUMNAME(resultcode),
	/* collptr     */ NULL,
	/* totextptr   */ p80211_totext_enumint,
	/* fromtextptr */ p80211_fromtext_enumint,
	/* validfunptr */ p80211_isvalid_enumint
}
};  /* end of p2req_mm_state request metadata list */

UINT32	MKREQMETASIZE(p2req_mm_state) = 
		sizeof(MKREQMETANAME(p2req_mm_state))/sizeof(p80211meta_t);
/*--------------------------------------------------------------------*/
/* Messages Group arrays */


extern UINT32 MKGRPMETASIZE(dot11req);

grplistitem_t MKGRPMETANAME(dot11req)[] = {
	{
		(char *)&MKGRPMETASIZE(dot11req),
		NULL
	},
	{
		"dot11req_mibget",
		MKREQMETANAME(dot11req_mibget)
	},
	{
		"dot11req_mibset",
		MKREQMETANAME(dot11req_mibset)
	},
	{
		"dot11req_powermgmt",
		MKREQMETANAME(dot11req_powermgmt)
	},
	{
		"dot11req_scan",
		MKREQMETANAME(dot11req_scan)
	},
	{
		"dot11req_scan_results",
		MKREQMETANAME(dot11req_scan_results)
	},
	{
		"dot11req_join",
		MKREQMETANAME(dot11req_join)
	},
	{
		"dot11req_authenticate",
		MKREQMETANAME(dot11req_authenticate)
	},
	{
		"dot11req_deauthenticate",
		MKREQMETANAME(dot11req_deauthenticate)
	},
	{
		"dot11req_associate",
		MKREQMETANAME(dot11req_associate)
	},
	{
		"dot11req_reassociate",
		MKREQMETANAME(dot11req_reassociate)
	},
	{
		"dot11req_disassociate",
		MKREQMETANAME(dot11req_disassociate)
	},
	{
		"dot11req_start",
		MKREQMETANAME(dot11req_start)
	}
};

UINT32 MKGRPMETASIZE(dot11req) =sizeof(MKGRPMETANAME(dot11req)) /
				sizeof(grplistitem_t);

extern UINT32 MKGRPMETASIZE(dot11ind);

grplistitem_t MKGRPMETANAME(dot11ind)[] = {
	{
		(char *)&MKGRPMETASIZE(dot11ind),
		NULL
	},
	{
		"dot11ind_authenticate",
		MKINDMETANAME(dot11ind_authenticate)
	},
	{
		"dot11ind_deauthenticate",
		MKINDMETANAME(dot11ind_deauthenticate)
	},
	{
		"dot11ind_associate",
		MKINDMETANAME(dot11ind_associate)
	},
	{
		"dot11ind_reassociate",
		MKINDMETANAME(dot11ind_reassociate)
	},
	{
		"dot11ind_disassociate",
		MKINDMETANAME(dot11ind_disassociate)
	}
};

UINT32 MKGRPMETASIZE(dot11ind) =sizeof(MKGRPMETANAME(dot11ind)) /
				sizeof(grplistitem_t);


extern UINT32 MKGRPMETASIZE(lnxreq);

grplistitem_t MKGRPMETANAME(lnxreq)[] = {
	{
		(char *)&MKGRPMETASIZE(lnxreq),
		NULL
	},
	{
		"lnxreq_wlansniff",
		MKREQMETANAME(lnxreq_wlansniff)
	}
};

UINT32 MKGRPMETASIZE(lnxreq) =sizeof(MKGRPMETANAME(lnxreq)) /
				sizeof(grplistitem_t);


extern UINT32 MKGRPMETASIZE(lnxind);

grplistitem_t MKGRPMETANAME(lnxind)[] = {
	{
		(char *)&MKGRPMETASIZE(lnxind),
		NULL
	},
	{
		"lnxind_wlansniffrm",
		MKINDMETANAME(lnxind_wlansniffrm)
	}
};

UINT32 MKGRPMETASIZE(lnxind) =sizeof(MKGRPMETANAME(lnxind)) /
				sizeof(grplistitem_t);


extern UINT32 MKGRPMETASIZE(p2req);

grplistitem_t MKGRPMETANAME(p2req)[] = {
	{
		(char *)&MKGRPMETASIZE(p2req),
		NULL
	},
	{
		"p2req_readpda",
		MKREQMETANAME(p2req_readpda)
	},
	{
		"p2req_auxport_state",	/* enable=true|false */
		MKREQMETANAME(p2req_auxport_state)
	},
	{
		"p2req_auxport_read",	/* addr, len[2-1024], datap */
		MKREQMETANAME(p2req_auxport_read)
	},
	{
		"p2req_auxport_write",	/* addr, len[2-1024], datap */
		MKREQMETANAME(p2req_auxport_write)
	},
	{
		"p2req_ramdl_state",	/* enable=true|false, exeaddr=UINT32 */
		MKREQMETANAME(p2req_ramdl_state)
	},
	{
		"p2req_ramdl_write",	/* addr, len[2-1024], datap */
		MKREQMETANAME(p2req_ramdl_write)
	},
	{
		"p2req_flashdl_state",	/* enable=true|false */
		MKREQMETANAME(p2req_flashdl_state)
	},
	{
		"p2req_flashdl_write",	/* addr, len[2-1024], datap */
		MKREQMETANAME(p2req_flashdl_write)
	},
	{
		"p2req_mm_state",	/* enable=true|false, level=[0-3] */
		MKREQMETANAME(p2req_mm_state)
	}
};


UINT32 MKGRPMETASIZE(p2req) = sizeof(MKGRPMETANAME(p2req)) /
				sizeof(grplistitem_t);

extern UINT32 msg_catlist_size;

catlistitem_t msg_catlist[] =
{
	{
		(char *)&msg_catlist_size,
		NULL
	},
	{
		"dot11req",
		MKGRPMETANAME(dot11req)
	},
	/* dot11cfm does not exist at this time */
	{
		"dot11ind",
		MKGRPMETANAME(dot11ind)
	},
	{
		"lnxreq",
		MKGRPMETANAME(lnxreq)
	},
	{
		"lnxind",
		MKGRPMETANAME(lnxind)
	},
	{
		"p2req",
		MKGRPMETANAME(p2req)
	}
};

UINT32 msg_catlist_size = sizeof(msg_catlist)/sizeof(catlistitem_t);


/*================================================================*/
/* Local Function Declarations */

/*================================================================*/
/* Function Definitions */
