/*
 * Linux-Mobile-IP
 *            An implementation of Mobile IP for the LINUX operating system
 *            developed at the State University of New York, Binghamton
 *            (with support from the Center for Computing Technologies).
 *            The implementation uses the message formats described in the
 *            Internet Engineering Task Force (IETF) mobile-ip draft
 *            but is not (yet) fully compliant.
 *
 *            Recent drafts of the IETF Mobile IP proposal are
 *            available at ftp://software.watson.ibm.com/pub/mobile-ip/ 
 *
 *            Permission is hereby granted to redistribute this code and/or
 *            modify it under the terms of the GNU Genral Public License
 *            as published by the Free Software Foundation; either version
 *            two or (at your option) any later version.
 *
 *            The authors request that their contribution be appropriately 
 *            acknowledged in any derived work. 
 *
 *            messages.h - Include file containing the structs of all the
 *                         messages for Linux-Mobile-IP.
 * 
 * Version:   0.90     08/31/1995
 * 
 * Authors:   Vipul Gupta <vgupta@cs.binghamton.edu>
 *            Benjamin Lancki <ben@anchor.cs.binghamton.edu>
 * 
 * */  

/* Here we define the format of messages we exchange between mobile hosts
 * and mobile agents. */

/* codes for different message types */
#ifndef _MESSAGES_H_
#define _MESSAGES_H_
#define YOUAREHERETYPE      234
#define WHEREAMITYPE        189
#define REGISTERMETYPE        1
#define REGREPLYTYPE          3

struct whereami  {
   unsigned char code;
   unsigned char padding;
};

struct youarehere  {
   unsigned char code;    /* Code to indicate it is a URhere message */
   unsigned char addrnum; /* number of addresses advertised by router */
   unsigned short flags;  /* which of the at most sixteen routers are on
			   * a wired network 0=wireless 1=wired */
   /* These are followed by addrnum pairs of unsigned longs indicating
    * the ip address and netmask */ 
};

#define SFLAG 0x80
#define BFLAG 0x40
#define FFLAG 0x20
#define MFLAG 0x10
#define GFLAG 0x08

#define KEYIDEXT   18
#define MHAUTHEXT  32
#define MFAUTHEXT  33
#define FHAUTHEXT  34

struct id  {
   unsigned long high;
   unsigned long low;
};

struct registerme  {
   unsigned char type;
   unsigned char flags;
   unsigned short lifetime;
   unsigned long homeaddr;
   unsigned long ha;
   unsigned long coaddr;
   struct id Id;      /* This is followed by various extensions */ 
};

struct regreply  {
   unsigned char type;
   unsigned char code;
   unsigned short lifetime;
   unsigned long homeaddr;
   unsigned long ha;
   struct id Id;   /* This is followed by various extensions */
};
   
#endif /* _MESSAGES_H_ */

