/*
 * Linux-Mobile-IP
 *            An implementation of Mobile IP for the LINUX operating system
 *            developed at the State University of New York, Binghamton
 *            (with support from the Center for Computing Technologies).
 *            The implementation uses the message formats described in the
 *            Internet Engineering Task Force (IETF) mobile-ip draft
 *            but is not (yet) fully compliant.
 *
 *            Recent drafts of the IETF Mobile IP proposal are
 *            available at ftp://software.watson.ibm.com/pub/mobile-ip/ 
 *
 *            Permission is hereby granted to redistribute this code and/or
 *            modify it under the terms of the GNU Genral Public License
 *            as published by the Free Software Foundation; either version
 *            two or (at your option) any later version.
 *
 *            The authors request that their contribution be appropriately 
 *            acknowledged in any derived work. 
 *
 *            MH.H - Include file containing constants and data structs
 *                   for mh.c.
 * 
 * Version:   0.90     08/31/1995
 * 
 * Authors:   Vipul Gupta <vgupta@cs.binghamton.edu>
 *            Benjamin Lancki <ben@anchor.cs.binghamton.edu>
 * 
 * */  

#ifndef _MH_H_
#define _MH_H_1

#include <netinet/in.h>
#include "messages.h"

#define REGAWAY 0x01   /* flag in status indicates registered away */
#define REGHOME 0x02   /* flag in status indicates registered at home */
#define AWAITINGREPLY 0x04   /* set for outstanding registration req */
#define DUMMYUP   0x08  /* set to indicate dummy interface in use */

#define MAXDENIALS     3  /* If a request is rejected this many times,
			   * we drop that request */
#define MAXRETRIES     3  /* A request is retransmitted at most thrice */
#define RETRYINTERVAL  5  /* A request is retried after these many seconds */
#define THRESHOLD1   150  /* send first renewal request */
#define THRESHOLD2   100  /* send second renewal request */
#define THRESHOLD3    30  /* send third renewal request */
#define MAXLIFETIME  300  /* Max registration lifetime */
#define ADVERTISEON "255.255.255.255" /* this is the address where we send
				       * our whereamis */
#define MAXOVERLAP     5  /* Maximum number of wireless cells that may overlap
			   * this controls the number of different beacons 
			   * that can be heard by a mobile host in one 
			   * beacon interval */

#define WHEREAMIPORT   8888   /* and this is the port we send to */
#define YOUAREHEREPORT 6090   /* we listen here for URheres */
#define MIPREGPORT     434    /* here's where we send our registrations */

typedef struct mi  {
   char haauthtype[5];
   int secretlen;
   char secret[67];
   unsigned long homeaddr;
   unsigned long homenetmask;
   unsigned long homeagent;
   unsigned long o_homeagent; /* home agent's OTHER address useful for
                              * a campus setup where all mobile nodes
                              * belong to the same (disconnected) subnet */
   unsigned long homeaddaddr;
   unsigned long coaddr;
   unsigned long closeagentaddr;
   unsigned long itsotheraddr; /* useful for the same reason as o_homeagent */
   long rextimeleft; /* time left before we retransmit outstanding req */ 
   long regtimeleft; /* time left on our current registration */
   struct id RequestId; /* id of the last request */

   char URheremsg[511]; /* here we store the next URhere to be processed */
   char haveUR; /* for signalling between main loop and pickupURheres */
   struct sockaddr_in URheresock;
   int URherelen; /* actual length of the URhere message */
   
   int retries;
   char status; 
} myinfo; 

#endif /* _MH_H_ */
