/*
 * Linux-Mobile-IP
 *            An implementation of Mobile IP for the LINUX operating system
 *            developed at the State University of New York, Binghamton
 *            (with support from the Center for Computing Technologies).
 *            The implementation uses the message formats described in the
 *            Internet Engineering Task Force (IETF) mobile-ip draft
 *            but is not (yet) fully compliant.
 *
 *            Recent drafts of the IETF Mobile IP proposal are
 *            available at ftp://software.watson.ibm.com/pub/mobile-ip/ 
 *
 *            Permission is hereby granted to redistribute this code and/or
 *            modify it under the terms of the GNU Genral Public License
 *            as published by the Free Software Foundation; either version
 *            two or (at your option) any later version.
 *
 *            The authors request that their contribution be appropriately 
 *            acknowledged in any derived work. 
 *
 *            mhlow.c - Low level tunneling routines for the Mobile Host.
 * 
 * Version:   0.90     08/31/1995
 * 
 * Authors:   Vipul Gupta <vgupta@cs.binghamton.edu>
 *            Benjamin Lancki <ben@anchor.cs.binghamton.edu>
 * 
 * */  

#include <stdio.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <sys/ioctl.h>
#include <linux/route.h>
#include <linux/if.h>

extern int ioctlsid;
extern int debug;

lowifacedown(char *name)  {
 /* down the interface whose name is given */
   struct ifreq ifr;

   if (debug > 0)  {
      fprintf(stderr, "DOWNiface %s.\n", name);
   };
   strcpy(ifr.ifr_name, name);
   ifr.ifr_flags &= ~IFF_UP;
   if (ioctl(ioctlsid, SIOCSIFFLAGS, (char *) &ifr) < 0)  {
      perror("lowifacedown failed SIOCSIFFLAGS");
   };
}

lowifaceset(char *name, unsigned long ipaddr, unsigned long mask)  {
   struct ifreq ifr;
   struct sockaddr_in *sock;
   
   if (debug > 0)  {
      fprintf(stderr, "lowifaceset called on %s addr %lx mask %lx.\n", 
	      name, htonl(ipaddr), htonl(mask));
   };
   
   strcpy(ifr.ifr_name, name);

   if (ioctl(ioctlsid, SIOCGIFFLAGS, (char *) &ifr) < 0 )  {
      fprintf(stderr, "SIOCGIFFLAGS failed on %s\n", name);
      exit(-1);
   };
   ifr.ifr_flags |= IFF_UP;
   if (ioctl(ioctlsid, SIOCSIFFLAGS, (char *) &ifr) < 0)  {
      perror("lowifaceset failed SIOCSIFFLAGS");
   };
   sock = (struct sockaddr_in *) &ifr.ifr_addr;
   sock->sin_family = AF_INET;
   sock->sin_addr.s_addr = ipaddr;
   if (ioctl(ioctlsid, SIOCSIFADDR, (char *) &ifr) < 0)  {
      perror("lowifaceset failed SIOCSIFADDR");
   }
   sock = (struct sockaddr_in *) &ifr.ifr_broadaddr;
   sock->sin_family = AF_INET;
   sock->sin_addr.s_addr = (ipaddr & mask) | (0xffffffff & ~mask);
   if (ioctl(ioctlsid, SIOCSIFBRDADDR, (char *) &ifr) < 0)  {
      perror("lowifaceset failed SIOCSIFBRDADDR");
   }
   sock = (struct sockaddr_in *) &ifr.ifr_netmask;
   sock->sin_family = AF_INET;
   sock->sin_addr.s_addr = mask;
    if (ioctl(ioctlsid, SIOCSIFNETMASK, (char *) &ifr) < 0)  {
      perror("lowifaceset failed SIOCSIFNETMASK");
   };
}

lowrtdefault(unsigned long ipaddr)  {
   struct rtentry rtent;
   struct sockaddr_in *sock;
   
   if (debug > 0)  {
      fprintf(stderr, "ROUTEdefault gw %lx.\n", 
	      htonl(ipaddr));
   };
   bzero((char *) &rtent, sizeof(struct rtentry));
   sock = (struct sockaddr_in *) &rtent.rt_dst;
   sock->sin_family = AF_INET;
   sock = (struct sockaddr_in *) &rtent.rt_gateway;
   sock->sin_family = AF_INET;
   sock->sin_addr.s_addr = ipaddr;
   rtent.rt_flags = RTF_GATEWAY | RTF_UP;
   if (ioctl(ioctlsid, SIOCADDRT, (char *) &rtent) == -1)  {
      perror("SIOCADDRT failed");
   }
}

lowrtset(unsigned long dest, char *devname)  {
   struct rtentry rtent;
   struct sockaddr_in *sock;
   
   if (debug > 0)  {
      fprintf(stderr, "ROUTEset dest %8lx dev %s.\n", 
	      htonl(dest), devname);
   };
   bzero((char *) &rtent, sizeof(struct rtentry));
   sock = (struct sockaddr_in *) &rtent.rt_dst;
   sock->sin_family = AF_INET;
   sock->sin_addr.s_addr = htonl(dest);
   rtent.rt_flags = RTF_UP | RTF_HOST;
   strcpy(rtent.rt_dev, devname);
   if (ioctl(ioctlsid, SIOCADDRT, (char *) &rtent) == -1)  {
      perror("SIOCADDRT failed");
   }
}

/* The following routines should return an appropriate netmask and ip address
   that a mobile host can use while it is visiting a network outside
   its original administrative domain. Until we can use something better
   like DHCP, individual users will have to tailor these functions to
   their needs. The ip-addr of a nearby mobility agent is passed as
   argument and may be used to look up a table for the appropriate
   choice */

getnetmask(unsigned long addr)  {
   return(inet_addr("255.255.255.224"));
}

unsigned long
getipaddr(unsigned long addr)  {
   return(inet_addr("131.205.4.4"));
}

