/*
 * Linux-Mobile-IP
 *            An implementation of Mobile IP for the LINUX operating system
 *            developed at the State University of New York, Binghamton
 *            (with support from the Center for Computing Technologies).
 *            The implementation uses the message formats described in the
 *            Internet Engineering Task Force (IETF) mobile-ip draft
 *            but is not (yet) fully compliant.
 *
 *            More information can be obtained from:
 *            http://anchor.cs.binghamton.edu/~mobileip/  
 *           
 *
 *            Permission is hereby granted to redistribute this code and/or
 *            modify it under the terms of the GNU Genral Public License
 *            as published by the Free Software Foundation; either version
 *            two or (at your option) any later version.
 *
 *            The authors request that their contribution be appropriately 
 *            acknowledged in any derived work. 
 *
 *            agent.h - Include file containing constants and data structs
 *                      for agent.c.
 * 
 * Version:   0.95    11/24/1995
 * 
 * Authors:   Abhijit Dixit <abhijit@cs.binghamton.edu>
 *            Vipul Gupta <vgupta@cs.binghamton.edu>
 *            Benjamin Lancki <ben@anchor.cs.binghamton.edu>
 *            
 * */  

#ifndef _AGENT_H_
#define _AGENT_H_
#include "messages.h"

#define MAXMHNUM       8   /* max number of MH supported by us as well as max
			    # of visiting MH ...AD*/
#define MAXTUNNELS     2   /* max # of tunnels supported in the kernel */
/* IP address and port normally used for sending URhere messages */ 
#define ADVERTISETO   6090

/* Ports for listening to WhereAmI and RegisterMe messages */
#define WHEREAMIPORT  8888
#define MIPREGPORT    434
#define TUNNELUP     0x01
#define MAXLIFETIME   300   /* two minute lease on the tunnel */
#define ADVERTISEON "255.255.255.255"
#define PENDING 0x01
#define CONFIRMED 0x03

typedef struct mhd
     {
	unsigned long ipaddr; /* its permanent address */
	char authtype[5]; /* identifies the algorithm to be used 
			 * for authentcation */
	char secret[64];   /* secret used for authentication */
        int keylen;   /* size of secret key */
	unsigned char status; /*TUNNELUP indicates we are supporting the host*/
	unsigned long coaddr; /* end point of tunnel */
	struct id RegistrationId; /* If incoming request does not contain
				   * this value in its high 32 bits of Id,
				   * then we have an id mismatch */ 
	int timeleft; /* # of secs before this tunnel 
			 	 * is destroyed and we stop forwarding */
	unsigned char tunnelnum; /* tunnel number for this mh */
     } mhdata;

typedef struct vmhd /* AD */

     {
        unsigned long ipaddr; /*IP addr of visiting mobile host
			       which is also home addr in our case*/
	unsigned long ha;  /* Home agent's addr */
	
	char authtype[5]; /* identifies the algorithm to be used 
			 * for authentcation */
	char secret[64];   /* secret used for authentication */
        int keylen;   /* size of secret key */
	unsigned char status; /* reg req pending or granted */
	int timeleft; 
	unsigned short fromport; /* port from which reg. request has
				    come and reply should be sent */
	struct id RegId; /* Id for the request by visiting foreign MH */
	  
      } vmhdata;
#endif /* _AGENT_H_ */
