/*
 * Linux-Mobile-IP
 *            An implementation of Mobile IP for the LINUX operating system
 *            developed at the State University of New York, Binghamton
 *            (with support from the Center for Computing Technologies).
 *            The implementation uses the message formats described in the
 *            Internet Engineering Task Force (IETF) mobile-ip draft
 *            but is not (yet) fully compliant.
 *            
 *            More information can be obtained from:
 *            http://anchor.cs.binghamton.edu/~mobileip/
 *          
 *
 *            Permission is hereby granted to redistribute this code and/or
 *            modify it under the terms of the GNU Genral Public License
 *            as published by the Free Software Foundation; either version
 *            two or (at your option) any later version.
 *
 *            The authors request that their contribution be appropriately 
 *            acknowledged in any derived work. 
 *
 *            low.h - Include file for low.c.
 * 
 * Version:   0.95     11/24/1995
 * 
 * Authors:   Vipul Gupta <vgupta@cs.binghamton.edu>
 *            Benjamin Lancki <ben@anchor.cs.binghamton.edu>
 * 
 * */  

/* low.h some constants used to define low level network requests */
#ifndef _LOWIO_H_
#define _LOWIO_H_
#define REM0     0
#define REM1     1
#define PROXY    2

#define DOWN     3
#define MKPT2PT  4
#define REDIRECT 5

#define DELRT    6
#define ADDRT    7
#define GETRT    8

void lowifacereq(int, char, unsigned long, unsigned long);
void lowARPreq(int, unsigned long, char *);
void lowrtreq(int, unsigned long, char *);  
#endif /* _LOWIO_H_ */
