/*
 * Linux-Mobile-IP
 *            An implementation of Mobile IP for the LINUX operating system
 *            developed at the State University of New York, Binghamton
 *            (with support from the Center for Computing Technologies).
 *            The implementation uses the message formats described in the
 *            Internet Engineering Task Force (IETF) mobile-ip draft
 *            but is not (yet) fully compliant.
 *            
 *            More information can be obtained from:
 *            http://anchor.cs.binghamton.edu/~mobileip/      
 *
 *            Permission is hereby granted to redistribute this code and/or
 *            modify it under the terms of the GNU Genral Public License
 *            as published by the Free Software Foundation; either version
 *            two or (at your option) any later version.
 *
 *            The authors request that their contribution be appropriately 
 *            acknowledged in any derived work. 
 *
 *            mhfileio.c - Routine to read initialization file for Mobile Host.
 * 
 * Version:   0.95     11/24/1995
 * 
 * Authors:   Abhijit Dixit <abhijit@cs.binghamton.edu>
 *            Vipul Gupta <vgupta@cs.binghamton.edu>
 *            Benjamin Lancki <ben@anchor.cs.binghamton.edu>
 * 
 * */  

#include <stdio.h>
#include "mh.h"

extern myinfo Myinfo;
extern int debug;

void 
readhadata(char *file)  {
   /* a sample file looks like:
    *       md5  8 41 ef ad ff fe 1f a5 aa
    */
   
   FILE *fp;
   int i;
   
   memset(Myinfo.haauthtype, 0, 5);
   memset(Myinfo.secret, 0, 64);
   if (((fp = fopen(file, "r")) == NULL) ||
       (fscanf(fp, "%s %d ", Myinfo.haauthtype, &Myinfo.secretlen) != 2))
     {
	fprintf(stderr, "Could not read %s. Using defaults\n", fp);
	 strcpy(Myinfo.haauthtype, "none");
	 strcpy(Myinfo.secret, "doesn't really matter");
	 Myinfo.secretlen = strlen(Myinfo.secret);
   } else  {
      for (i = 0; ((i < Myinfo.secretlen) && (i < 64)); i++) 
      	fscanf(fp, "%x", &Myinfo.secret[i]);
   }
   if (debug > 0)  {
      fprintf(stderr, "Authtype is %s and Key (length = %d) is:\n", 
	      Myinfo.haauthtype, Myinfo.secretlen);
      for (i = 0; i < Myinfo.secretlen; i++) 
      	fprintf(stderr, "%x ", (unsigned char) Myinfo.secret[i]);
      fprintf(stderr, "\n");
   }
}
