/*
 * Linux-Mobile-IP
 *            An implementation of Mobile IP for the LINUX operating system
 *            developed at the State University of New York, Binghamton
 *            (with support from the Center for Computing Technologies).
 *            The implementation uses the message formats described in the
 *            Internet Engineering Task Force (IETF) mobile-ip draft
 *            but is not (yet) fully compliant.
 *            
 *            More information can be obtained from:
 *            http://anchor.cs.binghamton.edu/~mobileip/    
 *
 *
 *            Permission is hereby granted to redistribute this code and/or
 *            modify it under the terms of the GNU Genral Public License
 *            as published by the Free Software Foundation; either version
 *            two or (at your option) any later version.
 *
 *            The authors request that their contribution be appropriately 
 *            acknowledged in any derived work. 
 *
 *            utils.c - Various debugging utility functions.
 * 
 * Version:   0.95     11/24/1995
 * 
 * Authors:   Abhijit Dixit <abhijit@cs.binghamton.edu>
 *            Vipul Gupta <vgupta@cs.binghamton.edu>
 *            Benjamin Lancki <ben@anchor.cs.binghamton.edu>
 * 
 * */  

#include <stdio.h>
#include <sys/time.h>
#include "messages.h"

void printext(char *buf,int len,int flag) {
  char *msgptr;
  int skipover;
  int bytesseen=0;
  
  msgptr=buf;

  /* jump to offset in message where extensions begin, extensions offset 
     determined by message type */
  bytesseen=(flag) ? sizeof(struct regreply) : sizeof(struct registerme);
  msgptr+=bytesseen;

  /* keep looking for extension until end of message is reached  */
  while(bytesseen<len) {
    fprintf(stderr,"\nExtension: %d  Length: %d", (unsigned char)*msgptr, 
            (unsigned char)*(msgptr+1));
    skipover=*(msgptr+1);
    bytesseen+=skipover+2;
    msgptr+=skipover+2;
  }
}

void testprint(char *buf,int buflen) {
  int i;

  for(i=0;i<buflen;i++)
    fprintf(stderr,"%2x |",(unsigned char)*(buf+i));
  fprintf(stderr,"\n");
} 

void printtime() {
  struct timeval clock;
  struct timezone zone;
  time_t temp;

  gettimeofday(&clock,&zone);
  temp = (time_t) clock.tv_sec;
  fprintf(stderr,"%s\n",ctime(&temp));
}
