/*----------------------------------------------------------------------------

  Copyright (C) 1995-6, Vipul Gupta and Abhijit Dixit. Created 1995-6. All
  rights reserved.

  Linux-Mobile-IP
            An implementation of Mobile IP for the LINUX operating system
            developed at the State University of New York, Binghamton
            (with partial support from the Center for Computing Technologies).
            Except as noted in the accompanying documentation, this
            implementation complies with revision 16 of the Internet 
            Engineering Task Force (IETF) Mobile-IP draft.

            More information can be obtained from:
                  http://anchor.cs.binghamton.edu/~mobileip/  

  Version:   1.00     05/23/1996
 
  Authors:   Abhijit Dixit <abhijit@cs.binghamton.edu> 
             Vipul Gupta <vgupta@cs.binghamton.edu>
             Benjamin Lancki <ben@anchor.cs.binghamton.edu>

  Permission is hereby granted to redistribute this code and/or
  modify it under the terms of the GNU Genral Public License
  as published by the Free Software Foundation; either version
  two or (at your option) any later version provided this ENTIRE
  notice is retained in any copies or any part of this software.

  A copy of the GNU General Public License can be obtained by contacting
  the Free Software Foundation, Inc. 675 Mass Ave, Cambridge, MA 02139, USA.
             
-----------------------------------------------------------------------------*/


/* auth.c - Routines for MD5 encryption and authentication. */

/* This code is derived from the RSA Data Security, Inc. 
   MD5 Message-Digest Algorithm.  Information and source code for MD5 is
   available through http://www.cis.ohio-state.edu/htbin/rfc/rfc1321.html
   The following is the original copyright notice included with the
   MD5 software:
---------------------------------------------------------------------
 Copyright (C) 1990-2, RSA Data Security, Inc. Created 1990. All
 rights reserved.

RSA Data Security, Inc. makes no representations concerning either
the merchantability of this software or the suitability of this
software for any particular purpose. It is provided "as is"
without express or implied warranty of any kind.

These notices must be retained in any copies of any part of this
documentation and/or software.
---------------------------------------------------------------------
*/
#include <sys/types.h>
#include <stdio.h>
#include <string.h>
#include "messages.h"


void computedigest(char *,int,char *);

extern int debug;

/* define auxiliary functions */
#define F(x,y,z) (((x) & (y)) | ((~x) & (z)))
#define G(x,y,z) (((x) & (z)) |  ((y) & (~z)))
#define H(x,y,z) ((x) ^ (y) ^ (z))
#define I(x,y,z) ((y) ^ ((x) | (~z)))
#define ROT_LEFT(x,n) (((x) << (n)) | ((x) >> (32 - (n))))

/* define primary functions */
#define ROUND1(a,b,c,d,k,s,i) {\
          (a)+=F((b),(c),(d))+(k)+(unsigned long int)(i);\
          (a)=ROT_LEFT((a),(s));\
          (a)+=(b);\
        }
#define ROUND2(a,b,c,d,k,s,i) {\
          (a)+=G((b),(c),(d))+(k)+(unsigned long int)(i);\
          (a)=ROT_LEFT((a),(s));\
          (a)+=(b);\
        }
#define ROUND3(a,b,c,d,k,s,i) {\
          (a)+=H((b),(c),(d))+(k)+(unsigned long int)(i);\
          (a)=ROT_LEFT((a),(s));\
          (a)+=(b);\
        }
#define ROUND4(a,b,c,d,k,s,i) {\
          (a)+=I((b),(c),(d))+(k)+(unsigned long int)(i);\
          (a)=ROT_LEFT((a),(s));\
          (a)+=(b);\
        }

void computedigest(char *buf1,int buflen,char *buf2) {
  int i,j,padlen;
  unsigned long int x[16];
  unsigned long int a=0x67452301,
		    b=0xefcdab89,
		    c=0x98badcfe,
		    d=0x10325476,
		    aa,bb,cc,dd;

  /* add initial 0x80 padding byte to message */
  buf1[buflen]=0x80;

  /* determine the 0 padding length */
  padlen=55-(buflen%64);
  if(padlen<0)
    padlen=64+padlen;

  /* add the remainder of padding bytes as 0x00 */
  for(i=buflen+1;i<=buflen+padlen;i++)
    buf1[i]=0x00;

  /* tag original message length as 64 bit number to end of working array */
  *(long *)(buf1+i)=buflen*8;
  *(long *)(buf1+i+4)=0;

  if(debug>4) {
    for(j=0;j<=buflen+padlen+8;j++)
      fprintf(stderr,"%2x |",(unsigned char)buf1[j]);
    fprintf(stderr,"\n\n");
  }

  /* process entire message in 64 byte chunks */
  for(i=0;i<buflen+padlen+9;i+=64) {

    /* divide message into 16 words of length 32 bits */
    for(j=0;j<16;j++)
      x[j]=*(long *)(buf1+i+(j*4));

    /* store original values of registers */
    aa=a;
    bb=b;
    cc=c;
    dd=d;

    /* perform transformations on registers */
    ROUND1(a,b,c,d,x[ 0], 7,0xd76aa478);
    ROUND1(d,a,b,c,x[ 1],12,0xe8c7b756);
    ROUND1(c,d,a,b,x[ 2],17,0x242070db);
    ROUND1(b,c,d,a,x[ 3],22,0xc1bdceee);
    ROUND1(a,b,c,d,x[ 4], 7,0xf57c0faf);
    ROUND1(d,a,b,c,x[ 5],12,0x4787c62a);
    ROUND1(c,d,a,b,x[ 6],17,0xa8304613);
    ROUND1(b,c,d,a,x[ 7],22,0xfd469501);
    ROUND1(a,b,c,d,x[ 8], 7,0x698098d8);
    ROUND1(d,a,b,c,x[ 9],12,0x8b44f7af);
    ROUND1(c,d,a,b,x[10],17,0xffff5bb1);
    ROUND1(b,c,d,a,x[11],22,0x895cd7be);
    ROUND1(a,b,c,d,x[12], 7,0x6b901122);
    ROUND1(d,a,b,c,x[13],12,0xfd987193);
    ROUND1(c,d,a,b,x[14],17,0xa679438e);
    ROUND1(b,c,d,a,x[15],22,0x49b40821);
    ROUND2(a,b,c,d,x[ 1], 5,0xf61e2562);
    ROUND2(d,a,b,c,x[ 6], 9,0xc040b340);
    ROUND2(c,d,a,b,x[11],14,0x265e5a51);
    ROUND2(b,c,d,a,x[ 0],20,0xe9b6c7aa);
    ROUND2(a,b,c,d,x[ 5], 5,0xd62f105d);
    ROUND2(d,a,b,c,x[10], 9,0x02441453);
    ROUND2(c,d,a,b,x[15],14,0xd8a1e681);
    ROUND2(b,c,d,a,x[ 4],20,0xe7d3fbc8);
    ROUND2(a,b,c,d,x[ 9], 5,0x21e1cde6);
    ROUND2(d,a,b,c,x[14], 9,0xc33707d6);
    ROUND2(c,d,a,b,x[ 3],14,0xf4d50d87);
    ROUND2(b,c,d,a,x[ 8],20,0x455a14ed);
    ROUND2(a,b,c,d,x[13], 5,0xa9e3e905);
    ROUND2(d,a,b,c,x[ 2], 9,0xfcefa3f8);
    ROUND2(c,d,a,b,x[ 7],14,0x676f02d9);
    ROUND2(b,c,d,a,x[12],20,0x8d2a4c8a);
    ROUND3(a,b,c,d,x[ 5], 4,0xfffa3942);
    ROUND3(d,a,b,c,x[ 8],11,0x8771f681);
    ROUND3(c,d,a,b,x[11],16,0x6d9d6122);
    ROUND3(b,c,d,a,x[14],23,0xfde5380c);
    ROUND3(a,b,c,d,x[ 1], 4,0xa4beea44);
    ROUND3(d,a,b,c,x[ 4],11,0x4bdecfa9);
    ROUND3(c,d,a,b,x[ 7],16,0xf6bb4b60);
    ROUND3(b,c,d,a,x[10],23,0xbebfbc70);
    ROUND3(a,b,c,d,x[13], 4,0x289b7ec6);
    ROUND3(d,a,b,c,x[ 0],11,0xeaa127fa);
    ROUND3(c,d,a,b,x[ 3],16,0xd4ef3085);
    ROUND3(b,c,d,a,x[ 6],23,0x04881d05);
    ROUND3(a,b,c,d,x[ 9], 4,0xd9d4d039);
    ROUND3(d,a,b,c,x[12],11,0xe6db99e5);
    ROUND3(c,d,a,b,x[15],16,0x1fa27cf8);
    ROUND3(b,c,d,a,x[ 2],23,0xc4ac5665);
    ROUND4(a,b,c,d,x[ 0], 6,0xf4292244);
    ROUND4(d,a,b,c,x[ 7],10,0x432aff97);
    ROUND4(c,d,a,b,x[14],15,0xab9423a7);
    ROUND4(b,c,d,a,x[ 5],21,0xfc93a039);
    ROUND4(a,b,c,d,x[12], 6,0x655b59c3);
    ROUND4(d,a,b,c,x[ 3],10,0x8f0ccc92);
    ROUND4(c,d,a,b,x[10],15,0xffeff47d);
    ROUND4(b,c,d,a,x[ 1],21,0x85845dd1);
    ROUND4(a,b,c,d,x[ 8], 6,0x6fa87e4f);
    ROUND4(d,a,b,c,x[15],10,0xfe2ce6e0);
    ROUND4(c,d,a,b,x[ 6],15,0xa3014314);
    ROUND4(b,c,d,a,x[13],21,0x4e0811a1);
    ROUND4(a,b,c,d,x[ 4], 6,0xf7537e82);
    ROUND4(d,a,b,c,x[11],10,0xbd3af235);
    ROUND4(c,d,a,b,x[ 2],15,0x2ad7d2bb);
    ROUND4(b,c,d,a,x[ 9],21,0xeb86d391);

    /* add the original values of the registers to the final values */
    a+=aa;
    b+=bb;
    c+=cc;
    d+=dd;
  }

  /* put final register values into return array */
  *(unsigned long int *)buf2=a;
  *(unsigned long int *)(buf2+4)=b;
  *(unsigned long int *)(buf2+8)=c;
  *(unsigned long int *)(buf2+12)=d;

  if(debug>4) {
    for(i=0;i<16;i++)
      fprintf(stderr,"%x",(unsigned char)buf2[i]);
    fprintf(stderr,"\n");
  }
}

/* add a unique authentication extension to message */
void appendauth(char *buf,int *buflen,char *secretkey,int keylen,unsigned long SPIval) {
  static char scratchbuf[1024],digest[16];
  
  /* copy the initial message and key prefix/suffix into working array */
  /* according to IETF specs where a 128 bit security key precedes and */
  /* follows the message */
  memcpy(scratchbuf,secretkey,keylen);
  memcpy(scratchbuf+keylen,buf,*buflen);
  *(scratchbuf+keylen+(*buflen)) = MHAUTHEXT;
  *(scratchbuf+keylen+(*buflen)+1)= 20;
  memcpy(scratchbuf+keylen+(*buflen)+2,secretkey,keylen);

  /* compute digest for message */
  computedigest(scratchbuf,(keylen*2)+(*buflen)+2,digest);
  
  /* add authentication extension to message */
  *(buf+(*buflen))=MHAUTHEXT;
  *(buf+(*buflen)+1)=20;
  memcpy((buf+(*buflen)+2),(char*)&SPIval,4);
  memcpy(buf+(*buflen)+6,digest,16);  

  /* update buflen to reflect addition of extension */
  *buflen+=22;
}

/* search for the authentication extension in message and if it exists, return
   it's offset into the message */
int authextfound(char *buf,int len,int flag) {
  unsigned char *msgptr;
  int skipover;
  int bytesseen=0;
  
  msgptr=buf;

  /* jump to offset in message where extensions begin, extensions offset 
     determined by message type */
  bytesseen=(flag) ? sizeof(struct regreply) : sizeof(struct registerme);
  msgptr+=bytesseen;

  /* keep looking for authentication extension until end of message is 
     reached  */
  while(bytesseen<len)
    if(*msgptr==MHAUTHEXT)
      return(bytesseen);
    else if(*msgptr < 127 && *msgptr >0)
      return(0);
    else {
      skipover=*(msgptr+1);
      bytesseen+=skipover+2;
      msgptr+=skipover+2;
    }
  return(0);
}

/* compare authentication extension from received message with a newly
   computed digest of that message, if they match return 1(true) else
   return 0(false) */
int authok(char *buf,int len,int offset,char *secretkey,int keylen, unsigned long SPIval) {
  static char scratchbuf[1024],digest[16];
  char *msgptr;
  unsigned long *msgSPI;
 
  /* Check SPI */
  msgSPI= (unsigned long*)(buf+offset+2);
  if(*msgSPI != SPIval)
    {
      if(debug>1)
	fprintf(stderr,"SPI mismatch\n");
      return(0);
    }
  /* the IETF Mobil IP proposal calls for a digest of a message both
     preceded and followed by a 128 bit key */
  memcpy(scratchbuf,secretkey,keylen);
  memcpy(scratchbuf+keylen,buf,offset+2);
  memcpy(scratchbuf+keylen+offset+2,secretkey,keylen);

  /* determine new digest of this message */
  computedigest(scratchbuf,2*keylen+offset+2,digest);

  /* compare this newly created digest with the one included in the
     authentication extension and return result */
  msgptr=buf+offset+6;
  if(memcmp(digest,msgptr,16)==0)
    return(1);
  else
    return(0);
}
