/*----------------------------------------------------------------------------

  Copyright (C) 1995-6, Vipul Gupta and Abhijit Dixit. Created 1995-6. All
  rights reserved.

  Linux-Mobile-IP
            An implementation of Mobile IP for the LINUX operating system
            developed at the State University of New York, Binghamton
            (with partial support from the Center for Computing Technologies).
            Except as noted in the accompanying documentation, this
            implementation complies with revision 16 of the Internet 
            Engineering Task Force (IETF) Mobile-IP draft.

            More information can be obtained from:
                  http://anchor.cs.binghamton.edu/~mobileip/  

  Version:   1.00     05/23/1996
 
  Authors:   Abhijit Dixit <abhijit@cs.binghamton.edu> 
             Vipul Gupta <vgupta@cs.binghamton.edu>
             Benjamin Lancki <ben@anchor.cs.binghamton.edu>

  Permission is hereby granted to redistribute this code and/or
  modify it under the terms of the GNU Genral Public License
  as published by the Free Software Foundation; either version
  two or (at your option) any later version provided this ENTIRE
  notice is retained in any copies or any part of this software.

  A copy of the GNU General Public License can be obtained by contacting
  the Free Software Foundation, Inc. 675 Mass Ave, Cambridge, MA 02139, USA.
             
-----------------------------------------------------------------------------*/


        /* messages.h - Include file containing the structs of all the
                          messages for Linux-Mobile-IP. */

/* Here we define the format of messages we exchange between mobile hosts
 * and mobile agents. */

/* codes for different message types */
#ifndef _MESSAGES_H_
#define _MESSAGES_H_
#define YOUAREHERETYPE       16
#define WHEREAMITYPE        189
#define REGISTERMETYPE        1
#define REGREPLYTYPE          3
#define ROUTERADVTYPE         9
#define ROUTERSOLTYPE        10
#define SIZE_ICMP_HDR         8
#define SIZE_MOBILE_EXT       8  

/* Not required now ... delete afterwards
struct whereami  {
   unsigned char code;
   unsigned char padding;
}; */

struct icmp {
  u_char type;
  u_char code;
  u_short cksum;
  u_char addrnum;
  u_char addr_entry_size;
  u_short lifetime;
};

struct youarehere  {
   unsigned char type;    /* Type to indicate it is a Mobile serv extn. */
   unsigned char length; /* 6 + 4N N = the number of care of addrs*/
   unsigned short seqno;  /* The count of advertisement messages sent */
   unsigned short lifetime; 
   unsigned short flags;    
   /* These are followed by N  unsigned longs indicating
    * the ip address  */ 
};

/* Flags for Registration Request */
#define SFLAG 0x80 /* Simultaneous Binding */
#define BFLAG 0x40 /* Broadcast request */
#define DFLAG 0x20 /* Decapsulation by mobile node */
#define MFLAG 0x10 /* Minimal Encapsulation */
#define GFLAG 0x08 /* GRE encapsulation */
#define VFLAG 0x04 /* Van Jacobson header compression req */

/* Mobile service flag */
#define MSRFLAG 0x8000
#define MSBFLAG 0x4000
#define MSHFLAG 0x2000
#define MSFFLAG 0x1000
#define MSMFLAG 0x0800
#define MSGFLAG 0x0400
#define MSVFLAG 0x0200
 
#define KEYIDEXT   18
#define MHAUTHEXT  32
#define MFAUTHEXT  33
#define FHAUTHEXT  34

struct id  {
   unsigned long high;
   unsigned long low;
};

struct registerme  {
   unsigned char type;
   unsigned char flags;
   unsigned short lifetime;
   unsigned long homeaddr;
   unsigned long ha;
   unsigned long coaddr;
   struct id Id;      /* This is followed by various extensions */ 
};

struct regreply  {
   unsigned char type;
   unsigned char code;
   unsigned short lifetime;
   unsigned long homeaddr;
   unsigned long ha;
   struct id Id;   /* This is followed by various extensions */
};
   
#endif /* _MESSAGES_H_ */

