/*----------------------------------------------------------------------------

  Copyright (C) 1995-6, Vipul Gupta and Abhijit Dixit. Created 1995-6. All
  rights reserved.

  Linux-Mobile-IP
            An implementation of Mobile IP for the LINUX operating system
            developed at the State University of New York, Binghamton
            (with partial support from the Center for Computing Technologies).
            Except as noted in the accompanying documentation, this
            implementation complies with revision 16 of the Internet 
            Engineering Task Force (IETF) Mobile-IP draft.

            More information can be obtained from:
                  http://anchor.cs.binghamton.edu/~mobileip/  

  Version:   1.00     05/23/1996
 
  Authors:   Abhijit Dixit <abhijit@cs.binghamton.edu> 
             Vipul Gupta <vgupta@cs.binghamton.edu>
             Benjamin Lancki <ben@anchor.cs.binghamton.edu>

  Permission is hereby granted to redistribute this code and/or
  modify it under the terms of the GNU Genral Public License
  as published by the Free Software Foundation; either version
  two or (at your option) any later version provided this ENTIRE
  notice is retained in any copies or any part of this software.

  A copy of the GNU General Public License can be obtained by contacting
  the Free Software Foundation, Inc. 675 Mass Ave, Cambridge, MA 02139, USA.
             
-----------------------------------------------------------------------------*/

             /* MH.H - Include file containing constants and data structs
                                 for mh.c. */

#ifndef _MH_H_
#define _MH_H_1

#include <netinet/in.h>
#include "messages.h"

#define NOACTION      0x00
#define HOMEACTION    0x01
#define FOREIGNACTION 0x02
#define POPUPACTION   0x04

#define INIT         0x00
#define ATHOME       0x01
#define ATFOREIGN    0x02
#define ASPOPUP      0x03

#define WAITINGTOREGISTER   0x00
#define REGISTERED          0x04

#define WAITINGTODEREGISTER 0x00
#define DEREGISTERED        0x04
#define AWAITINGREPLY       0x08

#define MAXDENIALS     3  /* If a request is rejected this many times,
			   * we drop that request */
#define MAXRETRIES     3  /* A request is retransmitted at most thrice */
#define RETRYINTERVAL  5  /* A request is retried after these many seconds */
#define MAXLIFETIME  300  /* Max registration lifetime */
#define ADVERTISEON "224.0.0.1" 
#define MAXOVERLAP     5  /* Maximum number of wireless cells that may overlap
			   * this controls the number of different beacons 
			   * that can be heard by a mobile host in one 
			   * beacon interval */

#define MIPREGPORT     434    /* here's where we send our registrations */

#define TRUE    1
#define FALSE   0

typedef struct mi  {
  unsigned long SPIval;
  char haauthtype[5];
  int secretlen;
  char secret[67];
  
  /* These are command line inputes ... they will never change */
  unsigned long homeaddr;
  unsigned long homenetmask;
  unsigned long homeagent;
  unsigned long foreignnetmask; /* Use for POPUP when restoring normal popup */ 
  long timeleft; /* Timer */

  /* Passed by decision maker through struct dm_info */
  unsigned long coaddr;
  unsigned long closeagentaddr;
  char infname[10];
  unsigned short seqno;
  unsigned short lifetime;
  unsigned short agentflags;
  unsigned long gw;
  /* For registration request */
  struct id RequestId; /* id of the last request */
  unsigned char flags;

  struct sockaddr_in URheresock;
  unsigned short retries;   
  unsigned char status; 
} myinfo; 

typedef struct dmi
{
  unsigned char action;
  unsigned long coaddr;
  unsigned long closeagentaddr;
  char infname[10];
  unsigned short flags;
  unsigned short seqno;
  unsigned short lifetime;
  unsigned long gw;
  struct sockaddr_in from;
  char rtdismsg[256];
} dm_info;

#endif /* _MH_H_ */
















