/*----------------------------------------------------------------------------

  Copyright (C) 1995-6, Vipul Gupta and Abhijit Dixit. Created 1995-6. All
  rights reserved.

  Linux-Mobile-IP
            An implementation of Mobile IP for the LINUX operating system
            developed at the State University of New York, Binghamton
            (with partial support from the Center for Computing Technologies).
            Except as noted in the accompanying documentation, this
            implementation complies with revision 16 of the Internet 
            Engineering Task Force (IETF) Mobile-IP draft.

            More information can be obtained from:
                  http://anchor.cs.binghamton.edu/~mobileip/  

  Version:   1.00     05/23/1996
 
  Authors:   Abhijit Dixit <abhijit@cs.binghamton.edu> 
             Vipul Gupta <vgupta@cs.binghamton.edu>
             Benjamin Lancki <ben@anchor.cs.binghamton.edu>

  Permission is hereby granted to redistribute this code and/or
  modify it under the terms of the GNU Genral Public License
  as published by the Free Software Foundation; either version
  two or (at your option) any later version provided this ENTIRE
  notice is retained in any copies or any part of this software.

  A copy of the GNU General Public License can be obtained by contacting
  the Free Software Foundation, Inc. 675 Mass Ave, Cambridge, MA 02139, USA.
             
-----------------------------------------------------------------------------*/
 
 /* mhfileio.c - Routine to read initialization file for Mobile Host. */

#include <stdio.h>
#include "mh.h"

extern myinfo Myinfo;
extern int debug;

void 
readhadata(char *file)  {
   /* a sample file looks like:
    * SPI md5  8 41 ef ad ff fe 1f a5 aa
    */
   
   FILE *fp;
   int i;
   
   memset(Myinfo.haauthtype, 0, 5);
   memset(Myinfo.secret, 0, 64);
   if (((fp = fopen(file, "r")) == NULL) ||
       (fscanf(fp, "%ld %s %d ", &(Myinfo.SPIval),Myinfo.haauthtype, &Myinfo.secretlen) != 3))
     {
       fprintf(stderr,"Problem reading HA data\n");
       return;
     }
   else  {
      for (i = 0; ((i < Myinfo.secretlen) && (i < 64)); i++) 
      	fscanf(fp, "%x", &Myinfo.secret[i]);
   }
   if (debug > 0)  {
      fprintf(stderr, "Authtype is %s SPI is %ld Key (length = %d) is:\n", 
	      Myinfo.haauthtype, Myinfo.SPIval,Myinfo.secretlen);
      for (i = 0; i < Myinfo.secretlen; i++) 
      	fprintf(stderr, "%x ", (unsigned char) Myinfo.secret[i]);
      fprintf(stderr, "\n");
   }
}
